/*
 * LoadingEffect.kt
 * Copyright © 1993-2022, The Avail Foundation, LLC.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * * Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 *
 * * Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * * Neither the name of the copyright holder nor the names of the contributors
 *   may be used to endorse or promote products derived from this software
 *   without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

package avail.interpreter.effects

import avail.interpreter.levelOne.L1InstructionWriter

/**
 * A `LoadingEffect` is a summarized activity that took place during execution
 * of a top-level statement during module compilation.  If certain criteria are
 * met, what gets recorded for replay is not a zero-argument function containing
 * that top-level statement, but instead is a summarized function that has an
 * equivalent effect on the currently module, although it may be much more
 * efficient.
 *
 * @author Mark van Gulik &lt;mark@availlang.org&gt;
 */
abstract class LoadingEffect
{
	/**
	 * Write to the [L1InstructionWriter] a statement capable of
	 * reproducing this effect upon subsequent loading.  The generated code
	 * should leave one (ignored) value on the stack.
	 *
	 * @param writer
	 *   An [L1InstructionWriter].
	 * @param startLine
	 *   The initial line number at which the code that causes this effect is
	 *   located.
	 */
	abstract fun writeEffectTo(writer: L1InstructionWriter, startLine: Int)
}
