/*
 * Decompiled with CFR 0.152.
 */
package avail;

import avail.AvailDebuggerModel;
import avail.AvailRuntime;
import avail.descriptor.atoms.AtomDescriptor;
import avail.descriptor.fiber.A_Fiber;
import avail.descriptor.fiber.FiberDescriptor;
import avail.descriptor.maps.A_Map;
import avail.performance.Statistic;
import avail.performance.StatisticReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 (2\u00020\u0001:\u0001(B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0013\u001a\u00020\f2\u0012\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00160\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u0015J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0019J\u000e\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001bJ\u000e\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u0007J\u0014\u0010!\u001a\u00020\f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u0015J\u0006\u0010\"\u001a\u00020\fJ\u000e\u0010#\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u0007J\u000e\u0010$\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u0007J\u0006\u0010%\u001a\u00020\fJ\u0006\u0010&\u001a\u00020\fJ\u0006\u0010'\u001a\u00020\fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR#\u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\u000b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\tR#\u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\u000b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\t\u00a8\u0006)"}, d2={"Lavail/AvailDebuggerModel;", "", "runtime", "Lavail/AvailRuntime;", "(Lavail/AvailRuntime;)V", "debuggedFibers", "", "Lavail/descriptor/fiber/A_Fiber;", "getDebuggedFibers", "()Ljava/util/List;", "fiberCaptureFunction", "Lkotlin/Function1;", "", "getRuntime", "()Lavail/AvailRuntime;", "whenAddedFiberActions", "getWhenAddedFiberActions", "whenPausedActions", "getWhenPausedActions", "gatherFibersThen", "fibersProvider", "Lkotlin/Function0;", "", "then", "installFiberCapture", "", "kind", "Lavail/descriptor/fiber/FiberDescriptor$FiberKind;", "install", "isCapturingNewFibers", "fiberKind", "justPaused", "fiber", "releaseFibersThen", "restartFrameThen", "resume", "singleStep", "stepOutThen", "stepOverThen", "stepToLineThen", "Companion", "avail"})
public final class AvailDebuggerModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AvailRuntime runtime;
    @NotNull
    private final List<A_Fiber> debuggedFibers;
    @NotNull
    private final Function1<A_Fiber, Unit> fiberCaptureFunction;
    @NotNull
    private final List<Function1<A_Fiber, Unit>> whenPausedActions;
    @NotNull
    private final List<Function1<A_Fiber, Unit>> whenAddedFiberActions;
    @NotNull
    private static final Statistic reificationForDebuggerStat = new Statistic(StatisticReport.REIFICATIONS, "Reification for debugger");

    public AvailDebuggerModel(@NotNull AvailRuntime runtime) {
        Intrinsics.checkNotNullParameter((Object)runtime, (String)"runtime");
        this.runtime = runtime;
        this.debuggedFibers = new ArrayList();
        this.fiberCaptureFunction = (Function1)new Function1<A_Fiber, Unit>(this){
            final /* synthetic */ AvailDebuggerModel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull A_Fiber fiber2) {
                Intrinsics.checkNotNullParameter((Object)fiber2, (String)"fiber");
                if (!A_Map.Companion.hasKey(A_Fiber.Companion.getHeritableFiberGlobals(fiber2), AtomDescriptor.SpecialAtom.DONT_DEBUG_KEY.getAtom())) {
                    this.this$0.getRuntime().whenSafePointDo(80, (Function0<Unit>)((Function0)new Function0<Unit>(this.this$0, fiber2){
                        final /* synthetic */ AvailDebuggerModel this$0;
                        final /* synthetic */ A_Fiber $fiber;
                        {
                            this.this$0 = $receiver;
                            this.$fiber = $fiber;
                            super(0);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * WARNING - void declaration
                         */
                        public final void invoke() {
                            void $this$safeWrite$iv;
                            ReentrantReadWriteLock reentrantReadWriteLock = this.this$0.getRuntime().getRuntimeLock();
                            AvailDebuggerModel availDebuggerModel = this.this$0;
                            A_Fiber a_Fiber = this.$fiber;
                            boolean $i$f$safeWrite = false;
                            ReentrantReadWriteLock.WriteLock writeLock = $this$safeWrite$iv.writeLock();
                            Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"this.writeLock()");
                            Lock lock = writeLock;
                            lock.lock();
                            try {
                                boolean bl = false;
                                availDebuggerModel.getDebuggedFibers().removeIf(arg_0 -> fiberCaptureFunction.1.invoke$lambda$2$lambda$0(fiberCaptureFunction.1.1.INSTANCE, arg_0));
                                if (A_Fiber.Companion.getFiberHelper(a_Fiber).getDebugger().get() == null) {
                                    A_Fiber.Companion.captureInDebugger(a_Fiber, availDebuggerModel);
                                    availDebuggerModel.getDebuggedFibers().add(a_Fiber);
                                    Iterable $this$forEach$iv = availDebuggerModel.getWhenAddedFiberActions();
                                    boolean $i$f$forEach = false;
                                    for (T element$iv : $this$forEach$iv) {
                                        Function1 it = (Function1)element$iv;
                                        boolean bl2 = false;
                                        it.invoke((Object)a_Fiber);
                                    }
                                }
                                Unit unit = Unit.INSTANCE;
                            }
                            finally {
                                lock.unlock();
                            }
                        }

                        private static final boolean invoke$lambda$2$lambda$0(Function1 $tmp0, Object p0) {
                            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                            return (Boolean)$tmp0.invoke(p0);
                        }
                    }));
                }
            }
        };
        this.whenPausedActions = new ArrayList();
        this.whenAddedFiberActions = new ArrayList();
    }

    @NotNull
    public final AvailRuntime getRuntime() {
        return this.runtime;
    }

    @NotNull
    public final List<A_Fiber> getDebuggedFibers() {
        return this.debuggedFibers;
    }

    public final boolean isCapturingNewFibers(@NotNull FiberDescriptor.FiberKind fiberKind) {
        Intrinsics.checkNotNullParameter((Object)((Object)fiberKind), (String)"fiberKind");
        AtomicReference<Function1<A_Fiber, Unit>> atomicReference = this.runtime.getNewFiberHandlers().get((Object)fiberKind);
        Intrinsics.checkNotNull(atomicReference);
        return atomicReference.get() == this.fiberCaptureFunction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void singleStep(@NotNull A_Fiber fiber2) {
        Intrinsics.checkNotNullParameter((Object)fiber2, (String)"fiber");
        this.runtime.assertInSafePoint();
        ReentrantReadWriteLock $this$safeWrite$iv = this.runtime.getRuntimeLock();
        boolean $i$f$safeWrite = false;
        ReentrantReadWriteLock.WriteLock writeLock = $this$safeWrite$iv.writeLock();
        Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"this.writeLock()");
        Lock lock = writeLock;
        lock.lock();
        try {
            boolean bl = false;
            fiber2.lock((Function0)new Function0<Unit>(fiber2, this){
                final /* synthetic */ A_Fiber $fiber;
                final /* synthetic */ AvailDebuggerModel this$0;
                {
                    this.$fiber = $fiber;
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    FiberDescriptor.FiberHelper fiberHelper = A_Fiber.Companion.getFiberHelper(this.$fiber);
                    A_Fiber a_Fiber = this.$fiber;
                    AvailDebuggerModel availDebuggerModel = this.this$0;
                    FiberDescriptor.FiberHelper helper = fiberHelper;
                    boolean bl = false;
                    boolean bl2 = Intrinsics.areEqual((Object)A_Fiber.Companion.getFiberHelper(a_Fiber).getDebugger().get(), (Object)availDebuggerModel);
                    if (_Assertions.ENABLED && !bl2) {
                        String string2 = "Assertion failed";
                        throw new AssertionError((Object)string2);
                    }
                    Ref.BooleanRef allow = new Ref.BooleanRef();
                    allow.element = true;
                    helper.setDebuggerRunCondition((Function1<? super A_Fiber, Boolean>)((Function1)new Function1<A_Fiber, Boolean>(allow){
                        final /* synthetic */ Ref.BooleanRef $allow;
                        {
                            this.$allow = $allow;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(@NotNull A_Fiber it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            Boolean bl = this.$allow.element;
                            Ref.BooleanRef booleanRef = this.$allow;
                            boolean it2 = bl;
                            boolean bl2 = false;
                            booleanRef.element = false;
                            return bl;
                        }
                    }));
                    this.this$0.getRuntime().resumeIfPausedByDebugger(this.$fiber);
                }
            });
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    public final void stepOverThen() {
        String string2 = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string2);
    }

    public final void stepOutThen() {
        String string2 = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string2);
    }

    public final void stepToLineThen() {
        String string2 = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resume(@NotNull A_Fiber fiber2) {
        Intrinsics.checkNotNullParameter((Object)fiber2, (String)"fiber");
        ReentrantReadWriteLock $this$safeWrite$iv = this.runtime.getRuntimeLock();
        boolean $i$f$safeWrite = false;
        ReentrantReadWriteLock.WriteLock writeLock = $this$safeWrite$iv.writeLock();
        Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"this.writeLock()");
        Lock lock = writeLock;
        lock.lock();
        try {
            boolean bl = false;
            A_Fiber.Companion.releaseFromDebugger(fiber2);
            this.debuggedFibers.remove(fiber2);
            Iterable $this$forEach$iv = this.whenAddedFiberActions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function1 it = (Function1)element$iv;
                boolean bl2 = false;
                it.invoke((Object)fiber2);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    public final void restartFrameThen() {
        String string2 = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string2);
    }

    public final boolean installFiberCapture(@NotNull FiberDescriptor.FiberKind kind2, boolean install) {
        Intrinsics.checkNotNullParameter((Object)((Object)kind2), (String)"kind");
        return install ? this.runtime.compareAndSetFiberCaptureFunction(kind2, null, this.fiberCaptureFunction) : this.runtime.compareAndSetFiberCaptureFunction(kind2, this.fiberCaptureFunction, null);
    }

    @NotNull
    public final List<Function1<A_Fiber, Unit>> getWhenPausedActions() {
        return this.whenPausedActions;
    }

    @NotNull
    public final List<Function1<A_Fiber, Unit>> getWhenAddedFiberActions() {
        return this.whenAddedFiberActions;
    }

    public final void justPaused(@NotNull A_Fiber fiber2) {
        Intrinsics.checkNotNullParameter((Object)fiber2, (String)"fiber");
        this.runtime.whenSafePointDo(80, (Function0<Unit>)((Function0)new Function0<Unit>(this, fiber2){
            final /* synthetic */ AvailDebuggerModel this$0;
            final /* synthetic */ A_Fiber $fiber;
            {
                this.this$0 = $receiver;
                this.$fiber = $fiber;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$safeWrite$iv;
                ReentrantReadWriteLock reentrantReadWriteLock = this.this$0.getRuntime().getRuntimeLock();
                AvailDebuggerModel availDebuggerModel = this.this$0;
                A_Fiber a_Fiber = this.$fiber;
                boolean $i$f$safeWrite = false;
                ReentrantReadWriteLock.WriteLock writeLock = $this$safeWrite$iv.writeLock();
                Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"this.writeLock()");
                Lock lock = writeLock;
                lock.lock();
                try {
                    boolean bl = false;
                    Iterable $this$forEach$iv = availDebuggerModel.getWhenPausedActions();
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Function1 it = (Function1)element$iv;
                        boolean bl2 = false;
                        it.invoke((Object)a_Fiber);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    lock.unlock();
                }
            }
        }));
    }

    public final void gatherFibersThen(@NotNull Function0<? extends Collection<? extends A_Fiber>> fibersProvider, @NotNull Function0<Unit> then) {
        Intrinsics.checkNotNullParameter(fibersProvider, (String)"fibersProvider");
        Intrinsics.checkNotNullParameter(then, (String)"then");
        this.runtime.whenSafePointDo(80, (Function0<Unit>)((Function0)new Function0<Unit>(this, then, fibersProvider){
            final /* synthetic */ AvailDebuggerModel this$0;
            final /* synthetic */ Function0<Unit> $then;
            final /* synthetic */ Function0<Collection<A_Fiber>> $fibersProvider;
            {
                this.this$0 = $receiver;
                this.$then = $then;
                this.$fibersProvider = $fibersProvider;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$safeWrite$iv;
                ReentrantReadWriteLock reentrantReadWriteLock = this.this$0.getRuntime().getRuntimeLock();
                Function0<Collection<A_Fiber>> function0 = this.$fibersProvider;
                AvailDebuggerModel availDebuggerModel = this.this$0;
                boolean $i$f$safeWrite = false;
                ReentrantReadWriteLock.WriteLock writeLock = $this$safeWrite$iv.writeLock();
                Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"this.writeLock()");
                Lock lock = writeLock;
                lock.lock();
                try {
                    void $this$sortedBy$iv;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv;
                    boolean bl = false;
                    Iterable iterable = (Iterable)function0.invoke();
                    boolean $i$f$filter = false;
                    Iterator<T> iterator2 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        A_Fiber it = (A_Fiber)element$iv$iv;
                        boolean bl2 = false;
                        boolean bl3 = A_Fiber.Companion.getFiberHelper(it).getDebugger().get() == null && !A_Fiber.Companion.getExecutionState(it).getIndicatesTermination() && !A_Map.Companion.hasKey(A_Fiber.Companion.getHeritableFiberGlobals(it), AtomDescriptor.SpecialAtom.DONT_DEBUG_KEY.getAtom());
                        if (!bl3) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    boolean $i$f$sortedBy = false;
                    List newFibers = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            A_Fiber it = (A_Fiber)a;
                            boolean bl = false;
                            Comparable comparable = Long.valueOf(A_Fiber.Companion.getFiberHelper(it).getDebugUniqueId());
                            it = (A_Fiber)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(A_Fiber.Companion.getFiberHelper(it).getDebugUniqueId()));
                        }
                    });
                    availDebuggerModel.getDebuggedFibers().addAll(newFibers);
                    Iterable $this$forEach$iv = newFibers;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        boolean bl4;
                        A_Fiber fiber2 = (A_Fiber)element$iv;
                        boolean bl5 = false;
                        boolean bl6 = bl4 = A_Fiber.Companion.getFiberHelper(fiber2).getDebugger().get() == null;
                        if (_Assertions.ENABLED && !bl4) {
                            String string2 = "Assertion failed";
                            throw new AssertionError((Object)string2);
                        }
                        A_Fiber.Companion.captureInDebugger(fiber2, availDebuggerModel);
                        A_Fiber.Companion.getFiberHelper(fiber2).setDebuggerRunCondition((Function1<? super A_Fiber, Boolean>)((Function1)gatherFibersThen.1.1.1.INSTANCE));
                    }
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    lock.unlock();
                }
                this.$then.invoke();
            }
        }));
    }

    public final void releaseFibersThen(@NotNull Function0<Unit> then) {
        Intrinsics.checkNotNullParameter(then, (String)"then");
        this.runtime.whenSafePointDo(80, (Function0<Unit>)((Function0)new Function0<Unit>(this, then){
            final /* synthetic */ AvailDebuggerModel this$0;
            final /* synthetic */ Function0<Unit> $then;
            {
                this.this$0 = $receiver;
                this.$then = $then;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$safeWrite$iv;
                ReentrantReadWriteLock reentrantReadWriteLock = this.this$0.getRuntime().getRuntimeLock();
                AvailDebuggerModel availDebuggerModel = this.this$0;
                boolean $i$f$safeWrite = false;
                ReentrantReadWriteLock.WriteLock writeLock = $this$safeWrite$iv.writeLock();
                Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"this.writeLock()");
                Lock lock = writeLock;
                lock.lock();
                try {
                    boolean bl = false;
                    Iterable $this$forEach$iv = availDebuggerModel.getDebuggedFibers();
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        A_Fiber it = (A_Fiber)element$iv;
                        boolean bl2 = false;
                        A_Fiber.Companion.releaseFromDebugger(it);
                    }
                    availDebuggerModel.getDebuggedFibers().clear();
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    lock.unlock();
                }
                this.$then.invoke();
            }
        }));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lavail/AvailDebuggerModel$Companion;", "", "()V", "reificationForDebuggerStat", "Lavail/performance/Statistic;", "getReificationForDebuggerStat", "()Lavail/performance/Statistic;", "avail"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Statistic getReificationForDebuggerStat() {
            return reificationForDebuggerStat;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

