/*
 * Decompiled with CFR 0.152.
 */
package avail.anvil.actions;

import avail.AvailRuntime;
import avail.anvil.AvailWorkbench;
import avail.anvil.actions.AbstractWorkbenchAction;
import avail.anvil.actions.SubmitInputAction;
import avail.builder.AvailBuilder;
import avail.descriptor.representation.AvailObject;
import avail.io.ConsoleInputChannel;
import avail.io.ConsoleOutputChannel;
import avail.io.TextInterface;
import java.awt.event.ActionEvent;
import java.util.Comparator;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lavail/anvil/actions/SubmitInputAction;", "Lavail/anvil/actions/AbstractWorkbenchAction;", "workbench", "Lavail/anvil/AvailWorkbench;", "(Lavail/anvil/AvailWorkbench;)V", "actionPerformed", "", "event", "Ljava/awt/event/ActionEvent;", "updateIsEnabled", "busy", "", "avail"})
public final class SubmitInputAction
extends AbstractWorkbenchAction {
    public SubmitInputAction(@NotNull AvailWorkbench workbench) {
        Intrinsics.checkNotNullParameter((Object)workbench, (String)"workbench");
        super(workbench, "Submit Input", null, null, 12, null);
        this.putValue("ShortDescription", "Submit the input field (plus a new line) to standard input.");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(10, 0));
    }

    @Override
    public void updateIsEnabled(boolean busy) {
    }

    @Override
    public void actionPerformed(@NotNull ActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.getWorkbench().getInputField().isFocusOwner()) {
            boolean bl;
            boolean bl2 = bl = this.getWorkbench().getBackgroundTask() == null;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            if (this.getWorkbench().isRunning()) {
                this.getWorkbench().inputStream().update();
                return;
            }
            String string3 = this.getWorkbench().getInputField().getText();
            List<String> list2 = this.getWorkbench().getCommandHistory();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"string");
            list2.add(string3);
            this.getWorkbench().setCommandHistoryIndex(-1);
            this.getWorkbench().inputStream().feedbackForCommand(string3);
            this.getWorkbench().getInputField().setText("");
            this.getWorkbench().setRunning(true);
            this.getWorkbench().setEnablements();
            this.getWorkbench().getAvailBuilder().getRuntime().setTextInterface(new TextInterface(new ConsoleInputChannel(this.getWorkbench().inputStream()), new ConsoleOutputChannel(this.getWorkbench().outputStream()), new ConsoleOutputChannel(this.getWorkbench().errorStream())));
            this.getWorkbench().getAvailBuilder().attemptCommand(string3, (Function2<? super List<AvailBuilder.CompiledCommand>, ? super Function1<? super AvailBuilder.CompiledCommand, Unit>, Unit>)((Function2)new Function2<List<? extends AvailBuilder.CompiledCommand>, Function1<? super AvailBuilder.CompiledCommand, ? extends Unit>, Unit>(this){
                final /* synthetic */ SubmitInputAction this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull List<AvailBuilder.CompiledCommand> commands, @NotNull Function1<? super AvailBuilder.CompiledCommand, Unit> proceed) {
                    void $this$toTypedArray$iv;
                    Intrinsics.checkNotNullParameter(commands, (String)"commands");
                    Intrinsics.checkNotNullParameter(proceed, (String)"proceed");
                    Iterable $this$sortedBy$iv = commands;
                    boolean $i$f$sortedBy = false;
                    $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            AvailBuilder.CompiledCommand it = (AvailBuilder.CompiledCommand)a;
                            boolean bl = false;
                            Comparable comparable = (Comparable)((Object)it.toString());
                            it = (AvailBuilder.CompiledCommand)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.toString())));
                        }
                    });
                    boolean $i$f$toTypedArray = false;
                    void thisCollection$iv = $this$toTypedArray$iv;
                    AvailBuilder.CompiledCommand selection = (AvailBuilder.CompiledCommand)JOptionPane.showInputDialog(this.this$0.getWorkbench(), "Choose the desired entry point:", "Disambiguate", 3, null, thisCollection$iv.toArray(new AvailBuilder.CompiledCommand[0]), null);
                    proceed.invoke((Object)selection);
                }
            }), (Function2<? super AvailObject, ? super Function1<? super Function0<Unit>, Unit>, Unit>)((Function2)new Function2<AvailObject, Function1<? super Function0<? extends Unit>, ? extends Unit>, Unit>(this){
                final /* synthetic */ SubmitInputAction this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                public final void invoke(@NotNull AvailObject result2, @NotNull Function1<? super Function0<Unit>, Unit> cleanup) {
                    Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                    Intrinsics.checkNotNullParameter(cleanup, (String)"cleanup");
                    Function0 afterward2 = (Function0)new Function0<Unit>(this.this$0){
                        final /* synthetic */ SubmitInputAction this$0;
                        {
                            this.this$0 = $receiver;
                            super(0);
                        }

                        public final void invoke() {
                            this.this$0.getWorkbench().setRunning(false);
                            SwingUtilities.invokeLater(() -> actionPerformed.afterward.1.invoke$lambda$0(this.this$0));
                        }

                        private static final void invoke$lambda$0(SubmitInputAction this$0) {
                            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                            this$0.getWorkbench().inputStream().clear();
                            this$0.getWorkbench().getAvailBuilder().getRuntime().setTextInterface(new TextInterface(new ConsoleInputChannel(this$0.getWorkbench().inputStream()), new ConsoleOutputChannel(this$0.getWorkbench().outputStream()), new ConsoleOutputChannel(this$0.getWorkbench().errorStream())));
                            this$0.getWorkbench().setEnablements();
                        }
                    };
                    if (result2.isNil()) {
                        cleanup.invoke((Object)afterward2);
                        return;
                    }
                    AvailRuntime.stringifyThen$default(this.this$0.getWorkbench().getAvailBuilder().getRuntime(), result2, null, null, (Function1)new Function1<String, Unit>(this.this$0, cleanup, (Function0<Unit>)afterward2){
                        final /* synthetic */ SubmitInputAction this$0;
                        final /* synthetic */ Function1<Function0<Unit>, Unit> $cleanup;
                        final /* synthetic */ Function0<Unit> $afterward;
                        {
                            this.this$0 = $receiver;
                            this.$cleanup = $cleanup;
                            this.$afterward = $afterward;
                            super(1);
                        }

                        public final void invoke(@NotNull String resultString) {
                            Intrinsics.checkNotNullParameter((Object)resultString, (String)"resultString");
                            this.this$0.getWorkbench().outputStream().append(resultString).append("\n");
                            this.$cleanup.invoke(this.$afterward);
                        }
                    }, 6, null);
                }
            }), (Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ SubmitInputAction this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    SwingUtilities.invokeLater(() -> actionPerformed.3.invoke$lambda$0(this.this$0));
                }

                private static final void invoke$lambda$0(SubmitInputAction this$0) {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    this$0.getWorkbench().setRunning(false);
                    this$0.getWorkbench().inputStream().clear();
                    this$0.getWorkbench().getAvailBuilder().getRuntime().setTextInterface(new TextInterface(new ConsoleInputChannel(this$0.getWorkbench().inputStream()), new ConsoleOutputChannel(this$0.getWorkbench().outputStream()), new ConsoleOutputChannel(this$0.getWorkbench().errorStream())));
                    this$0.getWorkbench().setEnablements();
                }
            }));
        }
    }
}

