/*
 * Decompiled with CFR 0.152.
 */
package avail.anvil.settings;

import avail.anvil.AvailWorkbench;
import avail.anvil.environment.UtilitiesKt;
import avail.anvil.settings.TemplateEditPanel;
import avail.anvil.settings.TemplateRow;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.availlang.artifact.environment.project.TemplateExpansion;
import org.availlang.artifact.environment.project.TemplateGroup;
import org.availlang.json.UtilityKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0006\u0010$\u001a\u00020\bJ\u0006\u0010%\u001a\u00020\u0016J\u0010\u0010&\u001a\u00020\u00002\b\b\u0002\u0010'\u001a\u00020(J\f\u0010)\u001a\u00020\b*\u00020*H\u0002J\f\u0010+\u001a\u00020\b*\u00020*H\u0002R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u0006,"}, d2={"Lavail/anvil/settings/TemplatesPanel;", "Ljavax/swing/JPanel;", "workbench", "Lavail/anvil/AvailWorkbench;", "templateGroup", "Lorg/availlang/artifact/environment/project/TemplateGroup;", "saveAction", "Lkotlin/Function0;", "", "(Lavail/anvil/AvailWorkbench;Lorg/availlang/artifact/environment/project/TemplateGroup;Lkotlin/jvm/functions/Function0;)V", "checkedRowsKeys", "", "", "getCheckedRowsKeys", "()Ljava/util/Set;", "deleteSelectedTemplate", "Ljavax/swing/JButton;", "getDeleteSelectedTemplate", "()Ljavax/swing/JButton;", "getSaveAction", "()Lkotlin/jvm/functions/Function0;", "selectedRow", "Lavail/anvil/settings/TemplateRow;", "getSelectedRow", "()Lavail/anvil/settings/TemplateRow;", "setSelectedRow", "(Lavail/anvil/settings/TemplateRow;)V", "templateEditPanel", "Lavail/anvil/settings/TemplateEditPanel;", "getTemplateEditPanel", "()Lavail/anvil/settings/TemplateEditPanel;", "getTemplateGroup", "()Lorg/availlang/artifact/environment/project/TemplateGroup;", "templatesPanel", "getWorkbench", "()Lavail/anvil/AvailWorkbench;", "clearSelectedRow", "newEmptyTemplateRow", "redrawTemplates", "checkAll", "", "exportSettings", "Ljavax/swing/JFileChooser;", "importSettings", "avail"})
public class TemplatesPanel
extends JPanel {
    @NotNull
    private final AvailWorkbench workbench;
    @NotNull
    private final TemplateGroup templateGroup;
    @NotNull
    private final Function0<Unit> saveAction;
    @NotNull
    private final Set<String> checkedRowsKeys;
    @NotNull
    private final JPanel templatesPanel;
    @NotNull
    private TemplateRow selectedRow;
    @NotNull
    private final TemplateEditPanel templateEditPanel;
    @NotNull
    private final JButton deleteSelectedTemplate;

    /*
     * WARNING - void declaration
     */
    public TemplatesPanel(@NotNull AvailWorkbench workbench, @NotNull TemplateGroup templateGroup, @NotNull Function0<Unit> saveAction) {
        void $this$_init__u24lambda_u2428;
        JComponent jComponent;
        JButton $this$_init__u24lambda_u2419;
        JComponent $this$_init__u24lambda_u2418;
        JButton $this$deleteSelectedTemplate_u24lambda_u2410;
        JComponent $this$templatesPanel_u24lambda_u241;
        JComponent jComponent2;
        Intrinsics.checkNotNullParameter((Object)workbench, (String)"workbench");
        Intrinsics.checkNotNullParameter((Object)templateGroup, (String)"templateGroup");
        Intrinsics.checkNotNullParameter(saveAction, (String)"saveAction");
        this.workbench = workbench;
        this.templateGroup = templateGroup;
        this.saveAction = saveAction;
        this.checkedRowsKeys = new LinkedHashSet();
        JPanel jPanel = jComponent2 = new JPanel();
        TemplatesPanel templatesPanel = this;
        boolean bl = false;
        $this$templatesPanel_u24lambda_u241.setLayout(new BoxLayout($this$templatesPanel_u24lambda_u241, 1));
        Map $this$forEach$iv = this.workbench.getAvailProject$avail().getTemplateGroup().getTemplates();
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator2.next();
            boolean bl2 = false;
            $this$templatesPanel_u24lambda_u241.add(new TemplateRow((String)it.getKey(), (TemplateExpansion)it.getValue(), this.templateGroup, this.workbench, this, this.saveAction));
        }
        templatesPanel.templatesPanel = jComponent2;
        this.selectedRow = this.newEmptyTemplateRow();
        this.templateEditPanel = new TemplateEditPanel(this, this.selectedRow);
        $this$templatesPanel_u24lambda_u241 = jComponent2 = new JButton("Delete Checked");
        templatesPanel = this;
        boolean bl3 = false;
        $this$deleteSelectedTemplate_u24lambda_u2410.setOpaque(true);
        $this$deleteSelectedTemplate_u24lambda_u2410.setEnabled(false);
        int currentHeight = $this$deleteSelectedTemplate_u24lambda_u2410.getHeight();
        int currentWidth = $this$deleteSelectedTemplate_u24lambda_u2410.getWidth();
        $this$deleteSelectedTemplate_u24lambda_u2410.setMinimumSize(new Dimension(currentWidth + 140, currentHeight + 30));
        $this$deleteSelectedTemplate_u24lambda_u2410.setPreferredSize(new Dimension(currentWidth + 140, currentHeight + 30));
        $this$deleteSelectedTemplate_u24lambda_u2410.setMaximumSize(new Dimension(currentWidth + 140, currentHeight + 30));
        $this$deleteSelectedTemplate_u24lambda_u2410.setToolTipText("Delete checked rows");
        $this$deleteSelectedTemplate_u24lambda_u2410.addActionListener(arg_0 -> TemplatesPanel.deleteSelectedTemplate$lambda$10$lambda$9(this, arg_0));
        templatesPanel.deleteSelectedTemplate = jComponent2;
        this.setLayout(new BoxLayout(this, 1));
        JComponent $this$_init__u24lambda_u2414 = $this$deleteSelectedTemplate_u24lambda_u2410 = new JButton("Check All");
        boolean bl4 = false;
        $this$_init__u24lambda_u2414.setOpaque(true);
        int currentHeight2 = $this$_init__u24lambda_u2414.getHeight();
        int currentWidth2 = $this$_init__u24lambda_u2414.getWidth();
        $this$_init__u24lambda_u2414.setMinimumSize(new Dimension(currentWidth2 + 140, currentHeight2 + 30));
        $this$_init__u24lambda_u2414.setPreferredSize(new Dimension(currentWidth2 + 140, currentHeight2 + 30));
        $this$_init__u24lambda_u2414.setMaximumSize(new Dimension(currentWidth2 + 140, currentHeight2 + 30));
        $this$_init__u24lambda_u2414.setToolTipText("Create a new template");
        $this$_init__u24lambda_u2414.addActionListener(arg_0 -> TemplatesPanel.lambda$14$lambda$13(this, arg_0));
        JButton checkAllTemplate = $this$deleteSelectedTemplate_u24lambda_u2410;
        JButton $this$_init__u24lambda_u2417 = $this$_init__u24lambda_u2414 = new JButton("Uncheck All");
        boolean bl5 = false;
        $this$_init__u24lambda_u2417.setOpaque(true);
        int currentHeight3 = $this$_init__u24lambda_u2417.getHeight();
        int currentWidth3 = $this$_init__u24lambda_u2417.getWidth();
        $this$_init__u24lambda_u2417.setMinimumSize(new Dimension(currentWidth3 + 140, currentHeight3 + 30));
        $this$_init__u24lambda_u2417.setPreferredSize(new Dimension(currentWidth3 + 140, currentHeight3 + 30));
        $this$_init__u24lambda_u2417.setMaximumSize(new Dimension(currentWidth3 + 140, currentHeight3 + 30));
        $this$_init__u24lambda_u2417.setToolTipText("Create a new template");
        $this$_init__u24lambda_u2417.addActionListener(arg_0 -> TemplatesPanel.lambda$17$lambda$16(this, arg_0));
        JButton uncheckAllTemplate = $this$_init__u24lambda_u2414;
        $this$_init__u24lambda_u2417 = $this$_init__u24lambda_u2414 = new JPanel();
        templatesPanel = this;
        boolean bl6 = false;
        ((Container)$this$_init__u24lambda_u2418).setLayout(new FlowLayout(0));
        $this$_init__u24lambda_u2418.setMinimumSize(new Dimension(950, 50));
        $this$_init__u24lambda_u2418.setPreferredSize(new Dimension(950, 50));
        $this$_init__u24lambda_u2418.setMaximumSize(new Dimension(950, 50));
        $this$_init__u24lambda_u2418.setBackground(new Color(60, 63, 65));
        $this$_init__u24lambda_u2418.add(checkAllTemplate);
        $this$_init__u24lambda_u2418.add(uncheckAllTemplate);
        $this$_init__u24lambda_u2418.add(this.deleteSelectedTemplate);
        templatesPanel.add($this$_init__u24lambda_u2414);
        $this$_init__u24lambda_u2418 = $this$_init__u24lambda_u2414 = new JScrollPane(this.templatesPanel, 22, 31);
        templatesPanel = this;
        boolean bl7 = false;
        $this$_init__u24lambda_u2419.setMinimumSize(new Dimension(950, 400));
        $this$_init__u24lambda_u2419.setPreferredSize(new Dimension(950, 400));
        $this$_init__u24lambda_u2419.setMaximumSize(new Dimension(950, 400));
        templatesPanel.add($this$_init__u24lambda_u2414);
        this.add(this.templateEditPanel);
        JButton $this$_init__u24lambda_u2421 = $this$_init__u24lambda_u2419 = new JButton("Import From File");
        boolean bl8 = false;
        $this$_init__u24lambda_u2421.setOpaque(true);
        int currentHeight4 = $this$_init__u24lambda_u2421.getHeight();
        int currentWidth4 = $this$_init__u24lambda_u2421.getWidth();
        $this$_init__u24lambda_u2421.setMinimumSize(new Dimension(currentWidth4 + 165, currentHeight4 + 40));
        $this$_init__u24lambda_u2421.setPreferredSize(new Dimension(currentWidth4 + 165, currentHeight4 + 40));
        $this$_init__u24lambda_u2421.setMaximumSize(new Dimension(currentWidth4 + 165, currentHeight4 + 40));
        $this$_init__u24lambda_u2421.setToolTipText("Import expansion templates from settings file");
        $this$_init__u24lambda_u2421.addActionListener(arg_0 -> TemplatesPanel.lambda$21$lambda$20(this, arg_0));
        JButton importSettingsTemplates = $this$_init__u24lambda_u2419;
        JButton $this$_init__u24lambda_u2425 = $this$_init__u24lambda_u2421 = new JButton("Import Defaults");
        boolean bl9 = false;
        $this$_init__u24lambda_u2425.setOpaque(true);
        int currentHeight5 = $this$_init__u24lambda_u2425.getHeight();
        int currentWidth5 = $this$_init__u24lambda_u2425.getWidth();
        $this$_init__u24lambda_u2425.setMinimumSize(new Dimension(currentWidth5 + 165, currentHeight5 + 40));
        $this$_init__u24lambda_u2425.setPreferredSize(new Dimension(currentWidth5 + 165, currentHeight5 + 40));
        $this$_init__u24lambda_u2425.setMaximumSize(new Dimension(currentWidth5 + 165, currentHeight5 + 40));
        $this$_init__u24lambda_u2425.setToolTipText("Import system default expansion templates");
        $this$_init__u24lambda_u2425.addActionListener(arg_0 -> TemplatesPanel.lambda$25$lambda$24(this, arg_0));
        JButton importDefaultTemplates = $this$_init__u24lambda_u2421;
        JButton $this$_init__u24lambda_u2427 = jComponent = new JButton("Export");
        boolean bl10 = false;
        $this$_init__u24lambda_u2427.setOpaque(true);
        int currentHeight6 = $this$_init__u24lambda_u2427.getHeight();
        int currentWidth6 = $this$_init__u24lambda_u2427.getWidth();
        $this$_init__u24lambda_u2427.setMinimumSize(new Dimension(currentWidth6 + 165, currentHeight6 + 40));
        $this$_init__u24lambda_u2427.setPreferredSize(new Dimension(currentWidth6 + 165, currentHeight6 + 40));
        $this$_init__u24lambda_u2427.setMaximumSize(new Dimension(currentWidth6 + 165, currentHeight6 + 40));
        $this$_init__u24lambda_u2427.setToolTipText("Export expansion templates");
        $this$_init__u24lambda_u2427.addActionListener(arg_0 -> TemplatesPanel.lambda$27$lambda$26(this, arg_0));
        JButton exportTemplates = jComponent;
        $this$_init__u24lambda_u2427 = jComponent = new JPanel();
        templatesPanel = this;
        boolean bl11 = false;
        $this$_init__u24lambda_u2428.setLayout(new FlowLayout(2));
        $this$_init__u24lambda_u2428.setMinimumSize(new Dimension(950, 50));
        $this$_init__u24lambda_u2428.setPreferredSize(new Dimension(950, 50));
        $this$_init__u24lambda_u2428.setMaximumSize(new Dimension(950, 50));
        $this$_init__u24lambda_u2428.setBackground(new Color(60, 63, 65));
        $this$_init__u24lambda_u2428.add(importSettingsTemplates);
        $this$_init__u24lambda_u2428.add(importDefaultTemplates);
        $this$_init__u24lambda_u2428.add(exportTemplates);
        templatesPanel.add(jComponent);
    }

    @NotNull
    public final AvailWorkbench getWorkbench() {
        return this.workbench;
    }

    @NotNull
    public final TemplateGroup getTemplateGroup() {
        return this.templateGroup;
    }

    @NotNull
    public final Function0<Unit> getSaveAction() {
        return this.saveAction;
    }

    @NotNull
    public final Set<String> getCheckedRowsKeys() {
        return this.checkedRowsKeys;
    }

    @NotNull
    public final TemplateRow newEmptyTemplateRow() {
        return new TemplateRow("", new TemplateExpansion(""), this.templateGroup, this.workbench, this, this.saveAction);
    }

    @NotNull
    public final TemplateRow getSelectedRow() {
        return this.selectedRow;
    }

    public final void setSelectedRow(@NotNull TemplateRow templateRow) {
        Intrinsics.checkNotNullParameter((Object)templateRow, (String)"<set-?>");
        this.selectedRow = templateRow;
    }

    public final void clearSelectedRow() {
        this.selectedRow = this.newEmptyTemplateRow();
        this.templateEditPanel.setTemplateRow(this.selectedRow);
    }

    @NotNull
    public final TemplateEditPanel getTemplateEditPanel() {
        return this.templateEditPanel;
    }

    @NotNull
    public final TemplatesPanel redrawTemplates(boolean checkAll) {
        SwingUtilities.invokeLater(() -> TemplatesPanel.redrawTemplates$lambda$5(this, checkAll));
        return this;
    }

    public static /* synthetic */ TemplatesPanel redrawTemplates$default(TemplatesPanel templatesPanel, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: redrawTemplates");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        return templatesPanel.redrawTemplates(bl);
    }

    @NotNull
    public final JButton getDeleteSelectedTemplate() {
        return this.deleteSelectedTemplate;
    }

    private final void importSettings(JFileChooser $this$importSettings) {
        $this$importSettings.setDialogTitle("Select Templates File to Import From");
        $this$importSettings.setFileSelectionMode(0);
        String[] stringArray = new String[]{"json"};
        $this$importSettings.setFileFilter(new FileNameExtensionFilter("*.json", stringArray));
        $this$importSettings.addChoosableFileFilter(new FileFilter(){

            @NotNull
            public String getDescription() {
                return "Templates File (*.json)";
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean accept(@NotNull File f) {
                Intrinsics.checkNotNullParameter((Object)f, (String)"f");
                if (!f.isFile()) return false;
                if (!f.canWrite()) return false;
                String string2 = f.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"f.absolutePath");
                String string3 = string2.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                if (!StringsKt.endsWith$default((String)string3, (String)".json", (boolean)false, (int)2, null)) return false;
                return true;
            }
        });
        int result2 = $this$importSettings.showDialog(this, "Select Settings File");
        if (result2 == 0) {
            File file2 = $this$importSettings.getSelectedFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"selectedFile");
            TemplateGroup tg = new TemplateGroup(UtilityKt.jsonObject$default((String)FilesKt.readText$default((File)file2, null, (int)1, null), null, (int)2, null));
            this.templateGroup.getTemplates().putAll(tg.getTemplates());
            SwingUtilities.invokeLater(() -> TemplatesPanel.importSettings$lambda$11(this));
        }
    }

    private final void exportSettings(JFileChooser $this$exportSettings) {
        $this$exportSettings.setDialogTitle("Select File to Export Templates To");
        $this$exportSettings.setFileSelectionMode(0);
        String[] stringArray = new String[]{"json"};
        $this$exportSettings.setFileFilter(new FileNameExtensionFilter("*.json", stringArray));
        $this$exportSettings.addChoosableFileFilter(new FileFilter(){

            @NotNull
            public String getDescription() {
                return "Templates File (*.json)";
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean accept(@NotNull File f) {
                Intrinsics.checkNotNullParameter((Object)f, (String)"f");
                if (!f.isFile()) return false;
                if (!f.canWrite()) return false;
                String string2 = f.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"f.absolutePath");
                String string3 = string2.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                if (!StringsKt.endsWith$default((String)string3, (String)".json", (boolean)false, (int)2, null)) return false;
                return true;
            }
        });
        int result2 = $this$exportSettings.showSaveDialog(this);
        if (result2 == 0) {
            String string2 = $this$exportSettings.getSelectedFile().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"selectedFile.name");
            File target = StringsKt.endsWith$default((String)string2, (String)".json", (boolean)false, (int)2, null) ? $this$exportSettings.getSelectedFile() : new File($this$exportSettings.getSelectedFile().getAbsolutePath() + ".json");
            Intrinsics.checkNotNullExpressionValue((Object)target, (String)"target");
            FilesKt.writeText$default((File)target, (String)this.templateGroup.getJsonPrettyPrintedFormattedString(), null, (int)2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void redrawTemplates$lambda$5(TemplatesPanel this$0, boolean $checkAll) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.templatesPanel.removeAll();
        this$0.templatesPanel.revalidate();
        Iterable $this$sortedBy$iv = MapsKt.toList((Map)this$0.templateGroup.getTemplates());
        boolean $i$f$sortedBy = false;
        Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((String)it.getFirst()));
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getFirst()))));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$redrawTemplates_u24lambda_u245_u24lambda_u244_u24lambda_u243;
            TemplateRow templateRow;
            Pair it = (Pair)element$iv;
            boolean bl = false;
            TemplateRow templateRow2 = templateRow = new TemplateRow((String)it.getFirst(), (TemplateExpansion)it.getSecond(), this$0.templateGroup, this$0.workbench, this$0, this$0.saveAction);
            JPanel jPanel = this$0.templatesPanel;
            boolean bl2 = false;
            if (Intrinsics.areEqual((Object)this$0.selectedRow.getTemplateKey(), (Object)$this$redrawTemplates_u24lambda_u245_u24lambda_u244_u24lambda_u243.getTemplateKey())) {
                $this$redrawTemplates_u24lambda_u245_u24lambda_u244_u24lambda_u243.select$avail();
            }
            if ($checkAll) {
                $this$redrawTemplates_u24lambda_u245_u24lambda_u244_u24lambda_u243.getTemplateKeyCheckBox().setSelected(true);
                this$0.checkedRowsKeys.add($this$redrawTemplates_u24lambda_u245_u24lambda_u244_u24lambda_u243.getTemplateKey());
            }
            jPanel.add(templateRow);
        }
        this$0.templatesPanel.repaint();
    }

    /*
     * WARNING - void declaration
     */
    private static final void deleteSelectedTemplate$lambda$10$lambda$9$lambda$8(TemplatesPanel this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        int selection = JOptionPane.showConfirmDialog(this$0, "Delete Checked Rows?", "Delete Templates", 0);
        if (selection == 0) {
            void $this$deleteSelectedTemplate_u24lambda_u2410_u24lambda_u249_u24lambda_u248_u24lambda_u246;
            TemplateRow templateRow;
            TemplateRow templateRow2 = templateRow = this$0.newEmptyTemplateRow();
            TemplateEditPanel templateEditPanel = this$0.templateEditPanel;
            boolean bl = false;
            $this$deleteSelectedTemplate_u24lambda_u2410_u24lambda_u249_u24lambda_u248_u24lambda_u246.select$avail();
            templateEditPanel.setTemplateRow(templateRow);
            Iterable $this$forEach$iv = this$0.checkedRowsKeys;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl2 = false;
                this$0.templateGroup.getTemplates().remove(it);
            }
            this$0.saveAction.invoke();
            TemplatesPanel.redrawTemplates$default(this$0, false, 1, null);
        }
    }

    private static final void deleteSelectedTemplate$lambda$10$lambda$9(TemplatesPanel this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        SwingUtilities.invokeLater(() -> TemplatesPanel.deleteSelectedTemplate$lambda$10$lambda$9$lambda$8(this$0));
    }

    private static final void importSettings$lambda$11(TemplatesPanel this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        TemplatesPanel.redrawTemplates$default(this$0, false, 1, null);
        this$0.saveAction.invoke();
    }

    private static final void lambda$14$lambda$13$lambda$12(TemplatesPanel this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.redrawTemplates(true);
        this$0.deleteSelectedTemplate.setEnabled(true);
    }

    private static final void lambda$14$lambda$13(TemplatesPanel this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        SwingUtilities.invokeLater(() -> TemplatesPanel.lambda$14$lambda$13$lambda$12(this$0));
    }

    private static final void lambda$17$lambda$16$lambda$15(TemplatesPanel this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        TemplatesPanel.redrawTemplates$default(this$0, false, 1, null);
        this$0.deleteSelectedTemplate.setEnabled(false);
    }

    private static final void lambda$17$lambda$16(TemplatesPanel this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        SwingUtilities.invokeLater(() -> TemplatesPanel.lambda$17$lambda$16$lambda$15(this$0));
    }

    private static final void lambda$21$lambda$20(TemplatesPanel this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.importSettings(new JFileChooser());
    }

    private static final void lambda$25$lambda$24$lambda$23(TemplatesPanel this$0) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            TemplateGroup templateGroup = UtilitiesKt.getSystemDefaultTemplates();
            if (templateGroup == null) break block0;
            TemplateGroup it = templateGroup;
            boolean bl = false;
            this$0.templateGroup.getTemplates().putAll(it.getTemplates());
            TemplatesPanel.redrawTemplates$default(this$0, false, 1, null);
            this$0.workbench.saveProjectFileToDisk();
        }
    }

    private static final void lambda$25$lambda$24(TemplatesPanel this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        SwingUtilities.invokeLater(() -> TemplatesPanel.lambda$25$lambda$24$lambda$23(this$0));
    }

    private static final void lambda$27$lambda$26(TemplatesPanel this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.exportSettings(new JFileChooser());
    }
}

