/*
 * Decompiled with CFR 0.152.
 */
package avail.files;

import avail.error.ErrorCode;
import avail.files.AbstractAvailTextFile;
import avail.files.AbstractFileWrapper;
import avail.files.AvailFile;
import avail.files.EditRange;
import avail.files.FileAction;
import avail.files.FileErrorCode;
import avail.files.TracedAction;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B!\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ0\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\bH\u0016J \u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lavail/files/AvailTextFile;", "Lavail/files/AbstractAvailTextFile;", "fileWrapper", "Lavail/files/AbstractFileWrapper;", "charset", "Ljava/nio/charset/Charset;", "(Lavail/files/AbstractFileWrapper;Ljava/nio/charset/Charset;)V", "raw", "", "([BLavail/files/AbstractFileWrapper;Ljava/nio/charset/Charset;)V", "content", "", "rawContent", "getRawContent", "()[B", "editRange", "Lavail/files/TracedAction;", "data", "start", "", "end", "timestamp", "", "originator", "Ljava/util/UUID;", "getSavableContent", "replaceFile", "avail"})
public final class AvailTextFile
extends AbstractAvailTextFile {
    private String content;

    @Override
    @NotNull
    public byte[] getRawContent() {
        String string2 = this.content;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"content");
            string2 = null;
        }
        String string3 = string2;
        byte[] byArray = string3.getBytes(this.getCharset());
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return byArray;
    }

    @Override
    @NotNull
    public byte[] getSavableContent() {
        return this.getRawContent();
    }

    public AvailTextFile(final @NotNull AbstractFileWrapper fileWrapper, final @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)fileWrapper, (String)"fileWrapper");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        super(charset, fileWrapper);
        fileWrapper.getReference().readFileBytes(true, (Function2<? super byte[], ? super UUID, Unit>)((Function2)new Function2<byte[], UUID, Unit>(){

            public final void invoke(@NotNull byte[] bytes2, @Nullable UUID uUID) {
                Intrinsics.checkNotNullParameter((Object)bytes2, (String)"bytes");
                CharsetDecoder decoder = charset.newDecoder();
                decoder.onMalformedInput(CodingErrorAction.REPLACE);
                decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
                try {
                    String string2 = decoder.decode(ByteBuffer.wrap(bytes2)).toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"decoder.decode(ByteBuffer.wrap(bytes)).toString()");
                    content = string2;
                }
                catch (CharacterCodingException e) {
                    System.err.println("Attempted to decode bytes from supposed text file " + fileWrapper.getReference().getUri());
                    e.printStackTrace();
                    fileWrapper.notifyOpenFailure(FileErrorCode.DECODER_FAILURE, e);
                    return;
                }
                catch (Throwable e) {
                    System.err.println("Attempted to decode bytes from supposed text file " + fileWrapper.getReference().getUri());
                    e.printStackTrace();
                    fileWrapper.notifyOpenFailure(FileErrorCode.UNSPECIFIED, e);
                    return;
                }
                fileWrapper.notifyReady();
            }
        }), (Function2<? super ErrorCode, ? super Throwable, Unit>)((Function2)new Function2<ErrorCode, Throwable, Unit>(){

            public final void invoke(@NotNull ErrorCode code, @Nullable Throwable ex) {
                Intrinsics.checkNotNullParameter((Object)code, (String)"code");
                System.err.println("Received ErrorCode: " + code + " while attempting read file: " + fileWrapper.getReference().getUri() + " with exception:\n");
                Throwable throwable = ex;
                if (throwable != null) {
                    throwable.printStackTrace();
                }
                fileWrapper.notifyOpenFailure(code, ex);
            }
        }));
    }

    public /* synthetic */ AvailTextFile(AbstractFileWrapper abstractFileWrapper, Charset charset, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        this(abstractFileWrapper, charset);
    }

    public AvailTextFile(@NotNull byte[] raw, @NotNull AbstractFileWrapper fileWrapper, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
        Intrinsics.checkNotNullParameter((Object)fileWrapper, (String)"fileWrapper");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        super(charset, fileWrapper);
        CharsetDecoder decoder = charset.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPLACE);
        decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        try {
            String string2 = decoder.decode(ByteBuffer.wrap(raw)).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"decoder.decode(ByteBuffer.wrap(raw)).toString()");
            this.content = string2;
        }
        catch (CharacterCodingException e) {
            System.err.println("Attempted to decode bytes from supposed text file " + fileWrapper.getReference().getUri());
            e.printStackTrace();
            fileWrapper.notifyOpenFailure(FileErrorCode.DECODER_FAILURE, e);
            return;
        }
        catch (Throwable e) {
            System.err.println("Attempted to decode bytes from supposed text file " + fileWrapper.getReference().getUri());
            e.printStackTrace();
            fileWrapper.notifyOpenFailure(FileErrorCode.UNSPECIFIED, e);
            return;
        }
        fileWrapper.notifyReady();
    }

    public /* synthetic */ AvailTextFile(byte[] byArray, AbstractFileWrapper abstractFileWrapper, Charset charset, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            charset = Charsets.UTF_8;
        }
        this(byArray, abstractFileWrapper, charset);
    }

    @Override
    @NotNull
    public TracedAction replaceFile(@NotNull byte[] data, long timestamp, @NotNull UUID originator) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)originator, (String)"originator");
        AvailFile availFile = this;
        String string2 = this.content;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"content");
            string2 = null;
        }
        return AvailFile.editRange$default(availFile, data, 0, string2.length(), 0L, originator, 8, null);
    }

    @Override
    @NotNull
    public TracedAction editRange(@NotNull byte[] data, int start, int end, long timestamp, @NotNull UUID originator) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)originator, (String)"originator");
        String text = new String(data, this.getCharset());
        String string3 = this.content;
        if (string3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"content");
            string3 = null;
        }
        String removed = StringsKt.slice((String)string3, (IntRange)new IntRange(start + 1, end));
        String string4 = this.content;
        if (string4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"content");
            string4 = null;
        }
        String first = StringsKt.slice((String)string4, (IntRange)new IntRange(1, start));
        String string5 = this.content;
        if (string5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"content");
            string5 = null;
        }
        if ((string2 = this.content) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"content");
            string2 = null;
        }
        String third = StringsKt.slice((String)string5, (IntRange)new IntRange(end + 1, string2.length()));
        this.content = first + text + third;
        this.markDirty();
        FileAction fileAction = new EditRange(data, start, end);
        byte[] byArray = removed.getBytes(this.getCharset());
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return new TracedAction(timestamp, originator, fileAction, new EditRange(byArray, start, start + text.length()));
    }
}

