/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.levelOne;

import avail.descriptor.atoms.A_Atom;
import avail.descriptor.bundles.A_Bundle;
import avail.descriptor.character.A_Character;
import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.functions.CompiledCodeDescriptor;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AbstractDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.AvailObjectFieldHelper;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.CompiledCodeTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.descriptor.types.VariableTypeDescriptor;
import avail.interpreter.levelOne.L1OperandType;
import avail.interpreter.levelOne.L1OperandTypeDispatcher;
import avail.interpreter.levelOne.L1Operation;
import avail.utility.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 &2\u00020\u0001:\u0002&'B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00062\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ8\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u00162\u0006\u0010\u0019\u001a\u00020\u000f2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ8\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001c2\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u00142\u0010\b\u0002\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001e2\b\b\u0002\u0010\u001f\u001a\u00020\u000fH\u0002JB\u0010 \u001a\u00020\u00112\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u00162\u0006\u0010\u0019\u001a\u00020\u000f2\u001e\u0010!\u001a\u001a\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00110\"J\u000e\u0010#\u001a\u00020\u00112\u0006\u0010$\u001a\u00020%R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006("}, d2={"Lavail/interpreter/levelOne/L1Disassembler;", "", "code", "Lavail/descriptor/functions/A_RawFunction;", "(Lavail/descriptor/functions/A_RawFunction;)V", "allDeclarationNames", "", "", "getAllDeclarationNames", "()Ljava/util/List;", "getCode$avail", "()Lavail/descriptor/functions/A_RawFunction;", "disassembledAsSlots", "Lavail/descriptor/representation/AvailObjectFieldHelper;", "highlightPc", "", "print", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "recursionMap", "Ljava/util/IdentityHashMap;", "Lavail/descriptor/representation/A_BasicObject;", "Ljava/lang/Void;", "indent", "printIfSimple", "value", "Lavail/descriptor/representation/AvailObject;", "operandValues", "", "depth", "printInstructions", "action", "Lkotlin/Function3;", "visit", "visitor", "Lavail/interpreter/levelOne/L1Disassembler$L1DisassemblyVisitor;", "Companion", "L1DisassemblyVisitor", "avail"})
public final class L1Disassembler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final A_RawFunction code;
    @NotNull
    private final List<String> allDeclarationNames;

    /*
     * WARNING - void declaration
     */
    public L1Disassembler(@NotNull A_RawFunction code) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        this.code = code;
        Iterable iterable = A_RawFunction.Companion.getDeclarationNames(this.code);
        L1Disassembler l1Disassembler = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AvailObject availObject = (AvailObject)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(A_String.Companion.asNativeString((A_String)it));
        }
        l1Disassembler.allDeclarationNames = (List)destination$iv$iv;
    }

    @NotNull
    public final A_RawFunction getCode$avail() {
        return this.code;
    }

    @NotNull
    public final List<String> getAllDeclarationNames() {
        return this.allDeclarationNames;
    }

    /*
     * WARNING - void declaration
     */
    public final void visit(@NotNull L1DisassemblyVisitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        CompiledCodeDescriptor.L1InstructionDecoder $this$visit_u24lambda_u242 = new CompiledCodeDescriptor.L1InstructionDecoder();
        boolean bl = false;
        A_Tuple encodedDeltas = A_RawFunction.Companion.getLineNumberEncodedDeltas(this.code);
        int lineNumber = A_RawFunction.Companion.getCodeStartingLineNumber(this.code);
        int instructionCounter = 1;
        this.code.setUpInstructionDecoder($this$visit_u24lambda_u242);
        $this$visit_u24lambda_u242.pc(1);
        while (!$this$visit_u24lambda_u242.atEnd()) {
            int encodedDelta;
            int decodedDelta = ((encodedDelta = A_Tuple.Companion.tupleIntAt(encodedDeltas, instructionCounter++)) & 1) == 0 ? encodedDelta >> 1 : -(encodedDelta >> 1);
            int pc = $this$visit_u24lambda_u242.pc();
            L1Operation operation = $this$visit_u24lambda_u242.getOperation();
            visitor2.startOperation(operation, pc, lineNumber += decodedDelta);
            L1OperandType[] $this$forEachIndexed$iv = operation.getOperandTypes();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (L1OperandType item$iv : $this$forEachIndexed$iv) {
                void operandType;
                int n = index$iv++;
                L1OperandType l1OperandType = item$iv;
                int i2 = n;
                boolean bl2 = false;
                if (i2 > 0) {
                    visitor2.betweenOperands();
                }
                operandType.dispatch$avail(visitor2, $this$visit_u24lambda_u242.getOperand());
            }
            visitor2.endOperation(operation);
        }
    }

    public final void print(@NotNull StringBuilder builder, @NotNull IdentityHashMap<A_BasicObject, Void> recursionMap, int indent, int highlightPc) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter(recursionMap, (String)"recursionMap");
        String tabs = Strings.INSTANCE.repeated("\t", indent);
        this.printInstructions(recursionMap, indent, (Function3<? super Integer, ? super Integer, ? super String, Unit>)((Function3)new Function3<Integer, Integer, String, Unit>(builder, highlightPc, tabs){
            final /* synthetic */ StringBuilder $builder;
            final /* synthetic */ int $highlightPc;
            final /* synthetic */ String $tabs;
            {
                this.$builder = $builder;
                this.$highlightPc = $highlightPc;
                this.$tabs = $tabs;
                super(3);
            }

            public final void invoke(int pc, int line, @NotNull String string2) {
                Intrinsics.checkNotNullParameter((Object)string2, (String)"string");
                if (pc != 1) {
                    this.$builder.append("\n");
                }
                if (pc == this.$highlightPc) {
                    this.$builder.append(" \ud83d\udd35==> ");
                }
                this.$builder.append(this.$tabs + pc + ". [:" + line + "] " + string2);
            }
        }));
    }

    public static /* synthetic */ void print$default(L1Disassembler l1Disassembler, StringBuilder stringBuilder, IdentityHashMap identityHashMap, int n, int n2, int n3, Object object) {
        if ((n3 & 8) != 0) {
            n2 = -1;
        }
        l1Disassembler.print(stringBuilder, identityHashMap, n, n2);
    }

    public final void printInstructions(@NotNull IdentityHashMap<A_BasicObject, Void> recursionMap, int indent, @NotNull Function3<? super Integer, ? super Integer, ? super String, Unit> action2) {
        Intrinsics.checkNotNullParameter(recursionMap, (String)"recursionMap");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        StringBuilder tempBuilder = new StringBuilder();
        Ref.IntRef instructionPc = new Ref.IntRef();
        instructionPc.element = -1;
        Ref.IntRef instructionLine = new Ref.IntRef();
        instructionLine.element = -1;
        L1DisassemblyVisitor visitor2 = new L1DisassemblyVisitor(instructionPc, instructionLine, tempBuilder, action2, this, recursionMap, indent){
            final /* synthetic */ Ref.IntRef $instructionPc;
            final /* synthetic */ Ref.IntRef $instructionLine;
            final /* synthetic */ StringBuilder $tempBuilder;
            final /* synthetic */ Function3<Integer, Integer, String, Unit> $action;
            final /* synthetic */ L1Disassembler this$0;
            final /* synthetic */ IdentityHashMap<A_BasicObject, Void> $recursionMap;
            final /* synthetic */ int $indent;
            {
                this.$instructionPc = $instructionPc;
                this.$instructionLine = $instructionLine;
                this.$tempBuilder = $tempBuilder;
                this.$action = $action;
                this.this$0 = $receiver;
                this.$recursionMap = $recursionMap;
                this.$indent = $indent;
            }

            public void startOperation(@NotNull L1Operation operation, int pc, int line) {
                Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
                this.$instructionPc.element = pc;
                this.$instructionLine.element = line;
                this.$tempBuilder.append(operation.shortName());
                if (!(operation.getOperandTypes().length == 0)) {
                    this.$tempBuilder.append(" ");
                }
            }

            public void betweenOperands() {
                this.$tempBuilder.append(", ");
            }

            public void endOperation(@NotNull L1Operation operation) {
                Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
                Integer n = this.$instructionPc.element;
                Integer n2 = this.$instructionLine.element;
                String string2 = this.$tempBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"tempBuilder.toString()");
                this.$action.invoke((Object)n, (Object)n2, (Object)string2);
                StringsKt.clear((StringBuilder)this.$tempBuilder);
            }

            public void doImmediate(int index2) {
                this.$tempBuilder.append("#" + index2);
            }

            public void doLiteral(int index2) {
                AvailObject value = A_RawFunction.Companion.literalAt(this.this$0.getCode$avail(), index2);
                A_String print2 = (A_String)L1Disassembler.Companion.simplePrintable(value).component1();
                if (print2 == null) {
                    value.printOnAvoidingIndent(this.$tempBuilder, this.$recursionMap, this.$indent + 1);
                } else {
                    this.$tempBuilder.append(print2);
                }
            }

            public void doLocal(int index2) {
                String name = this.this$0.getAllDeclarationNames().get(index2 - 1);
                this.$tempBuilder.append(name);
            }

            public void doOuter(int index2) {
                int i2 = index2 + (this.this$0.getAllDeclarationNames().size() - A_RawFunction.Companion.getNumOuters(this.this$0.getCode$avail()));
                String name = this.this$0.getAllDeclarationNames().get(i2 - 1);
                this.$tempBuilder.append(name);
            }
        };
        this.visit(visitor2);
    }

    @NotNull
    public final List<AvailObjectFieldHelper> disassembledAsSlots(int highlightPc) {
        List slots = new ArrayList();
        Ref.IntRef currentOperationPc = new Ref.IntRef();
        currentOperationPc.element = Integer.MIN_VALUE;
        List operandValues = new ArrayList();
        StringBuilder nameBuilder = new StringBuilder();
        L1DisassemblyVisitor visitor2 = new L1DisassemblyVisitor(currentOperationPc, operandValues, nameBuilder, highlightPc, slots, this){
            final /* synthetic */ Ref.IntRef $currentOperationPc;
            final /* synthetic */ List<AvailObject> $operandValues;
            final /* synthetic */ StringBuilder $nameBuilder;
            final /* synthetic */ int $highlightPc;
            final /* synthetic */ List<AvailObjectFieldHelper> $slots;
            final /* synthetic */ L1Disassembler this$0;
            {
                this.$currentOperationPc = $currentOperationPc;
                this.$operandValues = $operandValues;
                this.$nameBuilder = $nameBuilder;
                this.$highlightPc = $highlightPc;
                this.$slots = $slots;
                this.this$0 = $receiver;
            }

            public void startOperation(@NotNull L1Operation operation, int pc, int line) {
                Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
                this.$currentOperationPc.element = pc;
                this.$operandValues.clear();
                StringsKt.clear((StringBuilder)this.$nameBuilder);
                if (pc == this.$highlightPc) {
                    this.$nameBuilder.append(" \ud83d\udd35==> ");
                }
                this.$nameBuilder.append(pc + ". [:" + line + "] " + operation.shortName());
                if (!(operation.getOperandTypes().length == 0)) {
                    this.$nameBuilder.append(" (");
                }
            }

            public void betweenOperands() {
                this.$nameBuilder.append(", ");
            }

            public void endOperation(@NotNull L1Operation operation) {
                Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
                if (!(operation.getOperandTypes().length == 0)) {
                    this.$nameBuilder.append(")");
                }
                Collection $this$toTypedArray$iv = this.$operandValues;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                this.$slots.add(new AvailObjectFieldHelper(this.this$0.getCode$avail(), AbstractDescriptor.DebuggerObjectSlots.DUMMY_DEBUGGER_SLOT, this.$currentOperationPc.element, ObjectTupleDescriptor.Companion.tupleFromList(this.$operandValues), "Instruction", this.$nameBuilder.toString(), thisCollection$iv.toArray(new AvailObject[0])));
            }

            public void doImmediate(int index2) {
                this.$nameBuilder.append("immediate=" + index2);
            }

            public void doLiteral(int index2) {
                this.$nameBuilder.append("literal#" + index2);
                AvailObject value = A_RawFunction.Companion.literalAt(this.this$0.getCode$avail(), index2);
                L1Disassembler.printIfSimple$default(this.this$0, value, this.$nameBuilder, this.$operandValues, 0, 8, null);
            }

            public void doLocal(int index2) {
                String name = this.this$0.getAllDeclarationNames().get(index2 - 1);
                this.$nameBuilder.append(index2 <= A_RawFunction.Companion.numArgs(this.this$0.getCode$avail()) ? "arg#" + index2 + " = " + name : "local#" + (index2 - A_RawFunction.Companion.numArgs(this.this$0.getCode$avail())) + " = " + name);
            }

            public void doOuter(int index2) {
                int i2 = index2 + (this.this$0.getAllDeclarationNames().size() - A_RawFunction.Companion.getNumOuters(this.this$0.getCode$avail()));
                String name = this.this$0.getAllDeclarationNames().get(i2 - 1);
                this.$nameBuilder.append("outer#" + index2 + " = " + name);
            }
        };
        this.visit(visitor2);
        return slots;
    }

    public static /* synthetic */ List disassembledAsSlots$default(L1Disassembler l1Disassembler, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = -1;
        }
        return l1Disassembler.disassembledAsSlots(n);
    }

    private final void printIfSimple(AvailObject value, StringBuilder builder, List<AvailObject> operandValues, int depth2) {
        if (depth2 > 3) {
            builder.append(" = ***depth***");
            return;
        }
        Pair<A_String, Boolean> pair = Companion.simplePrintable(value);
        A_String print2 = (A_String)pair.component1();
        boolean expand = (Boolean)pair.component2();
        if (depth2 == 0 && expand && operandValues != null) {
            operandValues.add(value);
        }
        if (print2 != null) {
            builder.append(" = " + print2);
            return;
        }
        if (value.isInstanceOf(VariableTypeDescriptor.Companion.getMostGeneralVariableType())) {
            builder.append(" = var(");
            AvailObject variableValue = value.value();
            this.printIfSimple(variableValue, builder, null, depth2 + 1);
            builder.append(")");
            return;
        }
        if (!value.isType() || !A_Number.Companion.equalsInt(A_Type.Companion.getInstanceCount(value), 1)) {
            return;
        }
        AvailObject instance = A_Type.Companion.getInstance(value);
        A_String print22 = (A_String)Companion.simplePrintable(instance).component1();
        if (print22 != null) {
            builder.append(" = " + print22 + "'s type");
            return;
        }
        if (!instance.isType() || !A_Number.Companion.equalsInt(A_Type.Companion.getInstanceCount(instance), 1)) {
            return;
        }
        AvailObject instanceInstance = A_Type.Companion.getInstance(instance);
        A_String print3 = (A_String)Companion.simplePrintable(instanceInstance).component1();
        if (print3 != null) {
            builder.append(" = " + print3 + "'s type's type");
        } else {
            builder.append(" = (some metatype)");
        }
    }

    static /* synthetic */ void printIfSimple$default(L1Disassembler l1Disassembler, AvailObject availObject, StringBuilder stringBuilder, List list2, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            list2 = null;
        }
        if ((n2 & 8) != 0) {
            n = 0;
        }
        l1Disassembler.printIfSimple(availObject, stringBuilder, list2, n);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H&J \u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH&\u00a8\u0006\u000b\u00c0\u0006\u0003"}, d2={"Lavail/interpreter/levelOne/L1Disassembler$L1DisassemblyVisitor;", "Lavail/interpreter/levelOne/L1OperandTypeDispatcher;", "betweenOperands", "", "endOperation", "operation", "Lavail/interpreter/levelOne/L1Operation;", "startOperation", "pc", "", "line", "avail"})
    public static interface L1DisassemblyVisitor
    extends L1OperandTypeDispatcher {
        public void startOperation(@NotNull L1Operation var1, int var2, int var3);

        public void betweenOperands();

        public void endOperation(@NotNull L1Operation var1);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lavail/interpreter/levelOne/L1Disassembler$Companion;", "", "()V", "simplePrintable", "Lkotlin/Pair;", "Lavail/descriptor/tuples/A_String;", "", "value", "Lavail/descriptor/representation/AvailObject;", "avail"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pair<A_String, Boolean> simplePrintable(@NotNull AvailObject value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return value.isNil() ? TuplesKt.to((Object)value, (Object)false) : (value.isString() ? TuplesKt.to((Object)value, (Object)false) : (value.isInstanceOf(PrimitiveTypeDescriptor.Types.NUMBER.getO()) ? TuplesKt.to((Object)value, (Object)false) : (value.isInstanceOf(PrimitiveTypeDescriptor.Types.MESSAGE_BUNDLE.getO()) ? TuplesKt.to((Object)A_Atom.Companion.getAtomName(A_Bundle.Companion.getMessage(value)), (Object)true) : (value.isInstanceOf(PrimitiveTypeDescriptor.Types.METHOD.getO()) ? TuplesKt.to((Object)value, (Object)true) : (value.isAtom() ? TuplesKt.to((Object)A_Atom.Companion.getAtomName(value), (Object)true) : (A_Character.Companion.isCharacter(value) ? TuplesKt.to((Object)value, (Object)false) : (value.equals(TupleTypeDescriptor.Companion.getMostGeneralTupleType()) ? TuplesKt.to((Object)value, (Object)false) : (value.equals(TupleTypeDescriptor.Companion.getStringType()) ? TuplesKt.to((Object)value, (Object)false) : (value.isInstanceOf(VariableTypeDescriptor.Companion.getMostGeneralVariableType()) ? TuplesKt.to(null, (Object)true) : (!value.isType() ? TuplesKt.to(null, (Object)true) : (value.isTop() ? TuplesKt.to((Object)value, (Object)false) : (value.traversed().descriptor() instanceof PrimitiveTypeDescriptor ? TuplesKt.to((Object)value, (Object)false) : (value.isBottom() ? TuplesKt.to((Object)value, (Object)false) : (value.isInstanceOf(CompiledCodeTypeDescriptor.Companion.mostGeneralCompiledCodeType()) ? TuplesKt.to((Object)A_RawFunction.Companion.getMethodName(value), (Object)true) : (value.isInstanceOf(FunctionTypeDescriptor.Companion.mostGeneralFunctionType()) ? TuplesKt.to((Object)A_RawFunction.Companion.getMethodName(value.code()), (Object)true) : TuplesKt.to(null, (Object)true))))))))))))))));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

