/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.levelTwoSimple;

import avail.descriptor.bundles.A_Bundle;
import avail.descriptor.functions.A_Function;
import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.functions.CompiledCodeDescriptor;
import avail.descriptor.functions.FunctionDescriptor;
import avail.descriptor.methods.A_ChunkDependable;
import avail.descriptor.methods.A_Definition;
import avail.descriptor.methods.A_Method;
import avail.descriptor.methods.A_Sendable;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.StringDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.BottomTypeDescriptor;
import avail.descriptor.types.ContinuationTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.levelOne.L1OperationDispatcher;
import avail.interpreter.levelTwo.L2SimpleChunk;
import avail.interpreter.levelTwo.operand.TypeRestriction;
import avail.interpreter.levelTwoSimple.L2SimpleInstruction;
import avail.interpreter.levelTwoSimple.L2Simple_CheckForInterrupt;
import avail.interpreter.levelTwoSimple.L2Simple_CloseFunction1;
import avail.interpreter.levelTwoSimple.L2Simple_CloseFunction2;
import avail.interpreter.levelTwoSimple.L2Simple_CloseFunction3;
import avail.interpreter.levelTwoSimple.L2Simple_CloseFunction4;
import avail.interpreter.levelTwoSimple.L2Simple_CloseFunctionN;
import avail.interpreter.levelTwoSimple.L2Simple_GeneralCall;
import avail.interpreter.levelTwoSimple.L2Simple_GetConstant;
import avail.interpreter.levelTwoSimple.L2Simple_GetOuter;
import avail.interpreter.levelTwoSimple.L2Simple_GetOuterClearing;
import avail.interpreter.levelTwoSimple.L2Simple_GetVariable;
import avail.interpreter.levelTwoSimple.L2Simple_GetVariableClearing;
import avail.interpreter.levelTwoSimple.L2Simple_Invoke;
import avail.interpreter.levelTwoSimple.L2Simple_MakeTuple1;
import avail.interpreter.levelTwoSimple.L2Simple_MakeTuple2;
import avail.interpreter.levelTwoSimple.L2Simple_MakeTuple3;
import avail.interpreter.levelTwoSimple.L2Simple_MakeTupleN;
import avail.interpreter.levelTwoSimple.L2Simple_Move;
import avail.interpreter.levelTwoSimple.L2Simple_MoveAndMakeImmutable;
import avail.interpreter.levelTwoSimple.L2Simple_MoveConstant;
import avail.interpreter.levelTwoSimple.L2Simple_Permute;
import avail.interpreter.levelTwoSimple.L2Simple_PushLabel;
import avail.interpreter.levelTwoSimple.L2Simple_PushLastOuter;
import avail.interpreter.levelTwoSimple.L2Simple_PushOuter;
import avail.interpreter.levelTwoSimple.L2Simple_SetConstant;
import avail.interpreter.levelTwoSimple.L2Simple_SetOuter;
import avail.interpreter.levelTwoSimple.L2Simple_SetVariable;
import avail.interpreter.levelTwoSimple.L2Simple_SuperCall;
import avail.optimizer.OptimizationLevel;
import avail.performance.Statistic;
import avail.performance.StatisticReport;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 N2\u00020\u0001:\u0001NB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020%H\u0016J\b\u0010'\u001a\u00020%H\u0016J\b\u0010(\u001a\u00020%H\u0016J\b\u0010)\u001a\u00020%H\u0016J\b\u0010*\u001a\u00020%H\u0016J\b\u0010+\u001a\u00020%H\u0016J\b\u0010,\u001a\u00020%H\u0016J\b\u0010-\u001a\u00020%H\u0016J\b\u0010.\u001a\u00020%H\u0016J\b\u0010/\u001a\u00020%H\u0016J\b\u00100\u001a\u00020%H\u0016J\b\u00101\u001a\u00020%H\u0016J\b\u00102\u001a\u00020%H\u0016J\b\u00103\u001a\u00020%H\u0016J\b\u00104\u001a\u00020%H\u0016J\b\u00105\u001a\u00020%H\u0016J\b\u00106\u001a\u00020%H\u0016J\b\u00107\u001a\u00020%H\u0016J\b\u00108\u001a\u00020%H\u0016J\b\u00109\u001a\u00020%H\u0016J\b\u0010:\u001a\u00020%H\u0016J\b\u0010;\u001a\u00020%H\u0016J\u000e\u0010<\u001a\u00020%2\u0006\u0010=\u001a\u00020\u0014J\u0006\u0010>\u001a\u00020?J \u0010@\u001a\u00020%2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020DH\u0002J\u0018\u0010F\u001a\u00020\u001e2\u0006\u0010G\u001a\u00020H2\u0006\u0010C\u001a\u00020DH\u0002J\u001f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u001a0J2\n\b\u0002\u0010K\u001a\u0004\u0018\u00010LH\u0002\u00a2\u0006\u0002\u0010MR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0016R\u001a\u0010 \u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001c\"\u0004\b\"\u0010#\u00a8\u0006O"}, d2={"Lavail/interpreter/levelTwoSimple/L2SimpleTranslator;", "Lavail/interpreter/levelOne/L1OperationDispatcher;", "code", "Lavail/descriptor/functions/A_RawFunction;", "nextOptimizationLevel", "Lavail/optimizer/OptimizationLevel;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "(Lavail/descriptor/functions/A_RawFunction;Lavail/optimizer/OptimizationLevel;Lavail/interpreter/execution/Interpreter;)V", "getCode", "()Lavail/descriptor/functions/A_RawFunction;", "contingentValues", "", "Lavail/descriptor/methods/A_ChunkDependable;", "instructionDecoder", "Lavail/descriptor/functions/CompiledCodeDescriptor$L1InstructionDecoder;", "getInstructionDecoder", "()Lavail/descriptor/functions/CompiledCodeDescriptor$L1InstructionDecoder;", "instructions", "", "Lavail/interpreter/levelTwoSimple/L2SimpleInstruction;", "getInstructions", "()Ljava/util/List;", "getInterpreter", "()Lavail/interpreter/execution/Interpreter;", "pc", "", "getPc", "()I", "restrictions", "Lavail/interpreter/levelTwo/operand/TypeRestriction;", "getRestrictions", "stackp", "getStackp", "setStackp", "(I)V", "L1Ext_doDuplicate", "", "L1Ext_doGetLiteral", "L1Ext_doPermute", "L1Ext_doPushLabel", "L1Ext_doSetLiteral", "L1Ext_doSetLocalSlot", "L1Ext_doSuperCall", "L1_doCall", "L1_doClose", "L1_doExtension", "L1_doGetLocal", "L1_doGetLocalClearing", "L1_doGetOuter", "L1_doGetOuterClearing", "L1_doMakeTuple", "L1_doPop", "L1_doPushLastLocal", "L1_doPushLastOuter", "L1_doPushLiteral", "L1_doPushLocal", "L1_doPushOuter", "L1_doSetLocal", "L1_doSetOuter", "add", "instruction", "createChunk", "Lavail/interpreter/levelTwo/L2SimpleChunk;", "generateGeneralCall", "bundle", "Lavail/descriptor/bundles/A_Bundle;", "expectedType", "Lavail/descriptor/types/A_Type;", "superUnionType", "generateGeneralInvocation", "calledFunction", "Lavail/descriptor/functions/A_Function;", "liveIndices", "", "rangeToNil", "Lkotlin/ranges/IntRange;", "(Lkotlin/ranges/IntRange;)[Ljava/lang/Integer;", "Companion", "avail"})
public final class L2SimpleTranslator
implements L1OperationDispatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final A_RawFunction code;
    @NotNull
    private final OptimizationLevel nextOptimizationLevel;
    @NotNull
    private final Interpreter interpreter;
    @NotNull
    private final List<TypeRestriction> restrictions;
    @NotNull
    private final List<L2SimpleInstruction> instructions;
    private int stackp;
    @NotNull
    private final CompiledCodeDescriptor.L1InstructionDecoder instructionDecoder;
    @NotNull
    private final Set<A_ChunkDependable> contingentValues;
    @NotNull
    private static final Statistic simpleTranslationStat = new Statistic(StatisticReport.L2_OPTIMIZATION_TIME, "L2Simple translation");

    public L2SimpleTranslator(@NotNull A_RawFunction code, @NotNull OptimizationLevel nextOptimizationLevel, @NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)((Object)nextOptimizationLevel), (String)"nextOptimizationLevel");
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        this.code = code;
        this.nextOptimizationLevel = nextOptimizationLevel;
        this.interpreter = interpreter;
        int n = A_RawFunction.Companion.getNumSlots(this.code) + 1;
        L2SimpleTranslator l2SimpleTranslator = this;
        ArrayList<TypeRestriction> arrayList = new ArrayList<TypeRestriction>(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = n3 = n2++;
            ArrayList<TypeRestriction> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(TypeRestriction.Companion.getNilRestriction());
        }
        l2SimpleTranslator.restrictions = arrayList;
        this.instructions = new ArrayList();
        this.stackp = A_RawFunction.Companion.getNumSlots(this.code) + 1;
        this.instructionDecoder = new CompiledCodeDescriptor.L1InstructionDecoder();
        this.contingentValues = new LinkedHashSet();
    }

    @NotNull
    public final A_RawFunction getCode() {
        return this.code;
    }

    @NotNull
    public final Interpreter getInterpreter() {
        return this.interpreter;
    }

    @NotNull
    public final List<TypeRestriction> getRestrictions() {
        return this.restrictions;
    }

    @NotNull
    public final List<L2SimpleInstruction> getInstructions() {
        return this.instructions;
    }

    public final int getStackp() {
        return this.stackp;
    }

    public final void setStackp(int n) {
        this.stackp = n;
    }

    @NotNull
    public final CompiledCodeDescriptor.L1InstructionDecoder getInstructionDecoder() {
        return this.instructionDecoder;
    }

    public final int getPc() {
        return this.instructionDecoder.pc();
    }

    @NotNull
    public final L2SimpleChunk createChunk() {
        int n;
        A_Type funType = this.code.functionType();
        this.restrictions.set(0, TypeRestriction.Companion.restrictionForType(funType, TypeRestriction.RestrictionFlagEncoding.BOXED_FLAG));
        A_Type paramTypes = A_Type.Companion.getArgsTupleType(funType);
        int numArgs = A_RawFunction.Companion.numArgs(this.code);
        int i2 = 1;
        if (i2 <= numArgs) {
            while (true) {
                this.restrictions.set(i2, TypeRestriction.Companion.restrictionForType(A_Type.Companion.typeAtIndex(paramTypes, i2), TypeRestriction.RestrictionFlagEncoding.BOXED_FLAG));
                if (i2 == numArgs) break;
                ++i2;
            }
        }
        if ((i2 = 1) <= (n = A_RawFunction.Companion.getNumLocals(this.code))) {
            while (true) {
                this.restrictions.set(i2 + numArgs, TypeRestriction.Companion.restrictionForType(A_RawFunction.Companion.localTypeAt(this.code, i2), TypeRestriction.RestrictionFlagEncoding.BOXED_FLAG));
                if (i2 == n) break;
                ++i2;
            }
        }
        this.code.setUpInstructionDecoder(this.instructionDecoder);
        this.instructionDecoder.pc(1);
        this.add(new L2Simple_CheckForInterrupt(this.stackp, this.getPc(), this.instructions.size() + 1, L2SimpleTranslator.liveIndices$default(this, null, 1, null)));
        while (!this.instructionDecoder.atEnd()) {
            this.instructionDecoder.getOperation().dispatch(this);
        }
        int n2 = i2 = this.stackp == A_RawFunction.Companion.getNumSlots(this.code) ? 1 : 0;
        if (_Assertions.ENABLED && i2 == 0) {
            boolean bl = false;
            String string2 = "One value should have been left on stack";
            throw new AssertionError((Object)string2);
        }
        L2SimpleChunk chunk = L2SimpleChunk.Companion.allocate(this.code, this.code.codePrimitive() == null ? 0 : -1, this.instructions, SetDescriptor.Companion.setFromCollection((Collection<? extends A_BasicObject>)this.contingentValues), this.nextOptimizationLevel);
        A_RawFunction.Companion.setStartingChunkAndReoptimizationCountdown(this.code, chunk, this.nextOptimizationLevel.getCountdown());
        return chunk;
    }

    public final void add(@NotNull L2SimpleInstruction instruction2) {
        Intrinsics.checkNotNullParameter((Object)instruction2, (String)"instruction");
        this.instructions.add(instruction2);
    }

    /*
     * WARNING - void declaration
     */
    private final void generateGeneralCall(A_Bundle bundle, A_Type expectedType, A_Type superUnionType) {
        void $this$fold$iv;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$mapTo$iv$iv;
        int numArgs = A_Bundle.Companion.getNumArgs(bundle);
        Integer[] registerIndices = this.liveIndices(RangesKt.until((int)(this.stackp - numArgs + 1), (int)this.stackp));
        registerIndices[this.stackp - 1] = this.stackp;
        Iterable $this$map$iv = (Iterable)RangesKt.downTo((int)this.stackp, (int)(this.stackp - numArgs + 1));
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(this.restrictions.get((int)it));
        }
        List argTypes2 = (List)destination$iv$iv;
        Iterable $i$f$map22 = A_Method.Companion.definitionsAtOrBelow(A_Bundle.Companion.getBundleMethod(bundle), argTypes2);
        boolean $i$f$filter22 = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            A_Definition it = (A_Definition)element$iv$iv;
            boolean bl = false;
            if (!A_Sendable.Companion.isMethodDefinition(it)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List possible = (List)destination$iv$iv2;
        Iterable $i$f$filter22 = possible;
        A_Type initial$iv = BottomTypeDescriptor.Companion.getBottom();
        boolean $i$f$fold = false;
        A_Type accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void def;
            A_Definition it = (A_Definition)element$iv;
            A_Type typeUnion = accumulator$iv;
            boolean bl = false;
            accumulator$iv = A_Type.Companion.typeUnion(typeUnion, A_Type.Companion.getReturnType(A_Sendable.Companion.bodySignature((A_Sendable)def)));
        }
        A_Type possibleType = accumulator$iv;
        if (superUnionType.isBottom()) {
            this.instructions.add(new L2Simple_GeneralCall(this.stackp, this.getPc(), this.instructions.size() + 1, registerIndices, expectedType, !A_Type.Companion.isSubtypeOf(possibleType, expectedType), bundle));
        } else {
            this.instructions.add(new L2Simple_SuperCall(this.stackp, this.getPc(), this.instructions.size() + 1, registerIndices, expectedType, !A_Type.Companion.isSubtypeOf(possibleType, expectedType), bundle, superUnionType));
        }
        int n = this.stackp;
        for (int i2 = this.stackp - numArgs + 1; i2 < n; ++i2) {
            this.restrictions.set(i2, TypeRestriction.Companion.getNilRestriction());
        }
        this.restrictions.set(this.stackp, TypeRestriction.Companion.restrictionForType(A_Type.Companion.typeIntersection(possibleType, expectedType), TypeRestriction.RestrictionFlagEncoding.BOXED_FLAG));
    }

    /*
     * WARNING - void declaration
     */
    private final TypeRestriction generateGeneralInvocation(A_Function calledFunction, A_Type expectedType) {
        A_Type guaranteedReturnType;
        A_RawFunction calledCode = calledFunction.code();
        int numArgs = A_RawFunction.Companion.numArgs(calledCode);
        Integer[] registerIndices = this.liveIndices(RangesKt.until((int)(this.stackp - numArgs + 1), (int)this.stackp));
        registerIndices[this.stackp - 1] = this.stackp;
        Primitive prim = calledCode.codePrimitive();
        if (prim != null) {
            Collection<A_Type> collection2;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = (Iterable)RangesKt.downTo((int)this.stackp, (int)(this.stackp - numArgs + 1));
            A_RawFunction a_RawFunction = calledCode;
            Primitive primitive2 = prim;
            A_Type.Companion companion = A_Type.Companion;
            boolean $i$f$map = false;
            void var10_12 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void i2;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(this.restrictions.get((int)i2).getType());
            }
            collection2 = (List)destination$iv$iv;
            v0 = companion.typeIntersection(primitive2.returnTypeGuaranteedByVM(a_RawFunction, (List<? extends A_Type>)collection2), A_Type.Companion.getReturnType(calledCode.functionType()));
        } else {
            v0 = guaranteedReturnType = A_Type.Companion.getReturnType(calledCode.functionType());
        }
        if (A_Number.Companion.equalsInt(A_Type.Companion.getInstanceCount(guaranteedReturnType), 1) && !guaranteedReturnType.isInstanceMeta() && prim != null && prim.hasFlag(Primitive.Flag.CanFold) && A_Type.Companion.isSubtypeOf(guaranteedReturnType, expectedType)) {
            this.instructions.add(new L2Simple_MoveConstant(A_Type.Companion.getInstance(guaranteedReturnType).makeShared(), this.stackp));
            return TypeRestriction.Companion.restrictionForType(A_Type.Companion.typeIntersection(guaranteedReturnType, expectedType), TypeRestriction.RestrictionFlagEncoding.BOXED_FLAG).withFlag(TypeRestriction.RestrictionFlagEncoding.IMMUTABLE_FLAG);
        }
        this.instructions.add(new L2Simple_Invoke(this.stackp, this.getPc(), this.instructions.size() + 1, registerIndices, expectedType, !A_Type.Companion.isSubtypeOf(guaranteedReturnType, expectedType), calledFunction));
        return TypeRestriction.Companion.restrictionForType(A_Type.Companion.typeIntersection(guaranteedReturnType, expectedType), TypeRestriction.RestrictionFlagEncoding.BOXED_FLAG);
    }

    /*
     * Unable to fully structure code
     */
    private final Integer[] liveIndices(IntRange rangeToNil) {
        var4_3 = this.restrictions.size() - 1;
        var5_4 = new Integer[var4_3];
        for (var3_2 = 0; var3_2 < var4_3; ++var3_2) {
            block6: {
                block5: {
                    var6_5 = var3_2;
                    v0 = var5_4;
                    v1 = var6_5;
                    index = var6_5 + 1;
                    $this$notNullAnd$iv = this.restrictions.get(index).getConstantOrNull();
                    $i$f$notNullAnd = false;
                    if ($this$notNullAnd$iv == null) ** GOTO lbl-1000
                    var10_9 = $this$notNullAnd$iv;
                    var13_12 = v1;
                    var12_11 = v0;
                    $i$a$-notNullAnd-L2SimpleTranslator$liveIndices$array$1$1 = false;
                    var14_13 = $this$liveIndices_u24lambda_u246.isNil();
                    v0 = var12_11;
                    v1 = var13_12;
                    if (var14_13) {
                        v2 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v2 = false;
                    }
                    if (!v2) break block5;
                    v3 = 0;
                    break block6;
                }
                $this$notNullAnd$iv = rangeToNil;
                $i$f$notNullAnd = false;
                if ($this$notNullAnd$iv == null) ** GOTO lbl-1000
                $this$liveIndices_u24lambda_u246 = $this$notNullAnd$iv;
                var13_12 = v1;
                var12_11 = v0;
                $i$a$-notNullAnd-L2SimpleTranslator$liveIndices$array$1$2 = false;
                var14_13 = $this$liveIndices_u24lambda_u247.contains(index);
                v0 = var12_11;
                v1 = var13_12;
                if (var14_13) {
                    v4 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v4 = false;
                }
                v3 = v4 != false ? 0 : index;
            }
            v0[v1] = v3;
        }
        array = var5_4;
        v5 = this.interpreter.getArraysForL2Simple().computeIfAbsent(ArraysKt.asList((Object[])array), (Function<Object, Integer[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, liveIndices$lambda$8(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)[Ljava/lang/Integer;)((Function1)((Function1)new Function1<List<? extends Integer>, Integer[]>((Integer[])array){
            final /* synthetic */ Integer[] $array;
            {
                this.$array = $array;
                super(1);
            }

            @NotNull
            public final Integer[] invoke(@NotNull List<Integer> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return this.$array;
            }
        })));
        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"array = Array(restrictio\u2026array.asList()) { array }");
        return v5;
    }

    static /* synthetic */ Integer[] liveIndices$default(L2SimpleTranslator l2SimpleTranslator, IntRange intRange, int n, Object object) {
        if ((n & 1) != 0) {
            intRange = null;
        }
        return l2SimpleTranslator.liveIndices(intRange);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void L1_doCall() {
        void $this$mapTo$iv$iv;
        Collection collection2;
        void $this$mapTo$iv$iv2;
        void $this$map$iv;
        AvailObject bundle = A_RawFunction.Companion.literalAt(this.code, this.instructionDecoder.getOperand());
        AvailObject expectedType = A_RawFunction.Companion.literalAt(this.code, this.instructionDecoder.getOperand());
        A_Method method = A_Bundle.Companion.getBundleMethod(bundle);
        this.contingentValues.add(method);
        int numArgs = A_Method.Companion.getNumArgs(method);
        this.stackp += numArgs - 1;
        Iterable iterable = (Iterable)RangesKt.downTo((int)this.stackp, (int)(this.stackp - numArgs + 1));
        boolean $i$f$map = false;
        void var8_8 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(this.restrictions.get((int)it));
        }
        List argRestrictions = (List)destination$iv$iv;
        Iterable $this$map$iv2 = argRestrictions;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            TypeRestriction bl = (TypeRestriction)item$iv$iv;
            collection2 = destination$iv$iv2;
            boolean bl2 = false;
            collection2.add(p0.getType());
        }
        List argTypes2 = (List)destination$iv$iv2;
        List<A_Definition> possible = A_Method.Companion.definitionsAtOrBelow(method, argRestrictions);
        A_Definition only = (A_Definition)CollectionsKt.singleOrNull(possible);
        if (only == null || !A_Sendable.Companion.isMethodDefinition(only) || !A_Type.Companion.acceptsListOfArgTypes(A_Sendable.Companion.bodySignature(only), argTypes2)) {
            this.generateGeneralCall(bundle, expectedType, BottomTypeDescriptor.Companion.getBottom());
            return;
        }
        A_Function calledFunction = A_Sendable.Companion.bodyBlock(only);
        A_RawFunction calledCode = calledFunction.code();
        Primitive primitive2 = calledCode.codePrimitive();
        TypeRestriction outputRestriction = null;
        if (primitive2 != null) {
            outputRestriction = primitive2.attemptToGenerateSimpleInvocation(this, calledFunction, calledCode, argRestrictions, expectedType);
        }
        if (outputRestriction == null) {
            outputRestriction = this.generateGeneralInvocation(calledFunction, expectedType);
        }
        int n = this.stackp;
        for (int i2 = this.stackp - numArgs + 1; i2 < n; ++i2) {
            this.restrictions.set(i2, TypeRestriction.Companion.getNilRestriction());
        }
        this.restrictions.set(this.stackp, outputRestriction.intersectionWithType(expectedType));
    }

    @Override
    public void L1_doPushLiteral() {
        AvailObject value = A_RawFunction.Companion.literalAt(this.code, this.instructionDecoder.getOperand());
        this.stackp += -1;
        this.add(new L2Simple_MoveConstant(value, this.stackp));
        this.restrictions.set(this.stackp, TypeRestriction.Companion.restrictionForConstant(value, TypeRestriction.RestrictionFlagEncoding.BOXED_FLAG).withFlag(TypeRestriction.RestrictionFlagEncoding.IMMUTABLE_FLAG));
    }

    @Override
    public void L1_doPushLastLocal() {
        int local = this.instructionDecoder.getOperand();
        this.stackp += -1;
        this.add(new L2Simple_Move(local, this.stackp));
        this.restrictions.set(this.stackp, this.restrictions.get(local));
        this.restrictions.set(local, TypeRestriction.Companion.getNilRestriction());
    }

    @Override
    public void L1_doPushLocal() {
        int local = this.instructionDecoder.getOperand();
        this.stackp += -1;
        TypeRestriction oldRestriction = this.restrictions.get(local);
        if (oldRestriction.hasFlag(TypeRestriction.RestrictionFlagEncoding.IMMUTABLE_FLAG)) {
            this.add(new L2Simple_Move(local, this.stackp));
        } else {
            this.add(new L2Simple_MoveAndMakeImmutable(local, this.stackp));
        }
        TypeRestriction newRestriction = oldRestriction.withFlag(TypeRestriction.RestrictionFlagEncoding.IMMUTABLE_FLAG);
        this.restrictions.set(this.stackp, newRestriction);
        this.restrictions.set(local, newRestriction);
    }

    @Override
    public void L1_doPushLastOuter() {
        int outer = this.instructionDecoder.getOperand();
        this.stackp += -1;
        this.add(new L2Simple_PushLastOuter(outer, this.stackp));
        this.restrictions.set(this.stackp, TypeRestriction.Companion.restrictionForType(A_RawFunction.Companion.outerTypeAt(this.code, outer), TypeRestriction.RestrictionFlagEncoding.BOXED_FLAG));
    }

    @Override
    public void L1_doClose() {
        boolean bl;
        int numOuters = this.instructionDecoder.getOperand();
        AvailObject rawFunction2 = A_RawFunction.Companion.literalAt(this.code, this.instructionDecoder.getOperand());
        boolean bl2 = bl = A_RawFunction.Companion.getNumOuters(rawFunction2) == numOuters;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        int oldStackp = this.stackp;
        this.stackp += numOuters - 1;
        this.add(switch (numOuters) {
            case 0 -> {
                A_Function v1 = FunctionDescriptor.Companion.createFunction(this.code, TupleDescriptor.Companion.getEmptyTuple());
                Intrinsics.checkNotNull((Object)v1, (String)"null cannot be cast to non-null type avail.descriptor.representation.AvailObject");
                yield new L2Simple_MoveConstant((AvailObject)v1, this.stackp);
            }
            case 1 -> new L2Simple_CloseFunction1(rawFunction2, this.stackp);
            case 2 -> new L2Simple_CloseFunction2(rawFunction2, this.stackp);
            case 3 -> new L2Simple_CloseFunction3(rawFunction2, this.stackp);
            case 4 -> new L2Simple_CloseFunction4(rawFunction2, this.stackp);
            default -> new L2Simple_CloseFunctionN(rawFunction2, this.stackp);
        });
        int n = this.stackp;
        for (int i2 = oldStackp; i2 < n; ++i2) {
            this.restrictions.set(i2, TypeRestriction.Companion.getNilRestriction());
        }
        this.restrictions.set(this.stackp, TypeRestriction.Companion.restrictionForType(A_Type.Companion.getFunctionType(rawFunction2), TypeRestriction.RestrictionFlagEncoding.BOXED_FLAG));
    }

    @Override
    public void L1_doSetLocal() {
        int variable = this.instructionDecoder.getOperand();
        this.add(new L2Simple_SetVariable(this.stackp, this.getPc(), this.instructions.size() + 1, L2SimpleTranslator.liveIndices$default(this, null, 1, null), variable));
        int n = this.stackp;
        this.stackp = n + 1;
        this.restrictions.set(n, TypeRestriction.Companion.getNilRestriction());
    }

    @Override
    public void L1_doGetLocalClearing() {
        int local = this.instructionDecoder.getOperand();
        this.stackp += -1;
        this.add(new L2Simple_GetVariableClearing(this.stackp, this.getPc(), this.instructions.size() + 1, L2SimpleTranslator.liveIndices$default(this, null, 1, null), local));
        this.restrictions.set(this.stackp, TypeRestriction.Companion.restrictionForType(A_Type.Companion.getReadType(this.restrictions.get(local).getType()), TypeRestriction.RestrictionFlagEncoding.BOXED_FLAG));
    }

    @Override
    public void L1_doPushOuter() {
        int outer = this.instructionDecoder.getOperand();
        this.stackp += -1;
        this.add(new L2Simple_PushOuter(outer, this.stackp));
        this.restrictions.set(this.stackp, TypeRestriction.Companion.restrictionForType(A_RawFunction.Companion.outerTypeAt(this.code, outer), TypeRestriction.RestrictionFlagEncoding.BOXED_FLAG));
    }

    @Override
    public void L1_doPop() {
        int n = this.stackp;
        this.stackp = n + 1;
        this.restrictions.set(this.stackp - 1, TypeRestriction.Companion.getNilRestriction());
    }

    @Override
    public void L1_doGetOuterClearing() {
        int outer = this.instructionDecoder.getOperand();
        this.stackp += -1;
        this.add(new L2Simple_GetOuterClearing(this.stackp, this.getPc(), this.instructions.size() + 1, L2SimpleTranslator.liveIndices$default(this, null, 1, null), outer));
        this.restrictions.set(this.stackp, TypeRestriction.Companion.restrictionForType(A_Type.Companion.getReadType(A_RawFunction.Companion.outerTypeAt(this.code, outer)), TypeRestriction.RestrictionFlagEncoding.BOXED_FLAG));
    }

    @Override
    public void L1_doSetOuter() {
        int outer = this.instructionDecoder.getOperand();
        this.add(new L2Simple_SetOuter(this.stackp, this.getPc(), this.instructions.size() + 1, L2SimpleTranslator.liveIndices$default(this, null, 1, null), outer));
        int n = this.stackp;
        this.stackp = n + 1;
        this.restrictions.set(n, TypeRestriction.Companion.getNilRestriction());
    }

    @Override
    public void L1_doGetLocal() {
        int local = this.instructionDecoder.getOperand();
        this.stackp += -1;
        this.add(new L2Simple_GetVariable(this.stackp, this.getPc(), this.instructions.size() + 1, L2SimpleTranslator.liveIndices$default(this, null, 1, null), local));
        this.restrictions.set(this.stackp, TypeRestriction.Companion.restrictionForType(A_Type.Companion.getReadType(this.restrictions.get(local).getType()), TypeRestriction.RestrictionFlagEncoding.BOXED_FLAG).withFlag(TypeRestriction.RestrictionFlagEncoding.IMMUTABLE_FLAG));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void L1_doMakeTuple() {
        int item$iv$iv;
        Iterator iterator2;
        boolean $i$f$mapTo;
        int size = this.instructionDecoder.getOperand();
        int oldStackp = this.stackp;
        this.stackp += size - 1;
        if (this.instructions.size() >= size) {
            boolean bl;
            block16: {
                Iterable $this$all$iv = (Iterable)new IntRange(1, size);
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    Iterator iterator3 = $this$all$iv.iterator();
                    while (iterator3.hasNext()) {
                        int element$iv;
                        int i2 = element$iv = ((IntIterator)iterator3).nextInt();
                        boolean bl2 = false;
                        L2SimpleInstruction it = this.instructions.get(this.instructions.size() - i2);
                        boolean bl3 = false;
                        if (it instanceof L2Simple_MoveConstant && ((L2Simple_MoveConstant)it).getTo() == oldStackp + i2 - 1) continue;
                        bl = false;
                        break block16;
                    }
                    bl = true;
                }
            }
            if (bl) {
                void $this$mapTo$iv$iv22;
                Iterable $this$map$iv = (Iterable)new IntRange(1, size);
                boolean $i$f$map = false;
                Iterable element$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                iterator2 = $this$mapTo$iv$iv22.iterator();
                while (iterator2.hasNext()) {
                    int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                    Collection collection2 = destination$iv$iv;
                    boolean bl4 = false;
                    Object object = CollectionsKt.removeLast(this.instructions);
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type avail.interpreter.levelTwoSimple.L2Simple_MoveConstant");
                    collection2.add(((L2Simple_MoveConstant)object).getValue());
                }
                List values = CollectionsKt.reversed((Iterable)((List)destination$iv$iv));
                Ref.ObjectRef tuple2 = new Ref.ObjectRef();
                tuple2.element = ObjectTupleDescriptor.Companion.tupleFromList(values);
                if (((A_Tuple)tuple2.element).isString()) {
                    tuple2.element = StringDescriptor.Companion.generateStringFromCodePoints(A_Tuple.Companion.getTupleSize((A_Tuple)tuple2.element), (Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>((Ref.ObjectRef<A_Tuple>)tuple2){
                        final /* synthetic */ Ref.ObjectRef<A_Tuple> $tuple;
                        {
                            this.$tuple = $tuple;
                            super(1);
                        }

                        @NotNull
                        public final Integer invoke(int i2) {
                            return A_Tuple.Companion.tupleCodePointAt((A_Tuple)this.$tuple.element, i2);
                        }
                    }));
                }
                int $this$mapTo$iv$iv22 = this.stackp;
                for (int i3 = oldStackp; i3 < $this$mapTo$iv$iv22; ++i3) {
                    this.restrictions.set(i3, TypeRestriction.Companion.getNilRestriction());
                }
                this.instructions.add(new L2Simple_MoveConstant(((A_Tuple)tuple2.element).makeShared(), this.stackp));
                this.restrictions.set(this.stackp, TypeRestriction.Companion.restrictionForConstant((A_BasicObject)tuple2.element, TypeRestriction.RestrictionFlagEncoding.BOXED_FLAG));
                return;
            }
        }
        this.add(switch (size) {
            case 0 -> new L2Simple_MoveConstant(TupleDescriptor.Companion.getEmptyTuple(), this.stackp);
            case 1 -> new L2Simple_MakeTuple1(this.stackp);
            case 2 -> new L2Simple_MakeTuple2(this.stackp);
            case 3 -> new L2Simple_MakeTuple3(this.stackp);
            default -> new L2Simple_MakeTupleN(size, this.stackp);
        });
        Iterable $this$map$iv = (Iterable)RangesKt.downTo((int)this.stackp, (int)oldStackp);
        boolean $i$f$map = false;
        Iterable $this$mapTo$iv$iv22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        iterator2 = $this$mapTo$iv$iv22.iterator();
        while (iterator2.hasNext()) {
            int it = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection3 = destination$iv$iv;
            boolean bl = false;
            collection3.add(this.restrictions.get(it).getType());
        }
        List types = (List)destination$iv$iv;
        int n = this.stackp;
        for (int i4 = oldStackp; i4 < n; ++i4) {
            this.restrictions.set(i4, TypeRestriction.Companion.getNilRestriction());
        }
        this.restrictions.set(this.stackp, TypeRestriction.Companion.restrictionForType(TupleTypeDescriptor.Companion.tupleTypeForTypesList(types), TypeRestriction.RestrictionFlagEncoding.BOXED_FLAG));
    }

    @Override
    public void L1_doGetOuter() {
        int outer = this.instructionDecoder.getOperand();
        this.stackp += -1;
        this.add(new L2Simple_GetOuter(this.stackp, this.getPc(), this.instructions.size() + 1, L2SimpleTranslator.liveIndices$default(this, null, 1, null), outer));
        this.restrictions.set(this.stackp, TypeRestriction.Companion.restrictionForType(A_Type.Companion.getReadType(A_RawFunction.Companion.outerTypeAt(this.code, outer)), TypeRestriction.RestrictionFlagEncoding.BOXED_FLAG).withFlag(TypeRestriction.RestrictionFlagEncoding.IMMUTABLE_FLAG));
    }

    @Override
    public void L1_doExtension() {
        if (_Assertions.ENABLED) {
            boolean bl = false;
            String string2 = "Illegal dispatch nybblecode";
            throw new AssertionError((Object)string2);
        }
    }

    @Override
    public void L1Ext_doPushLabel() {
        this.stackp += -1;
        this.restrictions.set(this.stackp, TypeRestriction.Companion.restrictionForType(ContinuationTypeDescriptor.Companion.continuationTypeForFunctionType(this.code.functionType()), TypeRestriction.RestrictionFlagEncoding.BOXED_FLAG));
        this.add(new L2Simple_PushLabel(this.stackp, this.getPc(), this.instructions.size() + 1, L2SimpleTranslator.liveIndices$default(this, null, 1, null)));
    }

    @Override
    public void L1Ext_doGetLiteral() {
        AvailObject variable = A_RawFunction.Companion.literalAt(this.code, this.instructionDecoder.getOperand());
        this.stackp += -1;
        this.add(new L2Simple_GetConstant(this.stackp, this.getPc(), this.instructions.size() + 1, L2SimpleTranslator.liveIndices$default(this, null, 1, null), variable));
        this.restrictions.set(this.stackp, TypeRestriction.Companion.restrictionForType(A_Type.Companion.getReadType(variable.kind()), TypeRestriction.RestrictionFlagEncoding.BOXED_FLAG).withFlag(TypeRestriction.RestrictionFlagEncoding.IMMUTABLE_FLAG));
    }

    @Override
    public void L1Ext_doSetLiteral() {
        AvailObject variable = A_RawFunction.Companion.literalAt(this.code, this.instructionDecoder.getOperand());
        this.add(new L2Simple_SetConstant(this.stackp, this.getPc(), this.instructions.size() + 1, L2SimpleTranslator.liveIndices$default(this, null, 1, null), variable));
        int n = this.stackp;
        this.stackp = n + 1;
        this.restrictions.set(n, TypeRestriction.Companion.getNilRestriction());
    }

    @Override
    public void L1Ext_doDuplicate() {
        TypeRestriction oldRestriction = this.restrictions.get(this.stackp);
        if (oldRestriction.hasFlag(TypeRestriction.RestrictionFlagEncoding.IMMUTABLE_FLAG)) {
            this.add(new L2Simple_Move(this.stackp, this.stackp - 1));
        } else {
            this.add(new L2Simple_MoveAndMakeImmutable(this.stackp, this.stackp - 1));
        }
        TypeRestriction newRestriction = oldRestriction.withFlag(TypeRestriction.RestrictionFlagEncoding.IMMUTABLE_FLAG);
        this.restrictions.set(this.stackp, newRestriction);
        this.stackp += -1;
        this.restrictions.set(this.stackp, newRestriction);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void L1Ext_doPermute() {
        Object[] $this$mapTo$iv$iv;
        AvailObject permutation = A_RawFunction.Companion.literalAt(this.code, this.instructionDecoder.getOperand());
        int size = A_Tuple.Companion.getTupleSize(permutation);
        int n = 0;
        Integer[] integerArray = new Integer[size];
        while (n < size) {
            int n2 = n++;
            integerArray[n2] = -1;
        }
        Integer[] reads = integerArray;
        int earliestStackp = this.stackp + size - 1;
        int i2 = 1;
        if (i2 <= size) {
            while (true) {
                reads[A_Tuple.Companion.tupleIntAt((A_Tuple)((A_Tuple)permutation), (int)i2) - 1] = earliestStackp + 1 - i2;
                if (i2 == size) break;
                ++i2;
            }
        }
        Integer[] $this$map$iv = reads;
        int $i$f$map = 0;
        Integer[] integerArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void var13_21 : $this$mapTo$iv$iv) {
            void it;
            int n2 = ((Number)var13_21).intValue();
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(this.restrictions.get((int)it));
        }
        List readRestrictions = (List)destination$iv$iv;
        $i$f$map = 0;
        $this$mapTo$iv$iv = new Integer[size];
        while ($i$f$map < size) {
            int n4 = $i$f$map++;
            $this$mapTo$iv$iv[n4] = earliestStackp - n4;
        }
        Object[] writes = $this$mapTo$iv$iv;
        this.add(new L2Simple_Permute(reads, (Integer[])writes));
        Iterable $this$forEach$iv = CollectionsKt.zip((Iterable)readRestrictions, (Object[])writes);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            TypeRestriction typeRestriction = (TypeRestriction)pair.component1();
            int writeIndex = ((Number)pair.component2()).intValue();
            this.restrictions.set(writeIndex, typeRestriction);
        }
    }

    @Override
    public void L1Ext_doSuperCall() {
        AvailObject bundle = A_RawFunction.Companion.literalAt(this.code, this.instructionDecoder.getOperand());
        AvailObject expectedType = A_RawFunction.Companion.literalAt(this.code, this.instructionDecoder.getOperand());
        AvailObject superUnionType = A_RawFunction.Companion.literalAt(this.code, this.instructionDecoder.getOperand());
        this.stackp += A_Method.Companion.getNumArgs(A_Bundle.Companion.getBundleMethod(bundle)) - 1;
        this.generateGeneralCall(bundle, expectedType, superUnionType);
    }

    @Override
    public void L1Ext_doSetLocalSlot() {
        int localSlot = this.instructionDecoder.getOperand();
        this.add(new L2Simple_Move(this.stackp, localSlot));
        this.restrictions.set(localSlot, this.restrictions.get(this.stackp));
        int n = this.stackp;
        this.stackp = n + 1;
        this.restrictions.set(n, TypeRestriction.Companion.getNilRestriction());
    }

    private static final Integer[] liveIndices$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Integer[])$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lavail/interpreter/levelTwoSimple/L2SimpleTranslator$Companion;", "", "()V", "simpleTranslationStat", "Lavail/performance/Statistic;", "translateToLevelTwoSimple", "Lavail/interpreter/levelTwo/L2SimpleChunk;", "code", "Lavail/descriptor/functions/A_RawFunction;", "nextOptimizationLevel", "Lavail/optimizer/OptimizationLevel;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "avail"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final L2SimpleChunk translateToLevelTwoSimple(@NotNull A_RawFunction code, @NotNull OptimizationLevel nextOptimizationLevel, @NotNull Interpreter interpreter) {
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            Intrinsics.checkNotNullParameter((Object)((Object)nextOptimizationLevel), (String)"nextOptimizationLevel");
            Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
            Statistic statistic = simpleTranslationStat;
            int index$iv = interpreter.getInterpreterIndex();
            boolean $i$f$record = false;
            long before$iv = System.nanoTime();
            boolean bl = false;
            L2SimpleTranslator translator = new L2SimpleTranslator(code, nextOptimizationLevel, interpreter);
            L2SimpleChunk result$iv = translator.createChunk();
            this_$iv.getStatistics()[index$iv].record(System.nanoTime() - before$iv);
            return result$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

