/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.files;

import avail.descriptor.atoms.A_Atom;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.EnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.io.IOSystem;
import avail.utility.Mutable;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014\u00a8\u0006\n"}, d2={"Lavail/interpreter/primitive/files/P_FileCopy;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
public final class P_FileCopy
extends Primitive {
    @NotNull
    public static final P_FileCopy INSTANCE = new P_FileCopy();

    private P_FileCopy() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline, Primitive.Flag.HasSideEffect};
        super(5, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(5);
        AvailObject source = interpreter.argument(0);
        AvailObject destination = interpreter.argument(1);
        AvailObject followSymlinks = interpreter.argument(2);
        AvailObject replace = interpreter.argument(3);
        AvailObject copyAttributes = interpreter.argument(4);
        Path sourcePath = null;
        try {
            Path path2 = IOSystem.Companion.getFileSystem().getPath(A_String.Companion.asNativeString(source), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"IOSystem.fileSystem.getP\u2026\tsource.asNativeString())");
            sourcePath = path2;
            path = IOSystem.Companion.getFileSystem().getPath(A_String.Companion.asNativeString(destination), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"{\n\t\t\t\tsourcePath = IOSys\u2026on.asNativeString())\n\t\t\t}");
        }
        catch (InvalidPathException e) {
            return interpreter.primitiveFailure(AvailErrorCode.E_INVALID_PATH);
        }
        Path destinationPath = path;
        List optionList = new ArrayList();
        if (A_Atom.Companion.getExtractBoolean(replace)) {
            optionList.add(StandardCopyOption.REPLACE_EXISTING);
        }
        if (A_Atom.Companion.getExtractBoolean(copyAttributes)) {
            optionList.add(StandardCopyOption.COPY_ATTRIBUTES);
        }
        Collection $this$toTypedArray$iv = optionList;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        CopyOption[] options = thisCollection$iv.toArray(new CopyOption[0]);
        try {
            EnumSet<Enum> visitOptions = A_Atom.Companion.getExtractBoolean(followSymlinks) ? EnumSet.of((Enum)FileVisitOption.FOLLOW_LINKS) : EnumSet.noneOf(FileVisitOption.class);
            Mutable<Boolean> partialSuccess = new Mutable<Boolean>(false);
            Files.walkFileTree(sourcePath, (Set<FileVisitOption>)visitOptions, Integer.MAX_VALUE, (FileVisitor<? super Path>)new FileVisitor<Path>(destinationPath, sourcePath, options, partialSuccess){
                final /* synthetic */ Path $destinationPath;
                final /* synthetic */ Path $sourcePath;
                final /* synthetic */ CopyOption[] $options;
                final /* synthetic */ Mutable<Boolean> $partialSuccess;
                {
                    this.$destinationPath = $destinationPath;
                    this.$sourcePath = $sourcePath;
                    this.$options = $options;
                    this.$partialSuccess = $partialSuccess;
                }

                @NotNull
                public FileVisitResult preVisitDirectory(@Nullable Path dir, @Nullable BasicFileAttributes unused) throws IOException {
                    block3: {
                        boolean bl;
                        boolean bl2 = bl = dir != null;
                        if (_Assertions.ENABLED && !bl) {
                            String string2 = "Assertion failed";
                            throw new AssertionError((Object)string2);
                        }
                        Path path = dir;
                        Intrinsics.checkNotNull((Object)path);
                        Path dstDir = this.$destinationPath.resolve(this.$sourcePath.relativize(path));
                        try {
                            Files.copy(dir, dstDir, Arrays.copyOf(this.$options, this.$options.length));
                        }
                        catch (FileAlreadyExistsException e) {
                            if (Files.isDirectory(dstDir, new LinkOption[0])) break block3;
                            throw e;
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }

                @NotNull
                public FileVisitResult visitFile(@Nullable Path file2, @Nullable BasicFileAttributes unused) throws IOException {
                    boolean bl;
                    boolean bl2 = bl = file2 != null;
                    if (_Assertions.ENABLED && !bl) {
                        String string2 = "Assertion failed";
                        throw new AssertionError((Object)string2);
                    }
                    Path path = file2;
                    Intrinsics.checkNotNull((Object)path);
                    Files.copy(path, this.$destinationPath.resolve(this.$sourcePath.relativize(file2)), Arrays.copyOf(this.$options, this.$options.length));
                    return FileVisitResult.CONTINUE;
                }

                @NotNull
                public FileVisitResult visitFileFailed(@Nullable Path file2, @Nullable IOException unused) {
                    this.$partialSuccess.setValue(true);
                    return FileVisitResult.CONTINUE;
                }

                @NotNull
                public FileVisitResult postVisitDirectory(@Nullable Path dir, @Nullable IOException e) {
                    if (e != null) {
                        this.$partialSuccess.setValue(true);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            if (partialSuccess.getValue().booleanValue()) {
                return interpreter.primitiveFailure(AvailErrorCode.E_PARTIAL_SUCCESS);
            }
        }
        catch (SecurityException e) {
            return interpreter.primitiveFailure(AvailErrorCode.E_PERMISSION_DENIED);
        }
        catch (AccessDeniedException e) {
            return interpreter.primitiveFailure(AvailErrorCode.E_PERMISSION_DENIED);
        }
        catch (IOException e) {
            return interpreter.primitiveFailure(AvailErrorCode.E_IO_ERROR);
        }
        return interpreter.primitiveSuccess(NilDescriptor.Companion.getNil());
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(TupleTypeDescriptor.Companion.getStringType(), TupleTypeDescriptor.Companion.getStringType(), EnumerationTypeDescriptor.Companion.getBooleanType(), EnumerationTypeDescriptor.Companion.getBooleanType(), EnumerationTypeDescriptor.Companion.getBooleanType()), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_INVALID_PATH, AvailErrorCode.E_PERMISSION_DENIED, AvailErrorCode.E_IO_ERROR, AvailErrorCode.E_PARTIAL_SUCCESS};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }
}

