/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.files;

import avail.descriptor.atoms.A_Atom;
import avail.descriptor.numbers.IntegerDescriptor;
import avail.descriptor.pojos.PojoDescriptor;
import avail.descriptor.pojos.RawPojoDescriptor;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.EnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.PojoTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.io.IOSystem;
import java.io.IOError;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014\u00a8\u0006\n"}, d2={"Lavail/interpreter/primitive/files/P_FileMetadata;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
public final class P_FileMetadata
extends Primitive {
    @NotNull
    public static final P_FileMetadata INSTANCE = new P_FileMetadata();

    private P_FileMetadata() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline, Primitive.Flag.HasSideEffect};
        super(2, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        A_BasicObject[] a_BasicObjectArray;
        Class<Object> clazz;
        BasicFileAttributes basicFileAttributes;
        Path path;
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(2);
        AvailObject filename = interpreter.argument(0);
        AvailObject followSymlinks = interpreter.argument(1);
        try {
            Path path2 = IOSystem.Companion.getFileSystem().getPath(A_String.Companion.asNativeString(filename), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"{\n\t\t\t\tIOSystem.fileSyste\u2026me.asNativeString())\n\t\t\t}");
            path = path2;
        }
        catch (InvalidPathException e) {
            return interpreter.primitiveFailure(AvailErrorCode.E_INVALID_PATH);
        }
        Path path3 = path;
        LinkOption[] options = IOSystem.Companion.followSymlinks(A_Atom.Companion.getExtractBoolean(followSymlinks));
        try {
            BasicFileAttributes basicFileAttributes2 = Files.readAttributes(path3, BasicFileAttributes.class, Arrays.copyOf(options, options.length));
            Intrinsics.checkNotNullExpressionValue((Object)basicFileAttributes2, (String)"{\n\t\t\t\tFiles.readAttribut\u2026lass.java, *options)\n\t\t\t}");
            basicFileAttributes = basicFileAttributes2;
        }
        catch (SecurityException e) {
            return interpreter.primitiveFailure(AvailErrorCode.E_PERMISSION_DENIED);
        }
        catch (AccessDeniedException e) {
            return interpreter.primitiveFailure(AvailErrorCode.E_PERMISSION_DENIED);
        }
        catch (IOException e) {
            return interpreter.primitiveFailure(AvailErrorCode.E_IO_ERROR);
        }
        BasicFileAttributes attributes = basicFileAttributes;
        A_BasicObject[] fileId = attributes.fileKey();
        A_BasicObject[] raw = null;
        if (fileId != null) {
            raw = fileId;
            clazz = fileId.getClass();
        } else {
            try {
                a_BasicObjectArray = path3.toAbsolutePath();
            }
            catch (SecurityException e) {
                a_BasicObjectArray = path3;
            }
            catch (IOError e) {
                a_BasicObjectArray = path3;
            }
            Intrinsics.checkNotNullExpressionValue((Object)a_BasicObjectArray, (String)"try\n\t\t\t\t{\n\t\t\t\t\tpath.toAb\u2026or)\n\t\t\t\t{\n\t\t\t\t\tpath\n\t\t\t\t}");
            raw = a_BasicObjectArray;
            clazz = Path.class;
        }
        Class<?> rawClass = clazz;
        a_BasicObjectArray = new A_BasicObject[6];
        a_BasicObjectArray[0] = PojoDescriptor.Companion.newPojo(RawPojoDescriptor.Companion.equalityPojo(raw), PojoTypeDescriptor.Companion.pojoTypeForClass(rawClass));
        a_BasicObjectArray[1] = IntegerDescriptor.Companion.fromInt(attributes.isRegularFile() ? 1 : (attributes.isDirectory() ? 2 : (attributes.isSymbolicLink() ? 3 : 4)));
        a_BasicObjectArray[2] = IntegerDescriptor.Companion.fromLong(attributes.creationTime().toMillis());
        a_BasicObjectArray[3] = IntegerDescriptor.Companion.fromLong(attributes.lastModifiedTime().toMillis());
        a_BasicObjectArray[4] = IntegerDescriptor.Companion.fromLong(attributes.lastAccessTime().toMillis());
        a_BasicObjectArray[5] = IntegerDescriptor.Companion.fromLong(attributes.size());
        A_Tuple tuple2 = ObjectTupleDescriptor.Companion.tupleFromArray(a_BasicObjectArray);
        return interpreter.primitiveSuccess(tuple2);
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(TupleTypeDescriptor.Companion.getStringType(), EnumerationTypeDescriptor.Companion.getBooleanType()), TupleTypeDescriptor.Companion.tupleTypeForSizesTypesDefaultType(IntegerRangeTypeDescriptor.Companion.singleInt(6), ObjectTupleDescriptor.Companion.tuple(PojoTypeDescriptor.Companion.mostGeneralPojoType(), IntegerRangeTypeDescriptor.Companion.inclusive(1L, 4L)), IntegerRangeTypeDescriptor.Companion.inclusive(0L, Long.MAX_VALUE)), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_INVALID_PATH, AvailErrorCode.E_PERMISSION_DENIED, AvailErrorCode.E_IO_ERROR};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }
}

