/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.phrases;

import avail.descriptor.atoms.A_Atom;
import avail.descriptor.bundles.A_Bundle;
import avail.descriptor.methods.A_Sendable;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.PhraseTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014\u00a8\u0006\n"}, d2={"Lavail/interpreter/primitive/phrases/P_LookupMacro;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
public final class P_LookupMacro
extends Primitive {
    @NotNull
    public static final P_LookupMacro INSTANCE = new P_LookupMacro();

    private P_LookupMacro() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline, Primitive.Flag.ReadsFromHiddenGlobalState};
        super(2, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(2);
        List<AvailObject> list2 = interpreter.argsBuffer;
        AvailObject atom = list2.get(0);
        AvailObject argPhrasesTuple = list2.get(1);
        A_Bundle bundle = A_Atom.Companion.getBundleOrNil(atom);
        if (bundle.isNil()) {
            return interpreter.primitiveFailure(AvailErrorCode.E_NO_METHOD_DEFINITION);
        }
        int bundleArgCount = A_Bundle.Companion.getNumArgs(bundle);
        if (A_Tuple.Companion.getTupleSize(argPhrasesTuple) != bundleArgCount) {
            return interpreter.primitiveFailure(AvailErrorCode.E_INCORRECT_NUMBER_OF_ARGUMENTS);
        }
        A_Tuple bestMacros = A_Bundle.Companion.lookupMacroByPhraseTuple(bundle, argPhrasesTuple);
        return switch (A_Tuple.Companion.getTupleSize(bestMacros)) {
            case 0 -> interpreter.primitiveFailure(AvailErrorCode.E_NO_METHOD_DEFINITION);
            case 1 -> interpreter.primitiveSuccess(A_Sendable.Companion.bodyBlock(A_Tuple.Companion.tupleAt(bestMacros, 1)));
            default -> interpreter.primitiveFailure(AvailErrorCode.E_AMBIGUOUS_METHOD_DEFINITION);
        };
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(PrimitiveTypeDescriptor.Types.ATOM.getO(), TupleTypeDescriptor.Companion.zeroOrMoreOf(PhraseTypeDescriptor.PhraseKind.PARSE_PHRASE.getMostGeneralType())), FunctionTypeDescriptor.Companion.functionTypeReturning(PhraseTypeDescriptor.PhraseKind.PARSE_PHRASE.getMostGeneralType()), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_INCORRECT_NUMBER_OF_ARGUMENTS, AvailErrorCode.E_NO_METHOD_DEFINITION, AvailErrorCode.E_AMBIGUOUS_METHOD_DEFINITION};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }
}

