/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.tuples;

import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.numbers.IntegerDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.ConcatenatedTupleTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.primitive.tuples.P_ExtractSubtuple;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0014J\b\u0010\r\u001a\u00020\u000bH\u0014J\u001e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016\u00a8\u0006\u0011"}, d2={"Lavail/interpreter/primitive/tuples/P_TupleReplaceRange;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "fallibilityForArgumentTypes", "Lavail/interpreter/Primitive$Fallibility;", "argumentTypes", "", "Lavail/descriptor/types/A_Type;", "privateBlockTypeRestriction", "privateFailureVariableType", "returnTypeGuaranteedByVM", "rawFunction", "Lavail/descriptor/functions/A_RawFunction;", "avail"})
public final class P_TupleReplaceRange
extends Primitive {
    @NotNull
    public static final P_TupleReplaceRange INSTANCE = new P_TupleReplaceRange();

    private P_TupleReplaceRange() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline, Primitive.Flag.CanFold};
        super(4, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(4);
        AvailObject originalTuple = interpreter.argument(0);
        AvailObject firstIndex = interpreter.argument(1);
        AvailObject lastIndex = interpreter.argument(2);
        AvailObject replacementSubtuple = interpreter.argument(3);
        if (!A_Number.Companion.isInt(firstIndex) || !A_Number.Companion.isInt(lastIndex)) {
            return interpreter.primitiveFailure(AvailErrorCode.E_SUBSCRIPT_OUT_OF_BOUNDS);
        }
        int startInt = A_Number.Companion.getExtractInt(firstIndex);
        int endInt = A_Number.Companion.getExtractInt(lastIndex);
        if (startInt < 1 || endInt < 0 || startInt > endInt + 1) {
            return interpreter.primitiveFailure(AvailErrorCode.E_NEGATIVE_SIZE);
        }
        int originalSize = A_Tuple.Companion.getTupleSize(originalTuple);
        if (endInt > originalSize) {
            return interpreter.primitiveFailure(AvailErrorCode.E_SUBSCRIPT_OUT_OF_BOUNDS);
        }
        A_Tuple result2 = null;
        int sizeToReplace = endInt - startInt + 1;
        if (sizeToReplace < 10 && A_Tuple.Companion.getTupleSize(replacementSubtuple) == sizeToReplace) {
            int sourceIndex = 1;
            result2 = originalTuple;
            int destIndex = startInt;
            if (destIndex <= endInt) {
                while (true) {
                    result2 = TupleDescriptor.Companion.staticTupleAtPutting(result2, destIndex, A_Tuple.Companion.tupleAt(replacementSubtuple, sourceIndex++));
                    if (destIndex != endInt) {
                        ++destIndex;
                        continue;
                    }
                    break;
                }
            }
        } else {
            boolean bl;
            A_Tuple leftPart = A_Tuple.Companion.copyTupleFromToCanDestroy(originalTuple, 1, startInt - 1, false);
            A_Tuple rightPart = A_Tuple.Companion.copyTupleFromToCanDestroy(originalTuple, endInt + 1, originalSize, true);
            result2 = A_Tuple.Companion.concatenateWith(A_Tuple.Companion.concatenateWith(leftPart, replacementSubtuple, true), rightPart, true);
            boolean bl2 = bl = A_Tuple.Companion.getTupleSize(result2) == originalSize - sizeToReplace + A_Tuple.Companion.getTupleSize(replacementSubtuple);
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
        }
        return interpreter.primitiveSuccess(result2);
    }

    @Override
    @NotNull
    public Primitive.Fallibility fallibilityForArgumentTypes(@NotNull List<? extends A_Type> argumentTypes) {
        Intrinsics.checkNotNullParameter(argumentTypes, (String)"argumentTypes");
        A_Type tupleType = argumentTypes.get(0);
        A_Type startType = argumentTypes.get(1);
        A_Type endType = argumentTypes.get(2);
        A_Type tupleSizeRange = A_Type.Companion.getSizeRange(tupleType);
        Primitive.Fallibility leftFallibility = P_ExtractSubtuple.INSTANCE.checkFallibility(tupleSizeRange, IntegerRangeTypeDescriptor.Companion.singleInt(1), IntegerRangeTypeDescriptor.Companion.integerRangeType(A_Number.Companion.noFailMinusCanDestroy(A_Type.Companion.getLowerBound(startType), IntegerDescriptor.Companion.getOne(), false), A_Type.Companion.getLowerInclusive(startType), A_Number.Companion.noFailMinusCanDestroy(A_Type.Companion.getUpperBound(startType), IntegerDescriptor.Companion.getOne(), false), A_Type.Companion.getUpperInclusive(startType)));
        Primitive.Fallibility rightFallibility = P_ExtractSubtuple.INSTANCE.checkFallibility(tupleSizeRange, IntegerRangeTypeDescriptor.Companion.integerRangeType(A_Number.Companion.noFailPlusCanDestroy(A_Type.Companion.getLowerBound(endType), IntegerDescriptor.Companion.getOne(), false), A_Type.Companion.getLowerInclusive(endType), A_Number.Companion.noFailPlusCanDestroy(A_Type.Companion.getUpperBound(endType), IntegerDescriptor.Companion.getOne(), false), A_Type.Companion.getUpperInclusive(endType)), tupleSizeRange);
        return leftFallibility == Primitive.Fallibility.CallSiteMustFail ? Primitive.Fallibility.CallSiteMustFail : (rightFallibility == Primitive.Fallibility.CallSiteMustFail ? Primitive.Fallibility.CallSiteMustFail : (leftFallibility == Primitive.Fallibility.CallSiteCanFail ? Primitive.Fallibility.CallSiteCanFail : (rightFallibility == Primitive.Fallibility.CallSiteCanFail ? Primitive.Fallibility.CallSiteCanFail : Primitive.Fallibility.CallSiteCannotFail)));
    }

    @Override
    @NotNull
    public A_Type returnTypeGuaranteedByVM(@NotNull A_RawFunction rawFunction2, @NotNull List<? extends A_Type> argumentTypes) {
        Intrinsics.checkNotNullParameter((Object)rawFunction2, (String)"rawFunction");
        Intrinsics.checkNotNullParameter(argumentTypes, (String)"argumentTypes");
        A_Type tupleType = argumentTypes.get(0);
        A_Type startType = argumentTypes.get(1);
        A_Type endType = argumentTypes.get(2);
        A_Type replacementType = argumentTypes.get(3);
        A_Type tupleSizeRange = A_Type.Companion.getSizeRange(tupleType);
        A_Type leftTupleType = P_ExtractSubtuple.INSTANCE.computeSliceType(tupleType, IntegerRangeTypeDescriptor.Companion.singleInt(1), IntegerRangeTypeDescriptor.Companion.integerRangeType(A_Number.Companion.noFailMinusCanDestroy(A_Type.Companion.getLowerBound(startType), IntegerDescriptor.Companion.getOne(), false), A_Type.Companion.getLowerInclusive(startType), A_Number.Companion.noFailMinusCanDestroy(A_Type.Companion.getUpperBound(startType), IntegerDescriptor.Companion.getOne(), false), A_Type.Companion.getUpperInclusive(startType)));
        A_Type rightTupleType = P_ExtractSubtuple.INSTANCE.computeSliceType(tupleType, IntegerRangeTypeDescriptor.Companion.integerRangeType(A_Number.Companion.noFailPlusCanDestroy(A_Type.Companion.getLowerBound(endType), IntegerDescriptor.Companion.getOne(), false), A_Type.Companion.getLowerInclusive(endType), A_Number.Companion.noFailPlusCanDestroy(A_Type.Companion.getUpperBound(endType), IntegerDescriptor.Companion.getOne(), false), A_Type.Companion.getUpperInclusive(endType)), tupleSizeRange);
        return ConcatenatedTupleTypeDescriptor.Companion.concatenatingAnd(leftTupleType, ConcatenatedTupleTypeDescriptor.Companion.concatenatingAnd(replacementType, rightTupleType));
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(TupleTypeDescriptor.Companion.getMostGeneralTupleType(), IntegerRangeTypeDescriptor.Companion.getNaturalNumbers(), IntegerRangeTypeDescriptor.Companion.getWholeNumbers(), TupleTypeDescriptor.Companion.getMostGeneralTupleType()), TupleTypeDescriptor.Companion.getMostGeneralTupleType(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_SUBSCRIPT_OUT_OF_BOUNDS, AvailErrorCode.E_NEGATIVE_SIZE};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }
}

