/*
 * Decompiled with CFR 0.152.
 */
package avail.io;

import avail.io.NybbleArray;
import avail.io.NybbleOutputStream;
import java.io.ByteArrayOutputStream;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000-\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002*\u0001\t\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003R\u0015\u0010\u0005\u001a\u00020\u00038\u00c2\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0015\u0010\u000b\u001a\u00020\u00038\u00c2\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0007R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lavail/io/NybbleOutputStream;", "", "initialCapacity", "", "(I)V", "byteIndex", "getByteIndex", "()I", "bytes", "avail/io/NybbleOutputStream$bytes$1", "Lavail/io/NybbleOutputStream$bytes$1;", "lastByte", "getLastByte", "nybbleIndex", "size", "getSize", "toNybbleArray", "Lavail/io/NybbleArray;", "toString", "", "write", "", "nybble", "avail"})
public final class NybbleOutputStream {
    @NotNull
    private final bytes.1 bytes;
    private int nybbleIndex;

    public NybbleOutputStream(int initialCapacity) {
        int n = (initialCapacity >>> 1) + (initialCapacity & 1);
        this.bytes = new ByteArrayOutputStream(n){

            public final byte[] getBuffer() {
                return this.buf;
            }
        };
    }

    public /* synthetic */ NybbleOutputStream(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        this(n);
    }

    public final int getSize() {
        return this.nybbleIndex;
    }

    private final int getByteIndex() {
        boolean $i$f$getByteIndex = false;
        return this.nybbleIndex >>> 1;
    }

    private final int getLastByte() {
        boolean $i$f$getLastByte = false;
        NybbleOutputStream this_$iv = this;
        boolean $i$f$getByteIndex = false;
        return this.bytes.getBuffer()[this_$iv.nybbleIndex >>> 1];
    }

    public final void write(int nybble) {
        boolean bl;
        boolean bl2 = 0 <= nybble ? nybble < 16 : (bl = false);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-NybbleOutputStream$write$22 = false;
            String $i$a$-assert-NybbleOutputStream$write$22 = "b must be in [0..15]";
            throw new AssertionError((Object)$i$a$-assert-NybbleOutputStream$write$22);
        }
        if ((this.nybbleIndex & 1) == 1) {
            NybbleOutputStream this_$iv = this;
            boolean $i$f$getByteIndex = false;
            this_$iv = this;
            boolean $i$f$getLastByte = false;
            NybbleOutputStream this_$iv$iv = this_$iv;
            boolean $i$f$getByteIndex2 = false;
            this.bytes.getBuffer()[this_$iv.nybbleIndex >>> 1] = (byte)(this_$iv.bytes.getBuffer()[this_$iv$iv.nybbleIndex >>> 1] | nybble << 4);
        } else {
            this.bytes.write(nybble);
        }
        int n = this.nybbleIndex;
        this.nybbleIndex = n + 1;
    }

    @NotNull
    public final NybbleArray toNybbleArray() {
        byte[] byArray = this.bytes.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"bytes.toByteArray()");
        return new NybbleArray(byArray, this.getSize());
    }

    @NotNull
    public String toString() {
        return this.toNybbleArray().toString();
    }

    public NybbleOutputStream() {
        this(0, 1, null);
    }
}

