/*
 * Decompiled with CFR 0.152.
 */
package avail.persistence.cache;

import avail.builder.ResolvedModuleName;
import avail.compiler.ModuleManifestEntry;
import avail.compiler.splitter.MessageSplitter;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.StringDescriptor;
import avail.error.ErrorCode;
import avail.persistence.cache.Repository;
import avail.resolver.ResolverReference;
import avail.utility.CodingKt;
import avail.utility.CollectionExtensionsKt;
import avail.utility.Mutable;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.availlang.persistence.IndexedFile;
import org.availlang.persistence.IndexedFileBuilder;
import org.availlang.persistence.IndexedFileException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\u0018\u0000 82\u00020\u0001:\f89:;<=>?@ABCB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0003J\u0006\u0010!\u001a\u00020\u001fJ\b\u0010\"\u001a\u00020\u001fH\u0016J\u0006\u0010#\u001a\u00020\u001fJ\u000e\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\rJ:\u0010&\u001a\u00060'R\u00020\u00002\u0006\u0010(\u001a\u00020\r2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201J\u0012\u00102\u001a\u00060\tR\u00020\u00002\u0006\u00103\u001a\u00020\u0003J\u0006\u00104\u001a\u00020\u001fJ\b\u00105\u001a\u00020\u001fH\u0002J\u0006\u00106\u001a\u00020\u001fJ\b\u00107\u001a\u00020\u0003H\u0016R\u001e\u0010\u0007\u001a\f\u0012\b\u0012\u00060\tR\u00020\u00000\b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\b\u0012\u00060\tR\u00020\u00000\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lavail/persistence/cache/Repository;", "Ljava/io/Closeable;", "rootName", "", "fileName", "Ljava/io/File;", "(Ljava/lang/String;Ljava/io/File;)V", "allArchives", "", "Lavail/persistence/cache/Repository$ModuleArchive;", "getAllArchives$avail", "()Ljava/util/List;", "dirtySince", "", "getFileName", "()Ljava/io/File;", "isOpen", "", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "getLock$avail", "()Ljava/util/concurrent/locks/ReentrantLock;", "moduleMap", "", "repository", "Lorg/availlang/persistence/IndexedFile;", "getRepository$avail", "()Lorg/availlang/persistence/IndexedFile;", "setRepository$avail", "(Lorg/availlang/persistence/IndexedFile;)V", "cleanModulesUnder", "", "rootRelativePath", "clear", "close", "commit", "commitIfStaleChanges", "maximumChangeAgeMs", "createModuleCompilation", "Lavail/persistence/cache/Repository$ModuleCompilation;", "compilationTime", "serializedBody", "", "serializedBlockPhrases", "manifest", "Lavail/persistence/cache/Repository$ManifestRecord;", "stylingRecord", "Lavail/persistence/cache/Repository$StylingRecord;", "phrasePaths", "Lavail/persistence/cache/Repository$PhrasePathRecord;", "getArchive", "rootRelativeName", "markDirty", "openOrCreate", "reopenIfNecessary", "toString", "Companion", "IndexedRepositoryBuilder", "LimitedCache", "ManifestRecord", "ModuleArchive", "ModuleCompilation", "ModuleCompilationKey", "ModuleVersion", "ModuleVersionKey", "PhraseNode", "PhrasePathRecord", "StylingRecord", "avail"})
public final class Repository
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String rootName;
    @NotNull
    private final File fileName;
    @NotNull
    private final ReentrantLock lock;
    @Nullable
    private IndexedFile repository;
    private long dirtySince;
    @NotNull
    private final Map<String, ModuleArchive> moduleMap;
    private boolean isOpen;
    private static final Logger logger = Logger.getLogger(Repository.class.getName());
    private static final int MAX_RECORDED_VERSIONS_PER_MODULE = 10;
    private static final int MAX_RECORDED_DIGESTS_PER_MODULE = 20;
    private static final int MAX_HISTORICAL_VERSION_COMPILATIONS = 10;
    private static final boolean DEBUG_REPOSITORY = false;
    private static final int DIGEST_SIZE = 32;
    @NotNull
    private static final Function2<Integer, Integer, Boolean> versionCheck = Companion.versionCheck.1.INSTANCE;

    public Repository(@NotNull String rootName, @NotNull File fileName) {
        Intrinsics.checkNotNullParameter((Object)rootName, (String)"rootName");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        this.rootName = rootName;
        this.fileName = fileName;
        this.lock = new ReentrantLock();
        this.moduleMap = new LinkedHashMap();
        this.openOrCreate();
    }

    @NotNull
    public final File getFileName() {
        return this.fileName;
    }

    @NotNull
    public final ReentrantLock getLock$avail() {
        return this.lock;
    }

    @Nullable
    public final IndexedFile getRepository$avail() {
        return this.repository;
    }

    public final void setRepository$avail(@Nullable IndexedFile indexedFile) {
        this.repository = indexedFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<ModuleArchive> getAllArchives$avail() {
        List<ModuleArchive> list2;
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            list2 = this.moduleMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(arg_0 -> Repository._get_allArchives_$lambda$1$lambda$0(allArchives.1.1.INSTANCE, arg_0)).toList();
        }
        finally {
            lock.unlock();
        }
        List<ModuleArchive> list3 = Collections.unmodifiableList(list2);
        Intrinsics.checkNotNullExpressionValue(list3, (String)"unmodifiableList(\n\t\t\tloc\u2026ue }\n\t\t\t\t\t.toList()\n\t\t\t})");
        return list3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ModuleCompilation createModuleCompilation(long compilationTime, @NotNull byte[] serializedBody, @NotNull byte[] serializedBlockPhrases, @NotNull ManifestRecord manifest2, @NotNull StylingRecord stylingRecord, @NotNull PhrasePathRecord phrasePaths) {
        ModuleCompilation moduleCompilation;
        Intrinsics.checkNotNullParameter((Object)serializedBody, (String)"serializedBody");
        Intrinsics.checkNotNullParameter((Object)serializedBlockPhrases, (String)"serializedBlockPhrases");
        Intrinsics.checkNotNullParameter((Object)manifest2, (String)"manifest");
        Intrinsics.checkNotNullParameter((Object)stylingRecord, (String)"stylingRecord");
        Intrinsics.checkNotNullParameter((Object)phrasePaths, (String)"phrasePaths");
        IndexedFile.ByteArrayOutputStream manifestBytes = new IndexedFile.ByteArrayOutputStream(4096);
        manifest2.write$avail(new DataOutputStream((OutputStream)manifestBytes));
        IndexedFile.ByteArrayOutputStream innerStylingRecordBytes = new IndexedFile.ByteArrayOutputStream(4096);
        stylingRecord.write$avail(new DataOutputStream((OutputStream)innerStylingRecordBytes));
        IndexedFile.ByteArrayOutputStream innerPhrasePathsBytes = new IndexedFile.ByteArrayOutputStream(4096);
        phrasePaths.write$avail(new DataOutputStream((OutputStream)innerPhrasePathsBytes));
        IndexedFile indexedFile = this.repository;
        Intrinsics.checkNotNull((Object)indexedFile);
        IndexedFile $this$createModuleCompilation_u24lambda_u243 = indexedFile;
        boolean bl = false;
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl2 = false;
            long l = IndexedFile.add$default((IndexedFile)$this$createModuleCompilation_u24lambda_u243, (byte[])serializedBody, (int)0, (int)0, (int)6, null);
            long l2 = IndexedFile.add$default((IndexedFile)$this$createModuleCompilation_u24lambda_u243, (byte[])serializedBlockPhrases, (int)0, (int)0, (int)6, null);
            byte[] byArray = manifestBytes.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"manifestBytes.toByteArray()");
            long l3 = IndexedFile.add$default((IndexedFile)$this$createModuleCompilation_u24lambda_u243, (byte[])byArray, (int)0, (int)0, (int)6, null);
            byte[] byArray2 = innerStylingRecordBytes.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"innerStylingRecordBytes.toByteArray()");
            long l4 = IndexedFile.add$default((IndexedFile)$this$createModuleCompilation_u24lambda_u243, (byte[])byArray2, (int)0, (int)0, (int)6, null);
            byte[] byArray3 = innerPhrasePathsBytes.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"innerPhrasePathsBytes.toByteArray()");
            moduleCompilation = new ModuleCompilation(this, compilationTime, l, l2, l3, l4, IndexedFile.add$default((IndexedFile)$this$createModuleCompilation_u24lambda_u243, (byte[])byArray3, (int)0, (int)0, (int)6, null));
        }
        finally {
            lock.unlock();
        }
        return moduleCompilation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ModuleArchive getArchive(@NotNull String rootRelativeName2) {
        ModuleArchive moduleArchive;
        Intrinsics.checkNotNullParameter((Object)rootRelativeName2, (String)"rootRelativeName");
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl;
            boolean bl2 = false;
            boolean bl3 = bl = !StringsKt.startsWith$default((String)rootRelativeName2, (String)"/", (boolean)false, (int)2, null);
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            ModuleArchive moduleArchive2 = this.moduleMap.computeIfAbsent(rootRelativeName2, arg_0 -> Repository.getArchive$lambda$5$lambda$4((Function1)new Function1<String, ModuleArchive>((Object)this){

                @NotNull
                public final ModuleArchive invoke(@NotNull String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return (Repository)this.receiver.new ModuleArchive(p0);
                }
            }, arg_0));
            moduleArchive = moduleArchive2;
        }
        finally {
            lock.unlock();
        }
        Intrinsics.checkNotNullExpressionValue((Object)moduleArchive, (String)"lock.withLock {\n\t\t\tasser\u2026 this::ModuleArchive)\n\t\t}");
        return moduleArchive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() throws IndexedFileException {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            Level level = Level.INFO;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"INFO");
            Object[] objectArray = new Object[]{this.rootName};
            Companion.log(level, "Clear: %s%n", objectArray);
            this.moduleMap.clear();
            IndexedFile indexedFile = this.repository;
            Intrinsics.checkNotNull((Object)indexedFile);
            IndexedFile repo = indexedFile;
            repo.close();
            this.repository = null;
            try {
                this.fileName.delete();
                this.repository = IndexedFileBuilder.openOrCreate$default((IndexedFileBuilder)IndexedRepositoryBuilder.INSTANCE, (File)this.fileName, (boolean)true, null, (int)0, (int)0, (int)0, (int)0, (int)0, null, (int)508, null);
                this.isOpen = true;
            }
            catch (Exception e) {
                throw new IndexedFileException((Throwable)e);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cleanModulesUnder(@NotNull String rootRelativePath) {
        Intrinsics.checkNotNullParameter((Object)rootRelativePath, (String)"rootRelativePath");
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            for (Map.Entry<String, ModuleArchive> entry : this.moduleMap.entrySet()) {
                String moduleKey = entry.getKey();
                ModuleArchive archive = entry.getValue();
                if (!Intrinsics.areEqual((Object)moduleKey, (Object)rootRelativePath) && !StringsKt.startsWith$default((String)moduleKey, (String)(rootRelativePath + "/"), (boolean)false, (int)2, null)) continue;
                archive.cleanCompilations();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    public final void markDirty() {
        if (this.dirtySince == 0L) {
            this.dirtySince = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void commit() throws IndexedFileException {
        Lock lock = this.lock;
        lock.lock();
        try {
            block12: {
                boolean bl = false;
                try {
                    if (this.dirtySince == 0L) break block12;
                    Level level = Level.FINER;
                    Intrinsics.checkNotNullExpressionValue((Object)level, (String)"FINER");
                    Object[] objectArray = new Object[]{this.rootName};
                    Companion.log(level, "Commit: %s%n", objectArray);
                    IndexedFile.ByteArrayOutputStream byteStream = new IndexedFile.ByteArrayOutputStream(131072);
                    Closeable closeable = new DataOutputStream((OutputStream)byteStream);
                    Throwable throwable = null;
                    try {
                        DataOutputStream binaryStream = (DataOutputStream)closeable;
                        boolean bl2 = false;
                        binaryStream.writeInt(this.moduleMap.size());
                        for (ModuleArchive moduleArchive : this.moduleMap.values()) {
                            moduleArchive.write(binaryStream);
                        }
                        Level level2 = Level.FINEST;
                        Intrinsics.checkNotNullExpressionValue((Object)level2, (String)"FINEST");
                        Object[] objectArray2 = new Object[]{byteStream.size()};
                        Companion.log(level2, "Commit size = %d%n", objectArray2);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    this.reopenIfNecessary();
                    IndexedFile indexedFile = this.repository;
                    Intrinsics.checkNotNull((Object)indexedFile);
                    IndexedFile repo = indexedFile;
                    repo.setMetadata(byteStream.toByteArray());
                    repo.commit();
                    this.dirtySince = 0L;
                }
                catch (IndexedFileException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IndexedFileException((Throwable)e);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void commitIfStaleChanges(long maximumChangeAgeMs) {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            if (this.dirtySince != 0L && System.currentTimeMillis() - this.dirtySince > maximumChangeAgeMs) {
                this.commit();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            Level level = Level.FINE;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"FINE");
            Object[] objectArray = new Object[]{this.rootName};
            Companion.log(level, "Close: %s%n", objectArray);
            this.isOpen = false;
            IndexedFile indexedFile = this.repository;
            if (indexedFile != null) {
                indexedFile.close();
            }
            this.moduleMap.clear();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void openOrCreate() throws IndexedFileException {
        boolean bl;
        boolean bl2 = bl = !this.isOpen;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        try {
            Object object;
            IndexedFile indexedFile;
            try {
                indexedFile = IndexedFileBuilder.openOrCreate$default((IndexedFileBuilder)IndexedRepositoryBuilder.INSTANCE, (File)this.fileName, (boolean)true, null, (int)0, (int)0, (int)0, (int)0, (int)0, versionCheck, (int)252, null);
            }
            catch (IndexedFileException e) {
                Level level = Level.INFO;
                Intrinsics.checkNotNullExpressionValue((Object)level, (String)"INFO");
                object = new Object[]{this.fileName};
                Companion.log(level, e, "Deleting obsolete repository: %s", object);
                this.fileName.delete();
                indexedFile = IndexedFileBuilder.openOrCreate$default((IndexedFileBuilder)IndexedRepositoryBuilder.INSTANCE, (File)this.fileName, (boolean)true, null, (int)0, (int)0, (int)0, (int)0, (int)0, versionCheck, (int)252, null);
            }
            IndexedFile repo = indexedFile;
            byte[] metadata = repo.getMetadata();
            if (metadata != null) {
                ByteArrayInputStream byteStream = new ByteArrayInputStream(metadata);
                object = new DataInputStream(byteStream);
                Throwable throwable = null;
                try {
                    boolean bl3;
                    DataInputStream binaryStream = (DataInputStream)object;
                    boolean bl4 = false;
                    int moduleCount = binaryStream.readInt();
                    while (moduleCount-- > 0) {
                        ModuleArchive archive = new ModuleArchive(binaryStream);
                        this.moduleMap.put(archive.getRootRelativeName$avail(), archive);
                    }
                    boolean bl5 = bl3 = byteStream.available() == 0;
                    if (_Assertions.ENABLED && !bl3) {
                        String string3 = "Assertion failed";
                        throw new AssertionError((Object)string3);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
            this.repository = repo;
            this.isOpen = true;
        }
        catch (IOException e) {
            throw new IndexedFileException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reopenIfNecessary() {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            Level level = Level.FINE;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"FINE");
            Object[] objectArray = new Object[]{this.rootName, this.isOpen};
            Companion.log(level, "Reopen if necessary %s (was open = %s)%n", objectArray);
            if (!this.isOpen) {
                this.openOrCreate();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    @NotNull
    public String toString() {
        Formatter out2 = new Formatter();
        Object[] objectArray = new Object[]{this.rootName};
        out2.format("Repository \"%s\" with modules:", objectArray);
        for (Map.Entry entry : this.moduleMap.entrySet()) {
            String key = (String)entry.getKey();
            ModuleArchive value = (ModuleArchive)entry.getValue();
            Object[] objectArray2 = new Object[]{key, value};
            out2.format("%n\t%s \u2192 %s", objectArray2);
        }
        String string2 = out2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"out.toString()");
        return string2;
    }

    private static final ModuleArchive _get_allArchives_$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ModuleArchive)$tmp0.invoke(p0);
    }

    private static final ModuleArchive getArchive$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ModuleArchive)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lavail/persistence/cache/Repository$IndexedRepositoryBuilder;", "Lorg/availlang/persistence/IndexedFileBuilder;", "()V", "avail"})
    private static final class IndexedRepositoryBuilder
    extends IndexedFileBuilder {
        @NotNull
        public static final IndexedRepositoryBuilder INSTANCE = new IndexedRepositoryBuilder();

        private IndexedRepositoryBuilder() {
            super("Avail compiled module repository V13");
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010&\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u001e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003j\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002`\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\b\u001a\u00020\t2\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u000bH\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lavail/persistence/cache/Repository$LimitedCache;", "K", "V", "Ljava/util/LinkedHashMap;", "Lkotlin/collections/LinkedHashMap;", "maximumSize", "", "(I)V", "removeEldestEntry", "", "eldest", "", "avail"})
    public static final class LimitedCache<K, V>
    extends LinkedHashMap<K, V> {
        private final int maximumSize;

        public LimitedCache(int maximumSize) {
            super(maximumSize, 0.75f, true);
            boolean bl;
            this.maximumSize = maximumSize;
            boolean bl2 = bl = this.maximumSize > 0;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
        }

        @Override
        protected boolean removeEldestEntry(@Nullable Map.Entry<? extends K, ? extends V> eldest) {
            return this.size() > this.maximumSize;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u001c\u001a\u00020\u001dJF\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u001d0$2\u001a\u0010%\u001a\u0016\u0012\u0004\u0012\u00020'\u0012\u0006\u0012\u0004\u0018\u00010(\u0012\u0004\u0012\u00020\u001d0&J\u0014\u0010)\u001a\b\u0018\u00010\u000bR\u00020\f2\u0006\u0010*\u001a\u00020\nJ\u0017\u0010+\u001a\u0004\u0018\u00010\u00122\u0006\u0010,\u001a\u00020-H\u0000\u00a2\u0006\u0002\b.J\"\u0010/\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020\n2\u0006\u00100\u001a\u0002012\n\u00102\u001a\u000603R\u00020\fJ\u001a\u00104\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020\n2\n\u00105\u001a\u00060\u000bR\u00020\fJ\b\u00106\u001a\u00020\u0006H\u0016J\u000e\u00107\u001a\u00020\u001d2\u0006\u0010\u0002\u001a\u000208R!\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u00060\u000bR\u00020\f0\t8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R2\u0010\u0019\u001a&\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u00060\u000bR\u00020\f0\u001aj\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u00060\u000bR\u00020\f`\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lavail/persistence/cache/Repository$ModuleArchive;", "", "binaryStream", "Ljava/io/DataInputStream;", "(Lavail/persistence/cache/Repository;Ljava/io/DataInputStream;)V", "rootRelativeName", "", "(Lavail/persistence/cache/Repository;Ljava/lang/String;)V", "allKnownVersions", "Ljava/util/SortedMap;", "Lavail/persistence/cache/Repository$ModuleVersionKey;", "Lavail/persistence/cache/Repository$ModuleVersion;", "Lavail/persistence/cache/Repository;", "getAllKnownVersions", "()Ljava/util/SortedMap;", "digestCache", "Lavail/persistence/cache/Repository$LimitedCache;", "", "", "lastUpdate", "repository", "getRepository", "()Lavail/persistence/cache/Repository;", "getRootRelativeName$avail", "()Ljava/lang/String;", "versions", "Ljava/util/LinkedHashMap;", "Lkotlin/collections/LinkedHashMap;", "cleanCompilations", "", "digestForFile", "resolvedModuleName", "Lavail/builder/ResolvedModuleName;", "forceRefreshDigest", "", "withDigest", "Lkotlin/Function1;", "failureHandler", "Lkotlin/Function2;", "Lavail/error/ErrorCode;", "", "getVersion", "versionKey", "provideDigest", "reference", "Lavail/resolver/ResolverReference;", "provideDigest$avail", "putCompilation", "compilationKey", "Lavail/persistence/cache/Repository$ModuleCompilationKey;", "compilation", "Lavail/persistence/cache/Repository$ModuleCompilation;", "putVersion", "version", "toString", "write", "Ljava/io/DataOutputStream;", "avail"})
    public final class ModuleArchive {
        @NotNull
        private final LinkedHashMap<ModuleVersionKey, ModuleVersion> versions;
        @NotNull
        private final String rootRelativeName;
        private long lastUpdate;
        @NotNull
        private final LimitedCache<Long, byte[]> digestCache;

        @NotNull
        public final Repository getRepository() {
            return Repository.this;
        }

        @NotNull
        public final String getRootRelativeName$avail() {
            return this.rootRelativeName;
        }

        @Nullable
        public final byte[] provideDigest$avail(@NotNull ResolverReference reference) {
            Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
            if (!Intrinsics.areEqual((Object)this.rootRelativeName, (Object)reference.getModuleName().getRootRelativeName())) {
                boolean bl = false;
                String string2 = reference.getQualifiedName() + " attempted to access archive for " + this.rootRelativeName;
                throw new IllegalArgumentException(string2.toString());
            }
            return (byte[])this.digestCache.get(reference.getLastModified());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final SortedMap<ModuleVersionKey, ModuleVersion> getAllKnownVersions() {
            Map map;
            Lock lock = Repository.this.getLock$avail();
            lock.lock();
            try {
                boolean bl = false;
                map = MapsKt.toMap((Map)this.versions);
            }
            finally {
                lock.unlock();
            }
            Map map2 = map;
            SortedMap<ModuleVersionKey, ModuleVersion> sortedMap = Collections.unmodifiableSortedMap(new TreeMap(map2));
            Intrinsics.checkNotNullExpressionValue(sortedMap, (String)"unmodifiableSortedMap(TreeMap(map))");
            return sortedMap;
        }

        @NotNull
        public String toString() {
            String string2 = Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName();
            Set<Map.Entry<ModuleVersionKey, ModuleVersion>> set2 = this.versions.entrySet();
            Intrinsics.checkNotNullExpressionValue(set2, (String)"versions.entries");
            Iterable iterable = set2;
            Comparator comparator = Map.Entry.comparingByKey();
            Intrinsics.checkNotNullExpressionValue(comparator, (String)"comparingByKey()");
            return string2 + CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedWith((Iterable)iterable, comparator), (CharSequence)", ", (CharSequence)(" " + this.rootRelativeName + " ("), (CharSequence)")", (int)0, null, (Function1)toString.1.INSTANCE, (int)24, null);
        }

        public final void digestForFile(@NotNull ResolvedModuleName resolvedModuleName, boolean forceRefreshDigest, @NotNull Function1<? super byte[], Unit> withDigest, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
            Intrinsics.checkNotNullParameter((Object)resolvedModuleName, (String)"resolvedModuleName");
            Intrinsics.checkNotNullParameter(withDigest, (String)"withDigest");
            Intrinsics.checkNotNullParameter(failureHandler, (String)"failureHandler");
            boolean bl = Intrinsics.areEqual((Object)resolvedModuleName.getRootRelativeName(), (Object)this.rootRelativeName);
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            ResolverReference sourceReference = resolvedModuleName.getResolverReference();
            long lastModification = sourceReference.getLastModified();
            byte[] digest = (byte[])this.digestCache.get(lastModification);
            if (digest != null && !forceRefreshDigest) {
                withDigest.invoke((Object)digest);
                return;
            }
            Function2 success2 = (Function2)new Function2<byte[], Long, Unit>(lastModification, Repository.this, withDigest, this){
                final /* synthetic */ long $lastModification;
                final /* synthetic */ Repository this$0;
                final /* synthetic */ Function1<byte[], Unit> $withDigest;
                final /* synthetic */ ModuleArchive this$1;
                {
                    this.$lastModification = $lastModification;
                    this.this$0 = $receiver;
                    this.$withDigest = $withDigest;
                    this.this$1 = $receiver2;
                    super(2);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke(@NotNull byte[] newDigest, long lastModified) {
                    boolean bl;
                    Intrinsics.checkNotNullParameter((Object)newDigest, (String)"newDigest");
                    boolean bl2 = bl = newDigest.length == 32;
                    if (_Assertions.ENABLED && !bl) {
                        String string2 = "Assertion failed";
                        throw new AssertionError((Object)string2);
                    }
                    if (lastModified >= this.$lastModification) {
                        Lock lock = this.this$0.getLock$avail();
                        ModuleArchive moduleArchive = this.this$1;
                        Repository repository = this.this$0;
                        lock.lock();
                        try {
                            boolean bl3 = false;
                            Long l = lastModified;
                            ((Map)ModuleArchive.access$getDigestCache$p(moduleArchive)).put(l, newDigest);
                            ModuleArchive.access$setLastUpdate$p(moduleArchive, lastModified);
                            repository.markDirty();
                            Unit unit = Unit.INSTANCE;
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                    this.$withDigest.invoke((Object)newDigest);
                }
            };
            sourceReference.digest$avail(forceRefreshDigest, (Function2<? super byte[], ? super Long, Unit>)success2, failureHandler);
        }

        public final void write(@NotNull DataOutputStream binaryStream) throws IOException {
            Intrinsics.checkNotNullParameter((Object)binaryStream, (String)"binaryStream");
            CodingKt.sizedString(binaryStream, this.rootRelativeName);
            CodingKt.vlq(binaryStream, this.digestCache.size());
            for (Map.Entry entry : ((Map)this.digestCache).entrySet()) {
                long key = ((Number)entry.getKey()).longValue();
                byte[] value = (byte[])entry.getValue();
                binaryStream.writeLong(key);
                binaryStream.write(value);
            }
            CodingKt.vlq(binaryStream, this.versions.size());
            for (Map.Entry entry : ((Map)this.versions).entrySet()) {
                ModuleVersionKey key = (ModuleVersionKey)entry.getKey();
                ModuleVersion value = (ModuleVersion)entry.getValue();
                key.write(binaryStream);
                value.write$avail(binaryStream);
            }
        }

        public ModuleArchive(DataInputStream binaryStream) throws IOException {
            Intrinsics.checkNotNullParameter((Object)binaryStream, (String)"binaryStream");
            this.versions = new LinkedHashMap(10, 0.75f, true);
            this.digestCache = new LimitedCache(20);
            this.rootRelativeName = CodingKt.decodeString(binaryStream);
            int digestCount = CodingKt.unvlqInt(binaryStream);
            while (digestCount-- > 0) {
                long lastModification = binaryStream.readLong();
                byte[] digest = new byte[32];
                binaryStream.readFully(digest);
                Long l = lastModification;
                ((Map)this.digestCache).put(l, digest);
            }
            int versionCount = CodingKt.unvlqInt(binaryStream);
            while (versionCount-- > 0) {
                ModuleVersionKey versionKey = new ModuleVersionKey(binaryStream);
                ModuleVersion version = new ModuleVersion(binaryStream);
                ((Map)this.versions).put(versionKey, version);
            }
        }

        public ModuleArchive(String rootRelativeName2) {
            Intrinsics.checkNotNullParameter((Object)rootRelativeName2, (String)"rootRelativeName");
            this.versions = new LinkedHashMap(10, 0.75f, true);
            this.digestCache = new LimitedCache(20);
            this.rootRelativeName = rootRelativeName2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final ModuleVersion getVersion(@NotNull ModuleVersionKey versionKey) {
            ModuleVersion moduleVersion;
            Intrinsics.checkNotNullParameter((Object)versionKey, (String)"versionKey");
            Lock lock = Repository.this.getLock$avail();
            lock.lock();
            try {
                boolean bl = false;
                moduleVersion = this.versions.get(versionKey);
            }
            finally {
                lock.unlock();
            }
            return moduleVersion;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void putVersion(@NotNull ModuleVersionKey versionKey, @NotNull ModuleVersion version) {
            Intrinsics.checkNotNullParameter((Object)versionKey, (String)"versionKey");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Lock lock = Repository.this.getLock$avail();
            Repository repository = Repository.this;
            lock.lock();
            try {
                boolean bl = false;
                ((Map)this.versions).put(versionKey, version);
                repository.markDirty();
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void putCompilation(@NotNull ModuleVersionKey versionKey, @NotNull ModuleCompilationKey compilationKey, @NotNull ModuleCompilation compilation) {
            Intrinsics.checkNotNullParameter((Object)versionKey, (String)"versionKey");
            Intrinsics.checkNotNullParameter((Object)compilationKey, (String)"compilationKey");
            Intrinsics.checkNotNullParameter((Object)compilation, (String)"compilation");
            Lock lock = Repository.this.getLock$avail();
            Repository repository = Repository.this;
            lock.lock();
            try {
                boolean bl = false;
                ModuleVersion moduleVersion = this.versions.get(versionKey);
                Intrinsics.checkNotNull((Object)moduleVersion);
                ModuleVersion version = moduleVersion;
                ((Map)version.getCompilations$avail()).put(compilationKey, compilation);
                repository.markDirty();
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }

        public final void cleanCompilations() {
            this.versions.clear();
        }

        public static final /* synthetic */ LimitedCache access$getDigestCache$p(ModuleArchive $this) {
            return $this.digestCache;
        }

        public static final /* synthetic */ void access$setLastUpdate$p(ModuleArchive $this, long l) {
            $this.lastUpdate = l;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0011\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0000H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u000bH\u0002J\u0013\u0010\u0017\u001a\u00020\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0018H\u0096\u0002J\b\u0010\u0019\u001a\u00020\u000bH\u0016J\b\u0010\u001a\u001a\u00020\u000fH\u0016J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0002\u001a\u00020\u001dR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lavail/persistence/cache/Repository$ModuleVersionKey;", "", "binaryStream", "Ljava/io/DataInputStream;", "(Ljava/io/DataInputStream;)V", "moduleName", "Lavail/builder/ResolvedModuleName;", "sourceDigest", "", "(Lavail/builder/ResolvedModuleName;[B)V", "hash", "", "isPackage", "", "shortString", "", "getShortString", "()Ljava/lang/String;", "getSourceDigest", "()[B", "compareTo", "other", "computeHash", "equals", "", "hashCode", "toString", "write", "", "Ljava/io/DataOutputStream;", "avail"})
    public static final class ModuleVersionKey
    implements Comparable<ModuleVersionKey> {
        private final boolean isPackage;
        @NotNull
        private final byte[] sourceDigest;
        private final int hash;

        @NotNull
        public final byte[] getSourceDigest() {
            return this.sourceDigest;
        }

        public int hashCode() {
            return this.hash;
        }

        private final int computeHash() {
            long h = this.isPackage ? 3735928559L : 2896935534L;
            for (byte digestByte : this.sourceDigest) {
                h = h * (long)1664525 + (long)digestByte;
            }
            return (int)h;
        }

        public boolean equals(@Nullable Object other) {
            if (other == null) {
                return false;
            }
            if (!(other instanceof ModuleVersionKey)) {
                return false;
            }
            ModuleVersionKey key = (ModuleVersionKey)other;
            return this.hash == key.hash && this.isPackage == key.isPackage && Arrays.equals(this.sourceDigest, key.sourceDigest);
        }

        public final void write(@NotNull DataOutputStream binaryStream) throws IOException {
            Intrinsics.checkNotNullParameter((Object)binaryStream, (String)"binaryStream");
            binaryStream.writeBoolean(this.isPackage);
            binaryStream.write(this.sourceDigest);
        }

        @NotNull
        public String toString() {
            String string2 = "VersionKey(@%s...)";
            Object[] objectArray = new Object[]{this.getShortString()};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
            return string3;
        }

        public ModuleVersionKey(@NotNull DataInputStream binaryStream) throws IOException {
            Intrinsics.checkNotNullParameter((Object)binaryStream, (String)"binaryStream");
            this.isPackage = binaryStream.readBoolean();
            this.sourceDigest = new byte[32];
            binaryStream.readFully(this.sourceDigest);
            this.hash = this.computeHash();
        }

        public ModuleVersionKey(@NotNull ResolvedModuleName moduleName2, @NotNull byte[] sourceDigest) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)moduleName2, (String)"moduleName");
            Intrinsics.checkNotNullParameter((Object)sourceDigest, (String)"sourceDigest");
            boolean bl2 = bl = sourceDigest.length == 32;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            this.sourceDigest = (byte[])sourceDigest.clone();
            this.isPackage = moduleName2.isPackage();
            this.hash = this.computeHash();
        }

        @NotNull
        public final String getShortString() {
            String string2 = "%02x%02x%02x";
            Object[] objectArray = new Object[]{this.sourceDigest[0], this.sourceDigest[1], this.sourceDigest[2]};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
            return string3;
        }

        @Override
        public int compareTo(@NotNull ModuleVersionKey other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            for (int i2 = 0; i2 < this.sourceDigest.length && i2 < other.sourceDigest.length; ++i2) {
                int d = (this.sourceDigest[i2] & 0xFF) - (other.sourceDigest[i2] & 0xFF);
                if (d == 0) continue;
                return d;
            }
            return this.sourceDigest.length - other.sourceDigest.length;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\tH\u0002J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000e\u001a\u00020\tH\u0016J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u0011R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lavail/persistence/cache/Repository$ModuleCompilationKey;", "", "binaryStream", "Ljava/io/DataInputStream;", "(Ljava/io/DataInputStream;)V", "predecessorCompilationTimes", "", "([J)V", "hash", "", "computeHash", "equals", "", "other", "hashCode", "write", "", "Ljava/io/DataOutputStream;", "avail"})
    public static final class ModuleCompilationKey {
        @NotNull
        private final long[] predecessorCompilationTimes;
        private final int hash;

        public int hashCode() {
            return this.hash;
        }

        private final int computeHash() {
            int h = -1638334171;
            for (long predecessorCompilationTime : this.predecessorCompilationTimes) {
                h = Companion.mix$avail(h, predecessorCompilationTime);
            }
            return h;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(@Nullable Object other) {
            if (other == null) {
                return false;
            }
            if (!(other instanceof ModuleCompilationKey)) {
                return false;
            }
            ModuleCompilationKey key = (ModuleCompilationKey)other;
            if (this.hash != key.hash) return false;
            if (!Arrays.equals(this.predecessorCompilationTimes, key.predecessorCompilationTimes)) return false;
            return true;
        }

        public final void write(@NotNull DataOutputStream binaryStream) throws IOException {
            Intrinsics.checkNotNullParameter((Object)binaryStream, (String)"binaryStream");
            CodingKt.vlq(binaryStream, this.predecessorCompilationTimes.length);
            for (long predecessorCompilationTime : this.predecessorCompilationTimes) {
                binaryStream.writeLong(predecessorCompilationTime);
            }
        }

        public ModuleCompilationKey(@NotNull DataInputStream binaryStream) throws IOException {
            Intrinsics.checkNotNullParameter((Object)binaryStream, (String)"binaryStream");
            int predecessorsCount = CodingKt.unvlqInt(binaryStream);
            this.predecessorCompilationTimes = new long[predecessorsCount];
            for (int i2 = 0; i2 < predecessorsCount; ++i2) {
                this.predecessorCompilationTimes[i2] = binaryStream.readLong();
            }
            this.hash = this.computeHash();
        }

        public ModuleCompilationKey(@NotNull long[] predecessorCompilationTimes) {
            Intrinsics.checkNotNullParameter((Object)predecessorCompilationTimes, (String)"predecessorCompilationTimes");
            this.predecessorCompilationTimes = (long[])predecessorCompilationTimes.clone();
            this.hash = this.computeHash();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B+\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\u000bJ\u0014\u0010!\u001a\b\u0018\u00010\rR\u00020\u000e2\u0006\u0010\"\u001a\u00020\u0017J\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0012J\u000e\u0010'\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0012J\b\u0010(\u001a\u00020\tH\u0016J\u0015\u0010)\u001a\u00020%2\u0006\u0010\u0002\u001a\u00020*H\u0000\u00a2\u0006\u0002\b+R\u001b\u0010\f\u001a\f\u0012\b\u0012\u00060\rR\u00020\u000e0\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R$\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u0017\u0012\b\u0012\u00060\rR\u00020\u000e0\u0016X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\t0\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0010R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0014R\u000e\u0010\u001f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lavail/persistence/cache/Repository$ModuleVersion;", "", "binaryStream", "Ljava/io/DataInputStream;", "(Lavail/persistence/cache/Repository;Ljava/io/DataInputStream;)V", "moduleSize", "", "localImportNames", "", "", "entryPoints", "(Lavail/persistence/cache/Repository;JLjava/util/List;Ljava/util/List;)V", "allCompilations", "Lavail/persistence/cache/Repository$ModuleCompilation;", "Lavail/persistence/cache/Repository;", "getAllCompilations", "()Ljava/util/List;", "comments", "", "getComments", "()[B", "compilations", "Lavail/persistence/cache/Repository$LimitedCache;", "Lavail/persistence/cache/Repository$ModuleCompilationKey;", "getCompilations$avail", "()Lavail/persistence/cache/Repository$LimitedCache;", "", "imports", "getImports", "moduleHeader", "getModuleHeader", "moduleHeaderRecordNumber", "stacksRecordNumber", "getCompilation", "compilationKey", "getEntryPoints", "putComments", "", "bytes", "putModuleHeader", "toString", "write", "Ljava/io/DataOutputStream;", "write$avail", "avail"})
    public final class ModuleVersion {
        private final long moduleSize;
        @NotNull
        private final List<String> localImportNames;
        @NotNull
        private final List<String> entryPoints;
        @NotNull
        private final LimitedCache<ModuleCompilationKey, ModuleCompilation> compilations;
        private long moduleHeaderRecordNumber;
        private long stacksRecordNumber;

        @NotNull
        public final LimitedCache<ModuleCompilationKey, ModuleCompilation> getCompilations$avail() {
            return this.compilations;
        }

        @NotNull
        public final List<String> getImports() {
            List<String> list2 = Collections.unmodifiableList(this.localImportNames);
            Intrinsics.checkNotNullExpressionValue(list2, (String)"unmodifiableList(localImportNames)");
            return list2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final byte[] getModuleHeader() {
            byte[] byArray;
            boolean bl;
            boolean bl2 = bl = this.moduleHeaderRecordNumber != -1L;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            Lock lock = Repository.this.getLock$avail();
            Repository repository = Repository.this;
            lock.lock();
            try {
                boolean bl3 = false;
                IndexedFile indexedFile = repository.getRepository$avail();
                Intrinsics.checkNotNull((Object)indexedFile);
                byArray = indexedFile.get(this.moduleHeaderRecordNumber);
            }
            finally {
                lock.unlock();
            }
            return byArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final byte[] getComments() {
            byte[] byArray;
            if (this.stacksRecordNumber == -1L) {
                byArray = null;
            } else {
                Lock lock = Repository.this.getLock$avail();
                Repository repository = Repository.this;
                lock.lock();
                try {
                    boolean bl = false;
                    IndexedFile indexedFile = repository.getRepository$avail();
                    Intrinsics.checkNotNull((Object)indexedFile);
                    byte[] byArray2 = indexedFile.get(this.stacksRecordNumber);
                    byArray = byArray2;
                }
                finally {
                    lock.unlock();
                }
            }
            return byArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final List<ModuleCompilation> getAllCompilations() {
            List list2;
            Lock lock = Repository.this.getLock$avail();
            lock.lock();
            try {
                boolean bl = false;
                Collection<ModuleCompilation> collection2 = this.compilations.values();
                Intrinsics.checkNotNullExpressionValue(collection2, (String)"compilations.values");
                list2 = CollectionsKt.toList((Iterable)collection2);
            }
            finally {
                lock.unlock();
            }
            return list2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final ModuleCompilation getCompilation(@NotNull ModuleCompilationKey compilationKey) {
            ModuleCompilation moduleCompilation;
            Intrinsics.checkNotNullParameter((Object)compilationKey, (String)"compilationKey");
            Lock lock = Repository.this.getLock$avail();
            lock.lock();
            try {
                boolean bl = false;
                moduleCompilation = (ModuleCompilation)this.compilations.get(compilationKey);
            }
            finally {
                lock.unlock();
            }
            return moduleCompilation;
        }

        @NotNull
        public final List<String> getEntryPoints() {
            List<String> list2 = Collections.unmodifiableList(this.entryPoints);
            Intrinsics.checkNotNullExpressionValue(list2, (String)"unmodifiableList(entryPoints)");
            return list2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void putModuleHeader(@NotNull byte[] bytes2) {
            Intrinsics.checkNotNullParameter((Object)bytes2, (String)"bytes");
            Lock lock = Repository.this.getLock$avail();
            Repository repository = Repository.this;
            lock.lock();
            try {
                boolean bl = false;
                IndexedFile indexedFile = repository.getRepository$avail();
                Intrinsics.checkNotNull((Object)indexedFile);
                IndexedFile repo = indexedFile;
                this.moduleHeaderRecordNumber = IndexedFile.add$default((IndexedFile)repo, (byte[])bytes2, (int)0, (int)0, (int)6, null);
                repository.markDirty();
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void putComments(@NotNull byte[] bytes2) {
            Intrinsics.checkNotNullParameter((Object)bytes2, (String)"bytes");
            Lock lock = Repository.this.getLock$avail();
            Repository repository = Repository.this;
            lock.lock();
            try {
                boolean bl = false;
                IndexedFile indexedFile = repository.getRepository$avail();
                Intrinsics.checkNotNull((Object)indexedFile);
                IndexedFile repo = indexedFile;
                this.stacksRecordNumber = IndexedFile.add$default((IndexedFile)repo, (byte[])bytes2, (int)0, (int)0, (int)6, null);
                repository.markDirty();
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }

        public final void write$avail(@NotNull DataOutputStream binaryStream) throws IOException {
            Intrinsics.checkNotNullParameter((Object)binaryStream, (String)"binaryStream");
            CodingKt.vlq(binaryStream, this.moduleSize);
            CodingKt.vlq(binaryStream, this.localImportNames.size());
            for (String entry : this.localImportNames) {
                CodingKt.sizedString(binaryStream, entry);
            }
            CodingKt.vlq(binaryStream, this.entryPoints.size());
            for (String string2 : this.entryPoints) {
                CodingKt.sizedString(binaryStream, string2);
            }
            CodingKt.vlq(binaryStream, this.compilations.size());
            for (Map.Entry entry : ((Map)this.compilations).entrySet()) {
                ModuleCompilationKey key = (ModuleCompilationKey)entry.getKey();
                ModuleCompilation value = (ModuleCompilation)entry.getValue();
                key.write(binaryStream);
                value.write$avail(binaryStream);
            }
            CodingKt.zigzag(binaryStream, this.moduleHeaderRecordNumber);
            CodingKt.zigzag(binaryStream, this.stacksRecordNumber);
        }

        @NotNull
        public String toString() {
            String string2 = "Version:%n\t\timports=%s%s%n\t\tcompilations=%s%n\t\tmoduleHeaderRecordNumber=%d%n\t\tstacksRecordNumber=%d%n";
            Object[] objectArray = new Object[]{this.localImportNames, this.entryPoints.isEmpty() ? "" : "\n\t\tentry points=" + this.entryPoints, this.compilations.values(), this.moduleHeaderRecordNumber, this.stacksRecordNumber};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
            return string3;
        }

        public ModuleVersion(DataInputStream binaryStream) throws IOException {
            Intrinsics.checkNotNullParameter((Object)binaryStream, (String)"binaryStream");
            this.compilations = new LimitedCache(10);
            this.moduleHeaderRecordNumber = -1L;
            this.stacksRecordNumber = -1L;
            this.moduleSize = CodingKt.unvlqLong(binaryStream);
            int localImportCount = CodingKt.unvlqInt(binaryStream);
            this.localImportNames = new ArrayList();
            while (localImportCount-- > 0) {
                this.localImportNames.add(CodingKt.decodeString(binaryStream));
            }
            int entryPointCount = CodingKt.unvlqInt(binaryStream);
            this.entryPoints = new ArrayList();
            while (entryPointCount-- > 0) {
                this.entryPoints.add(CodingKt.decodeString(binaryStream));
            }
            int compilationsCount = CodingKt.unvlqInt(binaryStream);
            while (compilationsCount-- > 0) {
                ((Map)this.compilations).put(new ModuleCompilationKey(binaryStream), new ModuleCompilation(Repository.this, binaryStream));
            }
            this.moduleHeaderRecordNumber = CodingKt.unzigzagLong(binaryStream);
            this.stacksRecordNumber = CodingKt.unzigzagLong(binaryStream);
        }

        public ModuleVersion(@NotNull long moduleSize, @NotNull List<String> localImportNames, List<String> entryPoints) {
            Intrinsics.checkNotNullParameter(localImportNames, (String)"localImportNames");
            Intrinsics.checkNotNullParameter(entryPoints, (String)"entryPoints");
            this.compilations = new LimitedCache(10);
            this.moduleHeaderRecordNumber = -1L;
            this.stacksRecordNumber = -1L;
            this.moduleSize = moduleSize;
            this.localImportNames = CollectionsKt.toMutableList((Collection)localImportNames);
            this.entryPoints = CollectionsKt.toMutableList((Collection)entryPoints);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B7\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\u0006\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0015\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0002\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0011\u0010\n\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lavail/persistence/cache/Repository$ModuleCompilation;", "", "binaryStream", "Ljava/io/DataInputStream;", "(Lavail/persistence/cache/Repository;Ljava/io/DataInputStream;)V", "compilationTime", "", "recordNumber", "recordNumberOfBlockPhrases", "recordNumberOfManifest", "recordNumberOfStyling", "recordNumberOfPhrasePaths", "(Lavail/persistence/cache/Repository;JJJJJJ)V", "bytes", "", "getBytes", "()[B", "getCompilationTime", "()J", "getRecordNumber", "getRecordNumberOfBlockPhrases", "getRecordNumberOfManifest", "getRecordNumberOfPhrasePaths", "getRecordNumberOfStyling", "toString", "", "write", "", "Ljava/io/DataOutputStream;", "write$avail", "avail"})
    public final class ModuleCompilation {
        private final long compilationTime;
        private final long recordNumber;
        private final long recordNumberOfBlockPhrases;
        private final long recordNumberOfManifest;
        private final long recordNumberOfStyling;
        private final long recordNumberOfPhrasePaths;
        final /* synthetic */ Repository this$0;

        public ModuleCompilation(Repository this$0, long compilationTime, long recordNumber, long recordNumberOfBlockPhrases, long recordNumberOfManifest, long recordNumberOfStyling, long recordNumberOfPhrasePaths) {
            this.this$0 = this$0;
            this.compilationTime = compilationTime;
            this.recordNumber = recordNumber;
            this.recordNumberOfBlockPhrases = recordNumberOfBlockPhrases;
            this.recordNumberOfManifest = recordNumberOfManifest;
            this.recordNumberOfStyling = recordNumberOfStyling;
            this.recordNumberOfPhrasePaths = recordNumberOfPhrasePaths;
        }

        public final long getCompilationTime() {
            return this.compilationTime;
        }

        public final long getRecordNumber() {
            return this.recordNumber;
        }

        public final long getRecordNumberOfBlockPhrases() {
            return this.recordNumberOfBlockPhrases;
        }

        public final long getRecordNumberOfManifest() {
            return this.recordNumberOfManifest;
        }

        public final long getRecordNumberOfStyling() {
            return this.recordNumberOfStyling;
        }

        public final long getRecordNumberOfPhrasePaths() {
            return this.recordNumberOfPhrasePaths;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final byte[] getBytes() {
            byte[] byArray;
            Lock lock = this.this$0.getLock$avail();
            Repository repository = this.this$0;
            lock.lock();
            try {
                boolean bl = false;
                IndexedFile indexedFile = repository.getRepository$avail();
                Intrinsics.checkNotNull((Object)indexedFile);
                byArray = indexedFile.get(this.recordNumber);
            }
            finally {
                lock.unlock();
            }
            return byArray;
        }

        public final void write$avail(@NotNull DataOutputStream binaryStream) throws IOException {
            Intrinsics.checkNotNullParameter((Object)binaryStream, (String)"binaryStream");
            binaryStream.writeLong(this.compilationTime);
            CodingKt.zigzag(binaryStream, this.recordNumber);
            CodingKt.zigzag(binaryStream, this.recordNumberOfBlockPhrases);
            CodingKt.zigzag(binaryStream, this.recordNumberOfManifest);
            CodingKt.zigzag(binaryStream, this.recordNumberOfStyling);
            CodingKt.zigzag(binaryStream, this.recordNumberOfPhrasePaths);
        }

        @NotNull
        public String toString() {
            String string2 = "Compilation(%tFT%<tTZ, rec=%d, phrases=%d, manifest=%d, styling=%d, phrase paths=%d)";
            Object[] objectArray = new Object[]{this.compilationTime, this.recordNumber, this.recordNumberOfBlockPhrases, this.recordNumberOfManifest, this.recordNumberOfStyling, this.recordNumberOfPhrasePaths};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
            return string3;
        }

        public ModuleCompilation(@NotNull Repository this$0, DataInputStream binaryStream) throws IOException {
            Intrinsics.checkNotNullParameter((Object)binaryStream, (String)"binaryStream");
            this(this$0, binaryStream.readLong(), CodingKt.unzigzagLong(binaryStream), CodingKt.unzigzagLong(binaryStream), CodingKt.unzigzagLong(binaryStream), CodingKt.unzigzagLong(binaryStream), CodingKt.unzigzagLong(binaryStream));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\b\u0016\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\f\u001a\u00020\rH\u0016J\u0015\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0012R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lavail/persistence/cache/Repository$ManifestRecord;", "", "bytes", "", "([B)V", "entries", "", "Lavail/compiler/ModuleManifestEntry;", "(Ljava/util/List;)V", "manifestEntries", "getManifestEntries", "()Ljava/util/List;", "toString", "", "write", "", "binaryStream", "Ljava/io/DataOutputStream;", "write$avail", "avail"})
    public static final class ManifestRecord {
        @NotNull
        private final List<ModuleManifestEntry> manifestEntries;

        @NotNull
        public final List<ModuleManifestEntry> getManifestEntries() {
            return this.manifestEntries;
        }

        public final void write$avail(@NotNull DataOutputStream binaryStream) throws IOException {
            Intrinsics.checkNotNullParameter((Object)binaryStream, (String)"binaryStream");
            Iterable $this$forEach$iv = this.manifestEntries;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ModuleManifestEntry entry = (ModuleManifestEntry)element$iv;
                boolean bl = false;
                entry.write(binaryStream);
            }
        }

        @NotNull
        public String toString() {
            String string2 = "ManifestRecord (%d entries)";
            Object[] objectArray = new Object[]{this.manifestEntries.size()};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
            return string3;
        }

        public ManifestRecord(@NotNull byte[] bytes2) throws IOException {
            Intrinsics.checkNotNullParameter((Object)bytes2, (String)"bytes");
            DataInputStream binaryStream = new DataInputStream(new ByteArrayInputStream(bytes2));
            List entries2 = new ArrayList();
            while (binaryStream.available() > 0) {
                entries2.add(new ModuleManifestEntry(binaryStream));
            }
            this.manifestEntries = entries2;
        }

        public ManifestRecord(@NotNull List<ModuleManifestEntry> entries2) {
            Intrinsics.checkNotNullParameter(entries2, (String)"entries");
            this.manifestEntries = entries2;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B?\b\u0016\u0012\u001c\u0010\u0005\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\n0\u0006\u0012\u0018\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00070\u0006\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0010\u001a\u00020\tH\u0016J\u0015\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0015R'\u0010\u0005\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\n0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR#\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lavail/persistence/cache/Repository$StylingRecord;", "", "bytes", "", "([B)V", "styleRuns", "", "Lkotlin/Pair;", "Lkotlin/ranges/IntRange;", "", "Lavail/persistence/cache/StyleRun;", "variableUses", "(Ljava/util/List;Ljava/util/List;)V", "getStyleRuns", "()Ljava/util/List;", "getVariableUses", "toString", "write", "", "binaryStream", "Ljava/io/DataOutputStream;", "write$avail", "avail"})
    public static final class StylingRecord {
        @NotNull
        private final List<Pair<IntRange, String>> styleRuns;
        @NotNull
        private final List<Pair<IntRange, IntRange>> variableUses;

        @NotNull
        public final List<Pair<IntRange, String>> getStyleRuns() {
            return this.styleRuns;
        }

        @NotNull
        public final List<Pair<IntRange, IntRange>> getVariableUses() {
            return this.variableUses;
        }

        /*
         * WARNING - void declaration
         */
        public final void write$avail(@NotNull DataOutputStream binaryStream) throws IOException {
            void $this$sortedBy$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Object object;
            void $this$groupByTo$iv$iv;
            Map $this$groupBy$iv;
            String styleName;
            Intrinsics.checkNotNullParameter((Object)binaryStream, (String)"binaryStream");
            Map styleToIndex = new LinkedHashMap();
            List stylesList = new ArrayList();
            Iterable $this$forEach$iv = this.styleRuns;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair pair = (Pair)element$iv;
                boolean bl = false;
                styleName = (String)pair.component2();
                styleToIndex.computeIfAbsent(styleName, arg_0 -> StylingRecord.write$lambda$1$lambda$0((Function1)new Function1<String, Integer>((List<String>)stylesList){
                    final /* synthetic */ List<String> $stylesList;
                    {
                        this.$stylesList = $stylesList;
                        super(1);
                    }

                    @NotNull
                    public final Integer invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.$stylesList.add(it);
                        return this.$stylesList.size();
                    }
                }, arg_0));
            }
            CodingKt.vlq(binaryStream, styleToIndex.size());
            $this$forEach$iv = stylesList;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Iterator p0 = (String)element$iv;
                boolean bl = false;
                CodingKt.sizedString(binaryStream, (String)((Object)p0));
            }
            int pos = 0;
            List nonemptyRuns = new ArrayList();
            Iterable $this$forEach$iv2 = this.styleRuns;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                boolean bl;
                styleName = (Pair)element$iv;
                boolean bl2 = false;
                IntRange run2 = (IntRange)styleName.component1();
                String styleName2 = (String)styleName.component2();
                int delta = run2.getFirst() - pos;
                boolean bl3 = bl = delta >= 0;
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                if (delta > 0) {
                    nonemptyRuns.add(TuplesKt.to((Object)0, (Object)delta));
                }
                boolean bl4 = bl = run2.getLast() >= run2.getFirst();
                if (_Assertions.ENABLED && !bl) {
                    String string3 = "Assertion failed";
                    throw new AssertionError((Object)string3);
                }
                Object v = styleToIndex.get(styleName2);
                Intrinsics.checkNotNull(v);
                nonemptyRuns.add(TuplesKt.to(v, (Object)(run2.getLast() - run2.getFirst() + 1)));
                pos = run2.getLast() + 1;
            }
            CodingKt.vlq(binaryStream, nonemptyRuns.size());
            $this$forEach$iv2 = nonemptyRuns;
            $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                styleName = (Pair)element$iv;
                boolean bl = false;
                int styleNumber = ((Number)styleName.component1()).intValue();
                int length = ((Number)styleName.component2()).intValue();
                CodingKt.vlq(binaryStream, styleNumber);
                CodingKt.vlq(binaryStream, length);
            }
            Iterable $i$f$forEach22 = this.variableUses;
            boolean $i$f$groupBy = false;
            void element$iv = $this$groupBy$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                void it;
                Object object2;
                Pair it2 = (Pair)element$iv$iv;
                boolean $i$a$-groupBy-Repository$StylingRecord$write$declarationsWithUses$32 = false;
                IntRange key$iv$iv = (IntRange)it2.getSecond();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object2;
                Pair $i$a$-groupBy-Repository$StylingRecord$write$declarationsWithUses$32 = (Pair)element$iv$iv;
                object = list$iv$iv;
                boolean bl = false;
                object.add((IntRange)it.getFirst());
            }
            $this$groupBy$iv = destination$iv$iv;
            boolean $i$f$map = false;
            $this$groupByTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator<Object> iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry item$iv$iv;
                Map.Entry list$iv$iv = item$iv$iv = (Map.Entry)iterator2.next();
                object = destination$iv$iv;
                boolean bl = false;
                IntRange k = (IntRange)list$iv$iv.getKey();
                List v = (List)list$iv$iv.getValue();
                Iterable $this$sortedBy$iv2 = v;
                boolean $i$f$sortedBy = false;
                object.add(TuplesKt.to((Object)k, (Object)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv2, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        IntRange it = (IntRange)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(it.getFirst());
                        it = (IntRange)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getFirst()));
                    }
                })));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$sortedBy = false;
            List declarationsWithUses = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Pair it = (Pair)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(((IntRange)it.getFirst()).getFirst());
                    it = (Pair)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(((IntRange)it.getFirst()).getFirst()));
                }
            });
            CodingKt.vlq(binaryStream, declarationsWithUses.size());
            int previousDeclarationEnd = 0;
            Iterable $this$forEach$iv3 = declarationsWithUses;
            boolean $i$f$forEach3 = false;
            for (Object element$iv2 : $this$forEach$iv3) {
                boolean isCompact;
                List uses2;
                IntRange decl;
                block19: {
                    iterator2 = (Pair)element$iv2;
                    boolean bl = false;
                    decl = (IntRange)iterator2.component1();
                    uses2 = (List)iterator2.component2();
                    CodingKt.vlq(binaryStream, decl.getFirst() - previousDeclarationEnd);
                    int declSize = decl.getLast() - decl.getFirst() + 1;
                    CodingKt.vlq(binaryStream, declSize);
                    Iterable $this$all$iv = uses2;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        v4 = true;
                    } else {
                        for (Object element$iv3 : $this$all$iv) {
                            IntRange it = (IntRange)element$iv3;
                            boolean bl5 = false;
                            if (it.getLast() - it.getFirst() + 1 == declSize && it.getFirst() > decl.getLast()) continue;
                            v4 = false;
                            break block19;
                        }
                        v4 = isCompact = true;
                    }
                }
                if (isCompact) {
                    CodingKt.vlq(binaryStream, uses2.size());
                    previousUseEnd = 0;
                    previousUseEnd = previousDeclarationEnd;
                    $this$forEach$iv = uses2;
                    $i$f$forEach = false;
                    for (Object element$iv4 : $this$forEach$iv) {
                        IntRange use = (IntRange)element$iv4;
                        boolean bl = false;
                        CodingKt.vlq(binaryStream, use.getFirst() - previousUseEnd);
                        previousUseEnd = use.getLast() + 1;
                    }
                } else {
                    CodingKt.vlq(binaryStream, 0);
                    CodingKt.vlq(binaryStream, uses2.size());
                    previousUseEnd = 0;
                    $this$forEach$iv = uses2;
                    $i$f$forEach = false;
                    for (Object element$iv4 : $this$forEach$iv) {
                        IntRange use = (IntRange)element$iv4;
                        boolean bl = false;
                        CodingKt.vlq(binaryStream, use.getFirst() - previousUseEnd);
                        CodingKt.vlq(binaryStream, use.getLast() - use.getFirst() + 1);
                        previousUseEnd = use.getLast() + 1;
                    }
                }
                previousDeclarationEnd = decl.getLast() + 1;
            }
        }

        @NotNull
        public String toString() {
            String string2 = "StylingRecord (%d styled runs)";
            Object[] objectArray = new Object[]{this.styleRuns.size()};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
            return string3;
        }

        public StylingRecord(@NotNull byte[] bytes2) throws IOException {
            int n;
            Intrinsics.checkNotNullParameter((Object)bytes2, (String)"bytes");
            DataInputStream binaryStream = new DataInputStream(new ByteArrayInputStream(bytes2));
            int n2 = 0;
            int n3 = CodingKt.unvlqInt(binaryStream);
            String[] stringArray = new String[n3];
            while (n2 < n3) {
                n = n2++;
                stringArray[n] = CodingKt.decodeString(binaryStream);
            }
            String[] styles = stringArray;
            int pos = 0;
            List allRuns = new ArrayList();
            int n4 = CodingKt.unvlqInt(binaryStream);
            for (n = 0; n < n4; ++n) {
                int it = n;
                boolean bl = false;
                int styleNumber = CodingKt.unvlqInt(binaryStream);
                int length = CodingKt.unvlqInt(binaryStream);
                pos += length;
                if (styleNumber <= 0) continue;
                allRuns.add(TuplesKt.to((Object)RangesKt.until((int)(pos - length), (int)pos), (Object)styles[styleNumber - 1]));
            }
            this.styleRuns = allRuns;
            List usesToDeclarations = new ArrayList();
            int previousDeclarationEnd = 0;
            int n5 = CodingKt.unvlqInt(binaryStream);
            for (int j = 0; j < n5; ++j) {
                int it = j;
                boolean bl = false;
                int declStart = previousDeclarationEnd + CodingKt.unvlqInt(binaryStream);
                int length = CodingKt.unvlqInt(binaryStream);
                IntRange decl = RangesKt.until((int)declStart, (int)(declStart + length));
                int usagesOrZero = CodingKt.unvlqInt(binaryStream);
                if (usagesOrZero == 0) {
                    previousUseEnd = 0;
                    var17_21 = CodingKt.unvlqInt(binaryStream);
                    int n6 = 0;
                    while (n6 < var17_21) {
                        int it2 = n6++;
                        boolean bl2 = false;
                        int useStart = previousUseEnd + CodingKt.unvlqInt(binaryStream);
                        int size = CodingKt.unvlqInt(binaryStream);
                        IntRange use = RangesKt.until((int)useStart, (int)(useStart + size));
                        usesToDeclarations.add(TuplesKt.to((Object)use, (Object)decl));
                        previousUseEnd = use.getLast() + 1;
                    }
                } else {
                    previousUseEnd = 0;
                    previousUseEnd = previousDeclarationEnd;
                    var17_21 = 0;
                    while (var17_21 < usagesOrZero) {
                        int it3 = var17_21++;
                        boolean bl3 = false;
                        int useStart = previousUseEnd + CodingKt.unvlqInt(binaryStream);
                        IntRange use = RangesKt.until((int)useStart, (int)(useStart + length));
                        usesToDeclarations.add(TuplesKt.to((Object)use, (Object)decl));
                        previousUseEnd = use.getLast() + 1;
                    }
                }
                previousDeclarationEnd = declStart + length;
            }
            this.variableUses = usesToDeclarations;
            int n7 = n5 = binaryStream.available() == 0 ? 1 : 0;
            if (_Assertions.ENABLED && n5 == 0) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
        }

        public StylingRecord(@NotNull List<Pair<IntRange, String>> styleRuns, @NotNull List<Pair<IntRange, IntRange>> variableUses) {
            Intrinsics.checkNotNullParameter(styleRuns, (String)"styleRuns");
            Intrinsics.checkNotNullParameter(variableUses, (String)"variableUses");
            this.styleRuns = styleRuns;
            this.variableUses = variableUses;
        }

        private static final Integer write$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Integer)$tmp0.invoke(p0);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 ,2\u00020\u0001:\u0002,-BA\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0000\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00000\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u001f\u001a\u00020\u0012J\b\u0010 \u001a\u00020!H\u0016JK\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00120'2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00120'2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00120*H\u0000\u00a2\u0006\u0002\b+R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00000\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R \u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00128F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\b\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R$\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\b\u0010\u0011\u001a\u0004\u0018\u00010\u001a8F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0010\u00a8\u0006."}, d2={"Lavail/persistence/cache/Repository$PhraseNode;", "", "atomModuleName", "Lavail/descriptor/tuples/A_String;", "atomName", "tokenSpans", "", "Lavail/persistence/cache/Repository$PhraseNode$PhraseNodeToken;", "parent", "children", "", "(Lavail/descriptor/tuples/A_String;Lavail/descriptor/tuples/A_String;Ljava/util/List;Lavail/persistence/cache/Repository$PhraseNode;Ljava/util/List;)V", "getAtomModuleName", "()Lavail/descriptor/tuples/A_String;", "getAtomName", "getChildren", "()Ljava/util/List;", "<set-?>", "", "indexInParent", "getIndexInParent", "()I", "getParent", "()Lavail/persistence/cache/Repository$PhraseNode;", "setParent", "(Lavail/persistence/cache/Repository$PhraseNode;)V", "Lavail/compiler/splitter/MessageSplitter;", "splitter", "getSplitter", "()Lavail/compiler/splitter/MessageSplitter;", "getTokenSpans", "depth", "toString", "", "write", "", "binaryStream", "Ljava/io/DataOutputStream;", "moduleNameMap", "", "atomNameMap", "tokenCursor", "Lavail/utility/Mutable;", "write$avail", "Companion", "PhraseNodeToken", "avail"})
    public static final class PhraseNode {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final A_String atomModuleName;
        @Nullable
        private final A_String atomName;
        @NotNull
        private final List<PhraseNodeToken> tokenSpans;
        @Nullable
        private PhraseNode parent;
        @NotNull
        private final List<PhraseNode> children;
        @Nullable
        private MessageSplitter splitter;
        private volatile int indexInParent;

        public PhraseNode(@Nullable A_String atomModuleName, @Nullable A_String atomName, @NotNull List<PhraseNodeToken> tokenSpans, @Nullable PhraseNode parent, @NotNull List<PhraseNode> children2) {
            Intrinsics.checkNotNullParameter(tokenSpans, (String)"tokenSpans");
            Intrinsics.checkNotNullParameter(children2, (String)"children");
            this.atomModuleName = atomModuleName;
            this.atomName = atomName;
            this.tokenSpans = tokenSpans;
            this.parent = parent;
            this.children = children2;
            this.indexInParent = -1;
        }

        public /* synthetic */ PhraseNode(A_String a_String, A_String a_String2, List list2, PhraseNode phraseNode, List list3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                list3 = new ArrayList();
            }
            this(a_String, a_String2, list2, phraseNode, list3);
        }

        @Nullable
        public final A_String getAtomModuleName() {
            return this.atomModuleName;
        }

        @Nullable
        public final A_String getAtomName() {
            return this.atomName;
        }

        @NotNull
        public final List<PhraseNodeToken> getTokenSpans() {
            return this.tokenSpans;
        }

        @Nullable
        public final PhraseNode getParent() {
            return this.parent;
        }

        public final void setParent(@Nullable PhraseNode phraseNode) {
            this.parent = phraseNode;
        }

        @NotNull
        public final List<PhraseNode> getChildren() {
            return this.children;
        }

        @Nullable
        public final MessageSplitter getSplitter() {
            MessageSplitter messageSplitter = this.splitter;
            if (messageSplitter == null) {
                A_String a_String = this.atomName;
                if (a_String != null) {
                    A_String it = a_String;
                    boolean bl = false;
                    messageSplitter = this.splitter = MessageSplitter.Companion.split(it);
                } else {
                    messageSplitter = null;
                }
            }
            return messageSplitter;
        }

        public final int getIndexInParent() {
            block3: {
                if (this.indexInParent != -1) break block3;
                Object object = this.parent;
                if (object != null && (object = ((PhraseNode)object).children) != null) {
                    Iterable $this$forEachIndexed$iv = (Iterable)object;
                    boolean $i$f$forEachIndexed = false;
                    int index$iv = 0;
                    for (Object item$iv : $this$forEachIndexed$iv) {
                        int n;
                        if ((n = index$iv++) < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        PhraseNode phraseNode = (PhraseNode)item$iv;
                        int i2 = n;
                        boolean bl = false;
                        child.indexInParent = i2 + 1;
                    }
                }
            }
            return this.indexInParent;
        }

        /*
         * Unable to fully structure code
         */
        public final void write$avail(@NotNull DataOutputStream binaryStream, @NotNull Map<A_String, Integer> moduleNameMap, @NotNull Map<A_String, Integer> atomNameMap, @NotNull Mutable<Integer> tokenCursor) throws IOException {
            Intrinsics.checkNotNullParameter((Object)binaryStream, (String)"binaryStream");
            Intrinsics.checkNotNullParameter(moduleNameMap, (String)"moduleNameMap");
            Intrinsics.checkNotNullParameter(atomNameMap, (String)"atomNameMap");
            Intrinsics.checkNotNullParameter(tokenCursor, (String)"tokenCursor");
            v0 = binaryStream;
            v1 = this.atomModuleName;
            if (v1 == null) ** GOTO lbl-1000
            var8_5 = v1;
            var14_6 = v0;
            $i$a$-let-Repository$PhraseNode$write$1 = false;
            v2 = moduleNameMap.get(p0);
            v0 = var14_6;
            v1 = v2;
            if (v2 != null) {
                v3 = v1.intValue();
            } else lbl-1000:
            // 2 sources

            {
                v3 = 0;
            }
            CodingKt.vlq(v0, v3);
            v4 = binaryStream;
            v5 = this.atomName;
            if (v5 == null) ** GOTO lbl-1000
            p0 = v5;
            var14_6 = v4;
            $i$a$-let-Repository$PhraseNode$write$2 = false;
            v6 = atomNameMap.get(p0);
            v4 = var14_6;
            v5 = v6;
            if (v6 != null) {
                v7 = v5.intValue();
            } else lbl-1000:
            // 2 sources

            {
                v7 = 0;
            }
            CodingKt.vlq(v4, v7);
            CodingKt.vlq(binaryStream, this.tokenSpans.size());
            $this$forEach$iv = this.tokenSpans;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                var9_8 = (PhraseNodeToken)element$iv;
                $i$a$-forEach-Repository$PhraseNode$write$3 = false;
                start = var9_8.component1();
                pastEnd = var9_8.component2();
                tokenIndexInName = var9_8.component3();
                CodingKt.zigzag(binaryStream, start - ((Number)tokenCursor.getValue()).intValue());
                tokenCursor.setValue(start);
                CodingKt.zigzag(binaryStream, pastEnd - ((Number)tokenCursor.getValue()).intValue());
                tokenCursor.setValue(pastEnd);
                CodingKt.vlq(binaryStream, tokenIndexInName);
            }
        }

        public final int depth() {
            return CollectionsKt.count(CollectionExtensionsKt.iterableWith(this, (Function1)depth.1.INSTANCE));
        }

        @NotNull
        public String toString() {
            PhraseNode p = this.parent;
            String indexInfo = p == null ? "" : "(" + this.getIndexInParent() + "/" + p.children.size() + ") ";
            return CollectionsKt.joinToString$default((Iterable)this.tokenSpans, (CharSequence)", ", (CharSequence)("PhraseNode " + indexInfo + this.atomName + ": "), null, (int)0, null, (Function1)toString.1.INSTANCE, (int)28, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lavail/persistence/cache/Repository$PhraseNode$PhraseNodeToken;", "", "start", "", "pastEnd", "tokenIndexInName", "(III)V", "getPastEnd", "()I", "getStart", "getTokenIndexInName", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "avail"})
        public static final class PhraseNodeToken {
            private final int start;
            private final int pastEnd;
            private final int tokenIndexInName;

            public PhraseNodeToken(int start, int pastEnd, int tokenIndexInName) {
                this.start = start;
                this.pastEnd = pastEnd;
                this.tokenIndexInName = tokenIndexInName;
            }

            public final int getStart() {
                return this.start;
            }

            public final int getPastEnd() {
                return this.pastEnd;
            }

            public final int getTokenIndexInName() {
                return this.tokenIndexInName;
            }

            public final int component1() {
                return this.start;
            }

            public final int component2() {
                return this.pastEnd;
            }

            public final int component3() {
                return this.tokenIndexInName;
            }

            @NotNull
            public final PhraseNodeToken copy(int start, int pastEnd, int tokenIndexInName) {
                return new PhraseNodeToken(start, pastEnd, tokenIndexInName);
            }

            public static /* synthetic */ PhraseNodeToken copy$default(PhraseNodeToken phraseNodeToken, int n, int n2, int n3, int n4, Object object) {
                if ((n4 & 1) != 0) {
                    n = phraseNodeToken.start;
                }
                if ((n4 & 2) != 0) {
                    n2 = phraseNodeToken.pastEnd;
                }
                if ((n4 & 4) != 0) {
                    n3 = phraseNodeToken.tokenIndexInName;
                }
                return phraseNodeToken.copy(n, n2, n3);
            }

            @NotNull
            public String toString() {
                return "PhraseNodeToken(start=" + this.start + ", pastEnd=" + this.pastEnd + ", tokenIndexInName=" + this.tokenIndexInName + ")";
            }

            public int hashCode() {
                int result2 = Integer.hashCode(this.start);
                result2 = result2 * 31 + Integer.hashCode(this.pastEnd);
                result2 = result2 * 31 + Integer.hashCode(this.tokenIndexInName);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof PhraseNodeToken)) {
                    return false;
                }
                PhraseNodeToken phraseNodeToken = (PhraseNodeToken)other;
                if (this.start != phraseNodeToken.start) {
                    return false;
                }
                if (this.pastEnd != phraseNodeToken.pastEnd) {
                    return false;
                }
                return this.tokenIndexInName == phraseNodeToken.tokenIndexInName;
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a8\u0006\u000e"}, d2={"Lavail/persistence/cache/Repository$PhraseNode$Companion;", "", "()V", "read", "Lavail/persistence/cache/Repository$PhraseNode;", "binaryStream", "Ljava/io/DataInputStream;", "moduleNameList", "", "Lavail/descriptor/tuples/A_String;", "atomNameList", "tokenCursor", "Lavail/utility/Mutable;", "", "avail"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final PhraseNode read(@NotNull DataInputStream binaryStream, @NotNull List<? extends A_String> moduleNameList, @NotNull List<? extends A_String> atomNameList, @NotNull Mutable<Integer> tokenCursor) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)binaryStream, (String)"binaryStream");
                Intrinsics.checkNotNullParameter(moduleNameList, (String)"moduleNameList");
                Intrinsics.checkNotNullParameter(atomNameList, (String)"atomNameList");
                Intrinsics.checkNotNullParameter(tokenCursor, (String)"tokenCursor");
                int index2 = CodingKt.unvlqInt(binaryStream);
                A_String atomModuleName = index2 == 0 ? null : moduleNameList.get(index2 - 1);
                int index3 = CodingKt.unvlqInt(binaryStream);
                A_String atomName = index3 == 0 ? null : atomNameList.get(index3 - 1);
                Iterable $this$map$iv = (Iterable)new IntRange(1, CodingKt.unvlqInt(binaryStream));
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    int item$iv$iv;
                    int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    int start = ((Number)tokenCursor.getValue()).intValue() + CodingKt.unzigzagInt(binaryStream);
                    tokenCursor.setValue(start);
                    int pastEnd = ((Number)tokenCursor.getValue()).intValue() + CodingKt.unzigzagInt(binaryStream);
                    tokenCursor.setValue(pastEnd);
                    int tokenIndexInName = CodingKt.unvlqInt(binaryStream);
                    collection2.add(new PhraseNodeToken(start, pastEnd, tokenIndexInName));
                }
                List tokenSpans = (List)destination$iv$iv;
                return new PhraseNode(atomModuleName, atomName, tokenSpans, null, null, 16, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0015\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u0014R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lavail/persistence/cache/Repository$PhrasePathRecord;", "", "bytes", "", "([B)V", "rootTrees", "", "Lavail/persistence/cache/Repository$PhraseNode;", "(Ljava/util/List;)V", "getRootTrees", "()Ljava/util/List;", "phraseNodesDo", "", "action", "Lkotlin/Function1;", "toString", "", "write", "binaryStream", "Ljava/io/DataOutputStream;", "write$avail", "avail"})
    public static final class PhrasePathRecord {
        @NotNull
        private final List<PhraseNode> rootTrees;

        public PhrasePathRecord(@NotNull List<PhraseNode> rootTrees) {
            Intrinsics.checkNotNullParameter(rootTrees, (String)"rootTrees");
            this.rootTrees = rootTrees;
        }

        public /* synthetic */ PhrasePathRecord(List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list2 = new ArrayList();
            }
            this(list2);
        }

        @NotNull
        public final List<PhraseNode> getRootTrees() {
            return this.rootTrees;
        }

        public final void phraseNodesDo(@NotNull Function1<? super PhraseNode, Unit> action2) {
            Intrinsics.checkNotNullParameter(action2, (String)"action");
            List workStack = new ArrayList();
            workStack.addAll(CollectionsKt.reversed((Iterable)this.rootTrees));
            while (!((Collection)workStack).isEmpty()) {
                PhraseNode node = (PhraseNode)CollectionsKt.removeLast((List)workStack);
                action2.invoke((Object)node);
                workStack.addAll(CollectionsKt.reversed((Iterable)node.getChildren()));
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void write$avail(@NotNull DataOutputStream binaryStream) throws IOException {
            A_String string2;
            void $this$forEach$iv;
            Intrinsics.checkNotNullParameter((Object)binaryStream, (String)"binaryStream");
            Map moduleNameMap = new LinkedHashMap();
            Map atomNameMap = new LinkedHashMap();
            List workStack = CollectionsKt.toMutableList((Collection)CollectionsKt.reversed((Iterable)this.rootTrees));
            while (!((Collection)workStack).isEmpty()) {
                A_String it;
                PhraseNode node = (PhraseNode)CollectionsKt.removeLast((List)workStack);
                if (node.getAtomModuleName() != null) {
                    boolean bl = false;
                    moduleNameMap.computeIfAbsent(it, arg_0 -> PhrasePathRecord.write$lambda$1$lambda$0((Function1)new Function1<A_String, Integer>((Map<A_String, Integer>)moduleNameMap){
                        final /* synthetic */ Map<A_String, Integer> $moduleNameMap;
                        {
                            this.$moduleNameMap = $moduleNameMap;
                            super(1);
                        }

                        @NotNull
                        public final Integer invoke(@NotNull A_String it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            return this.$moduleNameMap.size() + 1;
                        }
                    }, arg_0));
                }
                if (node.getAtomName() != null) {
                    boolean bl = false;
                    atomNameMap.computeIfAbsent(it, arg_0 -> PhrasePathRecord.write$lambda$3$lambda$2((Function1)new Function1<A_String, Integer>((Map<A_String, Integer>)atomNameMap){
                        final /* synthetic */ Map<A_String, Integer> $atomNameMap;
                        {
                            this.$atomNameMap = $atomNameMap;
                            super(1);
                        }

                        @NotNull
                        public final Integer invoke(@NotNull A_String it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            return this.$atomNameMap.size() + 1;
                        }
                    }, arg_0));
                }
                workStack.addAll(CollectionsKt.reversed((Iterable)node.getChildren()));
            }
            CodingKt.vlq(binaryStream, moduleNameMap.size());
            Iterable $this$sortedBy$iv = moduleNameMap.entrySet();
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Map.Entry it = (Map.Entry)a;
                    boolean bl = false;
                    Comparable comparable = (Integer)it.getValue();
                    it = (Map.Entry)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)it.getValue()));
                }
            });
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry entry = (Map.Entry)element$iv;
                boolean bl = false;
                string2 = (A_String)entry.getKey();
                CodingKt.sizedString(binaryStream, A_String.Companion.asNativeString(string2));
            }
            CodingKt.vlq(binaryStream, atomNameMap.size());
            $this$sortedBy$iv = atomNameMap.entrySet();
            $i$f$sortedBy = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Map.Entry it = (Map.Entry)a;
                    boolean bl = false;
                    Comparable comparable = (Integer)it.getValue();
                    it = (Map.Entry)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)it.getValue()));
                }
            });
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry entry = (Map.Entry)element$iv;
                boolean bl = false;
                string2 = (A_String)entry.getKey();
                CodingKt.sizedString(binaryStream, A_String.Companion.asNativeString(string2));
            }
            CodingKt.vlq(binaryStream, this.rootTrees.size());
            workStack.addAll(CollectionsKt.reversed((Iterable)this.rootTrees));
            Mutable<Integer> tokenCursor = new Mutable<Integer>(0);
            while (!((Collection)workStack).isEmpty()) {
                PhraseNode node = (PhraseNode)CollectionsKt.removeLast((List)workStack);
                node.write$avail(binaryStream, moduleNameMap, atomNameMap, tokenCursor);
                CodingKt.vlq(binaryStream, node.getChildren().size());
                workStack.addAll(CollectionsKt.reversed((Iterable)node.getChildren()));
            }
        }

        @NotNull
        public String toString() {
            return "PhrasePathRecord (" + this.rootTrees.size() + " top-level phrases)";
        }

        public PhrasePathRecord(@NotNull byte[] bytes2) throws IOException {
            boolean bl;
            int n;
            ArrayList<A_String> arrayList;
            int n2;
            Intrinsics.checkNotNullParameter((Object)bytes2, (String)"bytes");
            this(null, 1, null);
            DataInputStream binaryStream = new DataInputStream(new ByteArrayInputStream(bytes2));
            int n3 = CodingKt.unvlqInt(binaryStream);
            ArrayList<A_String> arrayList2 = new ArrayList<A_String>(n3);
            int n4 = 0;
            while (n4 < n3) {
                int n5 = n2 = n4++;
                arrayList = arrayList2;
                n = 0;
                arrayList.add(StringDescriptor.Companion.stringFrom(CodingKt.decodeString(binaryStream)));
            }
            List moduleNames = arrayList2;
            int n6 = CodingKt.unvlqInt(binaryStream);
            ArrayList arrayList3 = new ArrayList(n6);
            n2 = 0;
            while (n2 < n6) {
                int it;
                n = it = n2++;
                arrayList = arrayList3;
                boolean bl2 = false;
                arrayList.add(StringDescriptor.Companion.stringFrom(CodingKt.decodeString(binaryStream)));
            }
            List atomNames = arrayList3;
            PhraseNode fakeRoot = new PhraseNode(null, null, CollectionsKt.emptyList(), null, null, 16, null);
            List phrasesWithCountdowns = new ArrayList();
            phrasesWithCountdowns.add(TuplesKt.to((Object)fakeRoot, new Mutable<Integer>(CodingKt.unvlqInt(binaryStream))));
            Mutable<Integer> tokenCursor = new Mutable<Integer>(0);
            while (!((Collection)phrasesWithCountdowns).isEmpty()) {
                Pair it = (Pair)CollectionsKt.last((List)phrasesWithCountdowns);
                PhraseNode parent = (PhraseNode)it.component1();
                Mutable countdown = (Mutable)it.component2();
                if (((Number)countdown.getValue()).intValue() == 0) {
                    CollectionsKt.removeLast((List)phrasesWithCountdowns);
                    continue;
                }
                int n7 = ((Number)countdown.getValue()).intValue();
                countdown.setValue(n7 + -1);
                PhraseNode child = PhraseNode.Companion.read(binaryStream, moduleNames, atomNames, tokenCursor);
                child.setParent(parent);
                parent.getChildren().add(child);
                phrasesWithCountdowns.add(TuplesKt.to((Object)child, new Mutable<Integer>(CodingKt.unvlqInt(binaryStream))));
            }
            this.rootTrees.addAll((Collection<PhraseNode>)fakeRoot.getChildren());
            Iterable $this$forEach$iv = this.rootTrees;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PhraseNode it = (PhraseNode)element$iv;
                boolean bl3 = false;
                it.setParent(null);
            }
            boolean bl4 = bl = binaryStream.available() == 0;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
        }

        private static final Integer write$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Integer)$tmp0.invoke(p0);
        }

        private static final Integer write$lambda$3$lambda$2(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Integer)$tmp0.invoke(p0);
        }

        public PhrasePathRecord() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u0014J\u000e\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019J/\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00142\u0012\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010 \"\u00020\u0001\u00a2\u0006\u0002\u0010!J7\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\u00142\u0012\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010 \"\u00020\u0001\u00a2\u0006\u0002\u0010$J\u001d\u0010%\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u00062\u0006\u0010'\u001a\u00020(H\u0000\u00a2\u0006\u0002\b)R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00040\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006*"}, d2={"Lavail/persistence/cache/Repository$Companion;", "", "()V", "DEBUG_REPOSITORY", "", "DIGEST_SIZE", "", "MAX_HISTORICAL_VERSION_COMPILATIONS", "MAX_RECORDED_DIGESTS_PER_MODULE", "MAX_RECORDED_VERSIONS_PER_MODULE", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "versionCheck", "Lkotlin/Function2;", "getVersionCheck$avail", "()Lkotlin/jvm/functions/Function2;", "createTemporary", "Lavail/persistence/cache/Repository;", "rootName", "", "prefix", "suffix", "isIndexedRepositoryFile", "path", "Ljava/io/File;", "log", "", "level", "Ljava/util/logging/Level;", "format", "args", "", "(Ljava/util/logging/Level;Ljava/lang/String;[Ljava/lang/Object;)V", "exception", "", "(Ljava/util/logging/Level;Ljava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)V", "mix", "currentHash", "newLong", "", "mix$avail", "avail"})
    public static final class Companion {
        private Companion() {
        }

        public final void log(@NotNull Level level, @NotNull String format, Object ... args) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        }

        public final void log(@NotNull Level level, @NotNull Throwable exception, @NotNull String format, Object ... args) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        }

        public final int mix$avail(int currentHash, long newLong) {
            int h = currentHash;
            h *= 1664525;
            h += (int)newLong;
            h *= 1664525;
            return h ^= (int)(newLong >> 32);
        }

        @NotNull
        public final Function2<Integer, Integer, Boolean> getVersionCheck$avail() {
            return versionCheck;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final Repository createTemporary(@NotNull String rootName, @NotNull String prefix, @Nullable String suffix) {
            Repository repository;
            Intrinsics.checkNotNullParameter((Object)rootName, (String)"rootName");
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            try {
                File file2 = File.createTempFile(prefix, suffix);
                file2.deleteOnExit();
                IndexedFile indexedFile = null;
                IndexedFileBuilder indexedFileBuilder = IndexedRepositoryBuilder.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
                IndexedFile indexedFile2 = indexedFile = IndexedFileBuilder.openOrCreate$default((IndexedFileBuilder)indexedFileBuilder, (File)file2, (boolean)true, null, (int)0, (int)0, (int)0, (int)0, (int)0, null, (int)508, null);
                if (indexedFile2 != null) {
                    indexedFile2.close();
                }
                repository = new Repository(rootName, file2);
            }
            catch (Exception e) {
                throw new IndexedFileException((Throwable)e);
            }
            return repository;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean isIndexedRepositoryFile(@NotNull File path) throws IOException {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            if (path.isFile()) {
                Closeable closeable = new RandomAccessFile(path, "r");
                Throwable throwable = null;
                try {
                    int bytesRead;
                    RandomAccessFile file2 = (RandomAccessFile)closeable;
                    boolean bl = false;
                    byte[] repositoryHeader = IndexedRepositoryBuilder.INSTANCE.getHeaderBytes();
                    byte[] buffer = new byte[repositoryHeader.length];
                    int pos = 0;
                    while ((bytesRead = file2.read(buffer, pos, buffer.length - pos)) != -1 && (pos += bytesRead) != buffer.length) {
                    }
                    boolean bl2 = pos == buffer.length && Arrays.equals(repositoryHeader, buffer);
                    return bl2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

