/*
 * Decompiled with CFR 0.152.
 */
package avail.resolver;

import avail.builder.ModuleRootErrorCode;
import avail.error.ErrorCode;
import avail.error.StandardErrorCode;
import avail.files.AvailFile;
import avail.files.FileErrorCode;
import avail.files.FileManager;
import avail.resolver.ModuleRootResolver;
import avail.resolver.ResolverReference;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.GuardedBy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.NoSuchFileException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.availlang.artifact.AvailRootFileMetadata;
import org.availlang.artifact.ResourceType;
import org.availlang.artifact.jar.AvailArtifactJar;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J:\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00032\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u00162\u001a\u0010\u0017\u001a\u0016\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0004\u0012\u00020\u00120\u0018H\u0016JB\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u00032\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u00162\u001a\u0010\u0017\u001a\u0016\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0004\u0012\u00020\u00120\u0018H\u0016J:\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00032\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u00162\u001a\u0010\u0017\u001a\u0016\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0004\u0012\u00020\u00120\u0018H\u0016J:\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00032\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u00162\u001a\u0010\u0017\u001a\u0016\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0004\u0012\u00020\u00120\u0018H\u0016JP\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\"2\u001a\u0010#\u001a\u0016\u0012\u0004\u0012\u00020$\u0012\u0006\u0012\u0004\u0018\u00010%\u0012\u0004\u0012\u00020\u00120\u00182\u001a\u0010\u0017\u001a\u0016\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0004\u0012\u00020\u00120\u0018H\u0016J@\u0010&\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\u00120(2\u001a\u0010\u0017\u001a\u0016\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0004\u0012\u00020\u00120\u0018H\u0016JF\u0010*\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"2\u0018\u0010'\u001a\u0014\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\u00120\u00182\u001a\u0010\u0017\u001a\u0016\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0004\u0012\u00020\u00120\u0018H\u0016J8\u0010+\u001a\u00020\u00122\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u00120(2\u001a\u0010\u0017\u001a\u0016\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0004\u0012\u00020\u00120\u0018H\u0016J\b\u0010,\u001a\u00020\fH\u0016JF\u0010-\u001a\u00020\u00122\u0006\u0010.\u001a\u00020\f2\u0018\u0010/\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"00\u0012\u0004\u0012\u00020\u00120(2\u001a\u0010\u0017\u001a\u0016\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0004\u0012\u00020\u00120\u0018H\u0016JB\u00101\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"2\u0006\u00102\u001a\u00020$2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00120\u00162\u001a\u0010\u0017\u001a\u0016\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0004\u0012\u00020\u00120\u0018H\u0016J\b\u00103\u001a\u00020\u0003H\u0016R\u0012\u0010\t\u001a\u00020\n8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lavail/resolver/JarModuleRootResolver;", "Lavail/resolver/ModuleRootResolver;", "name", "", "uri", "Ljava/net/URI;", "fileManager", "Lavail/files/FileManager;", "(Ljava/lang/String;Ljava/net/URI;Lavail/files/FileManager;)V", "artifactJar", "Lorg/availlang/artifact/jar/AvailArtifactJar;", "canSave", "", "getCanSave", "()Z", "jarFileLock", "Ljava/util/concurrent/locks/ReentrantLock;", "close", "", "createDirectory", "qualifiedName", "completion", "Lkotlin/Function0;", "failureHandler", "Lkotlin/Function2;", "Lavail/error/ErrorCode;", "", "createFile", "mimeType", "createPackage", "deleteResource", "readFile", "bypassFileManager", "reference", "Lavail/resolver/ResolverReference;", "withContents", "", "Ljava/util/UUID;", "refreshResolverMetaData", "successHandler", "Lkotlin/Function1;", "", "refreshResolverReferenceDigest", "resolve", "resolvesToValidModuleRoot", "rootManifest", "forceRefresh", "withList", "", "saveFile", "fileContents", "toString", "avail"})
public final class JarModuleRootResolver
extends ModuleRootResolver {
    @NotNull
    private final ReentrantLock jarFileLock;
    @GuardedBy(value="jarFileLock")
    @NotNull
    private AvailArtifactJar artifactJar;

    public JarModuleRootResolver(@NotNull String name, @NotNull URI uri, @NotNull FileManager fileManager) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)fileManager, (String)"fileManager");
        super(name, uri, fileManager);
        this.jarFileLock = new ReentrantLock();
        this.artifactJar = new AvailArtifactJar(uri);
    }

    @Override
    public boolean getCanSave() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Lock lock = this.jarFileLock;
        lock.lock();
        try {
            boolean bl = false;
            this.artifactJar.close();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean resolvesToValidModuleRoot() {
        return new File(this.getUri().getPath()).isFile();
    }

    @Override
    public void resolve(@NotNull Function1<? super ResolverReference, Unit> successHandler, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        Intrinsics.checkNotNullParameter(successHandler, (String)"successHandler");
        Intrinsics.checkNotNullParameter(failureHandler, (String)"failureHandler");
        this.executeTask((Function0<Unit>)((Function0)new Function0<Unit>(this, failureHandler, successHandler){
            final /* synthetic */ JarModuleRootResolver this$0;
            final /* synthetic */ Function2<ErrorCode, Throwable, Unit> $failureHandler;
            final /* synthetic */ Function1<ResolverReference, Unit> $successHandler;
            {
                this.this$0 = $receiver;
                this.$failureHandler = $failureHandler;
                this.$successHandler = $successHandler;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                Map map = new LinkedHashMap<K, V>();
                String rootPrefix = "/" + this.this$0.getModuleRoot().getName();
                String rootInJar = this.this$0.getUri().getFragment();
                try {
                    Object element$iv;
                    Map $this$forEach$iv;
                    Enumeration $i$a$-withLock-JarModuleRootResolver$resolve$1$entries$22;
                    Map digests = null;
                    Object object = JarModuleRootResolver.access$getJarFileLock$p(this.this$0);
                    JarModuleRootResolver jarModuleRootResolver = this.this$0;
                    object.lock();
                    try {
                        boolean $i$a$-withLock-JarModuleRootResolver$resolve$1$entries$22 = false;
                        AvailArtifactJar availArtifactJar = JarModuleRootResolver.access$getArtifactJar$p(jarModuleRootResolver);
                        Intrinsics.checkNotNullExpressionValue((Object)rootInJar, (String)"rootInJar");
                        digests = availArtifactJar.extractDigestForRoot(rootInJar);
                        $i$a$-withLock-JarModuleRootResolver$resolve$1$entries$22 = JarModuleRootResolver.access$getArtifactJar$p(jarModuleRootResolver).getJarFileEntries();
                    }
                    finally {
                        object.unlock();
                    }
                    Enumeration entries2 = $i$a$-withLock-JarModuleRootResolver$resolve$1$entries$22;
                    object = JarModuleRootResolver.access$getArtifactJar$p(this.this$0).extractFileMetadataForRoot(this.this$0.getName(), rootInJar, entries2, digests);
                    jarModuleRootResolver = this.this$0;
                    boolean $i$f$forEach = false;
                    Iterator<Object> iterator2 = $this$forEach$iv.iterator();
                    while (iterator2.hasNext()) {
                        element$iv = iterator2.next();
                        AvailRootFileMetadata it = (AvailRootFileMetadata)element$iv;
                        boolean bl = false;
                        ResolverReference reference = new ResolverReference(jarModuleRootResolver, new URI(null, it.getPath(), null), it.getQualifiedName(), it.getType(), it.getMimeType(), it.getLastModified(), it.getSize(), null, (byte[])digests.get(it.getPath()), 128, null);
                        map.put(it.getQualifiedName(), reference);
                    }
                    map.put(rootPrefix, new ResolverReference(this.this$0, new URI(rootPrefix), rootPrefix, ResourceType.ROOT, "", 0L, 0L, this.this$0.getModuleRoot().getName(), null, 256, null));
                    $this$forEach$iv = map;
                    jarModuleRootResolver = this.this$0;
                    $i$f$forEach = false;
                    iterator2 = $this$forEach$iv.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        ResolverReference parentNode;
                        String parentName2;
                        Object object2 = element$iv = (Map.Entry)iterator2.next();
                        boolean bl = false;
                        String name = (String)object2.getKey();
                        ResolverReference reference = (ResolverReference)object2.getValue();
                        jarModuleRootResolver.getReferenceMap().put(reference.getQualifiedName(), reference);
                        if (!(((CharSequence)name).length() > 0) || (ResolverReference)map.get(parentName2 = StringsKt.substringBeforeLast((String)name, (String)"/", (String)"")) == null) continue;
                        boolean bl2 = reference.isResource();
                        if (bl2) {
                            parentNode.getResources().add(reference);
                            continue;
                        }
                        if (bl2) continue;
                        parentNode.getModules().add(reference);
                    }
                }
                catch (Throwable e) {
                    this.$failureHandler.invoke((Object)ModuleRootErrorCode.MODULE_ROOT_RESOLUTION_FAILED, (Object)e);
                    return;
                }
                V v = map.get(rootPrefix);
                Intrinsics.checkNotNull(v);
                ResolverReference rootReference = (ResolverReference)v;
                this.this$0.setModuleRootTree$avail(rootReference);
                this.$successHandler.invoke((Object)rootReference);
            }
        }));
    }

    @Override
    public void rootManifest(boolean forceRefresh, @NotNull Function1<? super List<ResolverReference>, Unit> withList, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        Intrinsics.checkNotNullParameter(withList, (String)"withList");
        Intrinsics.checkNotNullParameter(failureHandler, (String)"failureHandler");
        if (!this.getReferenceMap().isEmpty() && !forceRefresh) {
            withList.invoke((Object)CollectionsKt.toList((Iterable)this.getReferenceMap().values()));
            return;
        }
        this.executeTask((Function0<Unit>)((Function0)new Function0<Unit>(this, failureHandler, withList){
            final /* synthetic */ JarModuleRootResolver this$0;
            final /* synthetic */ Function2<ErrorCode, Throwable, Unit> $failureHandler;
            final /* synthetic */ Function1<List<ResolverReference>, Unit> $withList;
            {
                this.this$0 = $receiver;
                this.$failureHandler = $failureHandler;
                this.$withList = $withList;
                super(0);
            }

            public final void invoke() {
                this.this$0.resolve((Function1<? super ResolverReference, Unit>)((Function1)new Function1<ResolverReference, Unit>(this.$withList, this.this$0){
                    final /* synthetic */ Function1<List<ResolverReference>, Unit> $withList;
                    final /* synthetic */ JarModuleRootResolver this$0;
                    {
                        this.$withList = $withList;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull ResolverReference it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.$withList.invoke((Object)CollectionsKt.toList((Iterable)this.this$0.getReferenceMap().values()));
                    }
                }), this.$failureHandler);
            }
        }));
    }

    @Override
    public void refreshResolverMetaData(@NotNull ResolverReference reference, @NotNull Function1<? super Long, Unit> successHandler, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter(successHandler, (String)"successHandler");
        Intrinsics.checkNotNullParameter(failureHandler, (String)"failureHandler");
        this.executeTask((Function0<Unit>)((Function0)new Function0<Unit>(successHandler, reference){
            final /* synthetic */ Function1<Long, Unit> $successHandler;
            final /* synthetic */ ResolverReference $reference;
            {
                this.$successHandler = $successHandler;
                this.$reference = $reference;
                super(0);
            }

            public final void invoke() {
                this.$successHandler.invoke((Object)this.$reference.getLastModified());
            }
        }));
    }

    @Override
    public void refreshResolverReferenceDigest(@NotNull ResolverReference reference, @NotNull Function2<? super byte[], ? super Long, Unit> successHandler, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter(successHandler, (String)"successHandler");
        Intrinsics.checkNotNullParameter(failureHandler, (String)"failureHandler");
        byte[] digest = reference.getForcedDigest();
        if (digest == null) {
            failureHandler.invoke((Object)FileErrorCode.FILE_NOT_FOUND, (Object)new NoSuchFileException(new File(reference.getQualifiedName()), null, "Avail file " + reference.getQualifiedName() + " does not occur in Jar", 2, null));
        } else {
            successHandler.invoke((Object)digest, (Object)reference.getLastModified());
        }
    }

    @Override
    public void createFile(@NotNull String qualifiedName, @NotNull String mimeType, @NotNull Function0<Unit> completion, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        Intrinsics.checkNotNullParameter(failureHandler, (String)"failureHandler");
        failureHandler.invoke((Object)FileErrorCode.PERMISSIONS, null);
    }

    @Override
    public void createPackage(@NotNull String qualifiedName, @NotNull Function0<Unit> completion, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        Intrinsics.checkNotNullParameter(failureHandler, (String)"failureHandler");
        failureHandler.invoke((Object)FileErrorCode.PERMISSIONS, null);
    }

    @Override
    public void createDirectory(@NotNull String qualifiedName, @NotNull Function0<Unit> completion, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        Intrinsics.checkNotNullParameter(failureHandler, (String)"failureHandler");
        failureHandler.invoke((Object)FileErrorCode.PERMISSIONS, null);
    }

    @Override
    public void deleteResource(@NotNull String qualifiedName, @NotNull Function0<Unit> completion, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        Intrinsics.checkNotNullParameter(failureHandler, (String)"failureHandler");
        failureHandler.invoke((Object)FileErrorCode.PERMISSIONS, null);
    }

    @Override
    public void saveFile(@NotNull ResolverReference reference, @NotNull byte[] fileContents, @NotNull Function0<Unit> successHandler, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)fileContents, (String)"fileContents");
        Intrinsics.checkNotNullParameter(successHandler, (String)"successHandler");
        Intrinsics.checkNotNullParameter(failureHandler, (String)"failureHandler");
        failureHandler.invoke((Object)FileErrorCode.PERMISSIONS, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readFile(boolean bypassFileManager, @NotNull ResolverReference reference, @NotNull Function2<? super byte[], ? super UUID, Unit> withContents, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        Object object;
        boolean handled2;
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter(withContents, (String)"withContents");
        Intrinsics.checkNotNullParameter(failureHandler, (String)"failureHandler");
        Object[] objectArray = new ResourceType[]{ResourceType.ROOT, ResourceType.DIRECTORY, ResourceType.PACKAGE};
        if (!(!SetsKt.setOf((Object[])objectArray).contains(reference.getType()))) {
            boolean bl = false;
            String string2 = reference.getQualifiedName() + " is not a file that can be read!";
            throw new IllegalArgumentException(string2.toString());
        }
        if (!bypassFileManager && (handled2 = this.getFileManager().optionallyProvideExistingFile(reference, (Function2<? super UUID, ? super AvailFile, Unit>)((Function2)new Function2<UUID, AvailFile, Unit>(reference, withContents){
            final /* synthetic */ ResolverReference $reference;
            final /* synthetic */ Function2<byte[], UUID, Unit> $withContents;
            {
                this.$reference = $reference;
                this.$withContents = $withContents;
                super(2);
            }

            public final void invoke(@NotNull UUID uuid, @NotNull AvailFile availFile) {
                Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
                Intrinsics.checkNotNullParameter((Object)availFile, (String)"availFile");
                this.$reference.refresh(availFile.getLastModified(), availFile.getRawContent().length);
                this.$withContents.invoke((Object)availFile.getRawContent(), (Object)uuid);
            }
        }), failureHandler))) {
            return;
        }
        try {
            byte[] $i$a$-withLock-JarModuleRootResolver$readFile$fileContent$22;
            object = this.jarFileLock;
            object.lock();
            try {
                boolean $i$a$-withLock-JarModuleRootResolver$readFile$fileContent$22 = false;
                String string3 = reference.getResolver().getUri().getFragment();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"reference.resolver.uri.fragment");
                String string4 = reference.getUri().getSchemeSpecificPart();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"reference.uri.schemeSpecificPart");
                $i$a$-withLock-JarModuleRootResolver$readFile$fileContent$22 = this.artifactJar.extractRootFile(string3, string4);
            }
            finally {
                object.unlock();
            }
            object = $i$a$-withLock-JarModuleRootResolver$readFile$fileContent$22;
        }
        catch (IOException e) {
            failureHandler.invoke((Object)StandardErrorCode.IO_EXCEPTION, (Object)e);
            return;
        }
        catch (Throwable e) {
            failureHandler.invoke((Object)StandardErrorCode.UNSPECIFIED, (Object)e);
            return;
        }
        Object fileContent2 = object;
        withContents.invoke(fileContent2, null);
    }

    @NotNull
    public String toString() {
        return this.getName() + " - " + this.getUri();
    }

    public static final /* synthetic */ ReentrantLock access$getJarFileLock$p(JarModuleRootResolver $this) {
        return $this.jarFileLock;
    }

    public static final /* synthetic */ AvailArtifactJar access$getArtifactJar$p(JarModuleRootResolver $this) {
        return $this.artifactJar;
    }
}

