/*
 * Decompiled with CFR 0.152.
 */
package avail.stacks;

import avail.AvailRuntime;
import avail.descriptor.tuples.A_String;
import avail.stacks.LinkingFileMap;
import avail.stacks.StacksErrorLog;
import avail.stacks.StacksFilename;
import avail.stacks.StacksOutputFile;
import avail.stacks.StacksSynchronizer;
import avail.stacks.comment.ClassComment;
import avail.stacks.comment.GlobalComment;
import avail.stacks.comment.GrammaticalRestrictionComment;
import avail.stacks.comment.MacroComment;
import avail.stacks.comment.MethodComment;
import avail.stacks.comment.SemanticRestrictionComment;
import avail.stacks.tokens.QuotedStacksToken;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.availlang.json.JSONWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB'\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\u0000\u0012\u0006\u0010\f\u001a\u00020\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\rJ\u000e\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\"J\u000e\u00109\u001a\u0002072\u0006\u0010:\u001a\u00020*J\u000e\u0010;\u001a\u0002072\u0006\u0010<\u001a\u00020-J\u000e\u0010=\u001a\u0002072\u0006\u0010>\u001a\u000204J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fJ\u000e\u0010\u0016\u001a\u0002072\u0006\u0010?\u001a\u00020\u0015J\u000e\u0010\u001d\u001a\u0002072\u0006\u0010@\u001a\u00020\u001cJ\u000e\u0010%\u001a\u0002072\u0006\u0010A\u001a\u00020\tJ\u000e\u0010B\u001a\u0002072\u0006\u0010\u000b\u001a\u00020\u0000J6\u0010C\u001a\u0002072\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020\u00052\u0006\u0010M\u001a\u00020NR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\"\u0010\u0016\u001a\u0004\u0018\u00010\u00152\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\"\u0010\u0019\u001a\u0004\u0018\u00010\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\"\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\b\u0010\u0014\u001a\u0004\u0018\u00010\u001c@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001d\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\"0!\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001e\u0010%\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u0010(\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010'R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010'R\u001d\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020*0!\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010$R\u001d\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020-0!\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010$R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u001d\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002040!\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010$\u00a8\u0006O"}, d2={"Lavail/stacks/CommentGroup;", "", "name", "Lavail/descriptor/tuples/A_String;", "namingModule", "", "filename", "Lavail/stacks/StacksFilename;", "isPrivate", "", "(Lavail/descriptor/tuples/A_String;Ljava/lang/String;Lavail/stacks/StacksFilename;Z)V", "group", "fileName", "(Lavail/stacks/CommentGroup;Lavail/stacks/StacksFilename;Ljava/lang/String;Lavail/descriptor/tuples/A_String;)V", "aliases", "", "getAliases", "()Ljava/util/Set;", "categories", "getCategories", "<set-?>", "Lavail/stacks/comment/ClassComment;", "classImplementation", "getClassImplementation", "()Lavail/stacks/comment/ClassComment;", "filepath", "getFilepath", "()Lavail/stacks/StacksFilename;", "Lavail/stacks/comment/GlobalComment;", "global", "getGlobal", "()Lavail/stacks/comment/GlobalComment;", "grammaticalRestrictions", "", "Lavail/stacks/comment/GrammaticalRestrictionComment;", "getGrammaticalRestrictions", "()Ljava/util/Map;", "hasStickyComment", "getHasStickyComment", "()Z", "isPopulated", "macros", "Lavail/stacks/comment/MacroComment;", "getMacros", "methods", "Lavail/stacks/comment/MethodComment;", "getMethods", "getName", "()Lavail/descriptor/tuples/A_String;", "getNamingModule", "()Ljava/lang/String;", "semanticRestrictions", "Lavail/stacks/comment/SemanticRestrictionComment;", "getSemanticRestrictions", "addGrammaticalRestriction", "", "newGrammaticalRestriction", "addMacro", "newMacro", "addMethod", "newMethod", "addSemanticRestriction", "newSemanticRestriction", "aClassImplementation", "aGlobal", "aSwitch", "mergeWith", "toJSON", "outputPath", "Ljava/nio/file/Path;", "synchronizer", "Lavail/stacks/StacksSynchronizer;", "runtime", "Lavail/AvailRuntime;", "linkingFileMap", "Lavail/stacks/LinkingFileMap;", "nameOfGroup", "errorLog", "Lavail/stacks/StacksErrorLog;", "avail"})
public final class CommentGroup {
    @NotNull
    private final A_String name;
    @NotNull
    private final String namingModule;
    private final boolean isPrivate;
    private boolean hasStickyComment;
    @NotNull
    private final Set<String> categories;
    @NotNull
    private final Set<String> aliases;
    @Nullable
    private StacksFilename filepath;
    @NotNull
    private final Map<String, MethodComment> methods;
    @NotNull
    private final Map<String, MacroComment> macros;
    @NotNull
    private final Map<String, SemanticRestrictionComment> semanticRestrictions;
    @NotNull
    private final Map<String, GrammaticalRestrictionComment> grammaticalRestrictions;
    @Nullable
    private ClassComment classImplementation;
    @Nullable
    private GlobalComment global;

    @NotNull
    public final A_String getName() {
        return this.name;
    }

    @NotNull
    public final String getNamingModule() {
        return this.namingModule;
    }

    public final boolean isPrivate() {
        return this.isPrivate;
    }

    public final boolean getHasStickyComment() {
        return this.hasStickyComment;
    }

    @NotNull
    public final Set<String> getCategories() {
        return this.categories;
    }

    @NotNull
    public final Set<String> getAliases() {
        return this.aliases;
    }

    @Nullable
    public final StacksFilename getFilepath() {
        return this.filepath;
    }

    @NotNull
    public final Map<String, MethodComment> getMethods() {
        return this.methods;
    }

    @NotNull
    public final Map<String, MacroComment> getMacros() {
        return this.macros;
    }

    @NotNull
    public final Map<String, SemanticRestrictionComment> getSemanticRestrictions() {
        return this.semanticRestrictions;
    }

    @NotNull
    public final Map<String, GrammaticalRestrictionComment> getGrammaticalRestrictions() {
        return this.grammaticalRestrictions;
    }

    @Nullable
    public final ClassComment getClassImplementation() {
        return this.classImplementation;
    }

    @Nullable
    public final GlobalComment getGlobal() {
        return this.global;
    }

    public final boolean isPopulated() {
        return !this.methods.isEmpty() || !this.macros.isEmpty() || this.global != null || this.classImplementation != null;
    }

    public final void hasStickyComment(boolean aSwitch) {
        this.hasStickyComment = aSwitch;
    }

    @NotNull
    public final Set<String> categories() {
        if (this.categories.size() > 1) {
            this.categories.remove("Unclassified");
        }
        return this.categories;
    }

    public final void addMethod(@NotNull MethodComment newMethod) {
        Intrinsics.checkNotNullParameter((Object)newMethod, (String)"newMethod");
        this.methods.put(newMethod.identityCheck(), newMethod);
        this.aliases.add(newMethod.getSignature$avail().getName());
        for (QuotedStacksToken category : newMethod.getCategories$avail().get(0).categories()) {
            this.categories.add(category.getLexeme$avail());
        }
    }

    public final void addMacro(@NotNull MacroComment newMacro) {
        Intrinsics.checkNotNullParameter((Object)newMacro, (String)"newMacro");
        this.macros.put(newMacro.identityCheck(), newMacro);
        this.aliases.add(newMacro.getSignature$avail().getName());
        for (QuotedStacksToken category : newMacro.getCategories$avail().get(0).categories()) {
            this.categories.add(category.getLexeme$avail());
        }
    }

    public final void addSemanticRestriction(@NotNull SemanticRestrictionComment newSemanticRestriction) {
        Intrinsics.checkNotNullParameter((Object)newSemanticRestriction, (String)"newSemanticRestriction");
        this.semanticRestrictions.put(newSemanticRestriction.identityCheck(), newSemanticRestriction);
        this.aliases.add(newSemanticRestriction.getSignature$avail().getName());
        for (QuotedStacksToken category : newSemanticRestriction.getCategories$avail().get(0).categories()) {
            this.categories.add(category.getLexeme$avail());
        }
    }

    public final void addGrammaticalRestriction(@NotNull GrammaticalRestrictionComment newGrammaticalRestriction) {
        Intrinsics.checkNotNullParameter((Object)newGrammaticalRestriction, (String)"newGrammaticalRestriction");
        this.grammaticalRestrictions.put(newGrammaticalRestriction.identityCheck(), newGrammaticalRestriction);
        this.aliases.add(newGrammaticalRestriction.getSignature$avail().getName());
        for (QuotedStacksToken category : newGrammaticalRestriction.getCategories$avail().get(0).categories()) {
            this.categories.add(category.getLexeme$avail());
        }
    }

    public final void classImplementation(@NotNull ClassComment aClassImplementation) {
        Intrinsics.checkNotNullParameter((Object)aClassImplementation, (String)"aClassImplementation");
        this.classImplementation = aClassImplementation;
        this.aliases.add(aClassImplementation.getSignature$avail().getName());
        for (QuotedStacksToken category : aClassImplementation.getCategories$avail().get(0).categories()) {
            this.categories.add(category.getLexeme$avail());
        }
    }

    public final void global(@NotNull GlobalComment aGlobal) {
        Intrinsics.checkNotNullParameter((Object)aGlobal, (String)"aGlobal");
        this.global = aGlobal;
        this.aliases.add(aGlobal.getSignature$avail().getName());
        for (QuotedStacksToken category : aGlobal.getCategories$avail().get(0).categories()) {
            this.categories.add(category.getLexeme$avail());
        }
    }

    public CommentGroup(@NotNull A_String name, @NotNull String namingModule, @NotNull StacksFilename filename, boolean isPrivate) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)namingModule, (String)"namingModule");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        this.name = name;
        this.methods = new LinkedHashMap();
        this.macros = new LinkedHashMap();
        this.semanticRestrictions = new LinkedHashMap();
        this.grammaticalRestrictions = new LinkedHashMap();
        this.aliases = new LinkedHashSet();
        this.namingModule = namingModule;
        this.categories = new LinkedHashSet();
        this.filepath = filename;
        this.isPrivate = isPrivate;
        this.hasStickyComment = false;
    }

    public CommentGroup(@NotNull CommentGroup group, @NotNull StacksFilename fileName, @NotNull String namingModule, @NotNull A_String name) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)namingModule, (String)"namingModule");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.methods = group.methods;
        this.macros = group.macros;
        this.semanticRestrictions = group.semanticRestrictions;
        this.grammaticalRestrictions = group.grammaticalRestrictions;
        this.aliases = group.aliases;
        this.global = group.global;
        this.classImplementation = group.classImplementation;
        this.namingModule = namingModule;
        this.categories = group.categories();
        this.filepath = fileName;
        this.isPrivate = false;
        this.hasStickyComment = false;
    }

    /*
     * WARNING - void declaration
     */
    public final void toJSON(@NotNull Path outputPath, @NotNull StacksSynchronizer synchronizer, @NotNull AvailRuntime runtime, @NotNull LinkingFileMap linkingFileMap, @NotNull String nameOfGroup, @NotNull StacksErrorLog errorLog) throws IOException {
        void $this$toTypedArray$iv;
        List list2;
        Collection $this$dropLastWhile$iv;
        Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
        Intrinsics.checkNotNullParameter((Object)synchronizer, (String)"synchronizer");
        Intrinsics.checkNotNullParameter((Object)runtime, (String)"runtime");
        Intrinsics.checkNotNullParameter((Object)linkingFileMap, (String)"linkingFileMap");
        Intrinsics.checkNotNullParameter((Object)nameOfGroup, (String)"nameOfGroup");
        Intrinsics.checkNotNullParameter((Object)errorLog, (String)"errorLog");
        JSONWriter jsonWriter = new JSONWriter(null, false, 3, null);
        jsonWriter.startObject();
        if (this.categories.size() > 1) {
            this.categories.remove("Unclassified");
        }
        if (!this.methods.isEmpty()) {
            jsonWriter.write("type");
            jsonWriter.write("method");
            jsonWriter.write("name");
            jsonWriter.write(nameOfGroup);
            if (!this.grammaticalRestrictions.isEmpty()) {
                int listSize = this.grammaticalRestrictions.size();
                List list3 = CollectionsKt.toList((Iterable)this.grammaticalRestrictions.values());
                if (listSize > 1) {
                    for (int i2 = 1; i2 < listSize; ++i2) {
                        ((GrammaticalRestrictionComment)list3.get(0)).mergeGrammaticalRestrictionImplementations((GrammaticalRestrictionComment)list3.get(i2));
                    }
                }
                ((GrammaticalRestrictionComment)list3.get(0)).toJSON(linkingFileMap, nameOfGroup, errorLog, jsonWriter);
            }
            jsonWriter.write("definitions");
            jsonWriter.startArray();
            for (MethodComment methodComment : this.methods.values()) {
                jsonWriter.startObject();
                methodComment.toJSON(linkingFileMap, nameOfGroup, errorLog, jsonWriter);
                jsonWriter.endObject();
            }
            jsonWriter.endArray();
            if (!this.semanticRestrictions.isEmpty()) {
                jsonWriter.write("semanticRestrictions");
                jsonWriter.startArray();
                for (SemanticRestrictionComment semanticRestrictionComment : this.semanticRestrictions.values()) {
                    jsonWriter.startObject();
                    semanticRestrictionComment.toJSON(linkingFileMap, nameOfGroup, errorLog, jsonWriter);
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
        } else if (!this.macros.isEmpty()) {
            jsonWriter.write("type");
            jsonWriter.write("macro");
            jsonWriter.write("name");
            jsonWriter.write(nameOfGroup);
            if (!this.grammaticalRestrictions.isEmpty()) {
                int listSize = this.grammaticalRestrictions.size();
                List list4 = CollectionsKt.toList((Iterable)this.grammaticalRestrictions.values());
                if (listSize > 1) {
                    for (int i2 = 1; i2 < listSize; ++i2) {
                        ((GrammaticalRestrictionComment)list4.get(0)).mergeGrammaticalRestrictionImplementations((GrammaticalRestrictionComment)list4.get(i2));
                    }
                }
                ((GrammaticalRestrictionComment)list4.get(0)).toJSON(linkingFileMap, nameOfGroup, errorLog, jsonWriter);
            }
            jsonWriter.write("definitions");
            jsonWriter.startArray();
            for (MacroComment macroComment : this.macros.values()) {
                jsonWriter.startObject();
                macroComment.toJSON(linkingFileMap, nameOfGroup, errorLog, jsonWriter);
                jsonWriter.endObject();
            }
            jsonWriter.endArray();
            if (!this.semanticRestrictions.isEmpty()) {
                jsonWriter.write("semanticRestrictions");
                jsonWriter.startArray();
                for (SemanticRestrictionComment semanticRestrictionComment : this.semanticRestrictions.values()) {
                    jsonWriter.startObject();
                    semanticRestrictionComment.toJSON(linkingFileMap, nameOfGroup, errorLog, jsonWriter);
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
        } else if (this.global != null) {
            GlobalComment globalComment = this.global;
            Intrinsics.checkNotNull((Object)globalComment);
            globalComment.toJSON(linkingFileMap, nameOfGroup, errorLog, jsonWriter);
        } else if (this.classImplementation != null) {
            jsonWriter.write("type");
            jsonWriter.write("class");
            jsonWriter.write("name");
            jsonWriter.write(nameOfGroup);
            ClassComment classComment = this.classImplementation;
            Intrinsics.checkNotNull((Object)classComment);
            classComment.toJSON(linkingFileMap, nameOfGroup, errorLog, jsonWriter);
        }
        Path fullFilePath = outputPath;
        StacksFilename stacksFilename = this.filepath;
        Intrinsics.checkNotNull((Object)stacksFilename);
        Object i2 = stacksFilename.getPathName();
        Regex regex = new Regex("/");
        int n = 0;
        i2 = regex.split((CharSequence)i2, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list2 = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list2;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        for (String directory : thisCollection$iv.toArray(new String[0])) {
            Intrinsics.checkNotNullExpressionValue((Object)fullFilePath.resolve(directory), (String)"fullFilePath.resolve(directory)");
        }
        StacksFilename stacksFilename2 = this.filepath;
        Intrinsics.checkNotNull((Object)stacksFilename2);
        StacksOutputFile jsonFile = new StacksOutputFile(fullFilePath, synchronizer, stacksFilename2.getLeafFilename(), runtime, A_String.Companion.asNativeString(this.name));
        jsonWriter.endObject();
        jsonFile.write(jsonWriter.toString());
        jsonWriter.close();
    }

    public final void mergeWith(@NotNull CommentGroup group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        this.classImplementation = group.classImplementation;
        this.global = group.global;
        this.methods.putAll(group.methods);
        this.macros.putAll(group.macros);
        this.semanticRestrictions.putAll(group.semanticRestrictions);
        this.grammaticalRestrictions.putAll(group.grammaticalRestrictions);
    }
}

