/*
 * Decompiled with CFR 0.152.
 */
package avail.stacks.module;

import avail.AvailRuntime;
import avail.builder.ModuleNameResolver;
import avail.builder.UnresolvedDependencyException;
import avail.compiler.ModuleHeader;
import avail.compiler.ModuleImport;
import avail.descriptor.maps.A_Map;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.A_Set;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.StringDescriptor;
import avail.stacks.CommentGroup;
import avail.stacks.LinkingFileMap;
import avail.stacks.StacksErrorLog;
import avail.stacks.StacksFilename;
import avail.stacks.StacksOutputFile;
import avail.stacks.StacksSynchronizer;
import avail.stacks.comment.AvailComment;
import avail.stacks.exceptions.StacksCommentBuilderException;
import avail.stacks.exceptions.StacksScannerException;
import avail.stacks.module.StacksExtendsModule;
import avail.stacks.module.StacksImportModule;
import avail.stacks.module.StacksUsesModule;
import avail.stacks.scanner.StacksScanner;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.availlang.json.JSONWriter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0002\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00000\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J,\u0010/\u001a\u00020,2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00000\u000bH\u0002J&\u00100\u001a\u0002012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\fJ2\u00107\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u001c0\u000b2\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u0016092\u0006\u0010:\u001a\u00020\f2\u0006\u0010;\u001a\u00020\fH\u0002J6\u00107\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u001c0\u000b2\u0018\u00108\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170=0<2\u0006\u0010;\u001a\u00020\fH\u0002J\b\u0010>\u001a\u00020,H\u0002JH\u0010?\u001a\u00020,2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\u001e\u0010@\u001a\u001a\u0012\u0004\u0012\u00020\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00170\u000b0\u000b2\u0006\u00106\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002JH\u0010A\u001a\u00020,2\u0006\u00102\u001a\u0002032\u0006\u0010B\u001a\u00020C2\u0006\u00104\u001a\u0002052\u001e\u0010@\u001a\u001a\u0012\u0004\u0012\u00020\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00170D0D2\u0006\u0010\r\u001a\u00020\u000eH\u0002J.\u0010E\u001a\u00020,2\u0006\u00102\u001a\u0002032\u0006\u0010B\u001a\u00020C2\u0006\u00104\u001a\u0002052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007R\u001d\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00120\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R)\u0010\u0015\u001a\u001a\u0012\u0004\u0012\u00020\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00170\u000b0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0014R\u000e\u0010\u0019\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R&\u0010\u001a\u001a\u001a\u0012\u0004\u0012\u00020\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00170\u000b0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u001c0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001d\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0014R\u001a\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010#\u001a\u001a\u0012\u0004\u0012\u00020\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00170\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010$\u001a\u001a\u0012\u0004\u0012\u00020\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00170\u000b0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0014R&\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020'0\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0014\"\u0004\b)\u0010*\u00a8\u0006F"}, d2={"Lavail/stacks/module/CommentsModule;", "", "header", "Lavail/compiler/ModuleHeader;", "commentTokens", "Lavail/descriptor/tuples/A_Tuple;", "errorLog", "Lavail/stacks/StacksErrorLog;", "resolver", "Lavail/builder/ModuleNameResolver;", "moduleToComments", "", "", "linkingFileMap", "Lavail/stacks/LinkingFileMap;", "linkPrefix", "(Lavail/compiler/ModuleHeader;Lavail/descriptor/tuples/A_Tuple;Lavail/stacks/StacksErrorLog;Lavail/builder/ModuleNameResolver;Ljava/util/Map;Lavail/stacks/LinkingFileMap;Ljava/lang/String;)V", "extendedNamesImplementations", "Lavail/stacks/module/StacksExtendsModule;", "getExtendedNamesImplementations", "()Ljava/util/Map;", "extendsMethodLeafNameToModuleName", "Lavail/descriptor/tuples/A_String;", "Lavail/stacks/CommentGroup;", "getExtendsMethodLeafNameToModuleName", "fileExtensionName", "finalImplementationsGroupMap", "inScopeMethodsToFileNames", "Lavail/stacks/StacksFilename;", "moduleName", "getModuleName", "()Ljava/lang/String;", "namedPublicCommentImplementations", "getNamedPublicCommentImplementations", "privateCommentImplementations", "stickyNamesImplementations", "usesMethodLeafNameToModuleName", "getUsesMethodLeafNameToModuleName", "usesNamesImplementations", "Lavail/stacks/module/StacksUsesModule;", "getUsesNamesImplementations", "setUsesNamesImplementations", "(Ljava/util/Map;)V", "addImplementation", "", "comment", "Lavail/stacks/comment/AvailComment;", "buildModuleImportMaps", "calculateFinalImplementationGroupsMap", "", "outputPath", "Ljava/nio/file/Path;", "runtime", "Lavail/AvailRuntime;", "topLevelLinkFolderPath", "createFileNames", "names", "", "originatingModuleName", "fileExtension", "", "Lkotlin/Pair;", "populateExtendsFromUsesExtends", "writeAmbiguousAliasJSONFiles", "ambiguousMethodFileMap", "writeAmbiguousMethodsJSONFiles", "synchronizer", "Lavail/stacks/StacksSynchronizer;", "", "writeMethodsToJSONFiles", "avail"})
public final class CommentsModule {
    @NotNull
    private final String linkPrefix;
    @NotNull
    private final Map<String, StacksExtendsModule> extendedNamesImplementations;
    @NotNull
    private final String fileExtensionName;
    @NotNull
    private final Map<A_String, Map<String, CommentGroup>> stickyNamesImplementations;
    @NotNull
    private Map<String, StacksUsesModule> usesNamesImplementations;
    @NotNull
    private final String moduleName;
    @NotNull
    private final Map<A_String, CommentGroup> namedPublicCommentImplementations;
    @NotNull
    private final Map<A_String, StacksFilename> inScopeMethodsToFileNames;
    @NotNull
    private Map<A_String, Map<String, CommentGroup>> finalImplementationsGroupMap;
    @NotNull
    private final Map<A_String, Map<String, CommentGroup>> extendsMethodLeafNameToModuleName;
    @NotNull
    private final Map<A_String, Map<String, CommentGroup>> usesMethodLeafNameToModuleName;
    @NotNull
    private final Map<A_String, CommentGroup> privateCommentImplementations;

    public CommentsModule(@NotNull ModuleHeader header, @NotNull A_Tuple commentTokens, @NotNull StacksErrorLog errorLog, @NotNull ModuleNameResolver resolver, @NotNull Map<String, CommentsModule> moduleToComments, @NotNull LinkingFileMap linkingFileMap, @NotNull String linkPrefix) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        Intrinsics.checkNotNullParameter((Object)commentTokens, (String)"commentTokens");
        Intrinsics.checkNotNullParameter((Object)errorLog, (String)"errorLog");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Intrinsics.checkNotNullParameter(moduleToComments, (String)"moduleToComments");
        Intrinsics.checkNotNullParameter((Object)linkingFileMap, (String)"linkingFileMap");
        Intrinsics.checkNotNullParameter((Object)linkPrefix, (String)"linkPrefix");
        this.linkPrefix = linkPrefix;
        this.extendedNamesImplementations = new LinkedHashMap();
        this.fileExtensionName = "json";
        this.stickyNamesImplementations = new LinkedHashMap();
        this.usesNamesImplementations = new LinkedHashMap();
        this.moduleName = header.getModuleName().getQualifiedName();
        this.namedPublicCommentImplementations = new LinkedHashMap();
        this.finalImplementationsGroupMap = new LinkedHashMap();
        this.extendsMethodLeafNameToModuleName = new LinkedHashMap();
        this.usesMethodLeafNameToModuleName = new LinkedHashMap();
        this.privateCommentImplementations = new LinkedHashMap();
        this.inScopeMethodsToFileNames = this.createFileNames((Collection<? extends A_String>)header.getExportedNames(), this.moduleName, this.fileExtensionName);
        for (CommentsModule comment : moduleToComments.values()) {
            for (Map.Entry<A_String, Map<String, CommentGroup>> entry : comment.stickyNamesImplementations.entrySet()) {
                A_String key = entry.getKey();
                Map<String, CommentGroup> value = entry.getValue();
                Map<String, CommentGroup> localEntry = this.stickyNamesImplementations.get(key);
                if (localEntry != null) {
                    localEntry.putAll(value);
                    this.stickyNamesImplementations.put(key, localEntry);
                    continue;
                }
                this.stickyNamesImplementations.put(key, value);
            }
        }
        for (A_String implementationName : header.getExportedNames()) {
            StacksFilename stacksFilename = this.inScopeMethodsToFileNames.get(implementationName);
            Intrinsics.checkNotNull((Object)stacksFilename);
            CommentGroup group = new CommentGroup(implementationName, this.moduleName, stacksFilename, false);
            this.namedPublicCommentImplementations.put(implementationName, group);
            Map moduleNameToImplementation = new LinkedHashMap();
            moduleNameToImplementation.put(this.moduleName, group);
            this.extendsMethodLeafNameToModuleName.put(implementationName, moduleNameToImplementation);
        }
        this.buildModuleImportMaps(header, resolver, moduleToComments);
        this.populateExtendsFromUsesExtends();
        StringBuilder errorMessages = new StringBuilder();
        int errorCount = 0;
        for (AvailObject aToken : commentTokens) {
            try {
                AvailComment implementation = StacksScanner.Companion.processCommentString(aToken, this.moduleName, linkingFileMap);
                if (implementation == null) continue;
                this.addImplementation(implementation);
            }
            catch (StacksScannerException e) {
                errorMessages.append(e.getMessage());
                ++errorCount;
            }
            catch (StacksCommentBuilderException e) {
                errorMessages.append(e.getMessage());
                ++errorCount;
            }
        }
        if (errorCount > 0) {
            StringBuilder newLogEntry = new StringBuilder().append("<h3>").append(header.getModuleName().getQualifiedName()).append(" <em>(").append(errorCount).append(")</em></h3>\n<ol>");
            errorMessages.append("</ol>\n");
            newLogEntry.append((CharSequence)errorMessages);
            String string2 = newLogEntry.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"newLogEntry.toString()");
            String string3 = string2;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            byte[] byArray = string3.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            ByteBuffer errorBuffer = ByteBuffer.wrap(byArray);
            Intrinsics.checkNotNullExpressionValue((Object)errorBuffer, (String)"errorBuffer");
            errorLog.addLogEntry(errorBuffer, errorCount);
        }
    }

    @NotNull
    public final Map<String, StacksExtendsModule> getExtendedNamesImplementations() {
        return this.extendedNamesImplementations;
    }

    @NotNull
    public final Map<String, StacksUsesModule> getUsesNamesImplementations() {
        return this.usesNamesImplementations;
    }

    public final void setUsesNamesImplementations(@NotNull Map<String, StacksUsesModule> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.usesNamesImplementations = map;
    }

    @NotNull
    public final String getModuleName() {
        return this.moduleName;
    }

    @NotNull
    public final Map<A_String, CommentGroup> getNamedPublicCommentImplementations() {
        return this.namedPublicCommentImplementations;
    }

    @NotNull
    public final Map<A_String, Map<String, CommentGroup>> getExtendsMethodLeafNameToModuleName() {
        return this.extendsMethodLeafNameToModuleName;
    }

    @NotNull
    public final Map<A_String, Map<String, CommentGroup>> getUsesMethodLeafNameToModuleName() {
        return this.usesMethodLeafNameToModuleName;
    }

    /*
     * WARNING - void declaration
     */
    private final void addImplementation(AvailComment comment) {
        StacksFilename filename;
        A_String nameToCheck = StringDescriptor.Companion.stringFrom(comment.getSignature$avail().getName());
        if (this.extendsMethodLeafNameToModuleName.containsKey(nameToCheck)) {
            if (this.namedPublicCommentImplementations.containsKey(nameToCheck)) {
                CommentGroup commentGroup = this.namedPublicCommentImplementations.get(nameToCheck);
                Intrinsics.checkNotNull((Object)commentGroup);
                comment.addToImplementationGroup(commentGroup);
            }
            Map<String, CommentGroup> map = this.extendsMethodLeafNameToModuleName.get(nameToCheck);
            Intrinsics.checkNotNull(map);
            for (CommentGroup group : map.values()) {
                comment.addToImplementationGroup(group);
            }
        } else if (this.usesMethodLeafNameToModuleName.containsKey(nameToCheck)) {
            Map<String, CommentGroup> map = this.usesMethodLeafNameToModuleName.get(nameToCheck);
            Intrinsics.checkNotNull(map);
            for (CommentGroup group : map.values()) {
                comment.addToImplementationGroup(group);
            }
        } else {
            if (!this.privateCommentImplementations.containsKey(nameToCheck)) {
                long hashedName = nameToCheck.hash();
                filename = new StacksFilename(this.moduleName, (hashedName &= 0xFFFFFFFFL) + "." + this.fileExtensionName);
                CommentGroup privateGroup = new CommentGroup(nameToCheck, this.moduleName, filename, true);
                this.privateCommentImplementations.put(nameToCheck, privateGroup);
            }
            CommentGroup commentGroup = this.privateCommentImplementations.get(nameToCheck);
            Intrinsics.checkNotNull((Object)commentGroup);
            comment.addToImplementationGroup(commentGroup);
        }
        if (comment.isSticky()) {
            Object object;
            void $this$getOrPut$iv;
            long hashedName = nameToCheck.hash();
            filename = new StacksFilename(this.moduleName, (hashedName &= 0xFFFFFFFFL) + "." + this.fileExtensionName);
            CommentGroup stickyGroup = new CommentGroup(nameToCheck, this.moduleName, filename, true);
            comment.addToImplementationGroup(stickyGroup);
            stickyGroup.hasStickyComment(true);
            Map map = this.stickyNamesImplementations;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(nameToCheck);
            if (value$iv == null) {
                boolean bl = false;
                Map answer$iv = new LinkedHashMap();
                $this$getOrPut$iv.put(nameToCheck, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            map = (Map)object;
            String string2 = comment.getSignature$avail().getModule();
            map.put(string2, stickyGroup);
        }
    }

    private final void buildModuleImportMaps(ModuleHeader header, ModuleNameResolver resolver, Map<String, CommentsModule> moduleToComments) {
        Map usesMap = new LinkedHashMap();
        for (ModuleImport moduleImport : header.getImportedModules()) {
            try {
                Map<String, CommentGroup> cGroupMap;
                Object rename3;
                CommentGroup commentGroup;
                A_String name;
                List visibleValues;
                Object removeSet;
                Iterator<Object> rename2;
                Map<A_String, StacksFilename> renameFileNames;
                List renameValues;
                A_Set removeRenames;
                String moduleImportName = resolver.resolve(header.getModuleName().asSibling(A_String.Companion.asNativeString(moduleImport.getModuleName())), header.getModuleName()).getQualifiedName();
                if (moduleImport.isExtension()) {
                    Object rename222;
                    A_Set collectedExtendedNames = SetDescriptor.Companion.getEmptySet();
                    if (moduleImport.getWildcard()) {
                        Object object;
                        Map<A_String, CommentGroup> map;
                        CommentsModule commentsModule = moduleToComments.get(moduleImportName);
                        Intrinsics.checkNotNull((Object)commentsModule);
                        collectedExtendedNames = A_Set.Companion.setUnionCanDestroy(collectedExtendedNames, SetDescriptor.Companion.setFromCollection((Collection<? extends A_BasicObject>)commentsModule.extendsMethodLeafNameToModuleName.keySet()), true);
                        CommentsModule commentsModule2 = moduleToComments.get(moduleImportName);
                        collectedExtendedNames = A_Set.Companion.setUnionCanDestroy(collectedExtendedNames, SetDescriptor.Companion.setFromCollection(commentsModule2 != null && (map = commentsModule2.namedPublicCommentImplementations) != null && (object = map.keySet()) != null ? (Collection)object : (Collection)SetsKt.emptySet()), true);
                    }
                    if (!moduleImport.getExcludes().equals(SetDescriptor.Companion.getEmptySet())) {
                        collectedExtendedNames = A_Set.Companion.setMinusCanDestroy(collectedExtendedNames, moduleImport.getExcludes(), true);
                    }
                    removeRenames = A_Tuple.Companion.getAsSet(A_Map.Companion.getValuesAsTuple(moduleImport.getRenames()));
                    collectedExtendedNames = A_Set.Companion.setMinusCanDestroy(collectedExtendedNames, removeRenames, true);
                    collectedExtendedNames = A_Set.Companion.setUnionCanDestroy(collectedExtendedNames, moduleImport.getNames(), true);
                    CommentsModule commentsModule = moduleToComments.get(moduleImportName);
                    Intrinsics.checkNotNull((Object)commentsModule);
                    StacksExtendsModule stacksExtends = new StacksExtendsModule(commentsModule);
                    renameValues = new ArrayList();
                    for (Object rename222 : A_Map.Companion.getKeysAsSet(moduleImport.getRenames())) {
                        renameValues.add(rename222);
                    }
                    renameFileNames = this.createFileNames(renameValues, this.moduleName, this.fileExtensionName);
                    this.inScopeMethodsToFileNames.putAll(renameFileNames);
                    rename222 = A_Map.Companion.getKeysAsSet(moduleImport.getRenames()).iterator();
                    while (rename222.hasNext()) {
                        rename2 = (AvailObject)rename222.next();
                        A_String a_String = A_Map.Companion.mapAt(moduleImport.getRenames(), (A_BasicObject)((Object)rename2));
                        A_String a_String2 = (A_String)((Object)rename2);
                        StacksFilename stacksFilename = renameFileNames.get(rename2);
                        Intrinsics.checkNotNull((Object)stacksFilename);
                        stacksExtends.renameImplementation(a_String, a_String2, this, stacksFilename, !A_Set.Companion.hasElement(collectedExtendedNames, A_Map.Companion.mapAt(moduleImport.getRenames(), (A_BasicObject)((Object)rename2))));
                    }
                    removeSet = SetDescriptor.Companion.setFromCollection((Collection<? extends A_BasicObject>)stacksExtends.getExtendsMethodLeafNameToModuleName().keySet());
                    removeSet = A_Set.Companion.setMinusCanDestroy((A_Set)removeSet, collectedExtendedNames, true);
                    rename2 = removeSet.iterator();
                    while (rename2.hasNext()) {
                        AvailObject availObject = rename2.next();
                        stacksExtends.getExtendsMethodLeafNameToModuleName().remove(availObject);
                    }
                    this.extendedNamesImplementations.put(moduleImportName, stacksExtends);
                    for (A_String a_String : stacksExtends.getExtendsMethodLeafNameToModuleName().keySet()) {
                        Map.Entry<A_String, Map<String, CommentGroup>> addOn2 = stacksExtends.getExtendsMethodLeafNameToModuleName();
                        if (this.extendsMethodLeafNameToModuleName.containsKey(a_String)) {
                            Map<String, CommentGroup> modToImplement;
                            Map<String, CommentGroup> map = modToImplement = addOn2.get(a_String);
                            Intrinsics.checkNotNull(map);
                            for (Map.Entry<String, CommentGroup> entry : map.entrySet()) {
                                String key1 = entry.getKey();
                                CommentGroup value = entry.getValue();
                                Map<String, CommentGroup> map2 = this.extendsMethodLeafNameToModuleName.get(a_String);
                                if (map2 == null) continue;
                                map2.put(key1, value);
                            }
                            continue;
                        }
                        Map<String, CommentGroup> map = addOn2.get(a_String);
                        Intrinsics.checkNotNull(map);
                        this.extendsMethodLeafNameToModuleName.put(a_String, map);
                    }
                    visibleValues = new ArrayList();
                    for (Map.Entry<A_String, Map<String, CommentGroup>> addOn2 : this.usesMethodLeafNameToModuleName.entrySet()) {
                        name = (A_String)addOn2.getKey();
                        Map value = (Map)addOn2.getValue();
                        Iterator iterator2 = value.entrySet().iterator();
                        while (iterator2.hasNext()) {
                            commentGroup = (CommentGroup)iterator2.next().getValue();
                            visibleValues.add(TuplesKt.to((Object)name, (Object)commentGroup));
                        }
                    }
                    for (Map.Entry<A_String, Map<String, CommentGroup>> addOn2 : this.extendsMethodLeafNameToModuleName.entrySet()) {
                        name = addOn2.getKey();
                        Map<String, CommentGroup> groupMap = addOn2.getValue();
                        Iterator iterator3 = groupMap.entrySet().iterator();
                        while (iterator3.hasNext()) {
                            commentGroup = (CommentGroup)iterator3.next().getValue();
                            visibleValues.add(TuplesKt.to((Object)name, (Object)commentGroup));
                        }
                    }
                    Map<A_String, StacksFilename> map = this.createFileNames(visibleValues, this.fileExtensionName);
                    this.inScopeMethodsToFileNames.putAll(map);
                    continue;
                }
                A_Set collectedUsesNames = SetDescriptor.Companion.getEmptySet();
                if (moduleImport.getWildcard()) {
                    CommentsModule commentsModule = moduleToComments.get(moduleImportName);
                    Intrinsics.checkNotNull((Object)commentsModule);
                    collectedUsesNames = A_Set.Companion.setUnionCanDestroy(collectedUsesNames, SetDescriptor.Companion.setFromCollection((Collection<? extends A_BasicObject>)commentsModule.extendsMethodLeafNameToModuleName.keySet()), true);
                    CommentsModule commentsModule2 = moduleToComments.get(moduleImportName);
                    Intrinsics.checkNotNull((Object)commentsModule2);
                    collectedUsesNames = A_Set.Companion.setUnionCanDestroy(collectedUsesNames, SetDescriptor.Companion.setFromCollection((Collection<? extends A_BasicObject>)commentsModule2.namedPublicCommentImplementations.keySet()), true);
                }
                if (!moduleImport.getExcludes().equals(SetDescriptor.Companion.getEmptySet())) {
                    collectedUsesNames = A_Set.Companion.setMinusCanDestroy(collectedUsesNames, moduleImport.getExcludes(), true);
                }
                removeRenames = A_Tuple.Companion.getAsSet(A_Map.Companion.getValuesAsTuple(moduleImport.getRenames()));
                collectedUsesNames = A_Set.Companion.setMinusCanDestroy(collectedUsesNames, removeRenames, true);
                collectedUsesNames = A_Set.Companion.setUnionCanDestroy(collectedUsesNames, moduleImport.getNames(), true);
                CommentsModule commentsModule = moduleToComments.get(moduleImportName);
                Intrinsics.checkNotNull((Object)commentsModule);
                StacksUsesModule stacksUses = new StacksUsesModule(commentsModule, moduleImport.getRenames());
                renameValues = new ArrayList();
                for (Object rename3 : A_Map.Companion.getKeysAsSet(moduleImport.getRenames())) {
                    renameValues.add(rename3);
                }
                renameFileNames = this.createFileNames(renameValues, this.moduleName, ".json");
                rename3 = A_Map.Companion.getKeysAsSet(moduleImport.getRenames()).iterator();
                while (rename3.hasNext()) {
                    rename2 = (AvailObject)rename3.next();
                    A_String a_String = A_Map.Companion.mapAt(moduleImport.getRenames(), (A_BasicObject)((Object)rename2));
                    A_String a_String3 = (A_String)((Object)rename2);
                    StacksFilename stacksFilename = renameFileNames.get(rename2);
                    Intrinsics.checkNotNull((Object)stacksFilename);
                    stacksUses.renameImplementation(a_String, a_String3, this, stacksFilename, !A_Set.Companion.hasElement(collectedUsesNames, A_Map.Companion.mapAt(moduleImport.getRenames(), (A_BasicObject)((Object)rename2))));
                }
                removeSet = SetDescriptor.Companion.setFromCollection((Collection<? extends A_BasicObject>)stacksUses.getExtendsMethodLeafNameToModuleName().keySet());
                removeSet = A_Set.Companion.setMinusCanDestroy((A_Set)removeSet, collectedUsesNames, true);
                rename2 = removeSet.iterator();
                while (rename2.hasNext()) {
                    AvailObject availObject = rename2.next();
                    stacksUses.getExtendsMethodLeafNameToModuleName().remove(availObject);
                }
                usesMap.put(moduleImportName, stacksUses);
                for (Map.Entry entry : stacksUses.getExtendsMethodLeafNameToModuleName().entrySet()) {
                    Map.Entry<A_String, Map<String, CommentGroup>> key3 = (A_String)entry.getKey();
                    Map value = (Map)entry.getValue();
                    if (this.usesMethodLeafNameToModuleName.containsKey(key3)) {
                        for (Map.Entry entry2 : value.entrySet()) {
                            String mod = (String)entry2.getKey();
                            CommentGroup cGroup = (CommentGroup)entry2.getValue();
                            value.put(mod, cGroup);
                        }
                        continue;
                    }
                    this.usesMethodLeafNameToModuleName.put((A_String)((Object)key3), value);
                }
                visibleValues = new ArrayList();
                for (Map.Entry<A_String, Map<String, CommentGroup>> key3 : this.usesMethodLeafNameToModuleName.entrySet()) {
                    name = (A_String)key3.getKey();
                    cGroupMap = (Map<String, CommentGroup>)key3.getValue();
                    Iterator iterator4 = cGroupMap.entrySet().iterator();
                    while (iterator4.hasNext()) {
                        commentGroup = (CommentGroup)iterator4.next().getValue();
                        visibleValues.add(TuplesKt.to((Object)name, (Object)commentGroup));
                    }
                }
                for (Map.Entry<A_String, Map<String, CommentGroup>> key3 : this.extendsMethodLeafNameToModuleName.entrySet()) {
                    name = key3.getKey();
                    cGroupMap = key3.getValue();
                    Iterator<Map.Entry<String, CommentGroup>> iterator5 = cGroupMap.entrySet().iterator();
                    while (iterator5.hasNext()) {
                        commentGroup = iterator5.next().getValue();
                        visibleValues.add(TuplesKt.to((Object)name, (Object)commentGroup));
                    }
                }
                Map<A_String, StacksFilename> map = this.createFileNames(visibleValues, "json");
                this.inScopeMethodsToFileNames.putAll(map);
            }
            catch (UnresolvedDependencyException e) {
                e.printStackTrace();
            }
        }
        this.usesNamesImplementations = usesMap;
        Map namesExtendsImplementationsMap = new LinkedHashMap();
        for (StacksUsesModule module : this.usesNamesImplementations.values()) {
            for (StacksUsesModule usesModule : module.getModuleNameToUsesList().values()) {
                for (A_String nameToCheck : usesModule.getCommentGroups().keySet()) {
                    Map<String, CommentGroup> moduleToImplementation;
                    if (!usesModule.getExtendsMethodLeafNameToModuleName().containsKey(nameToCheck)) continue;
                    Intrinsics.checkNotNull(usesModule.getExtendsMethodLeafNameToModuleName().get(nameToCheck));
                    for (String usesModName : moduleToImplementation.keySet()) {
                        CommentGroup commentGroup = moduleToImplementation.get(usesModName);
                        Intrinsics.checkNotNull((Object)commentGroup);
                        if (!commentGroup.isPopulated()) continue;
                        for (StacksExtendsModule extendsModule : this.extendedNamesImplementations.values()) {
                            Map<String, CommentGroup> extendsLeaf;
                            Map<A_String, Map<String, CommentGroup>> extendsLeaves;
                            namesExtendsImplementationsMap.putAll((Map)extendsModule.flattenImplementationGroups().getFirst());
                            if (!extendsModule.getExtendsMethodLeafNameToModuleName().containsKey(nameToCheck) || !(extendsLeaves = extendsModule.getExtendsMethodLeafNameToModuleName()).containsKey(nameToCheck)) continue;
                            Map<String, CommentGroup> map = extendsLeaf = extendsLeaves.get(nameToCheck);
                            Intrinsics.checkNotNull(map);
                            if (!map.containsKey(usesModName)) continue;
                            CommentGroup commentGroup2 = extendsLeaf.get(usesModName);
                            Intrinsics.checkNotNull((Object)commentGroup2);
                            CommentGroup commentGroup3 = moduleToImplementation.get(usesModName);
                            Intrinsics.checkNotNull((Object)commentGroup3);
                            commentGroup2.mergeWith(commentGroup3);
                        }
                    }
                }
                Map namesUsesExtendsImplementationsMap = new LinkedHashMap();
                for (StacksExtendsModule usesExtendsModule : usesModule.getModuleNameToExtendsList().values()) {
                    Map first = (Map)usesExtendsModule.flattenImplementationGroups().getFirst();
                    for (String string2 : first.keySet()) {
                        Object v = first.get(string2);
                        Intrinsics.checkNotNull(v);
                        if (!((CommentGroup)((Pair)v).getSecond()).isPopulated()) continue;
                        Object v2 = first.get(string2);
                        Intrinsics.checkNotNull(v2);
                        namesUsesExtendsImplementationsMap.put(string2, v2);
                    }
                }
                for (String key : namesUsesExtendsImplementationsMap.keySet()) {
                    if (!namesExtendsImplementationsMap.containsKey(key)) continue;
                    Object v = namesExtendsImplementationsMap.get(key);
                    Intrinsics.checkNotNull(v);
                    CommentGroup commentGroup = (CommentGroup)((Pair)v).getSecond();
                    Object v3 = namesUsesExtendsImplementationsMap.get(key);
                    Intrinsics.checkNotNull(v3);
                    commentGroup.mergeWith((CommentGroup)((Pair)v3).getSecond());
                }
            }
        }
    }

    private final void populateExtendsFromUsesExtends() {
        Set<String> extendedModuleNames = this.extendedNamesImplementations.keySet();
        for (String extendsModuleName : extendedModuleNames) {
            Map<String, StacksUsesModule> usesModules;
            for (StacksUsesModule uses2 : this.usesNamesImplementations.values()) {
                usesModules = uses2.getModuleNameToUsesList();
                if (!usesModules.containsKey(extendsModuleName)) continue;
                Object object = usesModules.get(extendsModuleName);
                if (object == null || (object = ((StacksImportModule)object).getCommentGroups()) == null) continue;
                Object it = object;
                boolean bl = false;
                for (A_String methodName : it.keySet()) {
                    CommentGroup commentGroup;
                    StacksExtendsModule stacksExtendsModule = this.extendedNamesImplementations.get(extendsModuleName);
                    if (stacksExtendsModule == null) continue;
                    StacksExtendsModule sem = stacksExtendsModule;
                    boolean bl2 = false;
                    if (!sem.getCommentGroups().containsKey(methodName) || (commentGroup = sem.getCommentGroups().get(methodName)) == null) continue;
                    Object v = it.get(methodName);
                    Intrinsics.checkNotNull(v);
                    commentGroup.mergeWith((CommentGroup)v);
                }
            }
            for (String otherExtendsModuleName : extendedModuleNames) {
                Map<A_String, CommentGroup> nameToImplementations;
                if (Intrinsics.areEqual((Object)otherExtendsModuleName, (Object)extendsModuleName)) continue;
                StacksExtendsModule stacksExtendsModule = this.extendedNamesImplementations.get(otherExtendsModuleName);
                Map<String, StacksUsesModule> map = stacksExtendsModule != null ? stacksExtendsModule.getModuleNameToUsesList() : null;
                Intrinsics.checkNotNull(map);
                usesModules = map;
                if (!usesModules.containsKey(otherExtendsModuleName)) continue;
                StacksUsesModule stacksUsesModule = usesModules.get(otherExtendsModuleName);
                Intrinsics.checkNotNull(stacksUsesModule != null ? stacksUsesModule.getCommentGroups() : null);
                nameToImplementations = nameToImplementations;
                for (A_String methodName : nameToImplementations.keySet()) {
                    StacksExtendsModule stacksExtendsModule2 = this.extendedNamesImplementations.get(extendsModuleName);
                    Intrinsics.checkNotNull((Object)stacksExtendsModule2);
                    CommentGroup commentGroup = stacksExtendsModule2.getCommentGroups().get(methodName);
                    Intrinsics.checkNotNull((Object)commentGroup);
                    CommentGroup commentGroup2 = nameToImplementations.get(methodName);
                    Intrinsics.checkNotNull((Object)commentGroup2);
                    commentGroup.mergeWith(commentGroup2);
                }
            }
        }
    }

    private final Map<A_String, StacksFilename> createFileNames(List<? extends Pair<? extends A_String, CommentGroup>> names, String fileExtension) {
        Map newHashNameMap = new LinkedHashMap();
        Map namesToFileNames = new LinkedHashMap();
        for (Pair<? extends A_String, CommentGroup> pair : names) {
            A_String nameToBeHashed = (A_String)pair.getFirst();
            if (newHashNameMap.containsKey(pair.getFirst())) {
                Object object = pair.getFirst();
                Object v = newHashNameMap.get(pair.getFirst());
                Intrinsics.checkNotNull(v);
                newHashNameMap.put(object, ((Number)v).intValue() + 1);
                nameToBeHashed = StringDescriptor.Companion.stringFrom(A_String.Companion.asNativeString((A_String)pair.getFirst()) + newHashNameMap.get(pair.getFirst()));
            } else {
                newHashNameMap.put(nameToBeHashed, 0);
            }
            long hashedName = nameToBeHashed.hash();
            String fileName = (hashedName &= 0xFFFFFFFFL) + "." + fileExtension;
            namesToFileNames.put(pair.getFirst(), new StacksFilename(((CommentGroup)pair.getSecond()).getNamingModule(), fileName));
        }
        return namesToFileNames;
    }

    private final Map<A_String, StacksFilename> createFileNames(Collection<? extends A_String> names, String originatingModuleName, String fileExtension) {
        Map newHashNameMap = new LinkedHashMap();
        Map namesToFileNames = new LinkedHashMap();
        Iterator<? extends A_String> iterator2 = names.iterator();
        while (iterator2.hasNext()) {
            A_String key;
            A_String nameToBeHashed = key = iterator2.next();
            if (newHashNameMap.containsKey(key)) {
                Object v = newHashNameMap.get(key);
                Intrinsics.checkNotNull(v);
                newHashNameMap.put(key, ((Number)v).intValue() + 1);
                nameToBeHashed = StringDescriptor.Companion.stringFrom(A_String.Companion.asNativeString(key) + newHashNameMap.get(key));
            } else {
                newHashNameMap.put(nameToBeHashed, 0);
            }
            long hashedName = nameToBeHashed.hash();
            String fileName = (hashedName &= 0xFFFFFFFFL) + "." + fileExtension;
            namesToFileNames.put(key, new StacksFilename(originatingModuleName, fileName));
        }
        return namesToFileNames;
    }

    public final int calculateFinalImplementationGroupsMap(@NotNull LinkingFileMap linkingFileMap, @NotNull Path outputPath, @NotNull AvailRuntime runtime, @NotNull String topLevelLinkFolderPath) throws IOException {
        CommentGroup implementation;
        Map<String, CommentGroup> value;
        A_String key;
        Intrinsics.checkNotNullParameter((Object)linkingFileMap, (String)"linkingFileMap");
        Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
        Intrinsics.checkNotNullParameter((Object)runtime, (String)"runtime");
        Intrinsics.checkNotNullParameter((Object)topLevelLinkFolderPath, (String)"topLevelLinkFolderPath");
        Map filteredMap = new LinkedHashMap();
        Map notPopulated = new LinkedHashMap();
        int fileCount = 0;
        Map ambiguousMethodFileMap = new LinkedHashMap();
        for (Map.Entry<A_String, Map<String, CommentGroup>> entry : this.extendsMethodLeafNameToModuleName.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            Map<String, CommentGroup> stickyMap = this.stickyNamesImplementations.get(key);
            if (stickyMap != null) {
                value.putAll(stickyMap);
            }
            if (value.size() > 1) {
                ambiguousMethodFileMap.put(key, value);
            }
            for (String string2 : value.keySet()) {
                CommentGroup commentGroup = implementation = value.get(string2);
                boolean bl = commentGroup != null ? commentGroup.isPopulated() : false;
                if (bl) {
                    Unit unit;
                    if ((Map)filteredMap.get(key) != null) {
                        Map it;
                        boolean bl2 = false;
                        it.put(string2, implementation);
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    if (unit == null) {
                        CommentsModule $this$calculateFinalImplementationGroupsMap_u24lambda_u244 = this;
                        boolean bl3 = false;
                        Map modToImplement = new LinkedHashMap();
                        modToImplement.put(string2, implementation);
                        filteredMap.put(key, modToImplement);
                    }
                    for (String category : implementation.categories()) {
                        String string3 = A_String.Companion.asNativeString(key);
                        StacksFilename stacksFilename = implementation.getFilepath();
                        Intrinsics.checkNotNull((Object)stacksFilename);
                        linkingFileMap.addCategoryMethodPair(category, string3, stacksFilename.relativeFilePath());
                    }
                    if (value.size() == 1) {
                        String string4 = A_String.Companion.asNativeString(key);
                        StacksFilename stacksFilename = implementation.getFilepath();
                        Intrinsics.checkNotNull((Object)stacksFilename);
                        linkingFileMap.addNamedFileLinks(string4, this.linkPrefix + stacksFilename.relativeFilePath());
                    }
                    ++fileCount;
                    continue;
                }
                String string5 = string2 + "/" + A_String.Companion.asNativeString(key);
                CommentGroup commentGroup2 = value.get(string2);
                Intrinsics.checkNotNull((Object)commentGroup2);
                notPopulated.put(string5, commentGroup2);
            }
        }
        for (Map.Entry<A_String, Map<String, CommentGroup>> entry : this.stickyNamesImplementations.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            Map<String, CommentGroup> exportMap = this.extendsMethodLeafNameToModuleName.get(key);
            if (exportMap != null) continue;
            if (value.size() > 1) {
                ambiguousMethodFileMap.put(key, value);
            }
            for (Map.Entry entry2 : value.entrySet()) {
                implementation = (CommentGroup)entry2.getValue();
                if (filteredMap.containsKey(key)) {
                    Unit unit;
                    if ((Map)filteredMap.get(key) != null) {
                        Map it;
                        boolean bl = false;
                        it.put(entry2.getKey(), implementation);
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    if (unit == null) {
                        CommentsModule $this$calculateFinalImplementationGroupsMap_u24lambda_u246 = this;
                        boolean bl = false;
                        Map modToImplement = new LinkedHashMap();
                        modToImplement.put(entry2.getKey(), implementation);
                        filteredMap.put(key, modToImplement);
                    }
                }
                for (String category : implementation.categories()) {
                    String string6 = A_String.Companion.asNativeString(key);
                    StacksFilename stacksFilename = implementation.getFilepath();
                    Intrinsics.checkNotNull((Object)stacksFilename);
                    linkingFileMap.addCategoryMethodPair(category, string6, stacksFilename.relativeFilePath());
                }
                if (value.size() == 1) {
                    String string7 = A_String.Companion.asNativeString(key);
                    StacksFilename stacksFilename = implementation.getFilepath();
                    Intrinsics.checkNotNull((Object)stacksFilename);
                    linkingFileMap.addNamedFileLinks(string7, this.linkPrefix + stacksFilename.relativeFilePath());
                }
                ++fileCount;
            }
        }
        this.finalImplementationsGroupMap = filteredMap;
        int ambiguousFileCount = ambiguousMethodFileMap.size();
        if (ambiguousFileCount > 0) {
            StacksSynchronizer synchronizer = new StacksSynchronizer(ambiguousFileCount);
            this.writeAmbiguousMethodsJSONFiles(outputPath, synchronizer, runtime, ambiguousMethodFileMap, linkingFileMap);
            synchronizer.waitForWorkUnitsToComplete();
        }
        this.writeAmbiguousAliasJSONFiles(outputPath, runtime, ambiguousMethodFileMap, topLevelLinkFolderPath, linkingFileMap);
        return fileCount;
    }

    public final void writeMethodsToJSONFiles(@NotNull Path outputPath, @NotNull StacksSynchronizer synchronizer, @NotNull AvailRuntime runtime, @NotNull LinkingFileMap linkingFileMap, @NotNull StacksErrorLog errorLog) throws IOException {
        Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
        Intrinsics.checkNotNullParameter((Object)synchronizer, (String)"synchronizer");
        Intrinsics.checkNotNullParameter((Object)runtime, (String)"runtime");
        Intrinsics.checkNotNullParameter((Object)linkingFileMap, (String)"linkingFileMap");
        Intrinsics.checkNotNullParameter((Object)errorLog, (String)"errorLog");
        String newLogEntry = "<h3>Internal Link Errors</h3>\n<ol>\n";
        String string2 = newLogEntry;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        ByteBuffer errorBuffer = ByteBuffer.wrap(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)errorBuffer, (String)"errorBuffer");
        errorLog.addLogEntry(errorBuffer, 0);
        for (A_String implementationName : this.finalImplementationsGroupMap.keySet()) {
            Map<String, CommentGroup> tempImplementationMap;
            Map<String, CommentGroup> map = tempImplementationMap = this.finalImplementationsGroupMap.get(implementationName);
            Intrinsics.checkNotNull(map);
            for (String modulePath2 : map.keySet()) {
                CommentGroup implementation;
                Intrinsics.checkNotNull((Object)tempImplementationMap.get(modulePath2));
                implementation.toJSON(outputPath, synchronizer, runtime, linkingFileMap, A_String.Companion.asNativeString(implementationName), errorLog);
            }
        }
        String string3 = "</ol>\n";
        Charset charset2 = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"UTF_8");
        byte[] byArray2 = string3.getBytes(charset2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
        ByteBuffer closeErrorBuffer = ByteBuffer.wrap(byArray2);
        Intrinsics.checkNotNullExpressionValue((Object)closeErrorBuffer, (String)"closeErrorBuffer");
        errorLog.addLogEntry(closeErrorBuffer, 0);
    }

    private final void writeAmbiguousMethodsJSONFiles(Path outputPath, StacksSynchronizer synchronizer, AvailRuntime runtime, Map<A_String, ? extends Map<String, CommentGroup>> ambiguousMethodFileMap, LinkingFileMap linkingFileMap) throws IOException {
        Map<String, CommentGroup> tempImplementationMap;
        Map internalLinks = new LinkedHashMap();
        Path outputFolder = outputPath.resolve("_Ambiguities");
        String linkLocation = this.linkPrefix + "/_Ambiguities";
        for (A_String key : ambiguousMethodFileMap.keySet()) {
            Map<String, CommentGroup> map = tempImplementationMap = ambiguousMethodFileMap.get(key);
            Intrinsics.checkNotNull(map);
            for (String string2 : map.keySet()) {
                CommentGroup group;
                if (tempImplementationMap.get(string2) == null) continue;
                boolean bl = false;
                if (!group.isPopulated()) continue;
                for (String alias : group.getAliases()) {
                    StacksFilename stacksFilename = group.getFilepath();
                    Intrinsics.checkNotNull((Object)stacksFilename);
                    internalLinks.put(alias, linkLocation + stacksFilename.relativeFilePath());
                }
            }
        }
        for (A_String key : ambiguousMethodFileMap.keySet()) {
            Object modulePath32;
            tempImplementationMap = ambiguousMethodFileMap.get(key);
            Set ambiguousLinks = new LinkedHashSet();
            if (linkingFileMap.getAliasesToFileLink().containsKey(A_String.Companion.asNativeString(key))) {
                Set<String> set2 = linkingFileMap.getAliasesToFileLink().get(A_String.Companion.asNativeString(key));
                Intrinsics.checkNotNull(set2);
                for (String string3 : set2) {
                    ambiguousLinks.add(TuplesKt.to((Object)string3, (Object)string3));
                }
            }
            Set set3 = new LinkedHashSet();
            Map<String, CommentGroup> map = tempImplementationMap;
            Intrinsics.checkNotNull(map);
            for (Object modulePath32 : map.keySet()) {
                boolean bl;
                CommentGroup group;
                if (tempImplementationMap.get(modulePath32) == null) continue;
                boolean bl2 = false;
                if (group.isPopulated()) {
                    StacksFilename stacksFilename = group.getFilepath();
                    Intrinsics.checkNotNull((Object)stacksFilename);
                    bl = ambiguousLinks.add(new Pair((Object)(this.linkPrefix + stacksFilename.relativeFilePath()), (Object)group.getNamingModule()));
                    continue;
                }
                StacksFilename stacksFilename = group.getFilepath();
                Intrinsics.checkNotNull((Object)stacksFilename);
                bl = set3.add(stacksFilename.getPathName());
            }
            JSONWriter jSONWriter = new JSONWriter(null, false, 3, null);
            jSONWriter.startObject();
            jSONWriter.write("type");
            jSONWriter.write("ambiguous");
            jSONWriter.write("files");
            jSONWriter.startArray();
            for (Pair link3 : ambiguousLinks) {
                jSONWriter.startObject();
                jSONWriter.write("link");
                jSONWriter.write((String)link3.getFirst());
                jSONWriter.write("module");
                jSONWriter.write((String)link3.getSecond());
                jSONWriter.endObject();
            }
            modulePath32 = set3.iterator();
            while (modulePath32.hasNext()) {
                String noLink = (String)modulePath32.next();
                jSONWriter.startObject();
                jSONWriter.write("link");
                jSONWriter.write("");
                jSONWriter.write("module");
                jSONWriter.write(noLink);
                jSONWriter.endObject();
            }
            jSONWriter.endArray();
            jSONWriter.endObject();
            String fileName = (key.hash() & 0xFFFFFFFF) + "." + this.fileExtensionName;
            internalLinks.put(A_String.Companion.asNativeString(key), linkLocation + "/" + fileName);
            Intrinsics.checkNotNullExpressionValue((Object)outputFolder, (String)"outputFolder");
            StacksOutputFile linkingFile = new StacksOutputFile(outputFolder, synchronizer, fileName, runtime, A_String.Companion.asNativeString(key));
            linkingFile.write(jSONWriter.toString());
            jSONWriter.close();
        }
        linkingFileMap.internalLinks(internalLinks);
    }

    private final void writeAmbiguousAliasJSONFiles(Path outputPath, AvailRuntime runtime, Map<A_String, Map<String, CommentGroup>> ambiguousMethodFileMap, String topLevelLinkFolderPath, LinkingFileMap linkingFileMap) throws IOException {
        Map internalLinks = new LinkedHashMap();
        Path outputFolder = outputPath.resolve("library-documentation/_Ambiguities");
        Map tempAmbiguousAliasMap = new LinkedHashMap();
        for (String key : linkingFileMap.getNamedFileLinks().keySet()) {
            if (!linkingFileMap.getAliasesToFileLink().containsKey(key)) {
                String string2 = linkingFileMap.getNamedFileLinks().get(key);
                Intrinsics.checkNotNull((Object)string2);
                internalLinks.put(key, string2);
                continue;
            }
            Set<String> set2 = linkingFileMap.getAliasesToFileLink().get(key);
            Intrinsics.checkNotNull(set2);
            tempAmbiguousAliasMap.put(key, set2);
            Object v = tempAmbiguousAliasMap.get(key);
            Intrinsics.checkNotNull(v);
            Set set3 = (Set)v;
            String string3 = linkingFileMap.getNamedFileLinks().get(key);
            Intrinsics.checkNotNull((Object)string3);
            set3.add(string3);
            Object v2 = tempAmbiguousAliasMap.get(key);
            Intrinsics.checkNotNull(v2);
            if (((Set)v2).size() != 1) continue;
            String string4 = linkingFileMap.getNamedFileLinks().get(key);
            Intrinsics.checkNotNull((Object)string4);
            internalLinks.put(key, string4);
            tempAmbiguousAliasMap.remove(key);
        }
        int additionalAmbiguityFileCount = tempAmbiguousAliasMap.size();
        if (additionalAmbiguityFileCount > 0) {
            StacksSynchronizer ambiguousAliasSynchronizer = new StacksSynchronizer(additionalAmbiguityFileCount);
            for (String ambiguousAliasKey : tempAmbiguousAliasMap.keySet()) {
                Set ambiguousLinks = (Set)tempAmbiguousAliasMap.get(ambiguousAliasKey);
                JSONWriter jsonWriter = new JSONWriter(null, false, 3, null);
                jsonWriter.startObject();
                jsonWriter.write("type");
                jsonWriter.write("ambiguous");
                jsonWriter.write("files");
                jsonWriter.startArray();
                Set set4 = ambiguousLinks;
                Intrinsics.checkNotNull((Object)set4);
                for (String ambiguousLink : set4) {
                    jsonWriter.startObject();
                    jsonWriter.write("link");
                    jsonWriter.write(ambiguousLink);
                    jsonWriter.write("module");
                    jsonWriter.write(ambiguousLink);
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
                jsonWriter.endObject();
                String fileName = (StringDescriptor.Companion.stringFrom(ambiguousAliasKey).hash() & 0xFFFFFFFF) + "." + this.fileExtensionName;
                internalLinks.put(ambiguousAliasKey, this.linkPrefix + "/_Ambiguities/" + fileName);
                Intrinsics.checkNotNullExpressionValue((Object)outputFolder, (String)"outputFolder");
                StacksOutputFile jsonFile = new StacksOutputFile(outputFolder, ambiguousAliasSynchronizer, fileName, runtime, ambiguousAliasKey);
                jsonFile.write(jsonWriter.toString());
                jsonWriter.close();
            }
            ambiguousAliasSynchronizer.waitForWorkUnitsToComplete();
        }
        Map<String, String> map = linkingFileMap.getInternalLinks();
        Intrinsics.checkNotNull(map);
        map.putAll(internalLinks);
    }
}

