/*
 * Decompiled with CFR 0.152.
 */
package avail.stacks.scanner;

import avail.stacks.exceptions.StacksScannerException;
import avail.stacks.tokens.AbstractStacksToken;
import avail.stacks.tokens.BracketedStacksToken;
import avail.stacks.tokens.KeywordStacksToken;
import avail.stacks.tokens.QuotedStacksToken;
import avail.stacks.tokens.StacksToken;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u000e\b&\u0018\u0000 =2\u00020\u0001:\u0002=>B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010!\u001a\u00020\"H\u0000\u00a2\u0006\u0002\b#J\r\u0010$\u001a\u00020\"H\u0000\u00a2\u0006\u0002\b%J\r\u0010&\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b'J\r\u0010(\u001a\u00020\"H\u0000\u00a2\u0006\u0002\b)J\r\u0010*\u001a\u00020+H \u00a2\u0006\u0002\b,J\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007J\b\u0010-\u001a\u00020\u0003H\u0002J\u0010\u0010\n\u001a\u00020\"2\u0006\u0010.\u001a\u00020\tH\u0004J\u0010\u0010\r\u001a\u00020\"2\u0006\u0010/\u001a\u00020\tH\u0004J\t\u00100\u001a\u000201H\u0086\u0002J\u0006\u00102\u001a\u00020\u0003J\r\u00103\u001a\u000201H\u0000\u00a2\u0006\u0002\b4J\u0015\u00105\u001a\u00020+2\u0006\u00106\u001a\u000201H\u0000\u00a2\u0006\u0002\b7J\u0010\u0010\u001b\u001a\u00020\"2\u0006\u00108\u001a\u00020\tH\u0004J\u0006\u00109\u001a\u00020\"J\u0010\u0010\u001d\u001a\u00020\"2\u0006\u0010:\u001a\u00020\tH\u0004J\b\u0010\u001e\u001a\u00020\tH\u0004J\u0010\u0010\u001e\u001a\u00020\"2\u0006\u0010;\u001a\u00020\tH\u0004J\u0010\u0010\u001f\u001a\u00020\"2\u0006\u0010<\u001a\u00020\u0003H\u0004R\u0012\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\f\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0002\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0004R \u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001e\u0010\u001b\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\fR\u000e\u0010\u001d\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001f\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0012\u00a8\u0006?"}, d2={"Lavail/stacks/scanner/AbstractStacksScanner;", "", "moduleName", "", "(Ljava/lang/String;)V", "beingTokenized", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "<set-?>", "", "filePosition", "getFilePosition", "()I", "lineNumber", "getLineNumber", "setLineNumber", "(I)V", "getModuleName$avail", "()Ljava/lang/String;", "setModuleName$avail", "outputTokens", "", "Lavail/stacks/tokens/AbstractStacksToken;", "getOutputTokens", "()Ljava/util/List;", "setOutputTokens", "(Ljava/util/List;)V", "position", "getPosition", "startOfToken", "startOfTokenLinePosition", "tokenString", "getTokenString", "addBracketedToken", "", "addBracketedToken$avail", "addCurrentToken", "addCurrentToken$avail", "addKeywordToken", "addKeywordToken$avail", "addQuotedToken", "addQuotedToken$avail", "atEnd", "", "atEnd$avail", "currentTokenString", "newFilePosition", "newLineNumber", "next", "", "obtainModuleSimpleName", "peek", "peek$avail", "peekFor", "aCharacter", "peekFor$avail", "newPosition", "resetBeingTokenized", "newStartOfToken", "newStartOfTokenLinePosition", "aTokenString", "Companion", "ScannerAction", "avail"})
public abstract class AbstractStacksScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String moduleName;
    @NotNull
    private String tokenString;
    @NotNull
    private List<AbstractStacksToken> outputTokens;
    private int position;
    private int filePosition;
    private int startOfToken;
    private int startOfTokenLinePosition;
    private int lineNumber;
    @NotNull
    private StringBuilder beingTokenized;
    @NotNull
    private static final byte[] dispatchTable = new byte[65536];

    public AbstractStacksScanner(@NotNull String moduleName2) {
        Intrinsics.checkNotNullParameter((Object)moduleName2, (String)"moduleName");
        this.moduleName = moduleName2;
        this.tokenString = "";
        this.outputTokens = new ArrayList();
        this.beingTokenized = new StringBuilder();
    }

    @NotNull
    public final String getModuleName$avail() {
        return this.moduleName;
    }

    public final void setModuleName$avail(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        this.moduleName = string2;
    }

    @NotNull
    public final String getTokenString() {
        return this.tokenString;
    }

    @NotNull
    public final List<AbstractStacksToken> getOutputTokens() {
        return this.outputTokens;
    }

    public final void setOutputTokens(@NotNull List<AbstractStacksToken> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.outputTokens = list2;
    }

    public final int getPosition() {
        return this.position;
    }

    public final int getFilePosition() {
        return this.filePosition;
    }

    public final int getLineNumber() {
        return this.lineNumber;
    }

    public final void setLineNumber(int n) {
        this.lineNumber = n;
    }

    protected final void lineNumber(int newLineNumber) {
        this.lineNumber = newLineNumber;
    }

    protected final void startOfTokenLinePosition(int newStartOfTokenLinePosition) {
        this.startOfTokenLinePosition = newStartOfTokenLinePosition;
    }

    protected final int startOfTokenLinePosition() {
        return this.startOfTokenLinePosition;
    }

    protected final void startOfToken(int newStartOfToken) {
        this.startOfToken = newStartOfToken;
    }

    protected final void tokenString(@NotNull String aTokenString) {
        Intrinsics.checkNotNullParameter((Object)aTokenString, (String)"aTokenString");
        this.tokenString = aTokenString;
    }

    protected final void position(int newPosition) {
        this.position = newPosition;
    }

    @NotNull
    public final StringBuilder beingTokenized() {
        return this.beingTokenized;
    }

    public final void resetBeingTokenized() {
        this.beingTokenized = new StringBuilder();
    }

    private final String currentTokenString() {
        String string2;
        String string3 = this.beingTokenized.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"beingTokenized.toString()");
        String alternateToken = string3;
        if (((CharSequence)alternateToken).length() == 0) {
            String string4 = this.tokenString.substring(this.startOfToken, this.position);
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        } else {
            string2 = alternateToken;
        }
        return string2;
    }

    protected final void filePosition(int newFilePosition) {
        this.filePosition = newFilePosition;
    }

    @NotNull
    public final String obtainModuleSimpleName() {
        int i2;
        String modName = this.moduleName;
        for (i2 = modName.length() - 1; i2 > -1 && modName.charAt(i2) != '\\' && modName.charAt(i2) != '/'; --i2) {
        }
        String string2 = modName.substring(i2 + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
        return string2;
    }

    public final void addCurrentToken$avail() {
        StacksToken token = StacksToken.Companion.create(this.currentTokenString(), this.position + this.filePosition, this.lineNumber, this.startOfTokenLinePosition(), this.moduleName);
        this.outputTokens.add(token);
    }

    public final void addBracketedToken$avail() throws StacksScannerException {
        BracketedStacksToken token = BracketedStacksToken.Companion.create(this.currentTokenString(), this.lineNumber, this.position + this.filePosition, this.startOfTokenLinePosition(), this.moduleName);
        this.outputTokens.add(token);
    }

    public final void addQuotedToken$avail() {
        QuotedStacksToken token = QuotedStacksToken.Companion.create(this.currentTokenString(), this.position + this.filePosition, this.lineNumber, this.startOfTokenLinePosition(), this.moduleName);
        this.outputTokens.add(token);
    }

    @NotNull
    public final AbstractStacksToken addKeywordToken$avail() {
        AbstractStacksToken token = KeywordStacksToken.Companion.create(this.currentTokenString(), this.position + this.filePosition, this.lineNumber, this.startOfTokenLinePosition(), this.moduleName);
        this.outputTokens.add(token);
        return token;
    }

    public abstract boolean atEnd$avail();

    public final char next() throws StacksScannerException {
        if (this.atEnd$avail()) {
            String string2 = "\n<li><strong>%s</strong><em>Line #: %d</em>: Scanner Error: Attempted to read past end of file.</li>";
            Object[] objectArray = new Object[]{this.obtainModuleSimpleName(), this.lineNumber};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
            throw new StacksScannerException(string3, this);
        }
        int c = Character.codePointAt(this.tokenString, this.position);
        this.position += Character.charCount(c);
        if (c == 10) {
            int n = this.lineNumber;
            this.lineNumber = n + 1;
            this.startOfTokenLinePosition = 0;
        }
        return (char)c;
    }

    public final char peek$avail() {
        return (char)Character.codePointAt(this.tokenString, this.position);
    }

    public final boolean peekFor$avail(char aCharacter) throws StacksScannerException {
        if (this.atEnd$avail()) {
            return false;
        }
        if (this.peek$avail() != aCharacter) {
            return false;
        }
        this.next();
        return true;
    }

    static {
        for (int i2 = 0; i2 < 65536; ++i2) {
            char c = (char)i2;
            ScannerAction action2 = null;
            action2 = Character.isSpaceChar(c) || Character.isWhitespace(c) ? ScannerAction.WHITESPACE : ScannerAction.STANDARD_CHARACTER;
            AbstractStacksScanner.dispatchTable[i2] = (byte)action2.ordinal();
        }
        AbstractStacksScanner.dispatchTable[10] = (byte)ScannerAction.NEWLINE.ordinal();
        AbstractStacksScanner.dispatchTable[123] = (byte)ScannerAction.BRACKET.ordinal();
        AbstractStacksScanner.dispatchTable[34] = (byte)ScannerAction.DOUBLE_QUOTE.ordinal();
        AbstractStacksScanner.dispatchTable[47] = (byte)ScannerAction.SLASH.ordinal();
        AbstractStacksScanner.dispatchTable[65279] = (byte)ScannerAction.ZERO_WIDTH_WHITESPACE.ordinal();
        AbstractStacksScanner.dispatchTable[64] = (byte)ScannerAction.KEYWORD_START.ordinal();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0080\u0001\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0010B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H \u00a2\u0006\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000f\u00a8\u0006\u0011"}, d2={"Lavail/stacks/scanner/AbstractStacksScanner$ScannerAction;", "", "(Ljava/lang/String;I)V", "scan", "", "scanner", "Lavail/stacks/scanner/AbstractStacksScanner;", "scan$avail", "DOUBLE_QUOTE", "BRACKET", "KEYWORD_START", "NEWLINE", "SLASH", "STANDARD_CHARACTER", "WHITESPACE", "ZERO_WIDTH_WHITESPACE", "Companion", "avail"})
    public static final abstract class ScannerAction
    extends Enum<ScannerAction> {
        @NotNull
        public static final Companion Companion;
        public static final /* enum */ ScannerAction DOUBLE_QUOTE;
        public static final /* enum */ ScannerAction BRACKET;
        public static final /* enum */ ScannerAction KEYWORD_START;
        public static final /* enum */ ScannerAction NEWLINE;
        public static final /* enum */ ScannerAction SLASH;
        public static final /* enum */ ScannerAction STANDARD_CHARACTER;
        public static final /* enum */ ScannerAction WHITESPACE;
        public static final /* enum */ ScannerAction ZERO_WIDTH_WHITESPACE;
        private static final /* synthetic */ ScannerAction[] $VALUES;

        private ScannerAction() {
        }

        public abstract void scan$avail(@NotNull AbstractStacksScanner var1) throws StacksScannerException;

        public static ScannerAction[] values() {
            return (ScannerAction[])$VALUES.clone();
        }

        public static ScannerAction valueOf(String value) {
            return Enum.valueOf(ScannerAction.class, value);
        }

        public /* synthetic */ ScannerAction(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            DOUBLE_QUOTE = new DOUBLE_QUOTE("DOUBLE_QUOTE", 0);
            BRACKET = new BRACKET("BRACKET", 1);
            KEYWORD_START = new KEYWORD_START("KEYWORD_START", 2);
            NEWLINE = new NEWLINE("NEWLINE", 3);
            SLASH = new SLASH("SLASH", 4);
            STANDARD_CHARACTER = new STANDARD_CHARACTER("STANDARD_CHARACTER", 5);
            WHITESPACE = new WHITESPACE("WHITESPACE", 6);
            ZERO_WIDTH_WHITESPACE = new ZERO_WIDTH_WHITESPACE("ZERO_WIDTH_WHITESPACE", 7);
            $VALUES = scannerActionArray = new ScannerAction[]{ScannerAction.DOUBLE_QUOTE, ScannerAction.BRACKET, ScannerAction.KEYWORD_START, ScannerAction.NEWLINE, ScannerAction.SLASH, ScannerAction.STANDARD_CHARACTER, ScannerAction.WHITESPACE, ScannerAction.ZERO_WIDTH_WHITESPACE};
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lavail/stacks/scanner/AbstractStacksScanner$ScannerAction$Companion;", "", "()V", "forCodePoint", "Lavail/stacks/scanner/AbstractStacksScanner$ScannerAction;", "cp", "", "avail"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ScannerAction forCodePoint(char cp) {
                char c = cp;
                return c < '\u10000' ? ScannerAction.values()[AbstractStacksScanner.Companion.getDispatchTable$avail()[c]] : (Character.isSpaceChar((int)c) || Character.isWhitespace((int)c) ? WHITESPACE : STANDARD_CHARACTER);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u001c\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007j\u0002`\bH\u0002J\u0015\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0010\u00a2\u0006\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lavail/stacks/scanner/AbstractStacksScanner$ScannerAction$DOUBLE_QUOTE;", "Lavail/stacks/scanner/AbstractStacksScanner$ScannerAction;", "parseUnicodeEscapes", "", "scanner", "Lavail/stacks/scanner/AbstractStacksScanner;", "stringBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "scan", "scan$avail", "avail"})
        static final class DOUBLE_QUOTE
        extends ScannerAction {
            /*
             * WARNING - void declaration
             */
            DOUBLE_QUOTE() {
                void var1_1;
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void scan$avail(@NotNull AbstractStacksScanner scanner) throws StacksScannerException {
                Intrinsics.checkNotNullParameter((Object)scanner, (String)"scanner");
                int literalStartingLine = scanner.getLineNumber();
                if (scanner.atEnd$avail()) {
                    String string2 = "\n<li><strong>%s</strong><em>Line #: %d</em>: Scanner Error: Unterminated string literal.</li>";
                    Object[] objectArray = new Object[]{scanner.obtainModuleSimpleName(), scanner.getLineNumber()};
                    String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
                    throw new StacksScannerException(string3, scanner);
                }
                char c = scanner.next();
                scanner.resetBeingTokenized();
                boolean canErase = true;
                int erasurePosition = 0;
                while (true) {
                    if (c == '\"') {
                        scanner.addQuotedToken$avail();
                        scanner.resetBeingTokenized();
                        return;
                    }
                    char c2 = c;
                    if (c2 == '\\') {
                        if (scanner.atEnd$avail()) {
                            String string4 = "\n<li><strong>%s</strong><em>Line #: %d</em>: Scanner Error: Encountered end of file after backslash in string literal.\n";
                            Object[] objectArray = new Object[]{scanner.obtainModuleSimpleName(), scanner.getLineNumber()};
                            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
                            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(format, *args)");
                            throw new StacksScannerException(string5, scanner);
                        }
                        char c3 = scanner.next();
                        if (c3 == 'n') {
                            scanner.beingTokenized().append('\n');
                        } else if (c3 == 'r') {
                            scanner.beingTokenized().append('\r');
                        } else if (c3 == 't') {
                            scanner.beingTokenized().append('\t');
                        } else if (c3 == '\\') {
                            scanner.beingTokenized().append('\\');
                        } else if (c3 == '\"') {
                            scanner.beingTokenized().append('\"');
                        } else if (c3 == '\r') {
                            if (!scanner.atEnd$avail()) {
                                scanner.peekFor$avail('\n');
                            }
                            canErase = true;
                        } else if (c3 == '\n') {
                            canErase = true;
                        } else if (c3 == '|') {
                            if (!canErase) {
                                String string6 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Scanner Error: The input before  \"\\|\" contains non-whitespace/not-'*'.</li>";
                                Object[] objectArray = new Object[]{scanner.obtainModuleSimpleName(), scanner.getLineNumber()};
                                String string7 = String.format(string6, Arrays.copyOf(objectArray, objectArray.length));
                                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"format(format, *args)");
                                throw new StacksScannerException(string7, scanner);
                            }
                            scanner.beingTokenized().setLength(erasurePosition);
                            canErase = false;
                        } else if (c3 == '(') {
                            this.parseUnicodeEscapes(scanner, scanner.beingTokenized());
                        } else {
                            if (c3 == '[') {
                                scanner.lineNumber(literalStartingLine);
                                throw new StacksScannerException("Power strings are not yet supported", scanner);
                            }
                            String string8 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Scanner Error: Backslash escape should be followed by one of n, r, t, \\, \", (, [, |, or a line break.</li>";
                            Object[] objectArray = new Object[]{scanner.obtainModuleSimpleName(), scanner.getLineNumber()};
                            String string9 = String.format(string8, Arrays.copyOf(objectArray, objectArray.length));
                            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"format(format, *args)");
                            throw new StacksScannerException(string9, scanner);
                        }
                        erasurePosition = scanner.beingTokenized().length();
                    } else if (c2 == '\r') {
                        if (!scanner.atEnd$avail()) {
                            scanner.peekFor$avail('\n');
                        }
                        scanner.beingTokenized().append('\n');
                        canErase = true;
                        erasurePosition = scanner.beingTokenized().length();
                    } else if (c2 == '\n') {
                        scanner.beingTokenized().append('\n');
                        canErase = true;
                        erasurePosition = scanner.beingTokenized().length();
                    } else if (c2 == '*') {
                        if (!canErase) {
                            scanner.beingTokenized().append('*');
                            erasurePosition = scanner.beingTokenized().length();
                        }
                    } else {
                        scanner.beingTokenized().append(c);
                        if (canErase && !Character.isWhitespace(c)) {
                            canErase = false;
                        }
                    }
                    if (scanner.atEnd$avail()) {
                        scanner.lineNumber(literalStartingLine);
                        String string10 = "\n<li><strong>%s</strong><em>Line #: %d</em>: Scanner Error: Unterminated string literal.</li>";
                        Object[] objectArray = new Object[]{scanner.obtainModuleSimpleName(), scanner.getLineNumber()};
                        String string11 = String.format(string10, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"format(format, *args)");
                        throw new StacksScannerException(string11, scanner);
                    }
                    c = scanner.next();
                }
            }

            private final void parseUnicodeEscapes(AbstractStacksScanner scanner, StringBuilder stringBuilder) throws StacksScannerException {
                if (scanner.atEnd$avail()) {
                    String string2 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Scanner Error: Expected hexadecimal Unicode codepoints separated by commas</li>";
                    Object[] objectArray = new Object[]{scanner.obtainModuleSimpleName(), scanner.getLineNumber()};
                    String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
                    throw new StacksScannerException(string3, scanner);
                }
                char c = scanner.next();
                while (c != ')') {
                    char c2;
                    int value = 0;
                    int digitCount = 0;
                    while (c != ',' && c != ')') {
                        c2 = c;
                        boolean bl = '0' <= c2 ? c2 < ':' : false;
                        if (bl) {
                            value = (value << 4) + c - 48;
                            ++digitCount;
                        } else {
                            boolean bl2 = 'A' <= c2 ? c2 < 'G' : false;
                            if (bl2) {
                                value = (value << 4) + c - 65 + 10;
                                ++digitCount;
                            } else {
                                boolean bl3 = 'a' <= c2 ? c2 < 'g' : false;
                                if (bl3) {
                                    value = (value << 4) + c - 97 + 10;
                                    ++digitCount;
                                } else {
                                    String string4 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Scanner Error: Expected a hex digit or comma or closing parenthesis</li>";
                                    Object[] objectArray = new Object[]{scanner.obtainModuleSimpleName(), scanner.getLineNumber()};
                                    String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
                                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(format, *args)");
                                    throw new StacksScannerException(string5, scanner);
                                }
                            }
                        }
                        if (digitCount > 6) {
                            String string6 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Scanner Error: Expected at most six hex digits per comma-separated Unicode entry</li>";
                            Object[] objectArray = new Object[]{scanner.obtainModuleSimpleName(), scanner.getLineNumber()};
                            String string7 = String.format(string6, Arrays.copyOf(objectArray, objectArray.length));
                            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"format(format, *args)");
                            throw new StacksScannerException(string7, scanner);
                        }
                        c = scanner.next();
                    }
                    if (digitCount == 0) {
                        String string8 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Scanner Error: Expected a comma-separated list of Unicode code points, each being one to six (upper case) hexadecimal digits</li>";
                        Object[] objectArray = new Object[]{scanner.obtainModuleSimpleName(), scanner.getLineNumber()};
                        String string9 = String.format(string8, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"format(format, *args)");
                        throw new StacksScannerException(string9, scanner);
                    }
                    char c3 = c2 = digitCount >= 1 ? (char)'\u0001' : '\u0000';
                    if (_Assertions.ENABLED && c2 == '\u0000') {
                        String string10 = "Assertion failed";
                        throw new AssertionError((Object)string10);
                    }
                    if (value > 0x10FFFF) {
                        String string11 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Scanner Error: The maximum allowed code point for a Unicode character is U+10FFFF</li>";
                        Object[] objectArray = new Object[]{scanner.obtainModuleSimpleName(), scanner.getLineNumber()};
                        String string12 = String.format(string11, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"format(format, *args)");
                        throw new StacksScannerException(string12, scanner);
                    }
                    scanner.beingTokenized().appendCodePoint(value);
                    if (c != ',') continue;
                    c = scanner.next();
                }
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0015\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0010\u00a2\u0006\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lavail/stacks/scanner/AbstractStacksScanner$ScannerAction$BRACKET;", "Lavail/stacks/scanner/AbstractStacksScanner$ScannerAction;", "scan", "", "scanner", "Lavail/stacks/scanner/AbstractStacksScanner;", "scan$avail", "avail"})
        static final class BRACKET
        extends ScannerAction {
            /*
             * WARNING - void declaration
             */
            BRACKET() {
                void var1_1;
            }

            @Override
            public void scan$avail(@NotNull AbstractStacksScanner scanner) throws StacksScannerException {
                Intrinsics.checkNotNullParameter((Object)scanner, (String)"scanner");
                int startOfBracket = scanner.getPosition();
                int startOfBracketLineNumber = scanner.getLineNumber();
                int startOfBracketTokenLinePosition = scanner.startOfTokenLinePosition();
                while (Character.isSpaceChar(scanner.peek$avail()) || Character.isWhitespace(scanner.peek$avail())) {
                    scanner.next();
                    if (!scanner.atEnd$avail()) continue;
                    scanner.position(startOfBracket);
                    scanner.lineNumber(startOfBracketLineNumber);
                    scanner.startOfTokenLinePosition(startOfBracketTokenLinePosition);
                    scanner.addCurrentToken$avail();
                    return;
                }
                if (!scanner.peekFor$avail('@')) {
                    if (scanner.getPosition() != startOfBracket + 1) {
                        scanner.position(startOfBracket);
                        scanner.addCurrentToken$avail();
                        return;
                    }
                    return;
                }
                while (!scanner.peekFor$avail('}')) {
                    scanner.next();
                    if (!scanner.atEnd$avail()) continue;
                    scanner.position(startOfBracket);
                    scanner.lineNumber(startOfBracketLineNumber);
                    scanner.startOfTokenLinePosition(startOfBracketTokenLinePosition);
                    return;
                }
                scanner.addBracketedToken$avail();
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0015\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0010\u00a2\u0006\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lavail/stacks/scanner/AbstractStacksScanner$ScannerAction$KEYWORD_START;", "Lavail/stacks/scanner/AbstractStacksScanner$ScannerAction;", "scan", "", "scanner", "Lavail/stacks/scanner/AbstractStacksScanner;", "scan$avail", "avail"})
        static final class KEYWORD_START
        extends ScannerAction {
            /*
             * WARNING - void declaration
             */
            KEYWORD_START() {
                void var1_1;
            }

            @Override
            public void scan$avail(@NotNull AbstractStacksScanner scanner) throws StacksScannerException {
                Intrinsics.checkNotNullParameter((Object)scanner, (String)"scanner");
                while (!Character.isSpaceChar(scanner.peek$avail()) && !Character.isWhitespace(scanner.peek$avail())) {
                    scanner.next();
                }
                scanner.addKeywordToken$avail();
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0015\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0010\u00a2\u0006\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lavail/stacks/scanner/AbstractStacksScanner$ScannerAction$NEWLINE;", "Lavail/stacks/scanner/AbstractStacksScanner$ScannerAction;", "scan", "", "scanner", "Lavail/stacks/scanner/AbstractStacksScanner;", "scan$avail", "avail"})
        static final class NEWLINE
        extends ScannerAction {
            /*
             * WARNING - void declaration
             */
            NEWLINE() {
                void var1_1;
            }

            @Override
            public void scan$avail(@NotNull AbstractStacksScanner scanner) throws StacksScannerException {
                Intrinsics.checkNotNullParameter((Object)scanner, (String)"scanner");
                while (Character.isSpaceChar(scanner.peek$avail()) || Character.isWhitespace(scanner.peek$avail())) {
                    scanner.next();
                }
                if (scanner.peekFor$avail('*')) {
                    scanner.next();
                }
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0015\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0010\u00a2\u0006\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lavail/stacks/scanner/AbstractStacksScanner$ScannerAction$SLASH;", "Lavail/stacks/scanner/AbstractStacksScanner$ScannerAction;", "scan", "", "scanner", "Lavail/stacks/scanner/AbstractStacksScanner;", "scan$avail", "avail"})
        static final class SLASH
        extends ScannerAction {
            /*
             * WARNING - void declaration
             */
            SLASH() {
                void var1_1;
            }

            @Override
            public void scan$avail(@NotNull AbstractStacksScanner scanner) throws StacksScannerException {
                Intrinsics.checkNotNullParameter((Object)scanner, (String)"scanner");
                if (!scanner.peekFor$avail('*')) {
                    while (Character.isSpaceChar(scanner.peek$avail()) || Character.isWhitespace(scanner.peek$avail())) {
                        scanner.next();
                    }
                    scanner.addCurrentToken$avail();
                } else {
                    int startLine = scanner.getLineNumber();
                    int depth2 = 1;
                    do {
                        if (scanner.atEnd$avail()) {
                            String string2 = "\n<li><strong>%s</strong><em> Line #: %d</em>: Scanner Error: Expected a close comment (*/) to correspond with the open comment (/*) on line #%d</li>";
                            Object[] objectArray = new Object[]{scanner.obtainModuleSimpleName(), scanner.getLineNumber(), startLine};
                            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
                            throw new StacksScannerException(string3, scanner);
                        }
                        if (scanner.peekFor$avail('/') && scanner.peekFor$avail('*')) {
                            ++depth2;
                            continue;
                        }
                        if (scanner.peekFor$avail('*')) {
                            if (!scanner.peekFor$avail('/')) continue;
                            --depth2;
                            continue;
                        }
                        scanner.next();
                    } while (depth2 != 0);
                }
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0015\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0010\u00a2\u0006\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lavail/stacks/scanner/AbstractStacksScanner$ScannerAction$STANDARD_CHARACTER;", "Lavail/stacks/scanner/AbstractStacksScanner$ScannerAction;", "scan", "", "scanner", "Lavail/stacks/scanner/AbstractStacksScanner;", "scan$avail", "avail"})
        static final class STANDARD_CHARACTER
        extends ScannerAction {
            /*
             * WARNING - void declaration
             */
            STANDARD_CHARACTER() {
                void var1_1;
            }

            @Override
            public void scan$avail(@NotNull AbstractStacksScanner scanner) throws StacksScannerException {
                Intrinsics.checkNotNullParameter((Object)scanner, (String)"scanner");
                scanner.resetBeingTokenized();
                while (!(Character.isSpaceChar(scanner.peek$avail()) || Character.isWhitespace(scanner.peek$avail()) || scanner.atEnd$avail())) {
                    scanner.next();
                }
                scanner.addCurrentToken$avail();
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0015\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0010\u00a2\u0006\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lavail/stacks/scanner/AbstractStacksScanner$ScannerAction$WHITESPACE;", "Lavail/stacks/scanner/AbstractStacksScanner$ScannerAction;", "scan", "", "scanner", "Lavail/stacks/scanner/AbstractStacksScanner;", "scan$avail", "avail"})
        static final class WHITESPACE
        extends ScannerAction {
            /*
             * WARNING - void declaration
             */
            WHITESPACE() {
                void var1_1;
            }

            @Override
            public void scan$avail(@NotNull AbstractStacksScanner scanner) {
                Intrinsics.checkNotNullParameter((Object)scanner, (String)"scanner");
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0015\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0010\u00a2\u0006\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lavail/stacks/scanner/AbstractStacksScanner$ScannerAction$ZERO_WIDTH_WHITESPACE;", "Lavail/stacks/scanner/AbstractStacksScanner$ScannerAction;", "scan", "", "scanner", "Lavail/stacks/scanner/AbstractStacksScanner;", "scan$avail", "avail"})
        static final class ZERO_WIDTH_WHITESPACE
        extends ScannerAction {
            /*
             * WARNING - void declaration
             */
            ZERO_WIDTH_WHITESPACE() {
                void var1_1;
            }

            @Override
            public void scan$avail(@NotNull AbstractStacksScanner scanner) {
                Intrinsics.checkNotNullParameter((Object)scanner, (String)"scanner");
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lavail/stacks/scanner/AbstractStacksScanner$Companion;", "", "()V", "dispatchTable", "", "getDispatchTable$avail", "()[B", "avail"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final byte[] getDispatchTable$avail() {
            return dispatchTable;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

