/*
 * Decompiled with CFR 0.152.
 */
package avail.utility;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.ULong;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0002H\u0000\u001a\u0014\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001H\u0000\u001a\u0014\u0010\t\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\n\u001a\u00020\u0004H\u0000\u001a\f\u0010\u000b\u001a\u00020\f*\u00020\u0002H\u0000\u001a\f\u0010\r\u001a\u00020\u000e*\u00020\u0002H\u0000\u001a\f\u0010\u000f\u001a\u00020\f*\u00020\u0002H\u0000\u001a\f\u0010\u0010\u001a\u00020\u000e*\u00020\u0002H\u0000\u001a\u0014\u0010\u0011\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\u0012\u001a\u00020\fH\u0000\u001a\u0014\u0010\u0011\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u000eH\u0000\u001a\u0014\u0010\u0013\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\u0012\u001a\u00020\fH\u0000\u001a\u0014\u0010\u0013\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u000eH\u0000\u00a8\u0006\u0014"}, d2={"decodeByteArray", "", "Ljava/io/DataInputStream;", "decodeString", "", "sizedByteArray", "", "Ljava/io/DataOutputStream;", "bytes", "sizedString", "s", "unvlqInt", "", "unvlqLong", "", "unzigzagInt", "unzigzagLong", "vlq", "value", "zigzag", "avail"})
public final class CodingKt {
    public static final void vlq(@NotNull DataOutputStream $this$vlq, int value) {
        int residue;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$vlq, (String)"<this>");
        boolean bl2 = bl = value >= 0;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        for (residue = value; residue >= 128; residue >>>= 7) {
            int b = residue & 0x7F | 0x80;
            $this$vlq.write(b);
        }
        $this$vlq.write(residue);
    }

    public static final void vlq(@NotNull DataOutputStream $this$vlq, long value) {
        long residue;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$vlq, (String)"<this>");
        boolean bl2 = bl = value >= 0L;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        for (residue = value; residue >= 128L; residue >>>= 7) {
            long b = residue & 0x7FL | 0x80L;
            $this$vlq.write((int)b);
        }
        $this$vlq.write((int)residue);
    }

    public static final int unvlqInt(@NotNull DataInputStream $this$unvlqInt) {
        int b;
        Intrinsics.checkNotNullParameter((Object)$this$unvlqInt, (String)"<this>");
        int n = 0;
        int k = 0;
        while (true) {
            b = $this$unvlqInt.read();
            if ((b & 0x80) != 128) break;
            n |= (b & 0x7F) << k;
            k += 7;
        }
        return n | b << k;
    }

    public static final long unvlqLong(@NotNull DataInputStream $this$unvlqLong) {
        int b;
        Intrinsics.checkNotNullParameter((Object)$this$unvlqLong, (String)"<this>");
        long n = 0L;
        int k = 0;
        while (true) {
            b = $this$unvlqLong.read();
            if ((b & 0x80) != 128) break;
            n |= (long)(b & 0x7F) << k;
            k += 7;
        }
        return n | (long)(b << k);
    }

    public static final void zigzag(@NotNull DataOutputStream $this$zigzag, int value) {
        Intrinsics.checkNotNullParameter((Object)$this$zigzag, (String)"<this>");
        CodingKt.vlq($this$zigzag, value >> 31 ^ value << 1);
    }

    public static final void zigzag(@NotNull DataOutputStream $this$zigzag, long value) {
        Intrinsics.checkNotNullParameter((Object)$this$zigzag, (String)"<this>");
        CodingKt.vlq($this$zigzag, value >> 63 ^ value << 1);
    }

    public static final int unzigzagInt(@NotNull DataInputStream $this$unzigzagInt) {
        Intrinsics.checkNotNullParameter((Object)$this$unzigzagInt, (String)"<this>");
        int n = CodingKt.unvlqInt($this$unzigzagInt);
        int u = UInt.constructor-impl((int)n);
        int l = UInt.constructor-impl((int)(u >>> 1));
        int r = UInt.constructor-impl((int)(-(n & 1)));
        return UInt.constructor-impl((int)(l ^ r));
    }

    public static final long unzigzagLong(@NotNull DataInputStream $this$unzigzagLong) {
        Intrinsics.checkNotNullParameter((Object)$this$unzigzagLong, (String)"<this>");
        long n = CodingKt.unvlqLong($this$unzigzagLong);
        long u = ULong.constructor-impl((long)n);
        long l = ULong.constructor-impl((long)(u >>> 1));
        long r = ULong.constructor-impl((long)(-(n & 1L)));
        return ULong.constructor-impl((long)(l ^ r));
    }

    public static final void sizedByteArray(@NotNull DataOutputStream $this$sizedByteArray, @NotNull byte[] bytes2) {
        Intrinsics.checkNotNullParameter((Object)$this$sizedByteArray, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)bytes2, (String)"bytes");
        CodingKt.vlq($this$sizedByteArray, bytes2.length);
        $this$sizedByteArray.write(bytes2);
    }

    @NotNull
    public static final byte[] decodeByteArray(@NotNull DataInputStream $this$decodeByteArray) {
        Intrinsics.checkNotNullParameter((Object)$this$decodeByteArray, (String)"<this>");
        int size = CodingKt.unvlqInt($this$decodeByteArray);
        byte[] bytes2 = new byte[size];
        $this$decodeByteArray.readFully(bytes2);
        return bytes2;
    }

    public static final void sizedString(@NotNull DataOutputStream $this$sizedString, @NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)$this$sizedString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        String string2 = s;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        CodingKt.sizedByteArray($this$sizedString, byArray);
    }

    @NotNull
    public static final String decodeString(@NotNull DataInputStream $this$decodeString) {
        Intrinsics.checkNotNullParameter((Object)$this$decodeString, (String)"<this>");
        return StringsKt.decodeToString((byte[])CodingKt.decodeByteArray($this$decodeString));
    }
}

