/*
 * Decompiled with CFR 0.152.
 */
package avail.utility;

import avail.utility.ObjectTracer;
import java.lang.ref.Reference;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0011\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000b0\n2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\tH\u0002J\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\nJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0001H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0007\u001a&\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0018\u0012\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000b0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lavail/utility/ObjectTracer;", "", "start", "target", "(Ljava/lang/Object;Ljava/lang/Object;)V", "backLinks", "Ljava/util/IdentityHashMap;", "cacheByClass", "", "Ljava/lang/Class;", "", "Lkotlin/Function1;", "getStart", "()Ljava/lang/Object;", "getTarget", "workQueue", "Lkotlin/collections/ArrayDeque;", "gettersForClass", "cls", "scan", "scanObject", "", "obj", "avail"})
public final class ObjectTracer {
    @NotNull
    private final Object start;
    @NotNull
    private final Object target;
    @NotNull
    private final IdentityHashMap<Object, Object> backLinks;
    @NotNull
    private final ArrayDeque<Object> workQueue;
    @NotNull
    private final Map<Class<?>, List<Function1<Object, Object>>> cacheByClass;

    public ObjectTracer(@NotNull Object start, @NotNull Object target) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.start = start;
        this.target = target;
        this.backLinks = new IdentityHashMap();
        this.workQueue = new ArrayDeque();
        this.cacheByClass = new LinkedHashMap();
    }

    @NotNull
    public final Object getStart() {
        return this.start;
    }

    @NotNull
    public final Object getTarget() {
        return this.target;
    }

    @Nullable
    public final List<Object> scan() {
        this.backLinks.clear();
        this.workQueue.clear();
        this.workQueue.add(this.start);
        ((Map)this.backLinks).put(this.start, this.start);
        if (this.start == this.target) {
            return CollectionsKt.listOf((Object)this.start);
        }
        while (!((Collection)this.workQueue).isEmpty()) {
            if (!this.scanObject(this.workQueue.removeFirst())) continue;
            Object o = this.target;
            Object[] objectArray = new Object[]{o};
            List chain = CollectionsKt.mutableListOf((Object[])objectArray);
            while (o != this.start) {
                Intrinsics.checkNotNull((Object)this.backLinks.get(o));
                chain.add(o);
            }
            return CollectionsKt.reversed((Iterable)chain);
        }
        return null;
    }

    private final boolean scanObject(Object obj) {
        block4: {
            Class<?> cls;
            block3: {
                cls = obj.getClass();
                if (!cls.isArray()) break block3;
                if (cls.getComponentType().isPrimitive()) break block4;
                Intrinsics.checkNotNull((Object)obj, (String)"null cannot be cast to non-null type kotlin.Array<*>");
                Object[] $this$forEach$iv = (Object[])obj;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int j = 0; j < n; ++j) {
                    Object element$iv;
                    Object child = element$iv = $this$forEach$iv[j];
                    boolean bl = false;
                    if (child == null || ((Map)this.backLinks).containsKey(child)) continue;
                    ((Map)this.backLinks).put(child, obj);
                    this.workQueue.add(child);
                    if (child != this.target) continue;
                    return true;
                }
                break block4;
            }
            if (Reference.class.isAssignableFrom(cls)) {
                return false;
            }
            Iterable $this$forEach$iv = this.gettersForClass(obj.getClass());
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object child;
                Function1 getter = (Function1)element$iv;
                boolean bl = false;
                if (getter.invoke(obj) == null) continue;
                boolean bl2 = false;
                if (((Map)this.backLinks).containsKey(child)) continue;
                ((Map)this.backLinks).put(child, obj);
                this.workQueue.add(child);
                if (child != this.target) continue;
                return true;
            }
        }
        return false;
    }

    private final List<Function1<Object, Object>> gettersForClass(Class<?> cls) {
        List list2 = this.cacheByClass.computeIfAbsent(cls, arg_0 -> ObjectTracer.gettersForClass$lambda$3(gettersForClass.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"cacheByClass.computeIfAb\u2026\t\t\t\t}\n\t\t\t}\n\t\t\tgetters\n\t\t}");
        return list2;
    }

    private static final List gettersForClass$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)$tmp0.invoke(p0);
    }
}

