/*
 * Decompiled with CFR 0.152.
 */
package avail.compiler.splitter;

import avail.compiler.ParsingOperation;
import avail.compiler.splitter.Expression;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.TupleDescriptor;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 /2\u00020\u0001:\u0002/0B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0014\u001a\u0002H\u0015\"\u0004\b\u0000\u0010\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0017\u00a2\u0006\u0002\u0010\u0018J\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001dJ\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\nJ\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010!\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010\"\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001dJ\u001e\u0010\"\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\nJ\u001e\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010%\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010&\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010'\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010(\u001a\u00020\nJ\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0)J\u0006\u0010*\u001a\u00020\u001aJ\b\u0010+\u001a\u00020\u001aH\u0002J\u0006\u0010,\u001a\u00020-J\u0006\u0010.\u001a\u00020\u001aR\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u00061"}, d2={"Lavail/compiler/splitter/InstructionGenerator;", "", "()V", "<set-?>", "", "caseInsensitive", "getCaseInsensitive", "()Z", "delayedArgumentInstructions", "", "", "delayedExpressionList", "Lavail/compiler/splitter/Expression;", "expressionList", "instructions", "partialListsCount", "getPartialListsCount", "()I", "setPartialListsCount", "(I)V", "beCaseInsensitiveWhile", "O", "action", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "emit", "", "expression", "operation", "Lavail/compiler/ParsingOperation;", "label", "Lavail/compiler/splitter/InstructionGenerator$Label;", "operand", "emitBranchForward", "emitDelayed", "emitIf", "condition", "emitJumpBackward", "emitJumpForward", "emitWrapped", "listSize", "", "flushDelayed", "hoistTokenParsing", "instructionsTuple", "Lavail/descriptor/tuples/A_Tuple;", "optimizeInstructions", "Companion", "Label", "avail"})
@SourceDebugExtension(value={"SMAP\nInstructionGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InstructionGenerator.kt\navail/compiler/splitter/InstructionGenerator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,475:1\n1#2:476\n*E\n"})
public final class InstructionGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Integer> instructions = new ArrayList();
    @NotNull
    private final List<Expression> expressionList = new ArrayList();
    @NotNull
    private final List<Integer> delayedArgumentInstructions = new ArrayList();
    @NotNull
    private final List<Expression> delayedExpressionList = new ArrayList();
    private boolean caseInsensitive;
    private int partialListsCount = 1;
    private static final int placeholderInstruction = Integer.MIN_VALUE;

    public final boolean getCaseInsensitive() {
        return this.caseInsensitive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <O> O beCaseInsensitiveWhile(@NotNull Function0<? extends O> action2) {
        O o;
        Intrinsics.checkNotNullParameter(action2, "action");
        boolean old = this.caseInsensitive;
        this.caseInsensitive = true;
        try {
            o = action2.invoke();
        }
        finally {
            this.caseInsensitive = old;
        }
        return o;
    }

    public final int getPartialListsCount() {
        return this.partialListsCount;
    }

    public final void setPartialListsCount(int n) {
        this.partialListsCount = n;
    }

    public final void emit(@NotNull Expression expression2, @NotNull ParsingOperation operation) {
        boolean bl;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter((Object)operation, "operation");
        boolean bl2 = bl = operation != ParsingOperation.APPEND_ARGUMENT && operation != ParsingOperation.PERMUTE_LIST || this.delayedArgumentInstructions.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.expressionList.add(expression2);
        this.instructions.add(operation.getEncoding());
    }

    public final void emit(@NotNull Expression expression2, @NotNull ParsingOperation operation, int operand) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter((Object)operation, "operation");
        this.expressionList.add(expression2);
        this.instructions.add(operation.encoding(operand));
    }

    public final void emitIf(boolean condition, @NotNull Expression expression2, @NotNull ParsingOperation operation) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter((Object)operation, "operation");
        if (condition) {
            this.emit(expression2, operation);
        }
    }

    public final void emit(@NotNull Expression expression2, @NotNull ParsingOperation operation, @NotNull Label label) {
        boolean bl;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter((Object)operation, "operation");
        Intrinsics.checkNotNullParameter(label, "label");
        boolean bl2 = bl = operation != ParsingOperation.BRANCH_FORWARD && operation != ParsingOperation.JUMP_FORWARD && operation != ParsingOperation.JUMP_BACKWARD;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Use emitJumpForward() etc. to emit jumps and branches";
            throw new AssertionError((Object)string2);
        }
        this.expressionList.add(expression2);
        if (label.getPosition() == -1) {
            label.getOperationsToFix().add(TuplesKt.to(this.instructions.size() + 1, operation));
            this.instructions.add(Integer.MIN_VALUE);
        } else {
            this.instructions.add(operation.encoding(label.getPosition()));
        }
    }

    public final void emit(@NotNull Label label) {
        boolean bl;
        Intrinsics.checkNotNullParameter(label, "label");
        boolean bl2 = bl = label.getPosition() == -1;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-InstructionGenerator$emit$32 = false;
            String $i$a$-assert-InstructionGenerator$emit$32 = "Label was already emitted";
            throw new AssertionError((Object)$i$a$-assert-InstructionGenerator$emit$32);
        }
        label.setPosition(this.instructions.size() + 1);
        for (Pair<Integer, ParsingOperation> pair : label.getOperationsToFix()) {
            boolean bl3;
            boolean bl4 = bl3 = ((Number)this.instructions.get(((Number)pair.getFirst()).intValue() - 1)).intValue() == Integer.MIN_VALUE;
            if (_Assertions.ENABLED && !bl3) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            if (((Number)pair.getFirst()).intValue() + 1 == label.getPosition()) {
                System.out.println((Object)"DEBUG: Operation target falls through.");
            }
            this.instructions.set(((Number)pair.getFirst()).intValue() - 1, pair.getSecond().encoding(label.getPosition()));
        }
        label.getOperationsToFix().clear();
    }

    public final void emitJumpForward(@NotNull Expression expression2, @NotNull Label label) {
        boolean bl;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(label, "label");
        boolean bl2 = bl = label.getPosition() == -1;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Forward jumps must actually be forward";
            throw new AssertionError((Object)string2);
        }
        this.expressionList.add(expression2);
        label.getOperationsToFix().add(TuplesKt.to(this.instructions.size() + 1, ParsingOperation.JUMP_FORWARD));
        this.instructions.add(Integer.MIN_VALUE);
    }

    public final void emitJumpBackward(@NotNull Expression expression2, @NotNull Label label) {
        boolean bl;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(label, "label");
        boolean bl2 = bl = label.getPosition() != -1;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Backward jumps must actually be backward";
            throw new AssertionError((Object)string2);
        }
        this.expressionList.add(expression2);
        this.instructions.add(ParsingOperation.JUMP_BACKWARD.encoding(label.getPosition()));
    }

    public final void emitBranchForward(@NotNull Expression expression2, @NotNull Label label) {
        boolean bl;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(label, "label");
        boolean bl2 = bl = label.getPosition() == -1;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Branches must be forward";
            throw new AssertionError((Object)string2);
        }
        this.expressionList.add(expression2);
        label.getOperationsToFix().add(TuplesKt.to(this.instructions.size() + 1, ParsingOperation.BRANCH_FORWARD));
        this.instructions.add(Integer.MIN_VALUE);
    }

    public final void emitDelayed(@NotNull Expression expression2, @NotNull ParsingOperation operation) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter((Object)operation, "operation");
        this.delayedExpressionList.add(expression2);
        this.delayedArgumentInstructions.add(operation.getEncoding());
    }

    public final void emitDelayed(@NotNull Expression expression2, @NotNull ParsingOperation operation, int operand) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter((Object)operation, "operation");
        this.delayedExpressionList.add(expression2);
        this.delayedArgumentInstructions.add(operation.encoding(operand));
    }

    public final void flushDelayed() {
        if (!((Collection)this.delayedArgumentInstructions).isEmpty()) {
            this.expressionList.addAll((Collection<Expression>)this.delayedExpressionList);
            this.instructions.addAll((Collection<Integer>)this.delayedArgumentInstructions);
            this.delayedExpressionList.clear();
            this.delayedArgumentInstructions.clear();
        }
    }

    public final void emitWrapped(@NotNull Expression expression2, int listSize) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        boolean bl = this.delayedArgumentInstructions.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        boolean bl2 = bl = listSize >= 0;
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        if (listSize == 0) {
            this.emit(expression2, ParsingOperation.EMPTY_LIST);
        } else {
            this.emit(expression2, ParsingOperation.WRAP_IN_LIST, listSize);
        }
    }

    public final void optimizeInstructions() {
        this.hoistTokenParsing();
    }

    private final void hoistTokenParsing() {
        int instructionsCount = this.instructions.size();
        BitSet branchTargets = new BitSet(instructionsCount);
        Iterator<Integer> iterator2 = this.instructions.iterator();
        while (iterator2.hasNext()) {
            int instruction2 = ((Number)iterator2.next()).intValue();
            ParsingOperation operation = ParsingOperation.Companion.decode(instruction2);
            if (operation != ParsingOperation.JUMP_FORWARD && operation != ParsingOperation.JUMP_BACKWARD && operation != ParsingOperation.BRANCH_FORWARD) continue;
            int target = ParsingOperation.Companion.operand(instruction2) - 1;
            branchTargets.set(target);
        }
        boolean changed = true;
        while (changed) {
            changed = false;
            for (int i2 = instructionsCount - 1; 0 < i2; --i2) {
                int priorInstruction;
                ParsingOperation priorOperation;
                int instruction3;
                ParsingOperation operation;
                if (branchTargets.get(i2) || (operation = ParsingOperation.Companion.decode(instruction3 = ((Number)this.instructions.get(i2)).intValue())) != ParsingOperation.PARSE_PART && operation != ParsingOperation.PARSE_PART_CASE_INSENSITIVELY || !(priorOperation = ParsingOperation.Companion.decode(priorInstruction = ((Number)this.instructions.get(i2 - 1)).intValue())).getCommutesWithParsePart()) continue;
                this.instructions.set(i2, priorInstruction);
                this.instructions.set(i2 - 1, instruction3);
                Expression temp = this.expressionList.get(i2);
                this.expressionList.set(i2, this.expressionList.get(i2 - 1));
                this.expressionList.set(i2 - 1, temp);
                changed = true;
            }
        }
    }

    @NotNull
    public final A_Tuple instructionsTuple() {
        boolean bl;
        boolean bl2 = bl = !this.instructions.contains(Integer.MIN_VALUE);
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "A placeholder instruction using a label was not resolved";
            throw new AssertionError((Object)string2);
        }
        boolean bl4 = bl = this.instructions.size() == this.expressionList.size();
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        bl = this.delayedExpressionList.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string4 = "Assertion failed";
            throw new AssertionError((Object)string4);
        }
        return TupleDescriptor.Companion.tupleFromIntegerList(this.instructions).makeShared();
    }

    @NotNull
    public final List<Expression> expressionList() {
        boolean bl;
        boolean bl2 = bl = this.instructions.size() == this.expressionList.size();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        List<Expression> list2 = Collections.unmodifiableList(this.expressionList);
        Intrinsics.checkNotNullExpressionValue(list2, "unmodifiableList(...)");
        return list2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lavail/compiler/splitter/InstructionGenerator$Companion;", "", "()V", "placeholderInstruction", "", "avail"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005R#\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lavail/compiler/splitter/InstructionGenerator$Label;", "", "()V", "isUsed", "", "()Z", "operationsToFix", "", "Lkotlin/Pair;", "", "Lavail/compiler/ParsingOperation;", "getOperationsToFix", "()Ljava/util/List;", "position", "getPosition", "()I", "setPosition", "(I)V", "avail"})
    public static final class Label {
        private int position = -1;
        @NotNull
        private final List<Pair<Integer, ParsingOperation>> operationsToFix = new ArrayList();

        public final int getPosition() {
            return this.position;
        }

        public final void setPosition(int n) {
            this.position = n;
        }

        @NotNull
        public final List<Pair<Integer, ParsingOperation>> getOperationsToFix() {
            return this.operationsToFix;
        }

        public final boolean isUsed() {
            return this.position != -1 || !((Collection)this.operationsToFix).isEmpty();
        }
    }
}

