/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.files;

import avail.AvailRuntime;
import avail.descriptor.atoms.A_Atom;
import avail.descriptor.atoms.AtomDescriptor;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.pojos.RawPojoDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.sets.A_Set;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.SetTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.io.IOSystem;
import java.io.IOException;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001f\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0014H\u0014R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lavail/interpreter/primitive/files/P_FileOpen;", "Lavail/interpreter/Primitive;", "()V", "allStandardOpenOptions", "", "Ljava/nio/file/StandardOpenOption;", "[Ljava/nio/file/StandardOpenOption;", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "openOptionsFor", "", "Ljava/nio/file/OpenOption;", "optionInts", "Lavail/descriptor/sets/A_Set;", "permissionsFor", "Ljava/nio/file/attribute/FileAttribute;", "(Lavail/descriptor/sets/A_Set;)[Ljava/nio/file/attribute/FileAttribute;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
@SourceDebugExtension(value={"SMAP\nP_FileOpen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 P_FileOpen.kt\navail/interpreter/primitive/files/P_FileOpen\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,242:1\n37#2,2:243\n*S KotlinDebug\n*F\n+ 1 P_FileOpen.kt\navail/interpreter/primitive/files/P_FileOpen\n*L\n193#1:243,2\n*E\n"})
public final class P_FileOpen
extends Primitive {
    @NotNull
    public static final P_FileOpen INSTANCE = new P_FileOpen();
    @NotNull
    private static final StandardOpenOption[] allStandardOpenOptions;

    private P_FileOpen() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline, Primitive.Flag.HasSideEffect};
        super(4, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        AsynchronousFileChannel asynchronousFileChannel;
        Path path;
        boolean bl;
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(4);
        AvailObject filename = interpreter.argument(0);
        AvailObject alignment = interpreter.argument(1);
        AvailObject options = interpreter.argument(2);
        AvailObject permissions = interpreter.argument(3);
        if (!A_Number.Companion.isInt(alignment)) {
            return interpreter.primitiveFailure(AvailErrorCode.E_EXCEEDS_VM_LIMIT);
        }
        int alignmentInt = A_Number.Companion.getExtractInt(alignment);
        if (alignmentInt == 0) {
            alignmentInt = 4096;
        }
        boolean bl2 = bl = alignmentInt > 0;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        IOSystem ioSystem = AvailRuntime.Companion.currentRuntime().getIoSystem();
        Set<OpenOption> fileOptions = this.openOptionsFor(options);
        FileAttribute<?>[] fileAttributes = this.permissionsFor(permissions);
        if (!fileOptions.contains(StandardOpenOption.READ) && !fileOptions.contains(StandardOpenOption.WRITE)) {
            return interpreter.primitiveFailure(AvailErrorCode.E_ILLEGAL_OPTION);
        }
        try {
            path = IOSystem.Companion.getFileSystem().getPath(A_String.Companion.asNativeString(filename), new String[0]);
            Intrinsics.checkNotNull(path);
        }
        catch (InvalidPathException e) {
            return interpreter.primitiveFailure(AvailErrorCode.E_INVALID_PATH);
        }
        Path path2 = path;
        AvailObject atom = AtomDescriptor.Companion.createAtom(filename, NilDescriptor.Companion.getNil());
        try {
            asynchronousFileChannel = ioSystem.openFile(path2, fileOptions, Arrays.copyOf(fileAttributes, fileAttributes.length));
        }
        catch (IllegalArgumentException e) {
            return interpreter.primitiveFailure(AvailErrorCode.E_ILLEGAL_OPTION);
        }
        catch (UnsupportedOperationException e) {
            return interpreter.primitiveFailure(AvailErrorCode.E_OPERATION_NOT_SUPPORTED);
        }
        catch (SecurityException e) {
            return interpreter.primitiveFailure(AvailErrorCode.E_PERMISSION_DENIED);
        }
        catch (AccessDeniedException e) {
            return interpreter.primitiveFailure(AvailErrorCode.E_PERMISSION_DENIED);
        }
        catch (IOException e) {
            return interpreter.primitiveFailure(AvailErrorCode.E_IO_ERROR);
        }
        AsynchronousFileChannel channel = asynchronousFileChannel;
        IOSystem.FileHandle fileHandle = new IOSystem.FileHandle(filename, alignmentInt, fileOptions.contains(StandardOpenOption.READ), fileOptions.contains(StandardOpenOption.WRITE), channel);
        AvailObject pojo2 = RawPojoDescriptor.Companion.identityPojo(fileHandle);
        A_Atom.Companion.setAtomProperty(atom, AtomDescriptor.SpecialAtom.FILE_KEY.getAtom(), pojo2);
        return interpreter.primitiveSuccess(atom);
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(TupleTypeDescriptor.Companion.getStringType(), IntegerRangeTypeDescriptor.Companion.getWholeNumbers(), SetTypeDescriptor.Companion.setTypeForSizesContentType(IntegerRangeTypeDescriptor.Companion.getWholeNumbers(), IntegerRangeTypeDescriptor.Companion.inclusive(0L, 9L)), SetTypeDescriptor.Companion.setTypeForSizesContentType(IntegerRangeTypeDescriptor.Companion.getWholeNumbers(), IntegerRangeTypeDescriptor.Companion.inclusive(1L, 9L))), PrimitiveTypeDescriptor.Types.ATOM.getO(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_EXCEEDS_VM_LIMIT, AvailErrorCode.E_INVALID_PATH, AvailErrorCode.E_ILLEGAL_OPTION, AvailErrorCode.E_OPERATION_NOT_SUPPORTED, AvailErrorCode.E_PERMISSION_DENIED, AvailErrorCode.E_IO_ERROR};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }

    private final Set<OpenOption> openOptionsFor(A_Set optionInts) {
        EnumSet<StandardOpenOption> options = EnumSet.noneOf(StandardOpenOption.class);
        for (AvailObject optionInt : optionInts) {
            options.add(allStandardOpenOptions[A_Number.Companion.getExtractInt(optionInt)]);
        }
        Intrinsics.checkNotNull(options);
        return options;
    }

    private final FileAttribute<?>[] permissionsFor(A_Set optionInts) {
        FileAttribute[] fileAttributeArray;
        if (IOSystem.Companion.getFileSystem().supportedFileAttributeViews().contains("posix")) {
            PosixFilePermission[] allPermissions = IOSystem.Companion.getPosixPermissions();
            EnumSet<PosixFilePermission> permissions = EnumSet.noneOf(PosixFilePermission.class);
            for (AvailObject optionInt : optionInts) {
                permissions.add(allPermissions[A_Number.Companion.getExtractInt(optionInt) - 1]);
            }
            FileAttribute[] fileAttributeArray2 = new FileAttribute[1];
            Intrinsics.checkNotNullExpressionValue(PosixFilePermissions.asFileAttribute((Set<PosixFilePermission>)permissions), "asFileAttribute(...)");
            fileAttributeArray = fileAttributeArray2;
        } else {
            fileAttributeArray = new FileAttribute[]{};
        }
        return fileAttributeArray;
    }

    static {
        Collection $this$toTypedArray$iv = EntriesMappings.entries$0;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        allStandardOpenOptions = thisCollection$iv.toArray(new StandardOpenOption[0]);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<StandardOpenOption> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])StandardOpenOption.values());
        }
    }
}

