/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.maps;

import avail.descriptor.maps.A_Map;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.MapTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.exceptions.AvailException;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J(\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0015"}, d2={"Lavail/interpreter/primitive/maps/P_MapReplacingNAryKey;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "recursivelyUpdateMap", "Lavail/descriptor/maps/A_Map;", "targetMap", "pathTuple", "Lavail/descriptor/tuples/A_Tuple;", "pathIndex", "", "newValue", "Lavail/descriptor/representation/A_BasicObject;", "recursivelyUpdateTuple", "targetTuple", "avail"})
public final class P_MapReplacingNAryKey
extends Primitive {
    @NotNull
    public static final P_MapReplacingNAryKey INSTANCE = new P_MapReplacingNAryKey();

    private P_MapReplacingNAryKey() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline, Primitive.Flag.CanFold};
        super(3, flagArray);
    }

    private final A_Tuple recursivelyUpdateTuple(A_Tuple targetTuple, A_Tuple pathTuple, int pathIndex, A_BasicObject newValue) throws AvailException {
        int targetIndex = A_Number.Companion.getExtractInt(A_Tuple.Companion.tupleAt(pathTuple, pathIndex));
        if (targetIndex > A_Tuple.Companion.getTupleSize(targetTuple)) {
            throw new AvailException(AvailErrorCode.E_SUBSCRIPT_OUT_OF_BOUNDS, null, 2, null);
        }
        if (pathIndex == A_Tuple.Companion.getTupleSize(pathTuple)) {
            return A_Tuple.Companion.tupleAtPuttingCanDestroy(targetTuple, targetIndex, newValue, true);
        }
        AvailObject subtuple = A_Tuple.Companion.tupleAt(targetTuple, targetIndex);
        if (subtuple.isTuple()) {
            A_Tuple newTuple2 = this.recursivelyUpdateTuple(subtuple, pathTuple, pathIndex + 1, newValue);
            return A_Tuple.Companion.tupleAtPuttingCanDestroy(targetTuple, targetIndex, newTuple2, true);
        }
        if (subtuple.isMap()) {
            A_Map newMap = this.recursivelyUpdateMap(subtuple, pathTuple, pathIndex + 1, newValue);
            return A_Tuple.Companion.tupleAtPuttingCanDestroy(targetTuple, targetIndex, newMap, true);
        }
        throw new AvailException(AvailErrorCode.E_INCORRECT_ARGUMENT_TYPE, null, 2, null);
    }

    private final A_Map recursivelyUpdateMap(A_Map targetMap, A_Tuple pathTuple, int pathIndex, A_BasicObject newValue) throws AvailException {
        AvailObject targetIndex = A_Tuple.Companion.tupleAt(pathTuple, pathIndex);
        AvailObject availObject = A_Map.Companion.mapAtOrNull(targetMap, targetIndex);
        if (availObject == null) {
            throw new AvailException(AvailErrorCode.E_KEY_NOT_FOUND, null, 2, null);
        }
        AvailObject targetElement = availObject;
        if (pathIndex == A_Tuple.Companion.getTupleSize(pathTuple)) {
            return A_Map.Companion.mapAtPuttingCanDestroy(targetMap, targetIndex, newValue, true);
        }
        if (targetElement.isTuple()) {
            A_Tuple newTuple2 = this.recursivelyUpdateTuple(targetElement, pathTuple, pathIndex + 1, newValue);
            return A_Map.Companion.mapAtPuttingCanDestroy(targetMap, targetIndex, newTuple2, true);
        }
        if (targetElement.isMap()) {
            A_Map newMap = this.recursivelyUpdateMap(targetElement, pathTuple, pathIndex + 1, newValue);
            return A_Map.Companion.mapAtPuttingCanDestroy(targetMap, targetIndex, newMap, true);
        }
        throw new AvailException(AvailErrorCode.E_INCORRECT_ARGUMENT_TYPE, null, 2, null);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Primitive.Result result2;
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(3);
        AvailObject map = interpreter.argument(0);
        AvailObject pathTuple = interpreter.argument(1);
        AvailObject newValue = interpreter.argument(2);
        try {
            result2 = interpreter.primitiveSuccess(this.recursivelyUpdateMap(map, pathTuple, 1, newValue));
        }
        catch (AvailException e) {
            result2 = interpreter.primitiveFailure(e);
        }
        return result2;
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(MapTypeDescriptor.Companion.mostGeneralMapType(), TupleTypeDescriptor.Companion.oneOrMoreOf(PrimitiveTypeDescriptor.Types.ANY.getO()), PrimitiveTypeDescriptor.Types.ANY.getO()), MapTypeDescriptor.Companion.mostGeneralMapType(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_SUBSCRIPT_OUT_OF_BOUNDS, AvailErrorCode.E_INCORRECT_ARGUMENT_TYPE, AvailErrorCode.E_KEY_NOT_FOUND};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }
}

