/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.methods;

import avail.AvailRuntime;
import avail.descriptor.atoms.A_Atom;
import avail.descriptor.bundles.A_Bundle;
import avail.descriptor.fiber.A_Fiber;
import avail.descriptor.methods.A_Method;
import avail.descriptor.methods.A_Sendable;
import avail.descriptor.module.A_Module;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.SetTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.exceptions.AvailRuntimeException;
import avail.exceptions.MalformedMessageException;
import avail.interpreter.Primitive;
import avail.interpreter.execution.AvailLoader;
import avail.interpreter.execution.Interpreter;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014\u00a8\u0006\n"}, d2={"Lavail/interpreter/primitive/methods/P_SealMethodsAtExistingDefinitions;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
@SourceDebugExtension(value={"SMAP\nP_SealMethodsAtExistingDefinitions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 P_SealMethodsAtExistingDefinitions.kt\navail/interpreter/primitive/methods/P_SealMethodsAtExistingDefinitions\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,138:1\n1#2:139\n*E\n"})
public final class P_SealMethodsAtExistingDefinitions
extends Primitive {
    @NotNull
    public static final P_SealMethodsAtExistingDefinitions INSTANCE = new P_SealMethodsAtExistingDefinitions();

    private P_SealMethodsAtExistingDefinitions() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline, Primitive.Flag.HasSideEffect};
        super(1, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(1);
        AvailObject methodNames = interpreter.argument(0);
        AvailLoader availLoader = A_Fiber.Companion.getAvailLoader(interpreter.fiber());
        if (availLoader == null) {
            return interpreter.primitiveFailure(AvailErrorCode.E_LOADING_IS_OVER);
        }
        AvailLoader loader = availLoader;
        if (!loader.getPhase().isExecuting()) {
            return interpreter.primitiveFailure(AvailErrorCode.E_CANNOT_DEFINE_DURING_COMPILATION);
        }
        AvailRuntime runtime = interpreter.runtime;
        A_Module module = interpreter.module();
        for (AvailObject name : methodNames) {
            A_Bundle bundle = A_Atom.Companion.getBundleOrNil(name);
            if (!bundle.getNotNil()) continue;
            A_Method method = A_Bundle.Companion.getBundleMethod(bundle);
            A_Tuple definitions = A_Method.Companion.getDefinitionsTuple(method);
            for (AvailObject definition : definitions) {
                if (A_Sendable.Companion.isForwardDefinition(definition)) continue;
                A_Type function = A_Sendable.Companion.bodySignature(definition);
                A_Type params = A_Type.Companion.getArgsTupleType(function);
                A_Tuple signature2 = A_Type.Companion.tupleOfTypesFromTo(params, 1, A_Method.Companion.getNumArgs(method));
                try {
                    runtime.addSeal(name, signature2);
                    A_Module.Companion.addSeal(module, name, signature2);
                }
                catch (MalformedMessageException e) {
                    if (_Assertions.ENABLED) {
                        boolean bl = false;
                        String string2 = "This should not happen!";
                        throw new AssertionError((Object)string2);
                    }
                    throw new AvailRuntimeException(e.getErrorCode());
                }
            }
        }
        return interpreter.primitiveSuccess(NilDescriptor.Companion.getNil());
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(SetTypeDescriptor.Companion.setTypeForSizesContentType(IntegerRangeTypeDescriptor.Companion.getWholeNumbers(), PrimitiveTypeDescriptor.Types.ATOM.getO())), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_LOADING_IS_OVER, AvailErrorCode.E_CANNOT_DEFINE_DURING_COMPILATION};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }
}

