/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.numbers;

import avail.descriptor.atoms.AtomDescriptor;
import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.numbers.AbstractNumberDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.EnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.levelTwo.operand.L2ConstantOperand;
import avail.interpreter.levelTwo.operand.L2Operand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedOperand;
import avail.interpreter.levelTwo.operation.L2_JUMP_IF_GREATER_THAN_CONSTANT;
import avail.interpreter.levelTwo.operation.L2_JUMP_IF_LESS_THAN_CONSTANT;
import avail.interpreter.levelTwo.operation.L2_JUMP_IF_LESS_THAN_OBJECT;
import avail.optimizer.L1Translator;
import avail.optimizer.L2BasicBlock;
import avail.optimizer.L2Generator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\rH\u0016JH\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\r2\u0006\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u00060\u0016R\u00020\u0014H\u0016\u00a8\u0006\u0017"}, d2={"Lavail/interpreter/primitive/numbers/P_LessThan;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "returnTypeGuaranteedByVM", "rawFunction", "Lavail/descriptor/functions/A_RawFunction;", "argumentTypes", "", "tryToGenerateSpecialPrimitiveInvocation", "", "functionToCallReg", "Lavail/interpreter/levelTwo/operand/L2ReadBoxedOperand;", "arguments", "translator", "Lavail/optimizer/L1Translator;", "callSiteHelper", "Lavail/optimizer/L1Translator$CallSiteHelper;", "avail"})
public final class P_LessThan
extends Primitive {
    @NotNull
    public static final P_LessThan INSTANCE = new P_LessThan();

    private P_LessThan() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CannotFail, Primitive.Flag.CanFold, Primitive.Flag.CanInline};
        super(2, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(2);
        AvailObject a = interpreter.argument(0);
        AvailObject b = interpreter.argument(1);
        return interpreter.primitiveSuccess(AtomDescriptor.Companion.objectFromBoolean(A_Number.Companion.lessThan(a, b)));
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(PrimitiveTypeDescriptor.Types.NUMBER.getO(), PrimitiveTypeDescriptor.Types.NUMBER.getO()), EnumerationTypeDescriptor.Companion.getBooleanType(), null, 4, null);
    }

    @Override
    @NotNull
    public A_Type returnTypeGuaranteedByVM(@NotNull A_RawFunction rawFunction2, @NotNull List<? extends A_Type> argumentTypes) {
        boolean bl;
        Intrinsics.checkNotNullParameter(rawFunction2, "rawFunction");
        Intrinsics.checkNotNullParameter(argumentTypes, "argumentTypes");
        A_Type type1 = argumentTypes.get(0);
        A_Type type2 = argumentTypes.get(1);
        Set<AbstractNumberDescriptor.Order> possible = AbstractNumberDescriptor.Companion.possibleOrdersWhenComparingInstancesOf(type1, type2);
        boolean canBeTrue = possible.contains((Object)AbstractNumberDescriptor.Order.LESS);
        boolean canBeFalse = possible.contains((Object)AbstractNumberDescriptor.Order.EQUAL) || possible.contains((Object)AbstractNumberDescriptor.Order.MORE) || possible.contains((Object)AbstractNumberDescriptor.Order.INCOMPARABLE);
        boolean bl2 = bl = canBeTrue || canBeFalse;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        return canBeTrue ? (canBeFalse ? EnumerationTypeDescriptor.Companion.getBooleanType() : EnumerationTypeDescriptor.Companion.getTrueType()) : EnumerationTypeDescriptor.Companion.getFalseType();
    }

    @Override
    public boolean tryToGenerateSpecialPrimitiveInvocation(@NotNull L2ReadBoxedOperand functionToCallReg, @NotNull A_RawFunction rawFunction2, @NotNull List<L2ReadBoxedOperand> arguments2, @NotNull List<? extends A_Type> argumentTypes, @NotNull L1Translator translator, @NotNull L1Translator.CallSiteHelper callSiteHelper) {
        boolean bl;
        Intrinsics.checkNotNullParameter(functionToCallReg, "functionToCallReg");
        Intrinsics.checkNotNullParameter(rawFunction2, "rawFunction");
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        Intrinsics.checkNotNullParameter(argumentTypes, "argumentTypes");
        Intrinsics.checkNotNullParameter(translator, "translator");
        Intrinsics.checkNotNullParameter(callSiteHelper, "callSiteHelper");
        L2ReadBoxedOperand firstReg = arguments2.get(0);
        L2ReadBoxedOperand secondReg = arguments2.get(1);
        A_Type firstType = firstReg.type();
        A_Type secondType = secondReg.type();
        L2Generator generator = translator.getGenerator();
        Set<AbstractNumberDescriptor.Order> possible = AbstractNumberDescriptor.Companion.possibleOrdersWhenComparingInstancesOf(firstType, secondType);
        boolean canBeTrue = possible.contains((Object)AbstractNumberDescriptor.Order.LESS);
        boolean canBeFalse = possible.contains((Object)AbstractNumberDescriptor.Order.EQUAL) || possible.contains((Object)AbstractNumberDescriptor.Order.MORE) || possible.contains((Object)AbstractNumberDescriptor.Order.INCOMPARABLE);
        boolean bl2 = bl = canBeTrue || canBeFalse;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        if (!canBeTrue || !canBeFalse) {
            callSiteHelper.useAnswer(generator.boxedConstant(AtomDescriptor.Companion.objectFromBoolean(canBeTrue)));
            return true;
        }
        AvailObject firstConstant = firstReg.constantOrNull();
        AvailObject secondConstant = secondReg.constantOrNull();
        L2BasicBlock truePath = generator.createBasicBlock("true path");
        L2BasicBlock falsePath = generator.createBasicBlock("false path");
        if (secondConstant != null) {
            L2Operand[] l2OperandArray = new L2Operand[]{firstReg, new L2ConstantOperand(secondConstant), L2Generator.Companion.edgeTo(truePath), L2Generator.Companion.edgeTo(falsePath)};
            generator.addInstruction(L2_JUMP_IF_LESS_THAN_CONSTANT.INSTANCE, l2OperandArray);
        } else if (firstConstant != null) {
            L2Operand[] l2OperandArray = new L2Operand[]{secondReg, new L2ConstantOperand(firstConstant), L2Generator.Companion.edgeTo(truePath), L2Generator.Companion.edgeTo(falsePath)};
            generator.addInstruction(L2_JUMP_IF_GREATER_THAN_CONSTANT.INSTANCE, l2OperandArray);
        } else {
            L2Operand[] l2OperandArray = new L2Operand[]{firstReg, secondReg, L2Generator.Companion.edgeTo(truePath), L2Generator.Companion.edgeTo(falsePath)};
            generator.addInstruction(L2_JUMP_IF_LESS_THAN_OBJECT.INSTANCE, l2OperandArray);
        }
        L2Generator.startBlock$default(generator, truePath, false, null, 6, null);
        callSiteHelper.useAnswer(generator.boxedConstant(AtomDescriptor.Companion.getTrueObject()));
        L2Generator.startBlock$default(generator, falsePath, false, null, 6, null);
        callSiteHelper.useAnswer(generator.boxedConstant(AtomDescriptor.Companion.getFalseObject()));
        return true;
    }
}

