/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.sockets;

import avail.AvailRuntime;
import avail.descriptor.atoms.A_Atom;
import avail.descriptor.atoms.AtomDescriptor;
import avail.descriptor.fiber.A_Fiber;
import avail.descriptor.fiber.FiberDescriptor;
import avail.descriptor.module.A_Module;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.pojos.RawPojoDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.StringDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FiberTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.InstanceTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.io.SimpleCompletionHandler;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014\u00a8\u0006\n"}, d2={"Lavail/interpreter/primitive/sockets/P_ServerSocketAccept;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
public final class P_ServerSocketAccept
extends Primitive {
    @NotNull
    public static final P_ServerSocketAccept INSTANCE = new P_ServerSocketAccept();

    private P_ServerSocketAccept() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline, Primitive.Flag.HasSideEffect};
        super(5, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Primitive.Result result2;
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(5);
        AvailObject handle2 = interpreter.argument(0);
        AvailObject name = interpreter.argument(1);
        AvailObject succeed2 = interpreter.argument(2);
        AvailObject fail2 = interpreter.argument(3);
        AvailObject priority = interpreter.argument(4);
        AvailObject pojo2 = A_Atom.Companion.getAtomProperty(handle2, AtomDescriptor.SpecialAtom.SERVER_SOCKET_KEY.getAtom());
        if (pojo2.isNil()) {
            return interpreter.primitiveFailure(A_Atom.Companion.isAtomSpecial(handle2) ? AvailErrorCode.E_SPECIAL_ATOM : AvailErrorCode.E_INVALID_HANDLE);
        }
        AsynchronousServerSocketChannel socket = (AsynchronousServerSocketChannel)pojo2.javaObjectNotNull();
        A_Fiber current = interpreter.fiber();
        A_Fiber newFiber2 = FiberDescriptor.Companion.newFiber$default(FiberDescriptor.Companion, A_Type.Companion.typeUnion(A_Type.Companion.getReturnType(succeed2.kind()), A_Type.Companion.getReturnType(fail2.kind())), interpreter.runtime, A_Fiber.Companion.getTextInterface(current), A_Number.Companion.getExtractInt(priority), null, new Function0<A_String>(name){
            final /* synthetic */ AvailObject $name;
            {
                this.$name = $name;
                super(0);
            }

            @NotNull
            public final A_String invoke() {
                Object[] objectArray = new Object[]{this.$name};
                return StringDescriptor.Companion.formatString("Server socket accept, name=%s", objectArray);
            }
        }, 16, null);
        A_Fiber.Companion.setAvailLoader(newFiber2, A_Fiber.Companion.getAvailLoader(current));
        A_Fiber.Companion.setHeritableFiberGlobals(newFiber2, A_Fiber.Companion.getHeritableFiberGlobals(current).makeShared());
        newFiber2.makeShared();
        succeed2.makeShared();
        fail2.makeShared();
        AvailRuntime runtime = AvailRuntime.Companion.currentRuntime();
        try {
            A_Module module = interpreter.module();
            socket.accept(Unit.INSTANCE, new SimpleCompletionHandler((Function1)new Function1<SimpleCompletionHandler.Companion.SuccessHelper<AsynchronousSocketChannel>, Unit>(name, module, runtime, newFiber2, succeed2){
                final /* synthetic */ AvailObject $name;
                final /* synthetic */ A_Module $module;
                final /* synthetic */ AvailRuntime $runtime;
                final /* synthetic */ A_Fiber $newFiber;
                final /* synthetic */ AvailObject $succeed;
                {
                    this.$name = $name;
                    this.$module = $module;
                    this.$runtime = $runtime;
                    this.$newFiber = $newFiber;
                    this.$succeed = $succeed;
                    super(1);
                }

                public final void invoke(@NotNull SimpleCompletionHandler.Companion.SuccessHelper<AsynchronousSocketChannel> $this$$receiver) {
                    Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                    AvailObject newHandle = AtomDescriptor.Companion.createAtom(this.$name, this.$module);
                    AvailObject newPojo = RawPojoDescriptor.Companion.identityPojo($this$$receiver.getValue());
                    A_Atom.Companion.setAtomProperty(newHandle, AtomDescriptor.SpecialAtom.SOCKET_KEY.getAtom(), newPojo);
                    this.$runtime.runOutermostFunction(this.$newFiber, this.$succeed, CollectionsKt.listOf(newHandle), false);
                }
            }, (Function1)new Function1<SimpleCompletionHandler.Companion.FailureHelper<AsynchronousSocketChannel>, Unit>(runtime, newFiber2, fail2){
                final /* synthetic */ AvailRuntime $runtime;
                final /* synthetic */ A_Fiber $newFiber;
                final /* synthetic */ AvailObject $fail;
                {
                    this.$runtime = $runtime;
                    this.$newFiber = $newFiber;
                    this.$fail = $fail;
                    super(1);
                }

                public final void invoke(@NotNull SimpleCompletionHandler.Companion.FailureHelper<AsynchronousSocketChannel> $this$$receiver) {
                    Intrinsics.checkNotNullParameter($this$$receiver, "$this$$receiver");
                    this.$runtime.runOutermostFunction(this.$newFiber, this.$fail, CollectionsKt.listOf(AvailErrorCode.E_IO_ERROR.numericCode()), false);
                }
            }));
            result2 = interpreter.primitiveSuccess(newFiber2);
        }
        catch (Throwable e) {
            result2 = interpreter.primitiveFailure(AvailErrorCode.E_IO_ERROR);
        }
        return result2;
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(PrimitiveTypeDescriptor.Types.ATOM.getO(), TupleTypeDescriptor.Companion.getNonemptyStringType(), FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(PrimitiveTypeDescriptor.Types.ATOM.getO()), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null), FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(InstanceTypeDescriptor.Companion.instanceType(AvailErrorCode.E_IO_ERROR.numericCode())), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null), IntegerRangeTypeDescriptor.Companion.getU8()), FiberTypeDescriptor.Companion.mostGeneralFiberType(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_INVALID_HANDLE, AvailErrorCode.E_SPECIAL_ATOM, AvailErrorCode.E_IO_ERROR};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }
}

