/*
 * Decompiled with CFR 0.152.
 */
package avail.io;

import avail.AvailRuntime;
import avail.AvailRuntimeConfiguration;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.A_Tuple;
import avail.io.IOSystem;
import avail.utility.Mutable;
import avail.utility.SimpleThreadFactory;
import java.io.IOException;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.availlang.cache.LRUCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 -2\u00020\u0001:\u0003,-.B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0005J\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015J\u0015\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0017J\u0016\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00062\u0006\u0010\u0012\u001a\u00020\u0005J=\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u001a\u0010 \u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\"0!\"\u0006\u0012\u0002\b\u00030\"\u00a2\u0006\u0002\u0010#JE\u0010$\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020&2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u001a\u0010 \u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\"0!\"\u0006\u0012\u0002\b\u00030\"\u00a2\u0006\u0002\u0010'J\u0006\u0010(\u001a\u00020)J\u0006\u0010*\u001a\u00020+R\"\u0010\u0003\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lavail/io/IOSystem;", "", "()V", "cachedBuffers", "Lorg/availlang/cache/LRUCache;", "Lavail/io/IOSystem$BufferKey;", "Lavail/utility/Mutable;", "Lavail/descriptor/tuples/A_Tuple;", "fileExecutor", "Ljava/util/concurrent/ThreadPoolExecutor;", "getFileExecutor", "()Ljava/util/concurrent/ThreadPoolExecutor;", "socketExecutor", "socketGroup", "Ljava/nio/channels/AsynchronousChannelGroup;", "destroy", "", "discardBuffer", "key", "executeFileTask", "task", "Ljava/lang/Runnable;", "executeSocketTask", "executeSocketTask$avail", "getBuffer", "openFile", "Ljava/nio/channels/AsynchronousFileChannel;", "path", "Ljava/nio/file/Path;", "options", "", "Ljava/nio/file/OpenOption;", "attributes", "", "Ljava/nio/file/attribute/FileAttribute;", "(Ljava/nio/file/Path;Ljava/util/Set;[Ljava/nio/file/attribute/FileAttribute;)Ljava/nio/channels/AsynchronousFileChannel;", "openFileWithAvailThread", "runtime", "Lavail/AvailRuntime;", "(Ljava/nio/file/Path;Lavail/AvailRuntime;Ljava/util/Set;[Ljava/nio/file/attribute/FileAttribute;)Ljava/nio/channels/AsynchronousFileChannel;", "openServerSocket", "Ljava/nio/channels/AsynchronousServerSocketChannel;", "openSocket", "Ljava/nio/channels/AsynchronousSocketChannel;", "BufferKey", "Companion", "FileHandle", "avail"})
public final class IOSystem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ThreadPoolExecutor fileExecutor = new ThreadPoolExecutor(AvailRuntimeConfiguration.INSTANCE.getAvailableProcessors(), AvailRuntimeConfiguration.INSTANCE.getAvailableProcessors() << 2, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue(), new SimpleThreadFactory("AvailFile"), new ThreadPoolExecutor.CallerRunsPolicy());
    @NotNull
    private final ThreadPoolExecutor socketExecutor = new ThreadPoolExecutor(AvailRuntimeConfiguration.INSTANCE.getAvailableProcessors(), AvailRuntimeConfiguration.INSTANCE.getAvailableProcessors() << 2, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue(), new SimpleThreadFactory("AvailSocket"), new ThreadPoolExecutor.CallerRunsPolicy());
    @NotNull
    private final LRUCache<BufferKey, Mutable<A_Tuple>> cachedBuffers = new LRUCache(10000, 10, cachedBuffers.1.INSTANCE, cachedBuffers.2.INSTANCE);
    @NotNull
    private final AsynchronousChannelGroup socketGroup;
    @NotNull
    private static final FileSystem fileSystem;
    @NotNull
    private static final LinkOption[] followSymlinks;
    @NotNull
    private static final LinkOption[] doNotFollowSymbolicLinks;
    @NotNull
    private static final PosixFilePermission[] posixPermissions;

    public IOSystem() {
        AsynchronousChannelGroup asynchronousChannelGroup;
        IOSystem iOSystem = this;
        try {
            IOSystem iOSystem2 = iOSystem;
            asynchronousChannelGroup = AsynchronousChannelGroup.withThreadPool(this.socketExecutor);
            Intrinsics.checkNotNull(asynchronousChannelGroup);
        }
        catch (IOException e) {
            IOSystem iOSystem3 = iOSystem;
            throw new RuntimeException(e);
        }
        iOSystem2.socketGroup = asynchronousChannelGroup;
    }

    @NotNull
    public final ThreadPoolExecutor getFileExecutor() {
        return this.fileExecutor;
    }

    public final void executeFileTask(@NotNull Runnable task2) {
        Intrinsics.checkNotNullParameter(task2, "task");
        this.fileExecutor.execute(task2);
    }

    public final void executeSocketTask$avail(@NotNull Runnable task2) {
        Intrinsics.checkNotNullParameter(task2, "task");
        this.socketExecutor.execute(task2);
    }

    @NotNull
    public final AsynchronousFileChannel openFile(@NotNull Path path, @NotNull Set<? extends OpenOption> options, FileAttribute<?> ... attributes) throws IllegalArgumentException, UnsupportedOperationException, SecurityException, IOException {
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(options, "options");
        Intrinsics.checkNotNullParameter(attributes, "attributes");
        AsynchronousFileChannel asynchronousFileChannel = AsynchronousFileChannel.open(path, options, this.fileExecutor, Arrays.copyOf(attributes, attributes.length));
        Intrinsics.checkNotNullExpressionValue(asynchronousFileChannel, "open(...)");
        return asynchronousFileChannel;
    }

    @NotNull
    public final AsynchronousFileChannel openFileWithAvailThread(@NotNull Path path, @NotNull AvailRuntime runtime, @NotNull Set<? extends OpenOption> options, FileAttribute<?> ... attributes) throws IllegalArgumentException, UnsupportedOperationException, SecurityException, IOException {
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(runtime, "runtime");
        Intrinsics.checkNotNullParameter(options, "options");
        Intrinsics.checkNotNullParameter(attributes, "attributes");
        AsynchronousFileChannel asynchronousFileChannel = AsynchronousFileChannel.open(path, options, runtime.getExecutor(), Arrays.copyOf(attributes, attributes.length));
        Intrinsics.checkNotNullExpressionValue(asynchronousFileChannel, "open(...)");
        return asynchronousFileChannel;
    }

    @NotNull
    public final Mutable<A_Tuple> getBuffer(@NotNull BufferKey key) {
        Intrinsics.checkNotNullParameter(key, "key");
        return this.cachedBuffers.get(key);
    }

    public final void discardBuffer(@NotNull BufferKey key) {
        Intrinsics.checkNotNullParameter(key, "key");
        this.cachedBuffers.remove(key);
    }

    @NotNull
    public final AsynchronousServerSocketChannel openServerSocket() throws IOException {
        AsynchronousServerSocketChannel asynchronousServerSocketChannel = AsynchronousServerSocketChannel.open(this.socketGroup);
        Intrinsics.checkNotNullExpressionValue(asynchronousServerSocketChannel, "open(...)");
        return asynchronousServerSocketChannel;
    }

    @NotNull
    public final AsynchronousSocketChannel openSocket() throws IOException {
        AsynchronousSocketChannel asynchronousSocketChannel = AsynchronousSocketChannel.open(this.socketGroup);
        Intrinsics.checkNotNullExpressionValue(asynchronousSocketChannel, "open(...)");
        return asynchronousSocketChannel;
    }

    public final void destroy() {
        this.fileExecutor.shutdownNow();
        try {
            this.socketGroup.shutdownNow();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.fileExecutor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            this.socketGroup.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static {
        FileSystem fileSystem = FileSystems.getDefault();
        Intrinsics.checkNotNullExpressionValue(fileSystem, "getDefault(...)");
        IOSystem.fileSystem = fileSystem;
        followSymlinks = new LinkOption[0];
        Enum[] enumArray = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
        doNotFollowSymbolicLinks = enumArray;
        enumArray = new PosixFilePermission[]{PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_WRITE, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_WRITE, PosixFilePermission.OTHERS_EXECUTE};
        posixPermissions = enumArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lavail/io/IOSystem$BufferKey;", "", "fileHandle", "Lavail/io/IOSystem$FileHandle;", "startPosition", "", "(Lavail/io/IOSystem$FileHandle;J)V", "equals", "", "other", "hashCode", "", "avail"})
    public static final class BufferKey {
        @NotNull
        private final FileHandle fileHandle;
        private final long startPosition;

        public BufferKey(@NotNull FileHandle fileHandle, long startPosition) {
            Intrinsics.checkNotNullParameter(fileHandle, "fileHandle");
            this.fileHandle = fileHandle;
            this.startPosition = startPosition;
        }

        public boolean equals(@Nullable Object other) {
            if (other instanceof BufferKey) {
                return Intrinsics.areEqual(this.fileHandle, ((BufferKey)other).fileHandle) && this.startPosition == ((BufferKey)other).startPosition;
            }
            return false;
        }

        public int hashCode() {
            int h = this.fileHandle.hashCode();
            h *= 1664525;
            h ^= 0xD198EA23;
            h += (int)(this.startPosition >> 32);
            h *= 1664525;
            h ^= 0x918F7711;
            h += (int)this.startPosition;
            h *= 1664525;
            return h ^= 0x32AE891D;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0019\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0004\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lavail/io/IOSystem$Companion;", "", "()V", "doNotFollowSymbolicLinks", "", "Ljava/nio/file/LinkOption;", "[Ljava/nio/file/LinkOption;", "fileSystem", "Ljava/nio/file/FileSystem;", "getFileSystem", "()Ljava/nio/file/FileSystem;", "followSymlinks", "posixPermissions", "Ljava/nio/file/attribute/PosixFilePermission;", "getPosixPermissions", "()[Ljava/nio/file/attribute/PosixFilePermission;", "[Ljava/nio/file/attribute/PosixFilePermission;", "shouldFollow", "", "(Z)[Ljava/nio/file/LinkOption;", "avail"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FileSystem getFileSystem() {
            return fileSystem;
        }

        @NotNull
        public final LinkOption[] followSymlinks(boolean shouldFollow) {
            return shouldFollow ? followSymlinks : doNotFollowSymbolicLinks;
        }

        @NotNull
        public final PosixFilePermission[] getPosixPermissions() {
            return posixPermissions;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lavail/io/IOSystem$FileHandle;", "", "filename", "Lavail/descriptor/tuples/A_String;", "alignment", "", "canRead", "", "canWrite", "channel", "Ljava/nio/channels/AsynchronousFileChannel;", "(Lavail/descriptor/tuples/A_String;IZZLjava/nio/channels/AsynchronousFileChannel;)V", "getAlignment", "()I", "bufferKeys", "Ljava/util/WeakHashMap;", "Lavail/io/IOSystem$BufferKey;", "Ljava/lang/Void;", "getBufferKeys", "()Ljava/util/WeakHashMap;", "getCanRead", "()Z", "getCanWrite", "getChannel", "()Ljava/nio/channels/AsynchronousFileChannel;", "getFilename", "()Lavail/descriptor/tuples/A_String;", "avail"})
    public static final class FileHandle {
        @NotNull
        private final A_String filename;
        private final int alignment;
        private final boolean canRead;
        private final boolean canWrite;
        @NotNull
        private final AsynchronousFileChannel channel;
        @NotNull
        private final WeakHashMap<BufferKey, Void> bufferKeys;

        public FileHandle(@NotNull A_String filename, int alignment, boolean canRead, boolean canWrite, @NotNull AsynchronousFileChannel channel) {
            Intrinsics.checkNotNullParameter(filename, "filename");
            Intrinsics.checkNotNullParameter(channel, "channel");
            this.filename = filename;
            this.alignment = alignment;
            this.canRead = canRead;
            this.canWrite = canWrite;
            this.channel = channel;
            this.bufferKeys = new WeakHashMap();
        }

        @NotNull
        public final A_String getFilename() {
            return this.filename;
        }

        public final int getAlignment() {
            return this.alignment;
        }

        public final boolean getCanRead() {
            return this.canRead;
        }

        public final boolean getCanWrite() {
            return this.canWrite;
        }

        @NotNull
        public final AsynchronousFileChannel getChannel() {
            return this.channel;
        }

        @NotNull
        public final WeakHashMap<BufferKey, Void> getBufferKeys() {
            return this.bufferKeys;
        }
    }
}

