/*
 * Decompiled with CFR 0.152.
 */
package avail.persistence.cache.record;

import avail.persistence.cache.Repository;
import avail.persistence.cache.record.ModuleCompilation;
import avail.persistence.cache.record.ModuleCompilationKey;
import avail.utility.CodingKt;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 /2\u00020\u0001:\u0001/B\u0017\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B3\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\rJ\u0010\u0010$\u001a\u0004\u0018\u00010\u000f2\u0006\u0010%\u001a\u00020\u0018J\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0013J\u000e\u0010*\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0013J\b\u0010+\u001a\u00020\u000bH\u0016J\u0015\u0010,\u001a\u00020(2\u0006\u0010\u0004\u001a\u00020-H\u0000\u00a2\u0006\u0002\b.R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R \u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u000f0\u0017X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0011R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0015R\u000e\u0010 \u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lavail/persistence/cache/record/ModuleVersion;", "", "repository", "Lavail/persistence/cache/Repository;", "binaryStream", "Ljava/io/DataInputStream;", "(Lavail/persistence/cache/Repository;Ljava/io/DataInputStream;)V", "moduleSize", "", "localImportNames", "", "", "entryPoints", "(Lavail/persistence/cache/Repository;JLjava/util/List;Ljava/util/List;)V", "allCompilations", "Lavail/persistence/cache/record/ModuleCompilation;", "getAllCompilations", "()Ljava/util/List;", "comments", "", "getComments", "()[B", "compilations", "Lavail/persistence/cache/Repository$LimitedCache;", "Lavail/persistence/cache/record/ModuleCompilationKey;", "getCompilations$avail", "()Lavail/persistence/cache/Repository$LimitedCache;", "", "imports", "getImports", "moduleHeader", "getModuleHeader", "moduleHeaderRecordNumber", "getRepository", "()Lavail/persistence/cache/Repository;", "stacksRecordNumber", "getCompilation", "compilationKey", "getEntryPoints", "putComments", "", "bytes", "putModuleHeader", "toString", "write", "Ljava/io/DataOutputStream;", "write$avail", "Companion", "avail"})
@SourceDebugExtension(value={"SMAP\nModuleVersion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleVersion.kt\navail/persistence/cache/record/ModuleVersion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,330:1\n1#2:331\n*E\n"})
public final class ModuleVersion {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Repository repository;
    private final long moduleSize;
    @NotNull
    private final List<String> localImportNames;
    @NotNull
    private final List<String> entryPoints;
    @NotNull
    private final Repository.LimitedCache<ModuleCompilationKey, ModuleCompilation> compilations;
    private long moduleHeaderRecordNumber;
    private long stacksRecordNumber;
    private static final int MAX_HISTORICAL_VERSION_COMPILATIONS = 10;

    @NotNull
    public final Repository getRepository() {
        return this.repository;
    }

    @NotNull
    public final Repository.LimitedCache<ModuleCompilationKey, ModuleCompilation> getCompilations$avail() {
        return this.compilations;
    }

    @NotNull
    public final List<String> getImports() {
        List<String> list2 = Collections.unmodifiableList(this.localImportNames);
        Intrinsics.checkNotNullExpressionValue(list2, "unmodifiableList(...)");
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] getModuleHeader() {
        byte[] byArray;
        boolean bl;
        boolean bl2 = bl = this.moduleHeaderRecordNumber != -1L;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        Lock lock = this.repository.getLock$avail();
        lock.lock();
        try {
            boolean bl3 = false;
            byArray = this.repository.get(this.moduleHeaderRecordNumber);
        }
        finally {
            lock.unlock();
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final byte[] getComments() {
        byte[] byArray;
        if (this.stacksRecordNumber == -1L) {
            byArray = null;
        } else {
            Lock lock = this.repository.getLock$avail();
            lock.lock();
            try {
                boolean bl = false;
                byte[] byArray2 = this.repository.get(this.stacksRecordNumber);
                byArray = byArray2;
            }
            finally {
                lock.unlock();
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<ModuleCompilation> getAllCompilations() {
        List<ModuleCompilation> list2;
        Lock lock = this.repository.getLock$avail();
        lock.lock();
        try {
            boolean bl = false;
            Collection<ModuleCompilation> collection2 = this.compilations.values();
            Intrinsics.checkNotNullExpressionValue(collection2, "<get-values>(...)");
            list2 = CollectionsKt.toList((Iterable)collection2);
        }
        finally {
            lock.unlock();
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final ModuleCompilation getCompilation(@NotNull ModuleCompilationKey compilationKey) {
        ModuleCompilation moduleCompilation;
        Intrinsics.checkNotNullParameter(compilationKey, "compilationKey");
        Lock lock = this.repository.getLock$avail();
        lock.lock();
        try {
            boolean bl = false;
            moduleCompilation = (ModuleCompilation)this.compilations.get(compilationKey);
        }
        finally {
            lock.unlock();
        }
        return moduleCompilation;
    }

    @NotNull
    public final List<String> getEntryPoints() {
        List<String> list2 = Collections.unmodifiableList(this.entryPoints);
        Intrinsics.checkNotNullExpressionValue(list2, "unmodifiableList(...)");
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void putModuleHeader(@NotNull byte[] bytes2) {
        Intrinsics.checkNotNullParameter(bytes2, "bytes");
        Lock lock = this.repository.getLock$avail();
        lock.lock();
        try {
            boolean bl = false;
            this.moduleHeaderRecordNumber = this.repository.add(bytes2);
            this.repository.markDirty();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void putComments(@NotNull byte[] bytes2) {
        Intrinsics.checkNotNullParameter(bytes2, "bytes");
        Lock lock = this.repository.getLock$avail();
        lock.lock();
        try {
            boolean bl = false;
            this.stacksRecordNumber = this.repository.add(bytes2);
            this.repository.markDirty();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    public final void write$avail(@NotNull DataOutputStream binaryStream) throws IOException {
        Intrinsics.checkNotNullParameter(binaryStream, "binaryStream");
        CodingKt.vlq(binaryStream, this.moduleSize);
        CodingKt.vlq(binaryStream, this.localImportNames.size());
        for (String entry : this.localImportNames) {
            CodingKt.sizedString(binaryStream, entry);
        }
        CodingKt.vlq(binaryStream, this.entryPoints.size());
        for (String string2 : this.entryPoints) {
            CodingKt.sizedString(binaryStream, string2);
        }
        CodingKt.vlq(binaryStream, this.compilations.size());
        for (Map.Entry entry : ((Map)this.compilations).entrySet()) {
            ModuleCompilationKey key = (ModuleCompilationKey)entry.getKey();
            ModuleCompilation value = (ModuleCompilation)entry.getValue();
            key.write(binaryStream);
            value.write$avail(binaryStream);
        }
        CodingKt.zigzag(binaryStream, this.moduleHeaderRecordNumber);
        CodingKt.zigzag(binaryStream, this.stacksRecordNumber);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u246 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u246.append("Version:\n\t\timports=");
        $this$toString_u24lambda_u246.append(this.localImportNames);
        if (!((Collection)this.entryPoints).isEmpty()) {
            $this$toString_u24lambda_u246.append("\n\t\tentry points=");
            $this$toString_u24lambda_u246.append(this.entryPoints);
        }
        $this$toString_u24lambda_u246.append("\n\t\tcompilations=");
        $this$toString_u24lambda_u246.append(this.compilations.values());
        $this$toString_u24lambda_u246.append("\n\t\tmoduleHeaderRecordNumber=");
        $this$toString_u24lambda_u246.append(this.moduleHeaderRecordNumber);
        $this$toString_u24lambda_u246.append("\n\t\tstacksRecordNumber=");
        $this$toString_u24lambda_u246.append(this.stacksRecordNumber);
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    public ModuleVersion(@NotNull Repository repository, @NotNull DataInputStream binaryStream) throws IOException {
        Intrinsics.checkNotNullParameter(repository, "repository");
        Intrinsics.checkNotNullParameter(binaryStream, "binaryStream");
        this.compilations = new Repository.LimitedCache(10);
        this.moduleHeaderRecordNumber = -1L;
        this.stacksRecordNumber = -1L;
        this.repository = repository;
        this.moduleSize = CodingKt.unvlqLong(binaryStream);
        int localImportCount = CodingKt.unvlqInt(binaryStream);
        this.localImportNames = new ArrayList();
        while (localImportCount-- > 0) {
            this.localImportNames.add(CodingKt.decodeString(binaryStream));
        }
        int entryPointCount = CodingKt.unvlqInt(binaryStream);
        this.entryPoints = new ArrayList();
        while (entryPointCount-- > 0) {
            this.entryPoints.add(CodingKt.decodeString(binaryStream));
        }
        int compilationsCount = CodingKt.unvlqInt(binaryStream);
        while (compilationsCount-- > 0) {
            ((Map)this.compilations).put(new ModuleCompilationKey(binaryStream), new ModuleCompilation(repository, binaryStream));
        }
        this.moduleHeaderRecordNumber = CodingKt.unzigzagLong(binaryStream);
        this.stacksRecordNumber = CodingKt.unzigzagLong(binaryStream);
    }

    public ModuleVersion(@NotNull Repository repository, long moduleSize, @NotNull List<String> localImportNames, @NotNull List<String> entryPoints) {
        Intrinsics.checkNotNullParameter(repository, "repository");
        Intrinsics.checkNotNullParameter(localImportNames, "localImportNames");
        Intrinsics.checkNotNullParameter(entryPoints, "entryPoints");
        this.compilations = new Repository.LimitedCache(10);
        this.moduleHeaderRecordNumber = -1L;
        this.stacksRecordNumber = -1L;
        this.repository = repository;
        this.moduleSize = moduleSize;
        this.localImportNames = CollectionsKt.toMutableList((Collection)localImportNames);
        this.entryPoints = CollectionsKt.toMutableList((Collection)entryPoints);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lavail/persistence/cache/record/ModuleVersion$Companion;", "", "()V", "MAX_HISTORICAL_VERSION_COMPILATIONS", "", "avail"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

