/*
 * Decompiled with CFR 0.152.
 */
package avail.utility;

import avail.utility.Strings;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000e\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012J7\u0010\u0013\u001a\u00020\u00062\b\b\u0002\u0010\u0014\u001a\u00020\u00062\b\b\u0002\u0010\u0015\u001a\u00020\u00122\u001b\u0010\u0016\u001a\u0017\u0012\b\u0012\u00060\u0018j\u0002`\u0019\u0012\u0004\u0012\u00020\u001a0\u0017\u00a2\u0006\u0002\b\u001bJ\u000e\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u0006J\u0016\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u0012J\u0016\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u0012J\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u0012J\u000e\u0010%\u001a\u00020\u00062\u0006\u0010&\u001a\u00020'J\n\u0010(\u001a\u00020\u0006*\u00020\u0006J8\u0010)\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120+0**\u00020\u00062\u0006\u0010,\u001a\u00020\u00062\b\b\u0002\u0010-\u001a\u00020.2\b\b\u0002\u0010/\u001a\u00020.J\u0016\u00100\u001a\u00020\u001a*\u00060\u0018j\u0002`\u00192\u0006\u0010$\u001a\u00020\u0012J\u0016\u00101\u001a\u00020\u001a*\u00060\u0018j\u0002`\u00192\u0006\u0010$\u001a\u00020\u0012Jd\u00102\u001a\u00020\u001a*\u00060\u0018j\u0002`\u00192\u0006\u00102\u001a\u00020\u00062*\u00103\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060+0\f\"\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060+2\u001b\u00104\u001a\u0017\u0012\b\u0012\u00060\u0018j\u0002`\u0019\u0012\u0004\u0012\u00020\u001a0\u0017\u00a2\u0006\u0002\b\u001b\u00a2\u0006\u0002\u00105J\u001c\u00106\u001a\u00020\u0006*\u00020\u00062\u0006\u00107\u001a\u00020\u00122\b\b\u0002\u00108\u001a\u00020\u0006J;\u00109\u001a\u00020\u001a*\u00060\u0018j\u0002`\u00192\u0006\u0010:\u001a\u00020\u00062\u0006\u0010;\u001a\u00020\u00062\u001b\u00104\u001a\u0017\u0012\b\u0012\u00060\u0018j\u0002`\u0019\u0012\u0004\u0012\u00020\u001a0\u0017\u00a2\u0006\u0002\b\u001bR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006<"}, d2={"Lavail/utility/Strings;", "", "()V", "escapesForHTML", "", "", "", "lineBreakPattern", "Ljava/util/regex/Pattern;", "getLineBreakPattern", "()Ljava/util/regex/Pattern;", "tabs", "", "[Ljava/lang/String;", "addLineNumbers", "source", "pattern", "startingLineNumber", "", "buildUnicodeBox", "title", "borderColumns", "builder", "Lkotlin/Function1;", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "", "Lkotlin/ExtensionFunctionType;", "escape", "s", "increaseIndentation", "originalString", "increasedIndentation", "repeated", "string", "count", "indent", "traceFor", "e", "", "escapedForHTML", "matchesAbbreviation", "", "Lkotlin/Pair;", "abbreviation", "allowPartials", "", "ignoreCase", "newlineTab", "tab", "tag", "attributes", "body", "(Ljava/lang/StringBuilder;Ljava/lang/String;[Lkotlin/Pair;Lkotlin/jvm/functions/Function1;)V", "truncateTo", "limit", "ellipsis", "wrap", "prefix", "suffix", "avail"})
@SourceDebugExtension(value={"SMAP\nStrings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Strings.kt\navail/utility/Strings\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,452:1\n1#2:453\n13309#3,2:454\n1174#4,2:456\n*S KotlinDebug\n*F\n+ 1 Strings.kt\navail/utility/Strings\n*L\n269#1:454,2\n400#1:456,2\n*E\n"})
public final class Strings {
    @NotNull
    public static final Strings INSTANCE = new Strings();
    @NotNull
    private static final String[] tabs;
    @NotNull
    private static final Pattern lineBreakPattern;
    @NotNull
    private static final Map<Character, String> escapesForHTML;

    private Strings() {
    }

    @NotNull
    public final String escape(@NotNull String s) {
        int codePoint;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(s, "s");
        StringBuilder $this$escape_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$escape_u24lambda_u240.append('\"');
        block8: for (int i2 = 0; i2 < s.length(); i2 += Character.charCount(codePoint)) {
            codePoint = s.codePointAt(i2);
            switch (codePoint) {
                case 92: {
                    $this$escape_u24lambda_u240.append("\\\\");
                    continue block8;
                }
                case 34: {
                    $this$escape_u24lambda_u240.append("\\\"");
                    continue block8;
                }
                case 8: {
                    $this$escape_u24lambda_u240.append("\\b");
                    continue block8;
                }
                case 10: {
                    $this$escape_u24lambda_u240.append("\\n");
                    continue block8;
                }
                case 13: {
                    $this$escape_u24lambda_u240.append("\\r");
                    continue block8;
                }
                case 9: {
                    $this$escape_u24lambda_u240.append("\\t");
                    continue block8;
                }
                default: {
                    $this$escape_u24lambda_u240.appendCodePoint(codePoint);
                }
            }
        }
        $this$escape_u24lambda_u240.append('\"');
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String addLineNumbers(@NotNull String source, @NotNull String pattern, int startingLineNumber) {
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(pattern, "pattern");
        Closeable closeable = new Formatter();
        Throwable throwable = null;
        try {
            Formatter formatter = (Formatter)closeable;
            boolean bl = false;
            int line = startingLineNumber;
            int position = 0;
            while (position < source.length()) {
                int nextStart = StringsKt.indexOf$default((CharSequence)source, '\n', position, false, 4, null);
                nextStart = nextStart == -1 ? source.length() : nextStart + 1;
                Object[] objectArray = new Object[2];
                objectArray[0] = line;
                Intrinsics.checkNotNullExpressionValue(source.substring(position, nextStart), "this as java.lang.String\u2026ing(startIndex, endIndex)");
                formatter.format(pattern, objectArray);
                position = nextStart;
                ++line;
            }
            String string2 = formatter.toString();
            Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
            String string3 = string2;
            return string3;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    @NotNull
    public final String tabs(int indent) {
        if (indent < tabs.length) {
            return tabs[indent];
        }
        StringBuilder builder = new StringBuilder(indent);
        int i2 = 1;
        if (i2 <= indent) {
            while (true) {
                builder.append('\t');
                if (i2 == indent) break;
                ++i2;
            }
        }
        String string2 = builder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }

    public final void tab(@NotNull StringBuilder $this$tab, int indent) {
        Intrinsics.checkNotNullParameter($this$tab, "<this>");
        int i2 = 1;
        if (i2 <= indent) {
            while (true) {
                $this$tab.append('\t');
                if (i2 == indent) break;
                ++i2;
            }
        }
    }

    public final void newlineTab(@NotNull StringBuilder $this$newlineTab, int indent) {
        Intrinsics.checkNotNullParameter($this$newlineTab, "<this>");
        StringBuilder stringBuilder = $this$newlineTab.append('\n');
        Intrinsics.checkNotNullExpressionValue(stringBuilder, "append(...)");
        this.tab(stringBuilder, indent);
    }

    @NotNull
    public final String repeated(@NotNull String string2, int count) {
        StringBuilder stringBuilder;
        int n;
        Intrinsics.checkNotNullParameter(string2, "string");
        int n2 = n = count >= 0 ? 1 : 0;
        if (_Assertions.ENABLED && n == 0) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        n = string2.length() * count;
        StringBuilder $this$repeated_u24lambda_u245 = stringBuilder = new StringBuilder(n);
        boolean bl = false;
        int n3 = 0;
        while (n3 < count) {
            int it = n3++;
            boolean bl2 = false;
            $this$repeated_u24lambda_u245.append(string2);
        }
        String string4 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string4, "StringBuilder(capacity).\u2026builderAction).toString()");
        return string4;
    }

    @NotNull
    public final Pattern getLineBreakPattern() {
        return lineBreakPattern;
    }

    @NotNull
    public final String increaseIndentation(@NotNull String originalString, int increasedIndentation) {
        String string2;
        boolean bl;
        Intrinsics.checkNotNullParameter(originalString, "originalString");
        boolean bl2 = bl = increasedIndentation >= 0;
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        if (increasedIndentation == 0) {
            string2 = originalString;
        } else {
            String string4 = lineBreakPattern.matcher(originalString).replaceAll(Matcher.quoteReplacement("\n" + this.tabs(increasedIndentation)));
            Intrinsics.checkNotNull(string4);
            string2 = string4;
        }
        return string2;
    }

    @NotNull
    public final String traceFor(@NotNull Throwable e) {
        String string2;
        Intrinsics.checkNotNullParameter(e, "e");
        try {
            ByteArrayOutputStream traceBytes = new ByteArrayOutputStream();
            PrintStream trace2 = new PrintStream((OutputStream)traceBytes, true, StandardCharsets.UTF_8.name());
            e.printStackTrace(trace2);
            byte[] byArray = traceBytes.toByteArray();
            Intrinsics.checkNotNullExpressionValue(byArray, "toByteArray(...)");
            byte[] byArray2 = byArray;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue(charset, "UTF_8");
            Charset charset2 = charset;
            string2 = new String(byArray2, charset2);
        }
        catch (UnsupportedEncodingException x) {
            if (_Assertions.ENABLED) {
                boolean bl = false;
                String string3 = "This never happens!";
                throw new AssertionError((Object)string3);
            }
            throw new RuntimeException(x);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void wrap(@NotNull StringBuilder $this$wrap, @NotNull String prefix, @NotNull String suffix, @NotNull Function1<? super StringBuilder, Unit> body2) {
        Intrinsics.checkNotNullParameter($this$wrap, "<this>");
        Intrinsics.checkNotNullParameter(prefix, "prefix");
        Intrinsics.checkNotNullParameter(suffix, "suffix");
        Intrinsics.checkNotNullParameter(body2, "body");
        $this$wrap.append(prefix);
        try {
            body2.invoke($this$wrap);
        }
        finally {
            $this$wrap.append(suffix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void tag(@NotNull StringBuilder $this$tag, @NotNull String tag, @NotNull Pair<String, String>[] attributes, @NotNull Function1<? super StringBuilder, Unit> body2) {
        Intrinsics.checkNotNullParameter($this$tag, "<this>");
        Intrinsics.checkNotNullParameter(tag, "tag");
        Intrinsics.checkNotNullParameter(attributes, "attributes");
        Intrinsics.checkNotNullParameter(body2, "body");
        $this$tag.append("<");
        $this$tag.append(tag);
        Pair<String, String>[] $this$forEach$iv = attributes;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            Pair<String, String> element$iv;
            Pair<String, String> pair = element$iv = $this$forEach$iv[j];
            boolean bl = false;
            String key = pair.component1();
            String value = pair.component2();
            $this$tag.append(" " + key + "=" + INSTANCE.escape(value));
        }
        $this$tag.append(">");
        try {
            body2.invoke($this$tag);
        }
        finally {
            $this$tag.append("</" + tag + ">");
        }
    }

    @NotNull
    public final List<Pair<Integer, Integer>> matchesAbbreviation(@NotNull String $this$matchesAbbreviation, @NotNull String abbreviation, boolean allowPartials, boolean ignoreCase) {
        int c;
        Intrinsics.checkNotNullParameter($this$matchesAbbreviation, "<this>");
        Intrinsics.checkNotNullParameter(abbreviation, "abbreviation");
        if (!allowPartials && abbreviation.length() > $this$matchesAbbreviation.length()) {
            return CollectionsKt.emptyList();
        }
        Function1 normalize2 = ignoreCase ? (Function1)matchesAbbreviation.normalize.1.INSTANCE : (Function1)matchesAbbreviation.normalize.2.INSTANCE;
        String search = (String)normalize2.invoke(abbreviation);
        int searchLength = search.length();
        String target = (String)normalize2.invoke($this$matchesAbbreviation);
        int targetLength = target.length();
        List matches = new ArrayList();
        Integer start = null;
        int scan = 0;
        int next = search.codePointAt(0);
        int i2 = 0;
        int matchLength = 0;
        do {
            if (next == (c = target.codePointAt(i2))) {
                if (start == null) {
                    start = i2;
                }
                if (++scan >= searchLength) {
                    matches.add(TuplesKt.to(start, i2 + 1));
                    matchLength += i2 - start + 1;
                    break;
                }
                next = search.codePointAt(scan);
                continue;
            }
            if (start == null) continue;
            matches.add(TuplesKt.to(start, i2));
            matchLength += i2 - start;
            start = null;
        } while ((i2 += Character.charCount(c)) < targetLength);
        return allowPartials || matchLength == searchLength ? matches : CollectionsKt.emptyList();
    }

    public static /* synthetic */ List matchesAbbreviation$default(Strings strings2, String string2, String string3, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return strings2.matchesAbbreviation(string2, string3, bl, bl2);
    }

    @NotNull
    public final String truncateTo(@NotNull String $this$truncateTo, int limit, @NotNull String ellipsis) {
        Object object;
        boolean bl;
        Intrinsics.checkNotNullParameter($this$truncateTo, "<this>");
        Intrinsics.checkNotNullParameter(ellipsis, "ellipsis");
        boolean bl2 = bl = limit >= ellipsis.length();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        if ($this$truncateTo.length() <= limit) {
            object = $this$truncateTo;
        } else {
            String string3 = $this$truncateTo.substring(0, limit - ellipsis.length());
            Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            object = string3 + ellipsis;
        }
        return object;
    }

    public static /* synthetic */ String truncateTo$default(Strings strings2, String string2, int n, String string3, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string3 = "\u2026";
        }
        return strings2.truncateTo(string2, n, string3);
    }

    @NotNull
    public final String escapedForHTML(@NotNull String $this$escapedForHTML) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter($this$escapedForHTML, "<this>");
        StringBuilder $this$escapedForHTML_u24lambda_u249 = stringBuilder = new StringBuilder();
        boolean bl = false;
        CharSequence $this$forEach$iv = $this$escapedForHTML;
        boolean $i$f$forEach = false;
        for (int j = 0; j < $this$forEach$iv.length(); ++j) {
            char element$iv;
            char c = element$iv = $this$forEach$iv.charAt(j);
            boolean bl2 = false;
            String transformed = escapesForHTML.get(Character.valueOf(c));
            if (transformed == null) {
                $this$escapedForHTML_u24lambda_u249.append(c);
                continue;
            }
            $this$escapedForHTML_u24lambda_u249.append(transformed);
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    @NotNull
    public final String buildUnicodeBox(@NotNull String title, int borderColumns, @NotNull Function1<? super StringBuilder, Unit> builder) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(title, "title");
        Intrinsics.checkNotNullParameter(builder, "builder");
        StringBuilder $this$buildUnicodeBox_u24lambda_u2410 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (((CharSequence)title).length() == 0) {
            $this$buildUnicodeBox_u24lambda_u2410.append("\u250f");
            $this$buildUnicodeBox_u24lambda_u2410.append(StringsKt.repeat("\u2501", borderColumns - 2));
            $this$buildUnicodeBox_u24lambda_u2410.append("\u2513\n");
        } else {
            int totalBorder = borderColumns - title.length() - 2;
            int prologue = totalBorder / 2;
            int epilogue = prologue + totalBorder % 2;
            $this$buildUnicodeBox_u24lambda_u2410.append("\u250f");
            $this$buildUnicodeBox_u24lambda_u2410.append(StringsKt.repeat("\u2501", prologue - 1));
            $this$buildUnicodeBox_u24lambda_u2410.append(" " + title + " ");
            $this$buildUnicodeBox_u24lambda_u2410.append(StringsKt.repeat("\u2501", epilogue - 1));
            $this$buildUnicodeBox_u24lambda_u2410.append("\u2513\n");
        }
        builder.invoke($this$buildUnicodeBox_u24lambda_u2410);
        if ($this$buildUnicodeBox_u24lambda_u2410.charAt(StringsKt.getLastIndex($this$buildUnicodeBox_u24lambda_u2410)) != '\n') {
            $this$buildUnicodeBox_u24lambda_u2410.append('\n');
        }
        $this$buildUnicodeBox_u24lambda_u2410.append("\u2517");
        $this$buildUnicodeBox_u24lambda_u2410.append(StringsKt.repeat("\u2501", borderColumns - 2));
        $this$buildUnicodeBox_u24lambda_u2410.append("\u251b\n");
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    public static /* synthetic */ String buildUnicodeBox$default(Strings strings2, String string2, int n, Function1 function1, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string2 = "";
        }
        if ((n2 & 2) != 0) {
            n = 80;
        }
        return strings2.buildUnicodeBox(string2, n, function1);
    }

    /*
     * WARNING - void declaration
     */
    static {
        String[] stringArray = new String[10];
        for (int j = 0; j < 10; ++j) {
            StringBuilder stringBuilder;
            int n = j;
            StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
            int n2 = n;
            String[] stringArray2 = stringArray;
            boolean bl = false;
            int n3 = 0;
            while (n3 < n) {
                void $this$tabs_u24lambda_u243;
                int it = n3++;
                boolean bl2 = false;
                $this$tabs_u24lambda_u243.append('\t');
            }
            Unit unit = Unit.INSTANCE;
            Intrinsics.checkNotNullExpressionValue(stringBuilder.toString(), "StringBuilder().apply(builderAction).toString()");
        }
        tabs = stringArray;
        Pattern pattern = Pattern.compile("\n", 16);
        Intrinsics.checkNotNullExpressionValue(pattern, "compile(...)");
        lineBreakPattern = pattern;
        Pair[] pairArray = new Pair[]{TuplesKt.to(Character.valueOf('&'), "&amp;"), TuplesKt.to(Character.valueOf('<'), "&lt;"), TuplesKt.to(Character.valueOf('>'), "&gt;"), TuplesKt.to(Character.valueOf('\"'), "&quot;"), TuplesKt.to(Character.valueOf('\''), "&#x27;"), TuplesKt.to(Character.valueOf('/'), "&#x2F;")};
        escapesForHTML = MapsKt.mapOf(pairArray);
    }
}

