/*
 * Decompiled with CFR 0.152.
 */
package org.availlang.persistence;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.availlang.persistence.IndexedFile;
import org.availlang.persistence.IndexedFileBuilder;
import org.availlang.persistence.IndexedFileException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0006H\u0016J\u007f\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00162\u0019\b\u0002\u0010\u001e\u001a\u0013\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020 0\u001f\u00a2\u0006\u0002\b!2\b\b\u0002\u0010\"\u001a\u00020\u00062\b\b\u0002\u0010#\u001a\u00020\u00062\b\b\u0002\u0010$\u001a\u00020\u00062\b\b\u0002\u0010%\u001a\u00020\u00062\b\b\u0002\u0010&\u001a\u00020\u00062\u001a\b\u0002\u0010'\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00160(R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0014\u0010\r\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0014\u0010\u000f\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\bR\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006)"}, d2={"Lorg/availlang/persistence/IndexedFileBuilder;", "", "headerString", "", "(Ljava/lang/String;)V", "defaultCompressionThreshold", "", "getDefaultCompressionThreshold", "()I", "defaultPageSize", "getDefaultPageSize", "defaultSoftCacheSize", "getDefaultSoftCacheSize", "defaultStrongCacheSize", "getDefaultStrongCacheSize", "defaultVersion", "getDefaultVersion", "headerBytes", "", "getHeaderBytes", "()[B", "defaultVersionCheck", "", "a", "b", "openOrCreate", "Lorg/availlang/persistence/IndexedFile;", "fileReference", "Ljava/io/File;", "forWriting", "setupActionIfNew", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "softCacheSize", "strongCacheSize", "pageSize", "compressionBlockSize", "version", "versionCheck", "Lkotlin/Function2;", "avail-storage"})
public abstract class IndexedFileBuilder {
    @NotNull
    private final byte[] headerBytes;
    private final int defaultPageSize;
    private final int defaultCompressionThreshold;
    private final int defaultSoftCacheSize;
    private final int defaultStrongCacheSize;
    private final int defaultVersion;

    public IndexedFileBuilder(@NotNull String headerString) {
        Intrinsics.checkNotNullParameter(headerString, "headerString");
        byte[] byArray = headerString.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "this as java.lang.String).getBytes(charset)");
        this.headerBytes = ArraysKt.plus(byArray, new byte[1]);
        this.defaultPageSize = 4096;
        this.defaultCompressionThreshold = 32768;
        this.defaultSoftCacheSize = 200;
        this.defaultStrongCacheSize = 100;
        this.defaultVersion = 3;
    }

    @NotNull
    public final byte[] getHeaderBytes() {
        return this.headerBytes;
    }

    public int getDefaultPageSize() {
        return this.defaultPageSize;
    }

    public int getDefaultCompressionThreshold() {
        return this.defaultCompressionThreshold;
    }

    public int getDefaultSoftCacheSize() {
        return this.defaultSoftCacheSize;
    }

    public int getDefaultStrongCacheSize() {
        return this.defaultStrongCacheSize;
    }

    public int getDefaultVersion() {
        return this.defaultVersion;
    }

    public boolean defaultVersionCheck(int a, int b) {
        return a == b;
    }

    @NotNull
    public final IndexedFile openOrCreate(@NotNull File fileReference, boolean forWriting, @NotNull Function1<? super IndexedFile, Unit> setupActionIfNew, int softCacheSize, int strongCacheSize, int pageSize, int compressionBlockSize, int version, @NotNull Function2<? super Integer, ? super Integer, Boolean> versionCheck2) throws IOException {
        RandomAccessFile randomAccessFile;
        Intrinsics.checkNotNullParameter(fileReference, "fileReference");
        Intrinsics.checkNotNullParameter(setupActionIfNew, "setupActionIfNew");
        Intrinsics.checkNotNullParameter(versionCheck2, "versionCheck");
        boolean existed = fileReference.exists();
        if (forWriting) {
            randomAccessFile = new RandomAccessFile(fileReference, "rw");
        } else if (existed) {
            randomAccessFile = new RandomAccessFile(fileReference, "rw");
        } else {
            throw new IndexedFileException("No such index file");
        }
        RandomAccessFile file2 = randomAccessFile;
        if (fileReference.length() == 0L) {
            if (!forWriting) {
                throw new IndexedFileException("Indexed file opened for read is zero bytes");
            }
            existed = false;
        }
        return new IndexedFile(fileReference, file2, this.headerBytes, forWriting, existed ? null : setupActionIfNew, softCacheSize, strongCacheSize, pageSize, compressionBlockSize, version, versionCheck2);
    }

    public static /* synthetic */ IndexedFile openOrCreate$default(IndexedFileBuilder indexedFileBuilder2, File file2, boolean bl, Function1 function1, int n, int n2, int n3, int n4, int n5, Function2 function2, int n6, Object object) throws IOException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: openOrCreate");
        }
        if ((n6 & 4) != 0) {
            function1 = openOrCreate.1.INSTANCE;
        }
        if ((n6 & 8) != 0) {
            n = indexedFileBuilder2.getDefaultSoftCacheSize();
        }
        if ((n6 & 0x10) != 0) {
            n2 = indexedFileBuilder2.getDefaultStrongCacheSize();
        }
        if ((n6 & 0x20) != 0) {
            n3 = indexedFileBuilder2.getDefaultPageSize();
        }
        if ((n6 & 0x40) != 0) {
            n4 = indexedFileBuilder2.getDefaultCompressionThreshold();
        }
        if ((n6 & 0x80) != 0) {
            n5 = indexedFileBuilder2.getDefaultVersion();
        }
        if ((n6 & 0x100) != 0) {
            function2 = new Function2<Integer, Integer, Boolean>((Object)indexedFileBuilder2){

                @NotNull
                public final Boolean invoke(int p0, int p1) {
                    return ((IndexedFileBuilder)this.receiver).defaultVersionCheck(p0, p1);
                }
            };
        }
        return indexedFileBuilder2.openOrCreate(file2, bl, function1, n, n2, n3, n4, n5, function2);
    }
}

