/*
 * Decompiled with CFR 0.152.
 */
package avail.anvil.text;

import avail.anvil.AvailEditor;
import avail.anvil.AvailWorkbench;
import avail.anvil.RenderingContext;
import avail.anvil.Stylesheet;
import avail.anvil.ValidatedRenderingContext;
import avail.anvil.ValidatedStylePattern;
import avail.anvil.shortcuts.PrintAllRenderingSolutionsShortcut;
import avail.anvil.streams.StreamStyle;
import avail.anvil.text.CodePane;
import avail.utility.Strings;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.TextAction;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lavail/anvil/text/PrintAllRenderingSolutions;", "Ljavax/swing/text/TextAction;", "()V", "actionPerformed", "", "e", "Ljava/awt/event/ActionEvent;", "avail"})
final class PrintAllRenderingSolutions
extends TextAction {
    @NotNull
    public static final PrintAllRenderingSolutions INSTANCE = new PrintAllRenderingSolutions();

    private PrintAllRenderingSolutions() {
        super(PrintAllRenderingSolutionsShortcut.INSTANCE.getActionMapKey());
    }

    @Override
    public void actionPerformed(@NotNull ActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        AvailEditor editor2 = AvailEditor.Companion.getEditor$avail(e);
        CodePane sourcePane2 = editor2.getSourcePane$avail();
        StyledDocument document2 = sourcePane2.getStyledDocument();
        Element element = document2.getCharacterElement(sourcePane2.getCaret().getDot());
        Object object = element.getAttributes().getAttribute(StyleConstants.NameAttribute);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        String classifiers = (String)object;
        AvailWorkbench workbench = editor2.getWorkbench();
        Stylesheet stylesheet = workbench.getStylesheet();
        Ref.ObjectRef solutions2 = new Ref.ObjectRef();
        solutions2.element = stylesheet.mostSpecificSolutions(stylesheet.findTree(classifiers));
        ValidatedRenderingContext finalSolution = stylesheet.distillFinalSolution((List)solutions2.element);
        String breakdown2 = Strings.buildUnicodeBox$default(Strings.INSTANCE, "Styling Solutions Report", 0, (Function1)new Function1<StringBuilder, Unit>(editor2, classifiers, (Ref.ObjectRef<List<ValidatedStylePattern>>)solutions2, stylesheet, finalSolution){
            final /* synthetic */ AvailEditor $editor;
            final /* synthetic */ String $classifiers;
            final /* synthetic */ Ref.ObjectRef<List<ValidatedStylePattern>> $solutions;
            final /* synthetic */ Stylesheet $stylesheet;
            final /* synthetic */ ValidatedRenderingContext $finalSolution;
            {
                this.$editor = $editor;
                this.$classifiers = $classifiers;
                this.$solutions = $solutions;
                this.$stylesheet = $stylesheet;
                this.$finalSolution = $finalSolution;
                super(1);
            }

            public final void invoke(@NotNull StringBuilder $this$buildUnicodeBox) {
                Intrinsics.checkNotNullParameter((Object)$this$buildUnicodeBox, (String)"$this$buildUnicodeBox");
                $this$buildUnicodeBox.append(this.$editor.getModuleName() + ":\n");
                $this$buildUnicodeBox.append("classifiers at caret:\n\t" + this.$classifiers + "\n");
                $this$buildUnicodeBox.append("rendering solutions at caret:");
                if (((List)this.$solutions.element).isEmpty()) {
                    this.$solutions.element = CollectionsKt.listOf((Object)this.$stylesheet.getNoSolutionsRule().getPattern());
                }
                Iterable $this$forEach$iv = (Iterable)this.$solutions.element;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    ValidatedStylePattern it = (ValidatedStylePattern)element$iv;
                    boolean bl = false;
                    $this$buildUnicodeBox.append("\n>>> " + it.getSource() + " \u21d2" + PrintAllRenderingSolutions.access$actionPerformed$prettify(it.getRenderingContext()));
                }
                $this$buildUnicodeBox.append("\n::: final rendering solution \u21d2" + PrintAllRenderingSolutions.access$actionPerformed$prettify(this.$finalSolution));
            }
        }, 2, null);
        workbench.writeText(breakdown2, StreamStyle.REPORT);
    }

    private static final String actionPerformed$prettify(RenderingContext renderingContext) {
        String pretty = ((Object)StringsKt.trimEnd((CharSequence)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)renderingContext.toString(), (String)"RenderingContext(", (String)"\n\t", (boolean)false, (int)4, null), (String)"=", (String)" = ", (boolean)false, (int)4, null), (String)", ", (String)"\n\t", (boolean)false, (int)4, null), (String)")", (String)"", (boolean)false, (int)4, null))).toString();
        if (((CharSequence)pretty).length() == 0) {
            pretty = "\n\t[no overrides]";
        }
        return pretty;
    }

    public static final /* synthetic */ String access$actionPerformed$prettify(RenderingContext renderingContext) {
        return PrintAllRenderingSolutions.actionPerformed$prettify(renderingContext);
    }
}

