/*
 * Decompiled with CFR 0.152.
 */
package avail.compiler;

import avail.AvailRuntime;
import avail.AvailRuntimeConfiguration;
import avail.builder.ModuleName;
import avail.compiler.FiberTerminationException;
import avail.compiler.ModuleHeader;
import avail.compiler.problems.CompilerDiagnostics;
import avail.compiler.problems.Problem;
import avail.compiler.problems.ProblemHandler;
import avail.compiler.problems.ProblemType;
import avail.compiler.scanning.LexingState;
import avail.descriptor.atoms.A_Atom;
import avail.descriptor.atoms.AtomDescriptor;
import avail.descriptor.bundles.A_Bundle;
import avail.descriptor.fiber.A_Fiber;
import avail.descriptor.fiber.FiberDescriptor;
import avail.descriptor.functions.A_Function;
import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.functions.FunctionDescriptor;
import avail.descriptor.maps.A_Map;
import avail.descriptor.maps.MapDescriptor;
import avail.descriptor.methods.A_Method;
import avail.descriptor.methods.A_Styler;
import avail.descriptor.methods.StylerDescriptor;
import avail.descriptor.module.A_Module;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.parsing.A_Lexer;
import avail.descriptor.phrases.A_Phrase;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.sets.A_Set;
import avail.descriptor.tokens.A_Token;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.StringDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.EnumerationTypeDescriptor;
import avail.descriptor.types.PhraseTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.exceptions.AvailEmergencyExitException;
import avail.exceptions.AvailRuntimeException;
import avail.interpreter.effects.LoadingEffect;
import avail.interpreter.execution.AvailLoader;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.levelOne.L1Decompiler;
import avail.interpreter.levelOne.L1InstructionWriter;
import avail.interpreter.levelOne.L1Operation;
import avail.io.TextInterface;
import avail.persistence.cache.record.NamesIndex;
import avail.persistence.cache.record.PhrasePathRecord;
import avail.serialization.Serializer;
import avail.utility.CollectionExtensionsKt;
import avail.utility.StackPrinterKt;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.availlang.persistence.IndexedFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0088\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00a0\u00012\u00020\u0001:\u0004\u00a0\u0001\u00a1\u0001Bu\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00126\u0010\r\u001a2\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u000b\u0012\u0004\u0012\u00020\u00130\u000ej\u0002`\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017J\u0006\u0010Y\u001a\u00020\u0013J\u0006\u0010Z\u001a\u00020\u0013Jf\u0010[\u001a\u00020\u00132\u0006\u0010\\\u001a\u00020J2\u0006\u0010]\u001a\u00020^2\f\u0010_\u001a\b\u0012\u0004\u0012\u00020a0`2\u0006\u0010b\u001a\u00020c2\u0006\u0010d\u001a\u00020\f2\u0006\u0010e\u001a\u00020\f2\u0012\u0010f\u001a\u000e\u0012\u0004\u0012\u00020h\u0012\u0004\u0012\u00020\u00130g2\u0012\u0010i\u001a\u000e\u0012\u0004\u0012\u00020j\u0012\u0004\u0012\u00020\u00130gH\u0002JE\u0010k\u001a\u00020\u00132\u0006\u0010]\u001a\u00020^2\u0006\u0010l\u001a\u00020\u00122\u0012\u0010m\u001a\u000e\u0012\u0004\u0012\u00020h\u0012\u0004\u0012\u00020\u00130g2\u0012\u0010i\u001a\u000e\u0012\u0004\u0012\u00020j\u0012\u0004\u0012\u00020\u00130gH\u0000\u00a2\u0006\u0002\bnJN\u0010o\u001a\u00020\u00132\u0006\u0010p\u001a\u00020\u00122\u0006\u0010]\u001a\u00020^2\u0006\u0010d\u001a\u00020\f2\u0006\u0010e\u001a\u00020\f2\u0012\u0010f\u001a\u000e\u0012\u0004\u0012\u00020h\u0012\u0004\u0012\u00020\u00130g2\u0012\u0010i\u001a\u000e\u0012\u0004\u0012\u00020j\u0012\u0004\u0012\u00020\u00130gJ\u001c\u0010q\u001a\u00020\u00132\u0006\u0010]\u001a\u00020^2\f\u0010m\u001a\b\u0012\u0004\u0012\u00020\u00130\u000bJ\u0006\u0010r\u001a\u00020\u0013J\u0006\u0010s\u001a\u00020\u0013J(\u0010s\u001a\u00020\u00132\u001e\u0010t\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020 0\u001f0\u001eH\u0002J\u000e\u0010u\u001a\u00020J2\u0006\u0010v\u001a\u00020IJ\u0010\u0010w\u001a\u00020\u00132\u0006\u0010x\u001a\u00020\u001cH\u0002J\u000e\u0010y\u001a\u00020\u00132\u0006\u0010z\u001a\u00020\u0012J\u000e\u0010{\u001a\u00020\u00132\u0006\u0010|\u001a\u00020}J)\u0010~\u001a\u00020\u00132\u0006\u0010\u007f\u001a\u00020\u00112\u0007\u0010\u0080\u0001\u001a\u00020\u00112\b\u0010\u0081\u0001\u001a\u00030\u0082\u0001H\u0000\u00a2\u0006\u0003\b\u0083\u0001J)\u0010\u0084\u0001\u001a\u00020\u00132\u0006\u0010\u007f\u001a\u00020\u00112\u0007\u0010\u0080\u0001\u001a\u00020\u00112\u0007\u0010\u0081\u0001\u001a\u00020jH\u0000\u00a2\u0006\u0003\b\u0085\u0001J)\u0010\u0086\u0001\u001a\u00020\u00132\u0006\u0010\u007f\u001a\u00020\u00112\u0007\u0010\u0080\u0001\u001a\u00020\u00112\u0007\u0010\u0081\u0001\u001a\u00020jH\u0000\u00a2\u0006\u0003\b\u0087\u0001J\u0011\u0010\u0088\u0001\u001a\u00020\u00132\u0006\u0010\\\u001a\u00020JH\u0002J\u0017\u0010\u0089\u0001\u001a\u00020\u00132\u0006\u0010\\\u001a\u00020JH\u0000\u00a2\u0006\u0003\b\u008a\u0001J\u0010\u0010\u008b\u0001\u001a\u00020\u00132\u0007\u0010\u008c\u0001\u001a\u00020\u0011J*\u0010\u008d\u0001\u001a\u00020\u00132\t\u0010\u008e\u0001\u001a\u0004\u0018\u00010\u00122\u0007\u0010\u008f\u0001\u001a\u00020\u00122\r\u0010\u0090\u0001\u001a\b\u0012\u0004\u0012\u00020\u00130\u000bJ6\u0010\u0091\u0001\u001a\u00020\u00132\u000e\u0010\u0092\u0001\u001a\t\u0012\u0004\u0012\u00020\u00120\u0093\u00012\u000e\u0010\u0094\u0001\u001a\t\u0012\u0004\u0012\u00020\u00120\u0095\u00012\r\u0010\u0090\u0001\u001a\b\u0012\u0004\u0012\u00020\u00130\u000bJ\u0016\u0010\u0096\u0001\u001a\u00020\u00132\r\u0010\u0097\u0001\u001a\b\u0012\u0004\u0012\u00020\u00130\u000bJD\u0010\u0098\u0001\u001a\u000f\u0012\u0005\u0012\u0003H\u0099\u0001\u0012\u0004\u0012\u00020\u00130g\"\u0005\b\u0000\u0010\u0099\u00012\u0006\u0010]\u001a\u00020^2\n\u0010\u009a\u0001\u001a\u0005\u0018\u00010\u009b\u00012\u0013\u0010m\u001a\u000f\u0012\u0005\u0012\u0003H\u0099\u0001\u0012\u0004\u0012\u00020\u00130gJB\u0010\u009c\u0001\u001a\u00020\u0013\"\u0005\b\u0000\u0010\u0099\u00012\u0006\u0010]\u001a\u00020^2\u001a\u0010\u009d\u0001\u001a\u0015\u0012\u0011\u0012\u000f\u0012\u0005\u0012\u0003H\u0099\u0001\u0012\u0004\u0012\u00020\u00130g0`2\b\u0010\u009e\u0001\u001a\u0003H\u0099\u0001\u00a2\u0006\u0003\u0010\u009f\u0001R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u001d\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020 0\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010!\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020 0\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020'\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0014\u0010.\u001a\u00020\u000f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R4\u00102\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u000b2\u000e\u00101\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u000b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106RA\u0010\r\u001a2\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u000b\u0012\u0004\u0012\u00020\u00130\u000ej\u0002`\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R\u0011\u00109\u001a\u00020:\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<R\u0014\u0010=\u001a\u00020>X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010@R\u0011\u0010A\u001a\u00020B\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010DR\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010FR\u001a\u0010G\u001a\u000e\u0012\u0004\u0012\u00020I\u0012\u0004\u0012\u00020J0HX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010K\u001a\b\u0012\u0004\u0012\u00020M0LX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010N\u001a\u00020O8F\u00a2\u0006\u0006\u001a\u0004\bP\u0010QR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\bR\u0010SR\u0011\u0010T\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\bU\u0010VR\u0011\u0010W\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\bX\u0010V\u00a8\u0006\u00a2\u0001"}, d2={"Lavail/compiler/CompilationContext;", "", "moduleHeader", "Lavail/compiler/ModuleHeader;", "module", "Lavail/descriptor/module/A_Module;", "source", "Lavail/descriptor/tuples/A_String;", "textInterface", "Lavail/io/TextInterface;", "pollForAbort", "Lkotlin/Function0;", "", "progressReporter", "Lkotlin/Function5;", "Lavail/builder/ModuleName;", "", "", "Lavail/descriptor/phrases/A_Phrase;", "", "Lavail/compiler/CompilerProgressReporter;", "problemHandler", "Lavail/compiler/problems/ProblemHandler;", "(Lavail/compiler/ModuleHeader;Lavail/descriptor/module/A_Module;Lavail/descriptor/tuples/A_String;Lavail/io/TextInterface;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function5;Lavail/compiler/problems/ProblemHandler;)V", "atomicWorkUnitsCompleted", "Ljava/util/concurrent/atomic/AtomicLong;", "atomicWorkUnitsQueued", "debugModuleName", "", "delayedSerializedEarlyEffects", "", "Lkotlin/Triple;", "Lavail/interpreter/effects/LoadingEffect;", "delayedSerializedEffects", "diagnostics", "Lavail/compiler/problems/CompilerDiagnostics;", "getDiagnostics", "()Lavail/compiler/problems/CompilerDiagnostics;", "loader", "Lavail/interpreter/execution/AvailLoader;", "getLoader", "()Lavail/interpreter/execution/AvailLoader;", "getModule", "()Lavail/descriptor/module/A_Module;", "getModuleHeader", "()Lavail/compiler/ModuleHeader;", "moduleName", "getModuleName$avail", "()Lavail/builder/ModuleName;", "newNoMoreWorkUnits", "noMoreWorkUnits", "getNoMoreWorkUnits", "()Lkotlin/jvm/functions/Function0;", "setNoMoreWorkUnits", "(Lkotlin/jvm/functions/Function0;)V", "getProgressReporter", "()Lkotlin/jvm/functions/Function5;", "runtime", "Lavail/AvailRuntime;", "getRuntime", "()Lavail/AvailRuntime;", "serializer", "Lavail/serialization/Serializer;", "getSerializer$avail", "()Lavail/serialization/Serializer;", "serializerOutputStream", "Lorg/availlang/persistence/IndexedFile$ByteArrayOutputStream;", "getSerializerOutputStream", "()Lorg/availlang/persistence/IndexedFile$ByteArrayOutputStream;", "getSource$avail", "()Lavail/descriptor/tuples/A_String;", "styleCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lavail/descriptor/methods/A_Method;", "Lavail/descriptor/functions/A_Function;", "stylingState", "Ljava/util/concurrent/atomic/AtomicReference;", "Lavail/compiler/CompilationContext$StylingCompletionState;", "surrogateIndexConverter", "Lavail/descriptor/tuples/A_String$SurrogateIndexConverter;", "getSurrogateIndexConverter", "()Lavail/descriptor/tuples/A_String$SurrogateIndexConverter;", "getTextInterface", "()Lavail/io/TextInterface;", "workUnitsCompleted", "getWorkUnitsCompleted", "()J", "workUnitsQueued", "getWorkUnitsQueued", "beginningStyling", "clearStyleCache", "evaluateFunctionThen", "function", "lexingState", "Lavail/compiler/scanning/LexingState;", "args", "", "Lavail/descriptor/representation/A_BasicObject;", "clientParseData", "Lavail/descriptor/maps/A_Map;", "shouldSerialize", "trackTasks", "onSuccess", "Lkotlin/Function1;", "Lavail/descriptor/representation/AvailObject;", "onFailure", "", "evaluatePhraseAtThen", "expression", "continuation", "evaluatePhraseAtThen$avail", "evaluatePhraseThen", "expressionNode", "eventuallyDo", "finishedStyling", "flushDelayedSerializedEffects", "effects", "getStylerFunction", "method", "logWorkUnits", "debugString", "recordPathForTopLevelPhrase", "rootPhrase", "recordToken", "token", "Lavail/descriptor/tokens/A_Token;", "reportEmergencyExitProblem", "lineNumber", "position", "e", "Lavail/exceptions/AvailEmergencyExitException;", "reportEmergencyExitProblem$avail", "reportExecutionProblem", "reportExecutionProblem$avail", "reportInternalProblem", "reportInternalProblem$avail", "serializeAfterRunning", "serializeWithoutSummary", "serializeWithoutSummary$avail", "startWorkUnits", "countToBeQueued", "styleSendThen", "originalSendPhrase", "transformedPhrase", "then", "visitAll", "phrases", "", "visitedSet", "", "whenNotStyling", "action", "workUnitCompletion", "ArgType", "optionalSafetyCheck", "Ljava/util/concurrent/atomic/AtomicBoolean;", "workUnitsDo", "continuations", "argument", "(Lavail/compiler/scanning/LexingState;Ljava/util/List;Ljava/lang/Object;)V", "Companion", "StylingCompletionState", "avail"})
@SourceDebugExtension(value={"SMAP\nCompilationContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompilationContext.kt\navail/compiler/CompilationContext\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Casts.kt\navail/utility/CastsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1449:1\n107#2:1450\n79#2,22:1451\n107#2:1475\n79#2,22:1476\n37#3,2:1473\n1855#4,2:1498\n1864#4,3:1500\n1620#4,3:1503\n1620#4,3:1506\n1855#4,2:1511\n766#4:1513\n857#4,2:1514\n766#4:1516\n857#4,2:1517\n766#4:1519\n857#4:1520\n2624#4,3:1521\n858#4:1524\n1603#4,9:1525\n1855#4:1534\n1856#4:1536\n1612#4:1537\n59#5:1509\n1#6:1510\n1#6:1535\n*S KotlinDebug\n*F\n+ 1 CompilationContext.kt\navail/compiler/CompilationContext\n*L\n298#1:1450\n298#1:1451,22\n451#1:1475\n451#1:1476,22\n433#1:1473,2\n591#1:1498,2\n807#1:1500,3\n856#1:1503,3\n859#1:1506,3\n1144#1:1511,2\n1218#1:1513\n1218#1:1514,2\n1230#1:1516\n1230#1:1517,2\n1231#1:1519\n1231#1:1520\n1232#1:1521,3\n1231#1:1524\n1403#1:1525,9\n1403#1:1534\n1403#1:1536\n1403#1:1537\n1075#1:1509\n1403#1:1535\n*E\n"})
public final class CompilationContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final ModuleHeader moduleHeader;
    @NotNull
    private final A_Module module;
    @NotNull
    private final A_String source;
    @NotNull
    private final TextInterface textInterface;
    @NotNull
    private final Function5<ModuleName, Long, Long, Integer, Function0<? extends A_Phrase>, Unit> progressReporter;
    @NotNull
    private final CompilerDiagnostics diagnostics;
    @NotNull
    private final AvailRuntime runtime;
    @NotNull
    private final AvailLoader loader;
    @NotNull
    private final AtomicLong atomicWorkUnitsQueued;
    @NotNull
    private final AtomicLong atomicWorkUnitsCompleted;
    @Nullable
    private volatile Function0<Unit> noMoreWorkUnits;
    @NotNull
    private final IndexedFile.ByteArrayOutputStream serializerOutputStream;
    @NotNull
    private final Serializer serializer;
    @Nullable
    private volatile String debugModuleName;
    @NotNull
    private final List<Triple<Integer, A_Phrase, LoadingEffect>> delayedSerializedEarlyEffects;
    @NotNull
    private final List<Triple<Integer, A_Phrase, LoadingEffect>> delayedSerializedEffects;
    @NotNull
    private final ConcurrentHashMap<A_Method, A_Function> styleCache;
    @NotNull
    private final AtomicReference<StylingCompletionState> stylingState;
    @NotNull
    private static final Logger logger;

    /*
     * WARNING - void declaration
     */
    public CompilationContext(@Nullable ModuleHeader moduleHeader, @NotNull A_Module module, @NotNull A_String source, @NotNull TextInterface textInterface, @NotNull Function0<Boolean> pollForAbort2, @NotNull Function5<? super ModuleName, ? super Long, ? super Long, ? super Integer, ? super Function0<? extends A_Phrase>, Unit> progressReporter, @NotNull ProblemHandler problemHandler) {
        void $this$loader_u24lambda_u240;
        AvailLoader availLoader;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)textInterface, (String)"textInterface");
        Intrinsics.checkNotNullParameter(pollForAbort2, (String)"pollForAbort");
        Intrinsics.checkNotNullParameter(progressReporter, (String)"progressReporter");
        Intrinsics.checkNotNullParameter((Object)problemHandler, (String)"problemHandler");
        this.moduleHeader = moduleHeader;
        this.module = module;
        this.source = source;
        this.textInterface = textInterface;
        this.progressReporter = progressReporter;
        this.diagnostics = new CompilerDiagnostics(this.source, this.getModuleName$avail(), pollForAbort2, problemHandler);
        this.runtime = AvailRuntime.Companion.currentRuntime();
        AvailLoader availLoader2 = availLoader = new AvailLoader(this.runtime, this.module, this.textInterface);
        CompilationContext compilationContext = this;
        boolean bl = false;
        $this$loader_u24lambda_u240.setManifestEntries(new ArrayList());
        $this$loader_u24lambda_u240.setNamesIndex(new NamesIndex(new LinkedHashMap(), null));
        compilationContext.loader = availLoader;
        this.atomicWorkUnitsQueued = new AtomicLong(0L);
        this.atomicWorkUnitsCompleted = new AtomicLong(0L);
        this.serializerOutputStream = new IndexedFile.ByteArrayOutputStream(1000);
        this.serializer = new Serializer((OutputStream)this.serializerOutputStream, this.module, null, 4, null);
        this.delayedSerializedEarlyEffects = new ArrayList();
        this.delayedSerializedEffects = new ArrayList();
        this.styleCache = new ConcurrentHashMap();
        this.stylingState = new AtomicReference<StylingCompletionState.NotStyling>(StylingCompletionState.NotStyling.INSTANCE);
    }

    @Nullable
    public final ModuleHeader getModuleHeader() {
        return this.moduleHeader;
    }

    @NotNull
    public final A_Module getModule() {
        return this.module;
    }

    @NotNull
    public final A_String getSource$avail() {
        return this.source;
    }

    @NotNull
    public final TextInterface getTextInterface() {
        return this.textInterface;
    }

    @NotNull
    public final Function5<ModuleName, Long, Long, Integer, Function0<? extends A_Phrase>, Unit> getProgressReporter() {
        return this.progressReporter;
    }

    @NotNull
    public final CompilerDiagnostics getDiagnostics() {
        return this.diagnostics;
    }

    @NotNull
    public final A_String.SurrogateIndexConverter getSurrogateIndexConverter() {
        return this.diagnostics.getSurrogateIndexConverter();
    }

    @NotNull
    public final AvailRuntime getRuntime() {
        return this.runtime;
    }

    @NotNull
    public final AvailLoader getLoader() {
        return this.loader;
    }

    @Nullable
    public final Function0<Unit> getNoMoreWorkUnits() {
        return this.noMoreWorkUnits;
    }

    /*
     * WARNING - void declaration
     */
    public final void setNoMoreWorkUnits(@Nullable Function0<Unit> newNoMoreWorkUnits) {
        boolean bl;
        boolean bl2 = bl = newNoMoreWorkUnits == null != (this.noMoreWorkUnits == null);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-CompilationContext$noMoreWorkUnits$22 = false;
            String $i$a$-assert-CompilationContext$noMoreWorkUnits$22 = "noMoreWorkUnits must transition to or from null";
            throw new AssertionError((Object)$i$a$-assert-CompilationContext$noMoreWorkUnits$22);
        }
        if (Interpreter.Companion.getDebugWorkUnits()) {
            void $this$trim$iv;
            boolean wasNull = this.noMoreWorkUnits == null;
            boolean isNull = newNoMoreWorkUnits == null;
            String string2 = (isNull ? "\nClear" : "\nSet") + " noMoreWorkUnits (was " + (wasNull ? "null)" : "non-null)");
            System.out.println((Object)string2);
            StringBuilder builder = new StringBuilder();
            Throwable e = new Throwable().fillInStackTrace();
            Intrinsics.checkNotNull((Object)e);
            builder.append(StackPrinterKt.getStackToString(e));
            String string3 = builder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
            CharSequence charSequence = string3;
            Regex regex = new Regex("\\A.*?\\R((.*?\\R){6})(.|\\R)*?\\z");
            String string4 = "$1";
            String trace2 = regex.replace(charSequence, string4);
            charSequence = trace2;
            CompilationContext compilationContext = this;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl3 = false;
                boolean bl4 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            compilationContext.logWorkUnits("SetNoMoreWorkUnits:\n\t" + ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
        }
        if (newNoMoreWorkUnits == null) {
            this.noMoreWorkUnits = null;
        } else {
            AtomicBoolean ran = new AtomicBoolean(false);
            this.noMoreWorkUnits = (Function0)new Function0<Unit>(ran, this, newNoMoreWorkUnits){
                final /* synthetic */ AtomicBoolean $ran;
                final /* synthetic */ CompilationContext this$0;
                final /* synthetic */ Function0<Unit> $newNoMoreWorkUnits;
                {
                    this.$ran = $ran;
                    this.this$0 = $receiver;
                    this.$newNoMoreWorkUnits = $newNoMoreWorkUnits;
                    super(0);
                }

                public final void invoke() {
                    boolean bl;
                    boolean bl2 = bl = !this.$ran.getAndSet(true);
                    if (_Assertions.ENABLED && !bl) {
                        boolean bl3 = false;
                        String string2 = "Attempting to invoke the same noMoreWorkUnits twice";
                        throw new AssertionError((Object)string2);
                    }
                    if (Interpreter.Companion.getDebugWorkUnits()) {
                        CompilationContext.access$logWorkUnits(this.this$0, "Running noMoreWorkUnits");
                    }
                    this.$newNoMoreWorkUnits.invoke();
                }
            };
        }
    }

    @NotNull
    public final IndexedFile.ByteArrayOutputStream getSerializerOutputStream() {
        return this.serializerOutputStream;
    }

    @NotNull
    public final Serializer getSerializer$avail() {
        return this.serializer;
    }

    @NotNull
    public final ModuleName getModuleName$avail() {
        return new ModuleName(A_Module.Companion.getModuleNameNative(this.module), false, 2, null);
    }

    public final long getWorkUnitsQueued() {
        return this.atomicWorkUnitsQueued.get();
    }

    public final long getWorkUnitsCompleted() {
        return this.atomicWorkUnitsCompleted.get();
    }

    public final void recordToken(@NotNull A_Token token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.diagnostics.recordToken(token);
    }

    public final void eventuallyDo(@NotNull LexingState lexingState, @NotNull Function0<Unit> continuation) {
        Intrinsics.checkNotNullParameter((Object)lexingState, (String)"lexingState");
        Intrinsics.checkNotNullParameter(continuation, (String)"continuation");
        this.runtime.execute(50, (Function0<Unit>)((Function0)new Function0<Unit>(continuation, this, lexingState){
            final /* synthetic */ Function0<Unit> $continuation;
            final /* synthetic */ CompilationContext this$0;
            final /* synthetic */ LexingState $lexingState;
            {
                this.$continuation = $continuation;
                this.this$0 = $receiver;
                this.$lexingState = $lexingState;
                super(0);
            }

            public final void invoke() {
                try {
                    this.$continuation.invoke();
                }
                catch (Exception e) {
                    this.this$0.reportInternalProblem$avail(this.$lexingState.getLineNumber(), this.$lexingState.getPosition(), e);
                }
            }
        }));
    }

    private final void logWorkUnits(String debugString) {
        String moduleName2 = this.debugModuleName;
        if (moduleName2 == null) {
            this.debugModuleName = moduleName2 = this.getModuleName$avail().getLocalName();
        }
        StringBuilder builder = new StringBuilder();
        String[] stringArray = new String[]{"\n"};
        for (String line : StringsKt.split$default((CharSequence)debugString, (String[])stringArray, (boolean)false, (int)0, (int)6, null)) {
            builder.append(moduleName2);
            builder.append("   ");
            builder.append(line);
            builder.append('\n');
        }
        System.out.print(builder);
    }

    /*
     * WARNING - void declaration
     */
    public final void startWorkUnits(int countToBeQueued) {
        boolean bl;
        boolean bl2 = bl = this.noMoreWorkUnits != null;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        boolean bl3 = bl = countToBeQueued > 0;
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        long queued = this.atomicWorkUnitsQueued.addAndGet(countToBeQueued);
        if (Interpreter.Companion.getDebugWorkUnits()) {
            void $this$trim$iv;
            String $this$toTypedArray$iv;
            long completed = this.getWorkUnitsCompleted();
            StringBuilder builder = new StringBuilder();
            Throwable e = new Throwable().fillInStackTrace();
            Intrinsics.checkNotNull((Object)e);
            builder.append(StackPrinterKt.getStackToString(e));
            String string4 = builder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
            Object object = string4;
            Regex regex = new Regex("\n");
            int n = 7;
            object = regex.split((CharSequence)object, n);
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            Object[] lines = thisCollection$iv.toArray(new String[0]);
            if (lines.length > 6) {
                String[] stringArray = Arrays.copyOf(lines, lines.length - 1);
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"copyOf(this, newSize)");
                lines = stringArray;
            }
            $this$toTypedArray$iv = ArraysKt.joinToString$default((Object[])lines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            Object object2 = countToBeQueued > 1 ? " (bulk = +" + countToBeQueued + ")" : "";
            long l = queued - completed;
            long l2 = completed;
            long l3 = queued;
            CompilationContext compilationContext = this;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl4 = false;
                boolean bl5 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            String string5 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            compilationContext.logWorkUnits("Starting work unit: queued = " + l3 + ", completed = " + l2 + " (delta=" + l + ")" + (String)object2 + "\n\t" + string5);
        }
        if (logger.isLoggable(Level.FINEST)) {
            Object[] objectArray = new Object[]{this.getWorkUnitsCompleted(), this.getWorkUnitsQueued()};
            logger.log(Level.FINEST, String.format("Started work unit: %d/%d%n", objectArray));
        }
    }

    @NotNull
    public final <ArgType> Function1<ArgType, Unit> workUnitCompletion(@NotNull LexingState lexingState, @Nullable AtomicBoolean optionalSafetyCheck, @NotNull Function1<? super ArgType, Unit> continuation) {
        AtomicBoolean hasRunSafetyCheck;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)lexingState, (String)"lexingState");
        Intrinsics.checkNotNullParameter(continuation, (String)"continuation");
        boolean bl2 = bl = this.noMoreWorkUnits != null;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        AtomicBoolean atomicBoolean = optionalSafetyCheck;
        if (atomicBoolean == null) {
            atomicBoolean = hasRunSafetyCheck = new AtomicBoolean(false);
        }
        if (Interpreter.Companion.getDebugWorkUnits()) {
            this.logWorkUnits("Creating unit for continuation @" + continuation.hashCode());
        }
        return new Function1<ArgType, Unit>(hasRunSafetyCheck, continuation, this, lexingState){
            final /* synthetic */ AtomicBoolean $hasRunSafetyCheck;
            final /* synthetic */ Function1<ArgType, Unit> $continuation;
            final /* synthetic */ CompilationContext this$0;
            final /* synthetic */ LexingState $lexingState;
            {
                this.$hasRunSafetyCheck = $hasRunSafetyCheck;
                this.$continuation = $continuation;
                this.this$0 = $receiver;
                this.$lexingState = $lexingState;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(ArgType value) {
                boolean bl;
                long queued;
                long completed;
                boolean bl2;
                boolean hadRun = this.$hasRunSafetyCheck.getAndSet(true);
                boolean bl3 = bl2 = !hadRun;
                if (_Assertions.ENABLED && !bl2) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                try {
                    this.$continuation.invoke(value);
                    completed = CompilationContext.access$getAtomicWorkUnitsCompleted$p(this.this$0).incrementAndGet();
                    queued = this.this$0.getWorkUnitsQueued();
                    boolean bl4 = bl = completed <= queued;
                }
                catch (Exception e) {
                    boolean e22;
                    long queued2;
                    long completed2;
                    try {
                        this.this$0.reportInternalProblem$avail(this.$lexingState.getLineNumber(), this.$lexingState.getPosition(), e);
                        completed2 = CompilationContext.access$getAtomicWorkUnitsCompleted$p(this.this$0).incrementAndGet();
                        queued2 = this.this$0.getWorkUnitsQueued();
                        boolean bl5 = e22 = completed2 <= queued2;
                    }
                    catch (Throwable throwable) {
                        boolean bl6;
                        long completed3 = CompilationContext.access$getAtomicWorkUnitsCompleted$p(this.this$0).incrementAndGet();
                        long queued3 = this.this$0.getWorkUnitsQueued();
                        boolean bl7 = bl6 = completed3 <= queued3;
                        if (_Assertions.ENABLED && !bl6) {
                            String string3 = "Assertion failed";
                            throw new AssertionError((Object)string3);
                        }
                        if (Interpreter.Companion.getDebugWorkUnits()) {
                            CompilationContext.access$logWorkUnits(this.this$0, "Completed work unit: queued = " + queued3 + ", completed = " + completed3 + " (delta=" + (queued3 - completed3) + ")");
                        }
                        if (CompilationContext.Companion.getLogger().isLoggable(Level.FINEST)) {
                            Object[] objectArray = new Object[]{completed3, queued3};
                            CompilationContext.Companion.getLogger().log(Level.FINEST, String.format("Completed work unit: %d/%d%n", objectArray));
                        }
                        if (completed3 == queued3) {
                            try {
                                Function0<Unit> function0 = this.this$0.getNoMoreWorkUnits();
                                Intrinsics.checkNotNull(function0);
                                Function0<Unit> noMore = function0;
                                this.this$0.setNoMoreWorkUnits(null);
                                noMore.invoke();
                            }
                            catch (Exception e3) {
                                this.this$0.reportInternalProblem$avail(this.$lexingState.getLineNumber(), this.$lexingState.getPosition(), e3);
                            }
                        }
                        throw throwable;
                    }
                    if (_Assertions.ENABLED && !e22) {
                        String string4 = "Assertion failed";
                        throw new AssertionError((Object)string4);
                    }
                    if (Interpreter.Companion.getDebugWorkUnits()) {
                        CompilationContext.access$logWorkUnits(this.this$0, "Completed work unit: queued = " + queued2 + ", completed = " + completed2 + " (delta=" + (queued2 - completed2) + ")");
                    }
                    if (CompilationContext.Companion.getLogger().isLoggable(Level.FINEST)) {
                        Object[] e22 = new Object[]{completed2, queued2};
                        CompilationContext.Companion.getLogger().log(Level.FINEST, String.format("Completed work unit: %d/%d%n", e22));
                    }
                    if (completed2 == queued2) {
                        try {
                            Function0<Unit> function0 = this.this$0.getNoMoreWorkUnits();
                            Intrinsics.checkNotNull(function0);
                            Function0<Unit> noMore = function0;
                            this.this$0.setNoMoreWorkUnits(null);
                            noMore.invoke();
                        }
                        catch (Exception e4) {
                            this.this$0.reportInternalProblem$avail(this.$lexingState.getLineNumber(), this.$lexingState.getPosition(), e4);
                        }
                    }
                }
                if (_Assertions.ENABLED && !bl) {
                    String string5 = "Assertion failed";
                    throw new AssertionError((Object)string5);
                }
                if (Interpreter.Companion.getDebugWorkUnits()) {
                    CompilationContext.access$logWorkUnits(this.this$0, "Completed work unit: queued = " + queued + ", completed = " + completed + " (delta=" + (queued - completed) + ")");
                }
                if (CompilationContext.Companion.getLogger().isLoggable(Level.FINEST)) {
                    Object[] objectArray = new Object[]{completed, queued};
                    CompilationContext.Companion.getLogger().log(Level.FINEST, String.format("Completed work unit: %d/%d%n", objectArray));
                }
                if (completed == queued) {
                    try {
                        Function0<Unit> function0 = this.this$0.getNoMoreWorkUnits();
                        Intrinsics.checkNotNull(function0);
                        Function0<Unit> noMore = function0;
                        this.this$0.setNoMoreWorkUnits(null);
                        noMore.invoke();
                    }
                    catch (Exception e22) {
                        this.this$0.reportInternalProblem$avail(this.$lexingState.getLineNumber(), this.$lexingState.getPosition(), e22);
                    }
                }
            }
        };
    }

    public final <ArgType> void workUnitsDo(@NotNull LexingState lexingState, @NotNull List<? extends Function1<? super ArgType, Unit>> continuations, ArgType argument) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)lexingState, (String)"lexingState");
        Intrinsics.checkNotNullParameter(continuations, (String)"continuations");
        boolean bl2 = bl = !((Collection)continuations).isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        boolean bl3 = bl = this.noMoreWorkUnits != null;
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        this.startWorkUnits(continuations.size());
        Iterable $this$forEach$iv = continuations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 continuation = (Function1)element$iv;
            boolean bl4 = false;
            Function1<ArgType, Unit> workUnit2 = this.workUnitCompletion(lexingState, null, continuation);
            this.runtime.execute(50, (Function0<Unit>)((Function0)new Function0<Unit>(workUnit2, argument){
                final /* synthetic */ Function1<ArgType, Unit> $workUnit;
                final /* synthetic */ ArgType $argument;
                {
                    this.$workUnit = $workUnit;
                    this.$argument = $argument;
                    super(0);
                }

                public final void invoke() {
                    this.$workUnit.invoke(this.$argument);
                }
            }));
        }
    }

    private final void evaluateFunctionThen(A_Function function, LexingState lexingState, List<? extends A_BasicObject> args, A_Map clientParseData, boolean shouldSerialize, boolean trackTasks, Function1<? super AvailObject, Unit> onSuccess, Function1<? super Throwable, Unit> onFailure) {
        Function1 adjustedSuccess2;
        boolean bl;
        A_RawFunction code = function.code();
        boolean bl2 = bl = A_RawFunction.Companion.numArgs(code) == args.size();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        A_Fiber fiber2 = FiberDescriptor.Companion.newLoaderFiber(A_Type.Companion.getReturnType(function.kind()), this.loader, (Function0<? extends A_String>)((Function0)new Function0<A_String>(code){
            final /* synthetic */ A_RawFunction $code;
            {
                this.$code = $code;
                super(0);
            }

            @NotNull
            public final A_String invoke() {
                Object[] objectArray = new Object[]{A_RawFunction.Companion.getMethodName(this.$code), A_Module.Companion.getShortModuleNameNative(A_RawFunction.Companion.getModule(this.$code)), A_RawFunction.Companion.getCodeStartingLineNumber(this.$code)};
                return StringDescriptor.Companion.formatString("Eval fn=%s, in %s:%d", objectArray);
            }
        }));
        A_Fiber.Companion.setFiberGlobals(fiber2, A_Map.Companion.mapAtPuttingCanDestroy(A_Fiber.Companion.getFiberGlobals(fiber2), AtomDescriptor.SpecialAtom.CLIENT_DATA_GLOBAL_KEY.getAtom(), clientParseData, true));
        if (shouldSerialize) {
            this.loader.startRecordingEffects();
        }
        if (shouldSerialize) {
            long before = A_Fiber.Companion.getFiberHelper(fiber2).fiberTime();
            boolean bl3 = false;
            v1 = (Function1)new Function1<AvailObject, Unit>(fiber2, before, this, function, onSuccess){
                final /* synthetic */ A_Fiber $fiber;
                final /* synthetic */ long $before;
                final /* synthetic */ CompilationContext this$0;
                final /* synthetic */ A_Function $function;
                final /* synthetic */ Function1<AvailObject, Unit> $onSuccess;
                {
                    this.$fiber = $fiber;
                    this.$before = $before;
                    this.this$0 = $receiver;
                    this.$function = $function;
                    this.$onSuccess = $onSuccess;
                    super(1);
                }

                public final void invoke(@NotNull AvailObject successValue) {
                    Intrinsics.checkNotNullParameter((Object)successValue, (String)"successValue");
                    long after = A_Fiber.Companion.getFiberHelper(this.$fiber).fiberTime();
                    Interpreter.Companion.current().recordTopStatementEvaluation(after - this.$before, this.this$0.getModule());
                    this.this$0.getLoader().stopRecordingEffects();
                    CompilationContext.access$serializeAfterRunning(this.this$0, this.$function);
                    this.$onSuccess.invoke((Object)successValue);
                }
            };
        } else {
            v1 = adjustedSuccess2 = onSuccess;
        }
        if (trackTasks) {
            lexingState.setFiberContinuationsTrackingWork(fiber2, adjustedSuccess2, onFailure);
        } else {
            A_Fiber.Companion.setSuccessAndFailure(fiber2, adjustedSuccess2, onFailure);
        }
        this.runtime.runOutermostFunction(fiber2, function, args, false);
    }

    public final void evaluatePhraseThen(@NotNull A_Phrase expressionNode, @NotNull LexingState lexingState, boolean shouldSerialize, boolean trackTasks, @NotNull Function1<? super AvailObject, Unit> onSuccess, @NotNull Function1<? super Throwable, Unit> onFailure) {
        A_Function a_Function;
        Intrinsics.checkNotNullParameter((Object)expressionNode, (String)"expressionNode");
        Intrinsics.checkNotNullParameter((Object)lexingState, (String)"lexingState");
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        Intrinsics.checkNotNullParameter(onFailure, (String)"onFailure");
        try {
            a_Function = FunctionDescriptor.Companion.createFunctionForPhrase(expressionNode, this.module, lexingState.getLineNumber());
        }
        catch (AvailRuntimeException e) {
            onFailure.invoke((Object)e);
            return;
        }
        A_Function function = a_Function;
        if (shouldSerialize) {
            this.loader.setTopLevelStatementBeingCompiled(A_RawFunction.Companion.getOriginatingPhrase(function.code()));
        }
        this.evaluateFunctionThen(function, lexingState, CollectionsKt.emptyList(), MapDescriptor.Companion.getEmptyMap(), shouldSerialize, trackTasks, onSuccess, onFailure);
    }

    public final void evaluatePhraseAtThen$avail(@NotNull LexingState lexingState, @NotNull A_Phrase expression2, @NotNull Function1<? super AvailObject, Unit> continuation, @NotNull Function1<? super Throwable, Unit> onFailure) {
        Intrinsics.checkNotNullParameter((Object)lexingState, (String)"lexingState");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter(continuation, (String)"continuation");
        Intrinsics.checkNotNullParameter(onFailure, (String)"onFailure");
        this.evaluatePhraseThen(expression2, lexingState, false, true, continuation, onFailure);
    }

    public final void flushDelayedSerializedEffects() {
        this.flushDelayedSerializedEffects(this.delayedSerializedEarlyEffects);
        this.flushDelayedSerializedEffects(this.delayedSerializedEffects);
    }

    private final void flushDelayedSerializedEffects(List<Triple<Integer, A_Phrase, LoadingEffect>> effects) {
        if (effects.isEmpty()) {
            return;
        }
        L1InstructionWriter writer = new L1InstructionWriter(this.module, ((Number)((Triple)CollectionsKt.first(effects)).getFirst()).intValue(), (A_Phrase)((Triple)CollectionsKt.first(effects)).getSecond());
        writer.argumentTypes(new A_Type[0]);
        writer.setReturnType(PrimitiveTypeDescriptor.Types.TOP.getO());
        writer.setReturnTypeIfPrimitiveFails(PrimitiveTypeDescriptor.Types.TOP.getO());
        Iterable $this$forEachIndexed$iv = effects;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Triple triple = (Triple)item$iv;
            int i2 = n;
            boolean bl = false;
            int line = ((Number)triple.component1()).intValue();
            LoadingEffect effect = (LoadingEffect)triple.component3();
            if (i2 > 0) {
                writer.write(0, L1Operation.L1_doPop, new int[0]);
            }
            effect.writeEffectTo(writer, line);
        }
        A_Function summaryFunction = FunctionDescriptor.Companion.createFunction(writer.compiledCode(), TupleDescriptor.Companion.getEmptyTuple());
        if (AvailLoader.Companion.getDebugUnsummarizedStatements()) {
            CharSequence charSequence;
            StringBuilder $this$flushDelayedSerializedEffects_u24lambda_u247 = charSequence = new StringBuilder();
            boolean bl = false;
            $this$flushDelayedSerializedEffects_u24lambda_u247.append(A_Module.Companion.getModuleNameNative(this.module));
            $this$flushDelayedSerializedEffects_u24lambda_u247.append(':');
            $this$flushDelayedSerializedEffects_u24lambda_u247.append(((Number)((Triple)CollectionsKt.first(effects)).getFirst()).intValue());
            $this$flushDelayedSerializedEffects_u24lambda_u247.append('-');
            $this$flushDelayedSerializedEffects_u24lambda_u247.append(((Number)((Triple)CollectionsKt.last(effects)).getFirst()).intValue());
            if (effects == this.delayedSerializedEarlyEffects) {
                $this$flushDelayedSerializedEffects_u24lambda_u247.append(" Early Summary -- \n");
            } else {
                $this$flushDelayedSerializedEffects_u24lambda_u247.append(" Summary -- \n");
            }
            $this$flushDelayedSerializedEffects_u24lambda_u247.append(L1Decompiler.Companion.decompile(summaryFunction.code()));
            $this$flushDelayedSerializedEffects_u24lambda_u247.append("(batch = " + effects.size() + ")");
            String string2 = charSequence.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
            charSequence = string2;
            System.out.println(charSequence);
        }
        this.serializer.serialize(summaryFunction);
        effects.clear();
    }

    private final synchronized void serializeAfterRunning(A_Function function) {
        A_Phrase phrase = A_RawFunction.Companion.getOriginatingPhrase(function.code());
        int startingLineNumber = A_RawFunction.Companion.getCodeStartingLineNumber(function.code());
        if (this.loader.statementCanBeSummarized()) {
            LoadingEffect effect;
            Collection collection2;
            Iterable $this$mapTo$iv;
            List<LoadingEffect> newEarlyEffects = this.loader.recordedEarlyEffects();
            List<LoadingEffect> newEffects = this.loader.recordedEffects();
            Iterable iterable = newEarlyEffects;
            Collection destination$iv = this.delayedSerializedEarlyEffects;
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                LoadingEffect loadingEffect = (LoadingEffect)item$iv;
                collection2 = destination$iv;
                boolean bl = false;
                collection2.add(new Triple((Object)startingLineNumber, (Object)phrase, (Object)effect));
            }
            $this$mapTo$iv = newEffects;
            destination$iv = this.delayedSerializedEffects;
            $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                effect = (LoadingEffect)item$iv;
                collection2 = destination$iv;
                boolean bl = false;
                collection2.add(new Triple((Object)startingLineNumber, (Object)phrase, (Object)effect));
            }
        } else {
            this.flushDelayedSerializedEffects();
            if (AvailLoader.Companion.getDebugUnsummarizedStatements()) {
                String string2 = A_Module.Companion.getModuleNameNative(this.module) + ":" + startingLineNumber + " Unsummarized -- \n" + function;
                System.out.println((Object)string2);
            }
            this.serializer.serialize(function);
        }
    }

    public final synchronized void serializeWithoutSummary$avail(@NotNull A_Function function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        if (AvailLoader.Companion.getDebugUnsummarizedStatements()) {
            String string2 = A_Module.Companion.getModuleNameNative(this.module) + ":" + A_RawFunction.Companion.getCodeStartingLineNumber(function.code()) + " Forced -- \n" + function;
            System.out.println((Object)string2);
        }
        this.serializer.serialize(function);
    }

    public final void reportInternalProblem$avail(int lineNumber, int position, @NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.diagnostics.setCompilationIsInvalid(true);
        ModuleName moduleName2 = this.getModuleName$avail();
        long l = position;
        ProblemType problemType = ProblemType.INTERNAL;
        Object[] objectArray = new Object[2];
        String string2 = e.getMessage();
        if (string2 == null) {
            string2 = "(no error message)";
        }
        objectArray[0] = string2;
        objectArray[1] = StackPrinterKt.getStackToString(e);
        Object[] objectArray2 = objectArray;
        Problem problem2 = new Problem(lineNumber, moduleName2, l, problemType, objectArray2){

            public void abortCompilation() {
            }
        };
        this.diagnostics.handleProblem(problem2);
    }

    public final void reportExecutionProblem$avail(int lineNumber, int position, @NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.diagnostics.setCompilationIsInvalid(true);
        if (e instanceof FiberTerminationException) {
            ModuleName moduleName2 = this.getModuleName$avail();
            long l = position;
            ProblemType problemType = ProblemType.EXECUTION;
            Object[] objectArray = new Object[]{};
            this.diagnostics.handleProblem(new Problem(lineNumber, moduleName2, l, problemType, objectArray){

                public void abortCompilation() {
                }
            });
        } else {
            ModuleName moduleName3 = this.getModuleName$avail();
            long l = position;
            ProblemType problemType = ProblemType.EXECUTION;
            Object[] objectArray = new Object[2];
            String string2 = e.getMessage();
            if (string2 == null) {
                string2 = "(no error message)";
            }
            objectArray[0] = string2;
            objectArray[1] = StackPrinterKt.getStackToString(e);
            Object[] objectArray2 = objectArray;
            this.diagnostics.handleProblem(new Problem(lineNumber, moduleName3, l, problemType, objectArray2){

                public void abortCompilation() {
                }
            });
        }
    }

    public final void reportEmergencyExitProblem$avail(int lineNumber, int position, @NotNull AvailEmergencyExitException e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.diagnostics.setCompilationIsInvalid(true);
        ModuleName moduleName2 = this.getModuleName$avail();
        long l = position;
        ProblemType problemType = ProblemType.EXECUTION;
        Object[] objectArray = new Object[]{e.getMessage()};
        Object[] objectArray2 = objectArray;
        this.diagnostics.handleProblem(new Problem(lineNumber, moduleName2, l, problemType, objectArray2){

            public void abortCompilation() {
            }
        });
    }

    public final void visitAll(@NotNull Collection<? extends A_Phrase> phrases, @NotNull Set<A_Phrase> visitedSet, @NotNull Function0<Unit> then) {
        Intrinsics.checkNotNullParameter(phrases, (String)"phrases");
        Intrinsics.checkNotNullParameter(visitedSet, (String)"visitedSet");
        Intrinsics.checkNotNullParameter(then, (String)"then");
        switch (phrases.size()) {
            case 0: {
                then.invoke();
                break;
            }
            case 1: {
                this.runtime.execute(50, (Function0<Unit>)((Function0)new Function0<Unit>(phrases, this, visitedSet, then){
                    final /* synthetic */ Collection<A_Phrase> $phrases;
                    final /* synthetic */ CompilationContext this$0;
                    final /* synthetic */ Set<A_Phrase> $visitedSet;
                    final /* synthetic */ Function0<Unit> $then;
                    {
                        this.$phrases = $phrases;
                        this.this$0 = $receiver;
                        this.$visitedSet = $visitedSet;
                        this.$then = $then;
                        super(0);
                    }

                    public final void invoke() {
                        A_Phrase.Companion.applyStylesThen((A_Phrase)CollectionsKt.single((Iterable)this.$phrases), this.this$0, this.$visitedSet, this.$then);
                    }
                }));
                break;
            }
            default: {
                CollectionExtensionsKt.parallelDoThen(phrases, (Function2)new Function2<A_Phrase, Function0<? extends Unit>, Unit>(this, visitedSet){
                    final /* synthetic */ CompilationContext this$0;
                    final /* synthetic */ Set<A_Phrase> $visitedSet;
                    {
                        this.this$0 = $receiver;
                        this.$visitedSet = $visitedSet;
                        super(2);
                    }

                    public final void invoke(@NotNull A_Phrase phrase, @NotNull Function0<Unit> after) {
                        Intrinsics.checkNotNullParameter((Object)phrase, (String)"phrase");
                        Intrinsics.checkNotNullParameter(after, (String)"after");
                        this.this$0.getRuntime().execute(50, (Function0<Unit>)((Function0)new Function0<Unit>(phrase, this.this$0, this.$visitedSet, after){
                            final /* synthetic */ A_Phrase $phrase;
                            final /* synthetic */ CompilationContext this$0;
                            final /* synthetic */ Set<A_Phrase> $visitedSet;
                            final /* synthetic */ Function0<Unit> $after;
                            {
                                this.$phrase = $phrase;
                                this.this$0 = $receiver;
                                this.$visitedSet = $visitedSet;
                                this.$after = $after;
                                super(0);
                            }

                            public final void invoke() {
                                A_Phrase.Companion.applyStylesThen(this.$phrase, this.this$0, this.$visitedSet, this.$after);
                            }
                        }));
                    }
                }, then);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void styleSendThen(@Nullable A_Phrase originalSendPhrase, @NotNull A_Phrase transformedPhrase, @NotNull Function0<Unit> then) {
        Intrinsics.checkNotNullParameter((Object)transformedPhrase, (String)"transformedPhrase");
        Intrinsics.checkNotNullParameter(then, (String)"then");
        v0 = styles = (List)new ArrayList<E>();
        $this$notNullAnd$iv = originalSendPhrase;
        $i$f$notNullAnd = false;
        if ($this$notNullAnd$iv == null) ** GOTO lbl-1000
        var7_8 = $this$notNullAnd$iv;
        var16_9 = v0;
        $i$a$-notNullAnd-CompilationContext$styleSendThen$1 = false;
        var17_12 = transformedPhrase.equals((A_BasicObject)$this$styleSendThen_u24lambda_u2410) == false;
        v0 = var16_9;
        if (var17_12) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        v0.add(v1 != false ? StylerDescriptor.SystemStyle.MACRO_SEND : StylerDescriptor.SystemStyle.METHOD_SEND);
        phraseKind = A_Phrase.Companion.getPhraseKind(transformedPhrase);
        yieldType = A_Phrase.Companion.getPhraseExpressionType(transformedPhrase);
        switch (WhenMappings.$EnumSwitchMapping$0[phraseKind.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                v2 = null;
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                v2 = null;
                break;
            }
            case 25: {
                v2 = A_Type.Companion.getSystemStyleForType(yieldType);
                break;
            }
            case 26: {
                token = A_Phrase.Companion.getToken(transformedPhrase);
                $i$a$-let-CompilationContext$styleSendThen$styleByType$1 = false;
                if (token.isInCurrentModule(this.module) && token.getGeneratingLexer().getNotNil() && this.getStylerFunction(A_Lexer.Companion.getLexerMethod(token.getGeneratingLexer())).getNotNil()) {
                    v2 = null;
                    break;
                }
                if (A_Type.Companion.isSubtypeOf(yieldType, PrimitiveTypeDescriptor.Types.NUMBER.getO())) {
                    v2 = StylerDescriptor.SystemStyle.NUMERIC_LITERAL;
                    break;
                }
                if (A_Type.Companion.isSubtypeOf(yieldType, PrimitiveTypeDescriptor.Types.CHARACTER.getO())) {
                    v2 = StylerDescriptor.SystemStyle.CHARACTER_LITERAL;
                    break;
                }
                if (A_Type.Companion.isSubtypeOf(yieldType, EnumerationTypeDescriptor.Companion.getBooleanType())) {
                    v2 = StylerDescriptor.SystemStyle.BOOLEAN_LITERAL;
                    break;
                }
                if (A_Type.Companion.isSubtypeOf(yieldType, PrimitiveTypeDescriptor.Types.ATOM.getO())) {
                    v2 = StylerDescriptor.SystemStyle.ATOM_LITERAL;
                    break;
                }
                v2 = A_Type.Companion.getSystemStyleForType(yieldType);
                if (v2 != null) break;
                v2 = StylerDescriptor.SystemStyle.OTHER_LITERAL;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        v3 = styleByType = v2;
        if (v3 != null) {
            it = v3;
            $i$a$-let-CompilationContext$styleSendThen$2 = false;
            styles.add(it);
        }
        $this$forEach$iv = styles;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            style = (StylerDescriptor.SystemStyle)element$iv;
            $i$a$-forEach-CompilationContext$styleSendThen$3 = false;
            if (originalSendPhrase != null) {
                $i$a$-let-CompilationContext$styleSendThen$3$1 = false;
                AvailLoader.styleTokens$default(this.loader, (Iterable)A_Phrase.Companion.getTokens(it), style, false, null, 12, null);
            }
            AvailLoader.styleTokens$default(this.loader, (Iterable)A_Phrase.Companion.getTokens(transformedPhrase), style, false, null, 12, null);
        }
        v4 = originalSendPhrase;
        if (v4 != null) {
            v5 = A_Phrase.Companion.getBundle(v4);
        } else if (A_Phrase.Companion.phraseKindIsUnder(transformedPhrase, PhraseTypeDescriptor.PhraseKind.SEND_PHRASE)) {
            v5 = A_Phrase.Companion.getBundle(transformedPhrase);
        } else {
            then.invoke();
            return;
        }
        bundleWithStyler = v5;
        stylerFn = this.getStylerFunction(A_Bundle.Companion.getBundleMethod(bundleWithStyler));
        if (AvailRuntimeConfiguration.INSTANCE.getDebugStyling()) {
            stylerName = stylerFn.isNil() != false ? "(default)" : A_String.Companion.asNativeString(A_RawFunction.Companion.getMethodName(stylerFn.code()));
            System.out.println((Object)("style send: " + bundleWithStyler + "\n\twith " + stylerName));
        }
        fiber = FiberDescriptor.Companion.newStylerFiber(this.loader, (Function0<? extends A_String>)((Function0)new Function0<A_String>(stylerFn, bundleWithStyler){
            final /* synthetic */ A_Function $stylerFn;
            final /* synthetic */ A_Bundle $bundleWithStyler;
            {
                this.$stylerFn = $stylerFn;
                this.$bundleWithStyler = $bundleWithStyler;
                super(0);
            }

            @NotNull
            public final A_String invoke() {
                String stylerName = this.$stylerFn.isNil() ? "default" : A_String.Companion.asNativeString(A_RawFunction.Companion.getMethodName(this.$stylerFn.code()));
                Object[] objectArray = new Object[]{A_Bundle.Companion.getMessage(this.$bundleWithStyler), stylerName};
                return StringDescriptor.Companion.formatString("Style %s (%s)", objectArray);
            }
        }));
        A_Fiber.Companion.setSuccessAndFailure(fiber, (Function1<? super AvailObject, Unit>)((Function1)new Function1<AvailObject, Unit>(then){
            final /* synthetic */ Function0<Unit> $then;
            {
                this.$then = $then;
                super(1);
            }

            public final void invoke(@NotNull AvailObject it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$then.invoke();
            }
        }), (Function1<? super Throwable, Unit>)((Function1)new Function1<Throwable, Unit>(then){
            final /* synthetic */ Function0<Unit> $then;
            {
                this.$then = $then;
                super(1);
            }

            public final void invoke(@NotNull Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$then.invoke();
            }
        }));
        var11_13 = new A_BasicObject[]{ObjectTupleDescriptor.Companion.tupleFromList(CollectionsKt.listOfNotNull((Object)originalSendPhrase)), transformedPhrase};
        this.runtime.runOutermostFunction(fiber, (A_Function)stylerFn.ifNil((Function0)new Function0<A_Function>(this){
            final /* synthetic */ CompilationContext this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final A_Function invoke() {
                return this.this$0.getRuntime().get(AvailRuntime.HookType.DEFAULT_STYLER);
            }
        }), CollectionsKt.listOf((Object[])var11_13), true);
    }

    public final void clearStyleCache() {
        this.styleCache.clear();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final A_Function getStylerFunction(@NotNull A_Method method) {
        List list2;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        A_Function a_Function = this.styleCache.get(method);
        if (a_Function != null) {
            A_Function it = a_Function;
            boolean bl = false;
            return it;
        }
        A_Set ancestorModules = A_Module.Companion.getAllAncestors(this.module);
        Iterable $this$filter$iv = A_Method.Companion.getMethodStylers(method);
        int $i$f$filter = 0;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AvailObject it = (AvailObject)element$iv$iv;
            boolean bl = false;
            boolean bl2 = A_RawFunction.Companion.getModule(it).isNil() || A_RawFunction.Companion.getModule(it).equals(this.module) || CollectionsKt.contains((Iterable)ancestorModules, (Object)A_RawFunction.Companion.getModule(it));
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List eligibleStylers = (List)destination$iv$iv;
        $i$f$filter = eligibleStylers.size();
        boolean bl = 0 <= $i$f$filter ? $i$f$filter < 2 : false;
        if (bl) {
            list2 = eligibleStylers;
        } else {
            Iterable $this$filterTo$iv$iv2;
            Iterable $this$filter$iv2 = eligibleStylers;
            boolean $i$f$filter2 = false;
            Iterable iterable2 = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                AvailObject it = (AvailObject)element$iv$iv;
                boolean bl3 = false;
                if (!A_RawFunction.Companion.getModule(it).getNotNil()) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List notBuiltIn = (List)destination$iv$iv2;
            $this$filter$iv2 = notBuiltIn;
            $i$f$filter2 = false;
            $this$filterTo$iv$iv2 = $this$filter$iv2;
            destination$iv$iv2 = new ArrayList();
            $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                boolean bl4;
                block13: {
                    AvailObject styler = (AvailObject)element$iv$iv;
                    boolean bl5 = false;
                    Iterable $this$none$iv = notBuiltIn;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl4 = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            AvailObject otherStyler = (AvailObject)element$iv;
                            boolean bl6 = false;
                            boolean bl7 = !styler.equals(otherStyler) && CollectionsKt.contains((Iterable)A_Module.Companion.getAllAncestors(A_RawFunction.Companion.getModule(otherStyler)), (Object)A_RawFunction.Companion.getModule(styler));
                            if (!bl7) continue;
                            bl4 = false;
                            break block13;
                        }
                        bl4 = true;
                    }
                }
                if (!bl4) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv2;
        }
        List mostSpecificStylers = list2;
        A_Function stylerFn = switch (mostSpecificStylers.size()) {
            case 0 -> NilDescriptor.Companion.getNil();
            case 1 -> A_Styler.Companion.getFunction((A_Styler)mostSpecificStylers.get(0));
            default -> NilDescriptor.Companion.getNil();
        };
        ((Map)this.styleCache).put(method, stylerFn);
        return stylerFn;
    }

    public final void beginningStyling() {
        if (!this.stylingState.compareAndSet(StylingCompletionState.NotStyling.INSTANCE, StylingCompletionState.StylingNotWaiting.INSTANCE)) {
            throw new IllegalStateException();
        }
    }

    public final void finishedStyling() {
        StylingCompletionState oldState = this.stylingState.getAndSet(StylingCompletionState.NotStyling.INSTANCE);
        if (oldState instanceof StylingCompletionState.NotStyling) {
            throw new IllegalStateException();
        }
        if (oldState instanceof StylingCompletionState.StylingAndWaiting) {
            ((StylingCompletionState.StylingAndWaiting)oldState).getNotStylingAction().invoke();
        }
    }

    public final void whenNotStyling(@NotNull Function0<Unit> action2) {
        StylingCompletionState.StylingAndWaiting newState;
        StylingCompletionState oldState;
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        do {
            StylingCompletionState stylingCompletionState;
            if ((stylingCompletionState = (oldState = this.stylingState.get())) instanceof StylingCompletionState.NotStyling) {
                action2.invoke();
                return;
            }
            if (stylingCompletionState instanceof StylingCompletionState.StylingNotWaiting) continue;
            if (stylingCompletionState instanceof StylingCompletionState.StylingAndWaiting) {
                throw new IllegalStateException();
            }
            throw new NoWhenBranchMatchedException();
        } while (!this.stylingState.compareAndSet(oldState, newState = new StylingCompletionState.StylingAndWaiting(action2)));
    }

    /*
     * WARNING - void declaration
     */
    public final void recordPathForTopLevelPhrase(@NotNull A_Phrase rootPhrase) {
        Intrinsics.checkNotNullParameter((Object)rootPhrase, (String)"rootPhrase");
        PhrasePathRecord.PhraseNode fakeRoot = new PhrasePathRecord.PhraseNode(null, null, NamesIndex.UsageType.MethodSend, CollectionsKt.emptyList(), null, null, 32, null);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)fakeRoot, CollectionsKt.listOf((Object)rootPhrase).iterator())};
        List workStack = CollectionsKt.mutableListOf((Object[])pairArray);
        while (!((Collection)workStack).isEmpty()) {
            void $this$mapNotNullTo$iv$iv;
            pairArray = (Pair[])CollectionsKt.last((List)workStack);
            PhrasePathRecord.PhraseNode parent = (PhrasePathRecord.PhraseNode)pairArray.component1();
            Iterator iterator2 = (Iterator)pairArray.component2();
            if (!iterator2.hasNext()) {
                CollectionsKt.removeLast((List)workStack);
                continue;
            }
            A_Phrase phrase = (A_Phrase)iterator2.next();
            Ref.ObjectRef moduleName2 = new Ref.ObjectRef();
            Ref.ObjectRef atomName = new Ref.ObjectRef();
            Ref.ObjectRef usageType = new Ref.ObjectRef();
            usageType.element = NamesIndex.UsageType.MethodSend;
            A_Phrase.Companion.getApparentSendName(phrase).ifNotNil((Function1)new Function1<A_Atom, Unit>((Ref.ObjectRef<A_String>)atomName, (Ref.ObjectRef<A_String>)moduleName2){
                final /* synthetic */ Ref.ObjectRef<A_String> $atomName;
                final /* synthetic */ Ref.ObjectRef<A_String> $moduleName;
                {
                    this.$atomName = $atomName;
                    this.$moduleName = $moduleName;
                    super(1);
                }

                public final void invoke(@NotNull A_Atom atom) {
                    Intrinsics.checkNotNullParameter((Object)atom, (String)"atom");
                    A_Atom.Companion.getIssuingModule(atom).ifNotNil((Function1)new Function1<A_Module, Unit>(this.$moduleName){
                        final /* synthetic */ Ref.ObjectRef<A_String> $moduleName;
                        {
                            this.$moduleName = $moduleName;
                            super(1);
                        }

                        public final void invoke(@NotNull A_Module module) {
                            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                            this.$moduleName.element = A_Module.Companion.getModuleName(module);
                        }
                    });
                    this.$atomName.element = A_Atom.Companion.getAtomName(atom);
                }
            });
            if (A_Phrase.Companion.isMacroSubstitutionNode(phrase)) {
                usageType.element = NamesIndex.UsageType.MacroSend;
                v0 = A_Phrase.Companion.getMacroOriginalSendNode(phrase);
            } else if (!A_Phrase.Companion.phraseKindIsUnder(phrase, PhraseTypeDescriptor.PhraseKind.LITERAL_PHRASE)) {
                v0 = phrase;
            } else if (A_Phrase.Companion.getToken(phrase).getGeneratingPhrase().getNotNil()) {
                v0 = A_Phrase.Companion.getToken(phrase).getGeneratingPhrase();
            } else if (A_Phrase.Companion.getToken(phrase).literal().isInstanceOfKind(PhraseTypeDescriptor.PhraseKind.PARSE_PHRASE.getMostGeneralType())) {
                usageType.element = NamesIndex.UsageType.MacroSend;
                v0 = A_Phrase.Companion.getToken(phrase).literal();
            } else {
                v0 = phrase = phrase;
            }
            if (atomName.element == null) {
                A_Phrase.Companion.getApparentSendName(phrase).ifNotNil((Function1)new Function1<A_Atom, Unit>((Ref.ObjectRef<A_String>)atomName, (Ref.ObjectRef<NamesIndex.UsageType>)usageType, (Ref.ObjectRef<A_String>)moduleName2){
                    final /* synthetic */ Ref.ObjectRef<A_String> $atomName;
                    final /* synthetic */ Ref.ObjectRef<NamesIndex.UsageType> $usageType;
                    final /* synthetic */ Ref.ObjectRef<A_String> $moduleName;
                    {
                        this.$atomName = $atomName;
                        this.$usageType = $usageType;
                        this.$moduleName = $moduleName;
                        super(1);
                    }

                    public final void invoke(@NotNull A_Atom atom) {
                        Intrinsics.checkNotNullParameter((Object)atom, (String)"atom");
                        A_Atom.Companion.getIssuingModule(atom).ifNotNil((Function1)new Function1<A_Module, Unit>(this.$usageType, this.$moduleName){
                            final /* synthetic */ Ref.ObjectRef<NamesIndex.UsageType> $usageType;
                            final /* synthetic */ Ref.ObjectRef<A_String> $moduleName;
                            {
                                this.$usageType = $usageType;
                                this.$moduleName = $moduleName;
                                super(1);
                            }

                            public final void invoke(@NotNull A_Module module) {
                                Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                                this.$usageType.element = NamesIndex.UsageType.MacroSend;
                                this.$moduleName.element = A_Module.Companion.getModuleName(module);
                            }
                        });
                        this.$atomName.element = A_Atom.Companion.getAtomName(atom);
                    }
                });
            }
            Iterable $this$mapNotNull$iv = CollectionsKt.zip((Iterable)A_Phrase.Companion.getTokens(phrase), (Iterable)A_Phrase.Companion.getTokenIndicesInName(phrase));
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
            while (iterator3.hasNext()) {
                PhrasePathRecord.PhraseNode.PhraseNodeToken phraseNodeToken;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator3.next();
                boolean bl = false;
                Pair pair = (Pair)element$iv$iv;
                boolean bl2 = false;
                AvailObject token = (AvailObject)pair.component1();
                AvailObject indexInName = (AvailObject)pair.component2();
                if (!token.isInCurrentModule(this.module)) {
                    phraseNodeToken = null;
                } else {
                    int start = this.getSurrogateIndexConverter().availIndexToJavaIndex(token.start() - 1);
                    int pastEnd = this.getSurrogateIndexConverter().availIndexToJavaIndex(A_Token.Companion.pastEnd(token) - 1);
                    int line = token.lineNumber();
                    int inName = A_Number.Companion.getExtractInt(indexInName);
                    String string2 = inName == 0 ? A_String.Companion.asNativeString(token.string()) : null;
                    phraseNodeToken = new PhrasePathRecord.PhraseNode.PhraseNodeToken(start, pastEnd, line, inName, string2);
                }
                if (phraseNodeToken == null) continue;
                PhrasePathRecord.PhraseNode.PhraseNodeToken it$iv$iv = phraseNodeToken;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List tokenSpans = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
            PhrasePathRecord.PhraseNode phraseNode = new PhrasePathRecord.PhraseNode((A_String)moduleName2.element, (A_String)atomName.element, (NamesIndex.UsageType)((Object)usageType.element), tokenSpans, parent, null, 32, null);
            List children2 = new ArrayList();
            A_Phrase childrenProvider = A_Phrase.Companion.phraseKindIsUnder(phrase, PhraseTypeDescriptor.PhraseKind.SEND_PHRASE) ? A_Phrase.Companion.getArgumentsListNode(phrase) : (A_Phrase.Companion.phraseKindIsUnder(phrase, PhraseTypeDescriptor.PhraseKind.LITERAL_PHRASE) && A_Phrase.Companion.getToken(phrase).literal().isInstanceOfKind(PhraseTypeDescriptor.PhraseKind.PARSE_PHRASE.getMostGeneralType()) ? (A_Phrase)A_Phrase.Companion.getToken(phrase).literal() : phrase);
            A_Phrase.Companion.childrenDo(childrenProvider, (Function1<? super A_Phrase, Unit>)((Function1)new Function1<A_Phrase, Unit>((Object)children2){

                public final void invoke(@NotNull A_Phrase p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((List)this.receiver).add(p0);
                }
            }));
            workStack.add(TuplesKt.to((Object)phraseNode, children2.iterator()));
        }
        PhrasePathRecord.PhraseNode root = (PhrasePathRecord.PhraseNode)CollectionsKt.single(fakeRoot.getChildren());
        root.setParent(null);
        A_Module.Companion.phrasePathRecord(this.module).getRootTrees().add(root);
    }

    public static final /* synthetic */ void access$logWorkUnits(CompilationContext $this, String debugString) {
        $this.logWorkUnits(debugString);
    }

    public static final /* synthetic */ AtomicLong access$getAtomicWorkUnitsCompleted$p(CompilationContext $this) {
        return $this.atomicWorkUnitsCompleted;
    }

    public static final /* synthetic */ void access$serializeAfterRunning(CompilationContext $this, A_Function function) {
        $this.serializeAfterRunning(function);
    }

    static {
        Logger logger = Logger.getLogger(CompilationContext.class.getName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        CompilationContext.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lavail/compiler/CompilationContext$Companion;", "", "()V", "logger", "Ljava/util/logging/Logger;", "getLogger", "()Ljava/util/logging/Logger;", "avail"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0003\u0006\u0007\b\u00a8\u0006\t"}, d2={"Lavail/compiler/CompilationContext$StylingCompletionState;", "", "()V", "NotStyling", "StylingAndWaiting", "StylingNotWaiting", "Lavail/compiler/CompilationContext$StylingCompletionState$NotStyling;", "Lavail/compiler/CompilationContext$StylingCompletionState$StylingAndWaiting;", "Lavail/compiler/CompilationContext$StylingCompletionState$StylingNotWaiting;", "avail"})
    public static abstract class StylingCompletionState {
        private StylingCompletionState() {
        }

        public /* synthetic */ StylingCompletionState(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lavail/compiler/CompilationContext$StylingCompletionState$NotStyling;", "Lavail/compiler/CompilationContext$StylingCompletionState;", "()V", "avail"})
        public static final class NotStyling
        extends StylingCompletionState {
            @NotNull
            public static final NotStyling INSTANCE = new NotStyling();

            private NotStyling() {
                super(null);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lavail/compiler/CompilationContext$StylingCompletionState$StylingAndWaiting;", "Lavail/compiler/CompilationContext$StylingCompletionState;", "notStylingAction", "Lkotlin/Function0;", "", "(Lkotlin/jvm/functions/Function0;)V", "getNotStylingAction", "()Lkotlin/jvm/functions/Function0;", "avail"})
        public static final class StylingAndWaiting
        extends StylingCompletionState {
            @NotNull
            private final Function0<Unit> notStylingAction;

            public StylingAndWaiting(@NotNull Function0<Unit> notStylingAction) {
                Intrinsics.checkNotNullParameter(notStylingAction, (String)"notStylingAction");
                super(null);
                this.notStylingAction = notStylingAction;
            }

            @NotNull
            public final Function0<Unit> getNotStylingAction() {
                return this.notStylingAction;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lavail/compiler/CompilationContext$StylingCompletionState$StylingNotWaiting;", "Lavail/compiler/CompilationContext$StylingCompletionState;", "()V", "avail"})
        public static final class StylingNotWaiting
        extends StylingCompletionState {
            @NotNull
            public static final StylingNotWaiting INSTANCE = new StylingNotWaiting();

            private StylingNotWaiting() {
                super(null);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PhraseTypeDescriptor.PhraseKind.values().length];
            try {
                nArray[PhraseTypeDescriptor.PhraseKind.ASSIGNMENT_PHRASE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PhraseTypeDescriptor.PhraseKind.BLOCK_PHRASE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PhraseTypeDescriptor.PhraseKind.EXPRESSION_AS_STATEMENT_PHRASE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PhraseTypeDescriptor.PhraseKind.EXPRESSION_PHRASE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PhraseTypeDescriptor.PhraseKind.FIRST_OF_SEQUENCE_PHRASE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PhraseTypeDescriptor.PhraseKind.LIST_PHRASE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PhraseTypeDescriptor.PhraseKind.MACRO_SUBSTITUTION_PHRASE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PhraseTypeDescriptor.PhraseKind.MARKER_PHRASE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PhraseTypeDescriptor.PhraseKind.PARSE_PHRASE.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PhraseTypeDescriptor.PhraseKind.PERMUTED_LIST_PHRASE.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PhraseTypeDescriptor.PhraseKind.REFERENCE_PHRASE.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PhraseTypeDescriptor.PhraseKind.SEQUENCE_AS_EXPRESSION_PHRASE.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PhraseTypeDescriptor.PhraseKind.SEQUENCE_PHRASE.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PhraseTypeDescriptor.PhraseKind.STATEMENT_PHRASE.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PhraseTypeDescriptor.PhraseKind.SUPER_CAST_PHRASE.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PhraseTypeDescriptor.PhraseKind.VARIABLE_USE_PHRASE.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PhraseTypeDescriptor.PhraseKind.ARGUMENT_PHRASE.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PhraseTypeDescriptor.PhraseKind.DECLARATION_PHRASE.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PhraseTypeDescriptor.PhraseKind.LABEL_PHRASE.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PhraseTypeDescriptor.PhraseKind.LOCAL_VARIABLE_PHRASE.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PhraseTypeDescriptor.PhraseKind.LOCAL_CONSTANT_PHRASE.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PhraseTypeDescriptor.PhraseKind.MODULE_VARIABLE_PHRASE.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PhraseTypeDescriptor.PhraseKind.MODULE_CONSTANT_PHRASE.ordinal()] = 23;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PhraseTypeDescriptor.PhraseKind.PRIMITIVE_FAILURE_REASON_PHRASE.ordinal()] = 24;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PhraseTypeDescriptor.PhraseKind.SEND_PHRASE.ordinal()] = 25;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PhraseTypeDescriptor.PhraseKind.LITERAL_PHRASE.ordinal()] = 26;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

