/*
 * Decompiled with CFR 0.152.
 */
package avail.compiler.splitter;

import avail.compiler.ParsingConversionRule;
import avail.compiler.ParsingOperation;
import avail.compiler.splitter.Expression;
import avail.compiler.splitter.Group;
import avail.compiler.splitter.InstructionGenerator;
import avail.compiler.splitter.MessageSplitter;
import avail.compiler.splitter.SectionCheckpoint;
import avail.compiler.splitter.WrapState;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.phrases.A_Phrase;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.InstanceTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.ListPhraseTypeDescriptor;
import avail.descriptor.types.PhraseTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.exceptions.SignatureException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\r\u0010\u0017\u001a\u00020\u0000H\u0010\u00a2\u0006\u0002\b\u0018J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001d\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0003H\u0010\u00a2\u0006\u0002\b!J\u0013\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00060#H\u0010\u00a2\u0006\u0002\b$J%\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020&H\u0010\u00a2\u0006\u0002\b+J\u001b\u0010,\u001a\u00020\u001d2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.H\u0010\u00a2\u0006\u0002\b0J\u0015\u00101\u001a\u00020\t2\u0006\u0010'\u001a\u00020\u001fH\u0010\u00a2\u0006\u0002\b2J1\u00103\u001a\u00020\u001d2\u000e\u00104\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u0001052\n\u00106\u001a\u000607j\u0002`82\u0006\u00109\u001a\u00020\u0003H\u0010\u00a2\u0006\u0002\b:J\b\u0010;\u001a\u00020<H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\t8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000bR\u0014\u0010\u0010\u001a\u00020\t8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000bR\u0014\u0010\u0012\u001a\u00020\u00038PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\t8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000b\u00a8\u0006="}, d2={"Lavail/compiler/splitter/Counter;", "Lavail/compiler/splitter/Expression;", "startInName", "", "pastEndInName", "group", "Lavail/compiler/splitter/Group;", "(IILavail/compiler/splitter/Group;)V", "isLowerCase", "", "isLowerCase$avail", "()Z", "recursivelyContainsReorders", "getRecursivelyContainsReorders", "shouldBeSeparatedOnLeft", "getShouldBeSeparatedOnLeft$avail", "shouldBeSeparatedOnRight", "getShouldBeSeparatedOnRight$avail", "underscoreCount", "getUnderscoreCount$avail", "()I", "yieldsValue", "getYieldsValue$avail", "applyCaseInsensitive", "applyCaseInsensitive$avail", "checkListStructure", "phrase", "Lavail/descriptor/phrases/A_Phrase;", "checkType", "", "argumentType", "Lavail/descriptor/types/A_Type;", "sectionNumber", "checkType$avail", "children", "", "children$avail", "emitOn", "Lavail/compiler/splitter/WrapState;", "phraseType", "generator", "Lavail/compiler/splitter/InstructionGenerator;", "wrapState", "emitOn$avail", "extractSectionCheckpointsInto", "sectionCheckpoints", "", "Lavail/compiler/splitter/SectionCheckpoint;", "extractSectionCheckpointsInto$avail", "mightBeEmpty", "mightBeEmpty$avail", "printWithArguments", "arguments", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "indent", "printWithArguments$avail", "toString", "", "avail"})
public final class Counter
extends Expression {
    @NotNull
    private final Group group;

    public Counter(int startInName, int pastEndInName, @NotNull Group group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        super(startInName, pastEndInName);
        this.group = group;
        boolean bl = this.group.getBeforeDagger().getYielders().isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        bl = this.group.getAfterDagger().getYielders().isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
    }

    @Override
    public boolean getRecursivelyContainsReorders() {
        return this.group.getRecursivelyContainsReorders();
    }

    @Override
    public boolean getYieldsValue$avail() {
        return true;
    }

    @Override
    public boolean isLowerCase$avail() {
        return this.group.isLowerCase$avail();
    }

    @Override
    @NotNull
    public Counter applyCaseInsensitive$avail() {
        return new Counter(this.getStartInName(), this.getPastEndInName(), this.group.applyCaseInsensitive$avail());
    }

    @Override
    public int getUnderscoreCount$avail() {
        boolean bl;
        boolean bl2 = bl = this.group.getUnderscoreCount$avail() == 0;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        return 0;
    }

    @Override
    public void extractSectionCheckpointsInto$avail(@NotNull List<SectionCheckpoint> sectionCheckpoints) {
        Intrinsics.checkNotNullParameter(sectionCheckpoints, (String)"sectionCheckpoints");
        this.group.extractSectionCheckpointsInto$avail(sectionCheckpoints);
    }

    @NotNull
    public List<Group> children$avail() {
        return CollectionsKt.listOf((Object)this.group);
    }

    @Override
    public void checkType$avail(@NotNull A_Type argumentType, int sectionNumber) throws SignatureException {
        Intrinsics.checkNotNullParameter((Object)argumentType, (String)"argumentType");
        if (!A_Type.Companion.isSubtypeOf(argumentType, IntegerRangeTypeDescriptor.Companion.getWholeNumbers())) {
            MessageSplitter.Companion.throwSignatureException(AvailErrorCode.E_INCORRECT_TYPE_FOR_COUNTING_GROUP);
            throw new KotlinNothingValueException();
        }
    }

    @Override
    @NotNull
    public WrapState emitOn$avail(@NotNull A_Type phraseType, @NotNull InstructionGenerator generator, @NotNull WrapState wrapState) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)phraseType, (String)"phraseType");
        Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
        Intrinsics.checkNotNullParameter((Object)((Object)wrapState), (String)"wrapState");
        generator.flushDelayed();
        A_Type phraseCountRange = A_Type.Companion.getPhraseTypeExpressionType(phraseType);
        AvailObject emptyTupleType = InstanceTypeDescriptor.Companion.instanceType(TupleDescriptor.Companion.getEmptyTuple());
        A_Type tupleOfEmptyTuplesType = TupleTypeDescriptor.Companion.tupleTypeForSizesTypesDefaultType(phraseCountRange, TupleDescriptor.Companion.getEmptyTuple(), emptyTupleType);
        A_Type tupleOfEmptyTuplePhrasesType = TupleTypeDescriptor.Companion.tupleTypeForSizesTypesDefaultType(phraseCountRange, TupleDescriptor.Companion.getEmptyTuple(), PhraseTypeDescriptor.PhraseKind.PARSE_PHRASE.create(emptyTupleType));
        A_Type listPhraseType = ListPhraseTypeDescriptor.Companion.createListPhraseType(PhraseTypeDescriptor.PhraseKind.LIST_PHRASE, tupleOfEmptyTuplesType, tupleOfEmptyTuplePhrasesType);
        WrapState newWrapState2 = this.group.emitOn$avail(listPhraseType, generator, wrapState);
        boolean bl2 = bl = newWrapState2 == WrapState.SHOULD_NOT_PUSH_LIST;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        generator.emit((Expression)this, ParsingOperation.CONVERT, ParsingConversionRule.LIST_TO_SIZE.getNumber());
        return wrapState.processAfterPushedArgument$avail(this, generator);
    }

    @Override
    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.group + ")";
    }

    @Override
    public void printWithArguments$avail(@Nullable Iterator<? extends A_Phrase> arguments, @NotNull StringBuilder builder, int indent) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Iterator<? extends A_Phrase> iterator2 = arguments;
        Intrinsics.checkNotNull(iterator2);
        A_Phrase countLiteral = iterator2.next();
        boolean bl = countLiteral.isInstanceOf(PhraseTypeDescriptor.PhraseKind.LITERAL_PHRASE.getMostGeneralType());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        int i2 = 1;
        int count = A_Number.Companion.getExtractInt(A_Phrase.Companion.getToken(countLiteral).literal());
        if (i2 <= count) {
            while (true) {
                if (i2 > 1) {
                    builder.append(' ');
                }
                Iterator<AvailObject> iterator3 = Collections.emptyIterator();
                Intrinsics.checkNotNullExpressionValue(iterator3, (String)"emptyIterator(...)");
                this.group.printGroupOccurrence(iterator3, builder, indent, this.getYieldsValue$avail());
                if (i2 == count) break;
                ++i2;
            }
        }
        builder.append('#');
    }

    @Override
    public boolean getShouldBeSeparatedOnLeft$avail() {
        return this.group.getShouldBeSeparatedOnLeft$avail();
    }

    @Override
    public boolean getShouldBeSeparatedOnRight$avail() {
        return true;
    }

    @Override
    public boolean mightBeEmpty$avail(@NotNull A_Type phraseType) {
        Intrinsics.checkNotNullParameter((Object)phraseType, (String)"phraseType");
        A_Type integerRangeType = A_Type.Companion.getPhraseTypeExpressionType(phraseType);
        boolean bl = integerRangeType.isIntegerRangeType();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        return A_Number.Companion.equalsInt(A_Type.Companion.getLowerBound(integerRangeType), 0);
    }

    @Override
    public boolean checkListStructure(@NotNull A_Phrase phrase) {
        Intrinsics.checkNotNullParameter((Object)phrase, (String)"phrase");
        return true;
    }
}

