/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.levelTwo.operation;

import avail.descriptor.atoms.A_Atom;
import avail.descriptor.objects.ObjectDescriptor;
import avail.descriptor.objects.ObjectLayoutVariant;
import avail.interpreter.levelTwo.L2Instruction;
import avail.interpreter.levelTwo.L2NamedOperandType;
import avail.interpreter.levelTwo.L2OperandType;
import avail.interpreter.levelTwo.L2Operation;
import avail.interpreter.levelTwo.operand.L2ArbitraryConstantOperand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedOperand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedVectorOperand;
import avail.interpreter.levelTwo.operand.L2WriteBoxedOperand;
import avail.interpreter.levelTwo.register.L2Register;
import avail.optimizer.jvm.JVMTranslator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.MethodVisitor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\n\u0010\n\u001a\u00060\u000bj\u0002`\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00040\u000eH\u0016J \u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0015"}, d2={"Lavail/interpreter/levelTwo/operation/L2_CREATE_OBJECT;", "Lavail/interpreter/levelTwo/L2Operation;", "()V", "appendToWithWarnings", "", "instruction", "Lavail/interpreter/levelTwo/L2Instruction;", "desiredTypes", "", "Lavail/interpreter/levelTwo/L2OperandType;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "warningStyleChange", "Lkotlin/Function1;", "", "translateToJVM", "translator", "Lavail/optimizer/jvm/JVMTranslator;", "method", "Lorg/objectweb/asm/MethodVisitor;", "avail"})
@SourceDebugExtension(value={"SMAP\nL2_CREATE_OBJECT.kt\nKotlin\n*S Kotlin\n*F\n+ 1 L2_CREATE_OBJECT.kt\navail/interpreter/levelTwo/operation/L2_CREATE_OBJECT\n+ 2 Casts.kt\navail/utility/CastsKt\n*L\n1#1,107:1\n46#2:108\n46#2:109\n*S KotlinDebug\n*F\n+ 1 L2_CREATE_OBJECT.kt\navail/interpreter/levelTwo/operation/L2_CREATE_OBJECT\n*L\n75#1:108\n93#1:109\n*E\n"})
public final class L2_CREATE_OBJECT
extends L2Operation {
    @NotNull
    public static final L2_CREATE_OBJECT INSTANCE = new L2_CREATE_OBJECT();

    private L2_CREATE_OBJECT() {
        L2NamedOperandType[] l2NamedOperandTypeArray = new L2NamedOperandType[]{L2OperandType.ARBITRARY_CONSTANT.named("variant"), L2OperandType.READ_BOXED_VECTOR.named("field values"), L2OperandType.WRITE_BOXED.named("new object")};
        super(l2NamedOperandTypeArray);
    }

    @Override
    public void appendToWithWarnings(@NotNull L2Instruction instruction2, @NotNull Set<? extends L2OperandType> desiredTypes, @NotNull StringBuilder builder, @NotNull Function1<? super Boolean, Unit> warningStyleChange) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)instruction2, (String)"instruction");
        Intrinsics.checkNotNullParameter(desiredTypes, (String)"desiredTypes");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter(warningStyleChange, (String)"warningStyleChange");
        boolean bl2 = Intrinsics.areEqual((Object)this, (Object)instruction2.getOperation());
        if (_Assertions.ENABLED && !bl2) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        L2ArbitraryConstantOperand variantOperand = (L2ArbitraryConstantOperand)instruction2.operand(0);
        L2ReadBoxedVectorOperand fieldsVector = (L2ReadBoxedVectorOperand)instruction2.operand(1);
        L2WriteBoxedOperand newObject = (L2WriteBoxedOperand)instruction2.operand(2);
        this.renderPreamble(instruction2, builder);
        builder.append(' ');
        builder.append(newObject.registerString());
        builder.append(" \u2190 {");
        Object $this$cast$iv = variantOperand.getConstant();
        boolean $i$f$cast = false;
        ObjectLayoutVariant variant = (ObjectLayoutVariant)$this$cast$iv;
        List<A_Atom> realSlots = variant.getRealSlots();
        List<L2ReadBoxedOperand> fieldSources = fieldsVector.getElements();
        boolean bl3 = bl = realSlots.size() == fieldSources.size();
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        Ref.IntRef i2 = new Ref.IntRef();
        CollectionsKt.joinTo$default((Iterable)realSlots, (Appendable)builder, (CharSequence)",", null, null, (int)0, null, (Function1)((Function1)new Function1<A_Atom, CharSequence>(fieldSources, i2){
            final /* synthetic */ List<L2ReadBoxedOperand> $fieldSources;
            final /* synthetic */ Ref.IntRef $i;
            {
                this.$fieldSources = $fieldSources;
                this.$i = $i;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull A_Atom key) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                int n = this.$i.element;
                this.$i.element = n + 1;
                return key + ": " + this.$fieldSources.get(n).registerString();
            }
        }), (int)60, null);
    }

    @Override
    public void translateToJVM(@NotNull JVMTranslator translator, @NotNull MethodVisitor method, @NotNull L2Instruction instruction2) {
        Intrinsics.checkNotNullParameter((Object)translator, (String)"translator");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)instruction2, (String)"instruction");
        boolean bl = Intrinsics.areEqual((Object)this, (Object)instruction2.getOperation());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        L2ArbitraryConstantOperand variantOperand = (L2ArbitraryConstantOperand)instruction2.operand(0);
        L2ReadBoxedVectorOperand fieldsVector = (L2ReadBoxedVectorOperand)instruction2.operand(1);
        L2WriteBoxedOperand newObject = (L2WriteBoxedOperand)instruction2.operand(2);
        Object $this$cast$iv = variantOperand.getConstant();
        boolean $i$f$cast = false;
        ObjectLayoutVariant variant = (ObjectLayoutVariant)$this$cast$iv;
        translator.literal(method, variant);
        ObjectDescriptor.Companion.getCreateUninitializedObjectMethod().generateCall(method);
        List fieldSources = fieldsVector.getElements();
        int limit = fieldSources.size();
        for (int i2 = 0; i2 < limit; ++i2) {
            translator.intConstant(method, i2 + 1);
            translator.load(method, (L2Register)((L2ReadBoxedOperand)fieldSources.get(i2)).register());
            ObjectDescriptor.Companion.getSetFieldMethod().generateCall(method);
        }
        translator.store(method, (L2Register)newObject.register());
    }
}

