/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.levelTwo.operation;

import avail.descriptor.functions.A_RegisterDump;
import avail.descriptor.representation.AvailObject;
import avail.interpreter.JavaLibrary;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.levelTwo.L2Instruction;
import avail.interpreter.levelTwo.L2JVMChunk;
import avail.interpreter.levelTwo.L2NamedOperandType;
import avail.interpreter.levelTwo.L2OperandType;
import avail.interpreter.levelTwo.L2Operation;
import avail.interpreter.levelTwo.ReadsHiddenVariable;
import avail.interpreter.levelTwo.WritesHiddenVariable;
import avail.interpreter.levelTwo.operand.L2IntImmediateOperand;
import avail.interpreter.levelTwo.register.L2Register;
import avail.optimizer.jvm.JVMTranslator;
import avail.utility.structures.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

@ReadsHiddenVariable(value={L2Operation.HiddenVariable.CURRENT_CONTINUATION.class})
@WritesHiddenVariable(value={L2Operation.HiddenVariable.CURRENT_CONTINUATION.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\nH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lavail/interpreter/levelTwo/operation/L2_ENTER_L2_CHUNK;", "Lavail/interpreter/levelTwo/L2Operation;", "()V", "hasSideEffect", "", "getHasSideEffect", "()Z", "appendToWithWarnings", "", "instruction", "Lavail/interpreter/levelTwo/L2Instruction;", "desiredTypes", "", "Lavail/interpreter/levelTwo/L2OperandType;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "warningStyleChange", "Lkotlin/Function1;", "isEntryPoint", "translateToJVM", "translator", "Lavail/optimizer/jvm/JVMTranslator;", "method", "Lorg/objectweb/asm/MethodVisitor;", "avail"})
public final class L2_ENTER_L2_CHUNK
extends L2Operation {
    @NotNull
    public static final L2_ENTER_L2_CHUNK INSTANCE = new L2_ENTER_L2_CHUNK();

    private L2_ENTER_L2_CHUNK() {
        L2NamedOperandType[] l2NamedOperandTypeArray = new L2NamedOperandType[]{L2OperandType.INT_IMMEDIATE.named("entry point offset in default chunk"), L2OperandType.COMMENT.named("chunk entry point name")};
        super(l2NamedOperandTypeArray);
    }

    @Override
    public boolean isEntryPoint(@NotNull L2Instruction instruction2) {
        Intrinsics.checkNotNullParameter((Object)instruction2, (String)"instruction");
        return true;
    }

    @Override
    public boolean getHasSideEffect() {
        return true;
    }

    @Override
    public void appendToWithWarnings(@NotNull L2Instruction instruction2, @NotNull Set<? extends L2OperandType> desiredTypes, @NotNull StringBuilder builder, @NotNull Function1<? super Boolean, Unit> warningStyleChange) {
        Intrinsics.checkNotNullParameter((Object)instruction2, (String)"instruction");
        Intrinsics.checkNotNullParameter(desiredTypes, (String)"desiredTypes");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter(warningStyleChange, (String)"warningStyleChange");
        boolean bl = Intrinsics.areEqual((Object)this, (Object)instruction2.getOperation());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.renderPreamble(instruction2, builder);
    }

    @Override
    public void translateToJVM(@NotNull JVMTranslator translator, @NotNull MethodVisitor method, @NotNull L2Instruction instruction2) {
        EnumMap<L2Register.RegisterKind, List<Integer>> localNumberLists;
        Intrinsics.checkNotNullParameter((Object)translator, (String)"translator");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)instruction2, (String)"instruction");
        L2IntImmediateOperand offsetInDefaultChunk = (L2IntImmediateOperand)instruction2.operand(0);
        if (offsetInDefaultChunk.getValue() != L2JVMChunk.ChunkEntryPoint.TRANSIENT.getOffsetInDefaultChunk()) {
            translator.loadInterpreter(method);
            translator.literal(method, offsetInDefaultChunk.getValue());
            Interpreter.Companion.getCheckValidityMethod().generateCall(method);
            Label isValidLabel = new Label();
            method.visitJumpInsn(154, isValidLabel);
            method.visitInsn(1);
            method.visitInsn(176);
            method.visitLabel(isValidLabel);
        }
        if ((localNumberLists = translator.getLiveLocalNumbersByKindPerEntryPoint().get(instruction2)) != null) {
            List<Integer> list2 = localNumberLists.get((Object)L2Register.RegisterKind.BOXED_KIND);
            Intrinsics.checkNotNull(list2);
            List<Integer> boxedList = list2;
            List<Integer> list3 = localNumberLists.get((Object)L2Register.RegisterKind.INTEGER_KIND);
            Intrinsics.checkNotNull(list3);
            List<Integer> intsList = list3;
            List<Integer> list4 = localNumberLists.get((Object)L2Register.RegisterKind.FLOAT_KIND);
            Intrinsics.checkNotNull(list4);
            List<Integer> floatsList = list4;
            int boxedCount = boxedList.size();
            int intsCount = intsList.size();
            int floatsCount = floatsList.size();
            int countdown = boxedCount + intsCount + floatsCount;
            if (countdown > 0) {
                boolean bl;
                int i2;
                translator.loadInterpreter(method);
                Interpreter.Companion.getGetReifiedContinuationMethod().generateCall(method);
                AvailObject.Companion.getRegisterDumpMethod().generateCall(method);
                for (i2 = 0; i2 < boxedCount; ++i2) {
                    if (--countdown > 0) {
                        method.visitInsn(89);
                    }
                    translator.intConstant(method, i2 + 1);
                    A_RegisterDump.Companion.getExtractDumpedObjectAtMethod().generateCall(method);
                    method.visitVarInsn(L2Register.RegisterKind.BOXED_KIND.getStoreInstruction(), ((Number)boxedList.get(i2)).intValue());
                }
                i2 = 1;
                Iterator<Integer> iterator2 = intsList.iterator();
                while (iterator2.hasNext()) {
                    int intRegisterIndex = ((Number)iterator2.next()).intValue();
                    if (--countdown > 0) {
                        method.visitInsn(89);
                    }
                    translator.intConstant(method, i2++);
                    A_RegisterDump.Companion.getExtractDumpedLongAtMethod().generateCall(method);
                    method.visitInsn(136);
                    method.visitVarInsn(L2Register.RegisterKind.INTEGER_KIND.getStoreInstruction(), intRegisterIndex);
                }
                iterator2 = floatsList.iterator();
                while (iterator2.hasNext()) {
                    int floatRegisterIndex = ((Number)iterator2.next()).intValue();
                    if (--countdown > 0) {
                        method.visitInsn(89);
                    }
                    translator.intConstant(method, i2++);
                    A_RegisterDump.Companion.getExtractDumpedLongAtMethod().generateCall(method);
                    JavaLibrary.INSTANCE.getBitCastLongToDoubleMethod().generateCall(method);
                    method.visitVarInsn(L2Register.RegisterKind.FLOAT_KIND.getStoreInstruction(), floatRegisterIndex);
                }
                boolean bl2 = bl = countdown == 0;
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
            }
            translator.loadInterpreter(method);
            Interpreter.Companion.getPopContinuationMethod().generateCall(method);
        }
    }
}

