/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.bootstrap.syntax;

import avail.compiler.AvailRejectedParseException;
import avail.compiler.problems.CompilerDiagnostics;
import avail.descriptor.fiber.FiberDescriptor;
import avail.descriptor.phrases.A_Phrase;
import avail.descriptor.phrases.DeclarationPhraseDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.tokens.TokenDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.InstanceMetaDescriptor;
import avail.descriptor.types.PhraseTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.primitive.style.P_BootstrapStatementStyler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\u000b"}, d2={"Lavail/interpreter/primitive/bootstrap/syntax/P_BootstrapVariableDeclarationMacro;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "bootstrapStyler", "Lavail/interpreter/primitive/style/P_BootstrapStatementStyler;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "avail"})
public final class P_BootstrapVariableDeclarationMacro
extends Primitive {
    @NotNull
    public static final P_BootstrapVariableDeclarationMacro INSTANCE = new P_BootstrapVariableDeclarationMacro();

    private P_BootstrapVariableDeclarationMacro() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline, Primitive.Flag.CannotFail, Primitive.Flag.Bootstrap};
        super(2, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(2);
        AvailObject variableNameLiteral = interpreter.argument(0);
        AvailObject typeLiteral = interpreter.argument(1);
        AvailObject nameToken = A_Phrase.Companion.getToken(variableNameLiteral).literal();
        A_String nameString = nameToken.string();
        if (nameToken.tokenType() != TokenDescriptor.TokenType.KEYWORD) {
            throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.STRONG, "new variable name to be alphanumeric, not " + nameString, new Object[0]);
        }
        AvailObject type = A_Phrase.Companion.getToken(typeLiteral).literal();
        if (type.isTop() || type.isBottom()) {
            throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.STRONG, "variable's declared type to be something other than " + type, new Object[0]);
        }
        A_Phrase variableDeclaration = DeclarationPhraseDescriptor.Companion.newVariable(nameToken, type, typeLiteral, NilDescriptor.Companion.getNil());
        A_Phrase a_Phrase = FiberDescriptor.Companion.addDeclaration(variableDeclaration);
        if (a_Phrase != null) {
            A_Phrase it = a_Phrase;
            boolean bl = false;
            throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.STRONG, "local variable " + nameString + " to have a name that doesn't shadow an existing " + it.declarationKind().nativeKindName() + " (from line " + A_Phrase.Companion.getToken(it).lineNumber() + ")", new Object[0]);
        }
        return interpreter.primitiveSuccess(variableDeclaration);
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(PhraseTypeDescriptor.PhraseKind.LITERAL_PHRASE.create(PrimitiveTypeDescriptor.Types.TOKEN.getO()), PhraseTypeDescriptor.PhraseKind.LITERAL_PHRASE.create(InstanceMetaDescriptor.Companion.anyMeta())), PhraseTypeDescriptor.PhraseKind.DECLARATION_PHRASE.getMostGeneralType(), null, 4, null);
    }

    @Override
    @NotNull
    public P_BootstrapStatementStyler bootstrapStyler() {
        return P_BootstrapStatementStyler.INSTANCE;
    }
}

