/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.compiler;

import avail.descriptor.atoms.AtomDescriptor;
import avail.descriptor.bundles.A_Bundle;
import avail.descriptor.fiber.A_Fiber;
import avail.descriptor.fiber.FiberDescriptor;
import avail.descriptor.maps.A_Map;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014\u00a8\u0006\n"}, d2={"Lavail/interpreter/primitive/compiler/P_CurrentMacroName;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
public final class P_CurrentMacroName
extends Primitive {
    @NotNull
    public static final P_CurrentMacroName INSTANCE = new P_CurrentMacroName();

    private P_CurrentMacroName() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline};
        super(0, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(0);
        if (!A_Fiber.Companion.generalFlag(interpreter.fiber(), FiberDescriptor.GeneralFlag.IS_EVALUATING_MACRO)) {
            return interpreter.primitiveFailure(AvailErrorCode.E_NOT_EVALUATING_MACRO);
        }
        if (A_Fiber.Companion.getAvailLoader(interpreter.fiber()) == null) {
            throw new IllegalStateException("Macro expansion shouldn't be possible after loading".toString());
        }
        A_Map fiberGlobals = A_Fiber.Companion.getFiberGlobals(interpreter.fiber());
        AvailObject clientData = A_Map.Companion.mapAt(fiberGlobals, AtomDescriptor.SpecialAtom.CLIENT_DATA_GLOBAL_KEY.getAtom());
        AvailObject currentMacroBundle = A_Map.Companion.mapAt(clientData, AtomDescriptor.SpecialAtom.MACRO_BUNDLE_KEY.getAtom());
        return interpreter.primitiveSuccess(A_Bundle.Companion.getMessage(currentMacroBundle));
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, TupleDescriptor.Companion.getEmptyTuple(), PrimitiveTypeDescriptor.Types.ATOM.getO(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_NOT_EVALUATING_MACRO};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }
}

