/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.controlflow;

import avail.descriptor.functions.A_Continuation;
import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.BottomTypeDescriptor;
import avail.descriptor.types.ContinuationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.levelTwo.L2Instruction;
import avail.interpreter.levelTwo.L2Operation;
import avail.interpreter.levelTwo.operand.L2Operand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedOperand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedVectorOperand;
import avail.interpreter.levelTwo.operand.L2WriteBoxedOperand;
import avail.interpreter.levelTwo.operation.L2_JUMP;
import avail.interpreter.levelTwo.operation.L2_JUMP_BACK;
import avail.interpreter.levelTwo.operation.L2_MOVE;
import avail.interpreter.levelTwo.operation.L2_RESTART_CONTINUATION;
import avail.interpreter.levelTwo.operation.L2_STRIP_MANIFEST;
import avail.interpreter.levelTwo.register.L2BoxedRegister;
import avail.optimizer.L1Translator;
import avail.optimizer.L2BasicBlock;
import avail.optimizer.L2Entity;
import avail.optimizer.L2EntityAndKind;
import avail.optimizer.L2Generator;
import avail.optimizer.L2Synonym;
import avail.optimizer.L2ValueManifest;
import avail.optimizer.values.L2SemanticValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014JH\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\u0006\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u00060\u0015R\u00020\u0013H\u0016\u00a8\u0006\u0016"}, d2={"Lavail/interpreter/primitive/controlflow/P_RestartContinuation;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "tryToGenerateSpecialPrimitiveInvocation", "", "functionToCallReg", "Lavail/interpreter/levelTwo/operand/L2ReadBoxedOperand;", "rawFunction", "Lavail/descriptor/functions/A_RawFunction;", "arguments", "", "argumentTypes", "translator", "Lavail/optimizer/L1Translator;", "callSiteHelper", "Lavail/optimizer/L1Translator$CallSiteHelper;", "avail"})
@SourceDebugExtension(value={"SMAP\nP_RestartContinuation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 P_RestartContinuation.kt\navail/interpreter/primitive/controlflow/P_RestartContinuation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,240:1\n1559#2:241\n1590#2,4:242\n*S KotlinDebug\n*F\n+ 1 P_RestartContinuation.kt\navail/interpreter/primitive/controlflow/P_RestartContinuation\n*L\n178#1:241\n178#1:242,4\n*E\n"})
public final class P_RestartContinuation
extends Primitive {
    @NotNull
    public static final P_RestartContinuation INSTANCE = new P_RestartContinuation();

    private P_RestartContinuation() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CannotFail, Primitive.Flag.CanInline, Primitive.Flag.CanSwitchContinuations, Primitive.Flag.AlwaysSwitchesContinuation};
        super(1, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(1);
        AvailObject originalCon = interpreter.argument(0);
        A_RawFunction code = originalCon.function().code();
        boolean bl2 = bl = A_Continuation.Companion.stackp(originalCon) == A_RawFunction.Companion.getNumSlots(code) + 1;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-P_RestartContinuation$attempt$32 = false;
            String $i$a$-assert-P_RestartContinuation$attempt$32 = "Continuation should have been a label- rather than call-continuation";
            throw new AssertionError((Object)$i$a$-assert-P_RestartContinuation$attempt$32);
        }
        boolean bl3 = bl = A_Continuation.Companion.pc(originalCon) == 0;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-P_RestartContinuation$attempt$42 = false;
            String $i$a$-assert-P_RestartContinuation$attempt$42 = "Continuation should have been a label- rather than call-continuation";
            throw new AssertionError((Object)$i$a$-assert-P_RestartContinuation$attempt$42);
        }
        int numArgs = A_RawFunction.Companion.numArgs(code);
        interpreter.argsBuffer.clear();
        int i2 = 1;
        if (i2 <= numArgs) {
            while (true) {
                interpreter.argsBuffer.add(A_Continuation.Companion.frameAt(originalCon, i2));
                if (i2 == numArgs) break;
                ++i2;
            }
        }
        interpreter.setReifiedContinuation(A_Continuation.Companion.caller(originalCon));
        interpreter.function = originalCon.function();
        interpreter.chunk = A_RawFunction.Companion.getStartingChunk(code);
        interpreter.offset = 0;
        interpreter.returnNow = false;
        interpreter.setLatestResult(null);
        return Primitive.Result.CONTINUATION_CHANGED;
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(ContinuationTypeDescriptor.Companion.getMostGeneralContinuationType()), BottomTypeDescriptor.Companion.getBottom(), null, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean tryToGenerateSpecialPrimitiveInvocation(@NotNull L2ReadBoxedOperand functionToCallReg, @NotNull A_RawFunction rawFunction2, @NotNull List<L2ReadBoxedOperand> arguments, @NotNull List<? extends A_Type> argumentTypes, @NotNull L1Translator translator, @NotNull L1Translator.CallSiteHelper callSiteHelper) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)functionToCallReg, (String)"functionToCallReg");
        Intrinsics.checkNotNullParameter((Object)rawFunction2, (String)"rawFunction");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter(argumentTypes, (String)"argumentTypes");
        Intrinsics.checkNotNullParameter((Object)translator, (String)"translator");
        Intrinsics.checkNotNullParameter((Object)callSiteHelper, (String)"callSiteHelper");
        L2ReadBoxedOperand continuationReg = arguments.get(0);
        L2Generator generator = translator.getGenerator();
        L2ValueManifest manifest2 = generator.getCurrentManifest();
        L2Synonym synonym = manifest2.semanticValueToSynonym(continuationReg.semanticValue());
        L2SemanticValue label = generator.getTopFrame().label();
        if (manifest2.hasSemanticValue(label) && Intrinsics.areEqual((Object)manifest2.semanticValueToSynonym(label), (Object)synonym)) {
            void $this$mapIndexedTo$iv$iv;
            Object temp;
            Set tempSemanticValues = new LinkedHashSet();
            Set tempRegisters = new LinkedHashSet();
            List tempReads = new ArrayList();
            int i22 = 1;
            int n = A_RawFunction.Companion.numArgs(translator.getCode());
            if (i22 <= n) {
                while (true) {
                    L2ReadBoxedOperand read2 = translator.readSlot(i22);
                    temp = generator.newTemp();
                    tempSemanticValues.add(temp);
                    L2WriteBoxedOperand tempWrite = L2_MOVE.Companion.getBoxed().createWrite(generator, SetsKt.setOf((Object)temp), read2.restriction());
                    L2Operand[] l2OperandArray = new L2Operand[]{read2, tempWrite};
                    generator.addInstruction(L2_MOVE.Companion.getBoxed(), l2OperandArray);
                    L2Instruction move = (L2Instruction)CollectionsKt.last(generator.currentBlock().instructions());
                    boolean bl2 = Intrinsics.areEqual((Object)move.getOperation(), L2_MOVE.Companion.getBoxed());
                    if (_Assertions.ENABLED && !bl2) {
                        String string2 = "Assertion failed";
                        throw new AssertionError((Object)string2);
                    }
                    tempRegisters.addAll((Collection)move.getDestinationRegisters());
                    tempReads.add(new L2ReadBoxedOperand((L2SemanticValue)temp, read2.restriction(), (L2BoxedRegister)tempWrite.register()));
                    if (i22 == n) break;
                    ++i22;
                }
            }
            L2Operand[] i22 = new L2Operand[]{new L2ReadBoxedVectorOperand(tempReads)};
            generator.addInstruction(L2_STRIP_MANIFEST.INSTANCE, i22);
            L2Operand[] $this$mapIndexed$iv = (L2Operand[])tempSemanticValues;
            boolean $i$f$mapIndexed22 = false;
            temp = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void temp2;
                void zeroIndex;
                int n2;
                if ((n2 = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                L2SemanticValue l2SemanticValue = (L2SemanticValue)item$iv$iv;
                int n3 = n2;
                Collection collection2 = destination$iv$iv;
                boolean bl3 = false;
                L2SemanticValue newArg = translator.createSemanticSlot((int)(zeroIndex + true), 1);
                L2WriteBoxedOperand writeOperand = generator.boxedWrite(newArg, manifest2.restrictionFor((L2SemanticValue)temp2));
                L2Operand[] l2OperandArray = new L2Operand[]{generator.readBoxed((L2SemanticValue)temp2), writeOperand};
                generator.addInstruction(L2_MOVE.Companion.getBoxed(), l2OperandArray);
                collection2.add(new L2ReadBoxedOperand(newArg, writeOperand.restriction(), (L2BoxedRegister)writeOperand.register()));
            }
            List newReads = (List)destination$iv$iv;
            $this$mapIndexed$iv = new L2Operand[]{new L2ReadBoxedVectorOperand(newReads)};
            generator.addInstruction(L2_STRIP_MANIFEST.INSTANCE, $this$mapIndexed$iv);
            L2BasicBlock trampolineBlock = generator.createBasicBlock("edge-split for restart");
            L2Operand[] $i$f$mapIndexed22 = new L2Operand[]{L2Generator.Companion.edgeTo(trampolineBlock), new L2ReadBoxedVectorOperand(newReads)};
            generator.addInstruction(L2_JUMP_BACK.INSTANCE, $i$f$mapIndexed22);
            L2Generator.startBlock$default(generator, trampolineBlock, false, null, 6, null);
            L2Operation l2Operation = L2_JUMP.INSTANCE;
            $i$f$mapIndexed22 = new L2Operand[1];
            L2BasicBlock l2BasicBlock = generator.getSpecialBlocks().get((Object)L2Generator.SpecialBlock.RESTART_LOOP_HEAD);
            Intrinsics.checkNotNull((Object)l2BasicBlock);
            $i$f$mapIndexed22[0] = L2Generator.Companion.backEdgeTo(l2BasicBlock);
            generator.addInstruction(l2Operation, $i$f$mapIndexed22);
            Set liveEntities = new LinkedHashSet();
            for (L2ReadBoxedOperand newRead : newReads) {
                liveEntities.add(new L2EntityAndKind(newRead.semanticValue(), newRead.getRegisterKind()));
                liveEntities.add(new L2EntityAndKind((L2Entity)newRead.register(), newRead.getRegisterKind()));
            }
            generator.currentBlock().successorEdges().get(0).setForcedClampedEntities(liveEntities);
            return true;
        }
        L2Operand[] l2OperandArray = new L2Operand[]{continuationReg};
        translator.addInstruction(L2_RESTART_CONTINUATION.INSTANCE, l2OperandArray);
        boolean bl4 = bl = !translator.getGenerator().currentlyReachable();
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        return true;
    }
}

