/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.files;

import avail.AvailRuntime;
import avail.descriptor.atoms.A_Atom;
import avail.descriptor.atoms.AtomDescriptor;
import avail.descriptor.fiber.A_Fiber;
import avail.descriptor.fiber.FiberDescriptor;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.numbers.InfinityDescriptor;
import avail.descriptor.numbers.IntegerDescriptor;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ByteBufferTupleDescriptor;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.StringDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FiberTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.InstanceTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.io.IOSystem;
import avail.io.SimpleCompletionHandler;
import avail.utility.Mutable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\u000bH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lavail/interpreter/primitive/files/P_FileRead;", "Lavail/interpreter/Primitive;", "()V", "MAX_READ_SIZE", "", "THRESHOLD_READ_SIZE", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
@SourceDebugExtension(value={"SMAP\nP_FileRead.kt\nKotlin\n*S Kotlin\n*F\n+ 1 P_FileRead.kt\navail/interpreter/primitive/files/P_FileRead\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,360:1\n1726#2,3:361\n*S KotlinDebug\n*F\n+ 1 P_FileRead.kt\navail/interpreter/primitive/files/P_FileRead\n*L\n277#1:361,3\n*E\n"})
public final class P_FileRead
extends Primitive {
    @NotNull
    public static final P_FileRead INSTANCE = new P_FileRead();
    private static final int MAX_READ_SIZE = 0x400000;
    private static final int THRESHOLD_READ_SIZE = 32768;

    private P_FileRead() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline, Primitive.Flag.HasSideEffect};
        super(6, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        boolean $this$all$iv2;
        A_Fiber newFiber2;
        List buffers;
        int alignment;
        int size;
        long oneBasedPositionLong;
        IOSystem ioSystem;
        AvailRuntime runtime;
        AsynchronousFileChannel fileChannel;
        IOSystem.FileHandle handle2;
        AvailObject fail2;
        AvailObject succeed2;
        block25: {
            boolean buffersTuple2;
            boolean bl;
            long augmentedStart;
            boolean actualFileSize2;
            boolean bl2;
            Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
            interpreter.checkArgumentCount(6);
            AvailObject positionObject = interpreter.argument(0);
            AvailObject sizeObject = interpreter.argument(1);
            AvailObject atom = interpreter.argument(2);
            succeed2 = interpreter.argument(3);
            fail2 = interpreter.argument(4);
            AvailObject priority = interpreter.argument(5);
            AvailObject pojo2 = A_Atom.Companion.getAtomProperty(atom, AtomDescriptor.SpecialAtom.FILE_KEY.getAtom());
            if (pojo2.isNil()) {
                return interpreter.primitiveFailure(A_Atom.Companion.isAtomSpecial(atom) ? AvailErrorCode.E_SPECIAL_ATOM : AvailErrorCode.E_INVALID_HANDLE);
            }
            handle2 = (IOSystem.FileHandle)pojo2.javaObjectNotNull();
            if (!handle2.getCanRead()) {
                return interpreter.primitiveFailure(AvailErrorCode.E_NOT_OPEN_FOR_READ);
            }
            fileChannel = handle2.getChannel();
            if (!A_Number.Companion.isLong(positionObject)) {
                return interpreter.primitiveFailure(AvailErrorCode.E_EXCEEDS_VM_LIMIT);
            }
            runtime = interpreter.runtime;
            ioSystem = runtime.getIoSystem();
            oneBasedPositionLong = A_Number.Companion.getExtractLong(positionObject);
            boolean bl3 = bl2 = oneBasedPositionLong > 0L;
            if (_Assertions.ENABLED && !bl2) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            size = Math.min(A_Number.Companion.isInt(sizeObject) ? A_Number.Companion.getExtractInt(sizeObject) : 0x400000, 0x400000);
            if (size > 32768) {
                long actualFileSize2 = 0L;
                try {
                    actualFileSize2 = fileChannel.size();
                }
                catch (IOException e) {
                    actualFileSize2 = Long.MAX_VALUE;
                    size = 32768;
                }
                if (oneBasedPositionLong > actualFileSize2) {
                    v1 = 1;
                } else {
                    long available = actualFileSize2 - oneBasedPositionLong + 1L;
                    v1 = size = Math.min(size, (int)Math.min(available, 0x400000L));
                }
            }
            boolean bl4 = 1 <= size ? size < 0x400001 : (actualFileSize2 = false);
            if (_Assertions.ENABLED && !actualFileSize2) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
            alignment = handle2.getAlignment();
            long augmentedEnd = (oneBasedPositionLong + (long)size + (long)alignment - (long)2) / (long)alignment * (long)alignment;
            long bufferCount = (augmentedEnd + 1L - (augmentedStart = (oneBasedPositionLong - 1L) / (long)alignment * (long)alignment + 1L)) / (long)alignment;
            boolean bl5 = bl = bufferCount == (long)((int)bufferCount);
            if (_Assertions.ENABLED && !bl) {
                String string4 = "Assertion failed";
                throw new AssertionError((Object)string4);
            }
            long firstPresentBufferStart = Long.MIN_VALUE;
            long firstMissingBufferStart = Long.MIN_VALUE;
            buffers = new ArrayList();
            long l = alignment;
            if (l <= 0L) {
                throw new IllegalArgumentException("Step must be positive, was: " + l + ".");
            }
            long bufferStart = augmentedStart;
            long l2 = ProgressionUtilKt.getProgressionLastElement((long)augmentedStart, (long)augmentedEnd, (long)l);
            long l3 = l;
            if (bufferStart <= l2) {
                while (true) {
                    IOSystem.BufferKey key;
                    Mutable<A_Tuple> bufferHolder;
                    A_Tuple buffer;
                    if ((buffer = (bufferHolder = ioSystem.getBuffer(key = new IOSystem.BufferKey(handle2, bufferStart))).getValue()) == null) {
                        if (firstMissingBufferStart == Long.MIN_VALUE) {
                            firstMissingBufferStart = bufferStart;
                            if (firstPresentBufferStart != Long.MIN_VALUE) {
                                break;
                            }
                        }
                    } else if (firstPresentBufferStart == Long.MIN_VALUE) {
                        firstPresentBufferStart = bufferStart;
                        if (firstMissingBufferStart != Long.MIN_VALUE) break;
                    }
                    buffers.add(buffer);
                    if (bufferStart == l2) break;
                    bufferStart += l3;
                }
            }
            A_Fiber current = interpreter.fiber();
            newFiber2 = FiberDescriptor.Companion.newFiber$default(FiberDescriptor.Companion, A_Type.Companion.typeUnion(A_Type.Companion.getReturnType(succeed2.kind()), A_Type.Companion.getReturnType(fail2.kind())), runtime, A_Fiber.Companion.getTextInterface(current), A_Number.Companion.getExtractInt(priority), null, (Function0)new Function0<A_String>(handle2){
                final /* synthetic */ IOSystem.FileHandle $handle;
                {
                    this.$handle = $handle;
                    super(0);
                }

                @NotNull
                public final A_String invoke() {
                    Object[] objectArray = new Object[]{this.$handle.getFilename()};
                    return StringDescriptor.Companion.formatString("Asynchronous file read, %s", objectArray);
                }
            }, 16, null);
            A_Fiber.Companion.setAvailLoader(newFiber2, A_Fiber.Companion.getAvailLoader(current));
            A_Fiber.Companion.setHeritableFiberGlobals(newFiber2, A_Fiber.Companion.getHeritableFiberGlobals(current).makeShared());
            newFiber2.makeShared();
            succeed2.makeShared();
            fail2.makeShared();
            if (firstPresentBufferStart == augmentedStart) {
                A_Tuple buffersTuple2 = ObjectTupleDescriptor.Companion.tupleFromList(buffers);
                A_Tuple concatenated = A_Tuple.Companion.concatenateTuplesCanDestroy(buffersTuple2, false);
                runtime.runOutermostFunction(newFiber2, succeed2, CollectionsKt.listOf((Object)concatenated), false);
                return interpreter.primitiveSuccess(newFiber2);
            }
            boolean bl6 = buffersTuple2 = firstMissingBufferStart == augmentedStart;
            if (_Assertions.ENABLED && !buffersTuple2) {
                String concatenated = "Assertion failed";
                throw new AssertionError((Object)concatenated);
            }
            Iterable $this$all$iv2 = buffers;
            boolean $i$f$all = false;
            if ($this$all$iv2 instanceof Collection && ((Collection)$this$all$iv2).isEmpty()) {
                v5 = true;
            } else {
                for (Object element$iv : $this$all$iv2) {
                    A_Tuple it = (A_Tuple)element$iv;
                    boolean bl7 = false;
                    if (it == null) continue;
                    v5 = false;
                    break block25;
                }
                v5 = $this$all$iv2 = true;
            }
        }
        if (_Assertions.ENABLED && !$this$all$iv2) {
            String string5 = "Assertion failed";
            throw new AssertionError((Object)string5);
        }
        size = buffers.size() * alignment;
        ByteBuffer buffer = ByteBuffer.allocateDirect(size);
        new SimpleCompletionHandler((Function1)new Function1<SimpleCompletionHandler.Companion.SuccessHelper<Integer>, Unit>(buffer, oneBasedPositionLong, alignment, handle2, ioSystem, runtime, newFiber2, succeed2){
            final /* synthetic */ ByteBuffer $buffer;
            final /* synthetic */ long $oneBasedPositionLong;
            final /* synthetic */ int $alignment;
            final /* synthetic */ IOSystem.FileHandle $handle;
            final /* synthetic */ IOSystem $ioSystem;
            final /* synthetic */ AvailRuntime $runtime;
            final /* synthetic */ A_Fiber $newFiber;
            final /* synthetic */ AvailObject $succeed;
            {
                this.$buffer = $buffer;
                this.$oneBasedPositionLong = $oneBasedPositionLong;
                this.$alignment = $alignment;
                this.$handle = $handle;
                this.$ioSystem = $ioSystem;
                this.$runtime = $runtime;
                this.$newFiber = $newFiber;
                this.$succeed = $succeed;
                super(1);
            }

            public final void invoke(@NotNull SimpleCompletionHandler.Companion.SuccessHelper<Integer> $this$$receiver) {
                Intrinsics.checkNotNullParameter($this$$receiver, (String)"$this$$receiver");
                this.$buffer.flip();
                A_Tuple bytesTuple = null;
                if (((Number)$this$$receiver.getValue()).intValue() == -1) {
                    boolean bl;
                    boolean bl2 = bl = this.$buffer.remaining() == 0;
                    if (_Assertions.ENABLED && !bl) {
                        String string2 = "Assertion failed";
                        throw new AssertionError((Object)string2);
                    }
                    bytesTuple = TupleDescriptor.Companion.getEmptyTuple();
                } else {
                    boolean bl;
                    boolean bl3 = bl = this.$buffer.remaining() == ((Number)$this$$receiver.getValue()).intValue();
                    if (_Assertions.ENABLED && !bl) {
                        String string3 = "Assertion failed";
                        throw new AssertionError((Object)string3);
                    }
                    ByteBuffer byteBuffer = this.$buffer;
                    Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"$buffer");
                    bytesTuple = ByteBufferTupleDescriptor.Companion.tupleForByteBuffer(byteBuffer).makeShared();
                    boolean bl4 = bl = A_Tuple.Companion.getTupleSize(bytesTuple) == ((Number)$this$$receiver.getValue()).intValue();
                    if (_Assertions.ENABLED && !bl) {
                        String string4 = "Assertion failed";
                        throw new AssertionError((Object)string4);
                    }
                    long lastPosition = this.$oneBasedPositionLong + ((Number)$this$$receiver.getValue()).longValue() - 1L;
                    long lastFullBufferStart = lastPosition / (long)this.$alignment * (long)this.$alignment - (long)this.$alignment + 1L;
                    int offsetInBuffer = 1;
                    long l = this.$alignment;
                    if (l <= 0L) {
                        throw new IllegalArgumentException("Step must be positive, was: " + l + ".");
                    }
                    long bufferStart = this.$oneBasedPositionLong;
                    long l2 = ProgressionUtilKt.getProgressionLastElement((long)this.$oneBasedPositionLong, (long)lastFullBufferStart, (long)l);
                    long l3 = l;
                    if (bufferStart <= l2) {
                        while (true) {
                            AvailObject subtuple;
                            boolean bl5;
                            boolean bl6 = bl5 = A_Tuple.Companion.getTupleSize(subtuple = A_Tuple.Companion.copyTupleFromToCanDestroy(bytesTuple, offsetInBuffer, offsetInBuffer + this.$alignment - 1, false).makeShared()) == this.$alignment;
                            if (_Assertions.ENABLED && !bl5) {
                                String string5 = "Assertion failed";
                                throw new AssertionError((Object)string5);
                            }
                            IOSystem.BufferKey key = new IOSystem.BufferKey(this.$handle, bufferStart);
                            Mutable<A_Tuple> bufferHolder = this.$ioSystem.getBuffer(key);
                            bufferHolder.setValue(subtuple);
                            this.$ioSystem.getBuffer(key);
                            offsetInBuffer += this.$alignment;
                            if (bufferStart == l2) break;
                            bufferStart += l3;
                        }
                    }
                }
                this.$runtime.runOutermostFunction(this.$newFiber, this.$succeed, CollectionsKt.listOf((Object)bytesTuple), false);
            }
        }, (Function1)new Function1<SimpleCompletionHandler.Companion.FailureHelper<Integer>, Unit>(runtime, newFiber2, fail2){
            final /* synthetic */ AvailRuntime $runtime;
            final /* synthetic */ A_Fiber $newFiber;
            final /* synthetic */ AvailObject $fail;
            {
                this.$runtime = $runtime;
                this.$newFiber = $newFiber;
                this.$fail = $fail;
                super(1);
            }

            public final void invoke(@NotNull SimpleCompletionHandler.Companion.FailureHelper<Integer> $this$$receiver) {
                Intrinsics.checkNotNullParameter($this$$receiver, (String)"$this$$receiver");
                this.$runtime.runOutermostFunction(this.$newFiber, this.$fail, CollectionsKt.listOf((Object)AvailErrorCode.E_IO_ERROR.numericCode()), false);
            }
        }).guardedDo((Function1)new Function1<SimpleCompletionHandler.Companion.GuardHelper<Integer>, Unit>(fileChannel, buffer, oneBasedPositionLong){
            final /* synthetic */ AsynchronousFileChannel $fileChannel;
            final /* synthetic */ ByteBuffer $buffer;
            final /* synthetic */ long $oneBasedPositionLong;
            {
                this.$fileChannel = $fileChannel;
                this.$buffer = $buffer;
                this.$oneBasedPositionLong = $oneBasedPositionLong;
                super(1);
            }

            public final void invoke(@NotNull SimpleCompletionHandler.Companion.GuardHelper<Integer> $this$guardedDo) {
                Intrinsics.checkNotNullParameter($this$guardedDo, (String)"$this$guardedDo");
                this.$fileChannel.read(this.$buffer, this.$oneBasedPositionLong - 1L, Unit.INSTANCE, (CompletionHandler)$this$guardedDo.getHandler());
            }
        });
        return interpreter.primitiveSuccess(newFiber2);
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        A_BasicObject[] a_BasicObjectArray = new A_BasicObject[]{IntegerRangeTypeDescriptor.Companion.getNaturalNumbers(), IntegerRangeTypeDescriptor.Companion.inclusive(IntegerDescriptor.Companion.getOne(), InfinityDescriptor.Companion.getPositiveInfinity()), PrimitiveTypeDescriptor.Types.ATOM.getO(), FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(TupleTypeDescriptor.Companion.zeroOrMoreOf(IntegerRangeTypeDescriptor.Companion.getU8())), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null), FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(InstanceTypeDescriptor.Companion.instanceType(AvailErrorCode.E_IO_ERROR.numericCode())), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null), IntegerRangeTypeDescriptor.Companion.getU8()};
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tupleFromArray(a_BasicObjectArray), FiberTypeDescriptor.Companion.fiberType(PrimitiveTypeDescriptor.Types.TOP.getO()), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_INVALID_HANDLE, AvailErrorCode.E_SPECIAL_ATOM, AvailErrorCode.E_NOT_OPEN_FOR_READ, AvailErrorCode.E_EXCEEDS_VM_LIMIT};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }
}

