/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.general;

import avail.descriptor.fiber.A_Fiber;
import avail.descriptor.fiber.FiberDescriptor;
import avail.descriptor.functions.A_Function;
import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.functions.ContinuationDescriptor;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.BottomTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.exceptions.AvailEmergencyExitException;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.levelTwo.operand.L2ReadBoxedOperand;
import avail.optimizer.L1Translator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014JH\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\u0006\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u00060\u0015R\u00020\u0013H\u0016\u00a8\u0006\u0016"}, d2={"Lavail/interpreter/primitive/general/P_EmergencyExit;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "tryToGenerateSpecialPrimitiveInvocation", "", "functionToCallReg", "Lavail/interpreter/levelTwo/operand/L2ReadBoxedOperand;", "rawFunction", "Lavail/descriptor/functions/A_RawFunction;", "arguments", "", "argumentTypes", "translator", "Lavail/optimizer/L1Translator;", "callSiteHelper", "Lavail/optimizer/L1Translator$CallSiteHelper;", "avail"})
public final class P_EmergencyExit
extends Primitive {
    @NotNull
    public static final P_EmergencyExit INSTANCE = new P_EmergencyExit();

    private P_EmergencyExit() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.Unknown, Primitive.Flag.CanSwitchContinuations, Primitive.Flag.AlwaysSwitchesContinuation, Primitive.Flag.CanSuspend, Primitive.Flag.CannotFail};
        super(1, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(1);
        AvailObject errorMessageProducer = interpreter.argument(0);
        boolean bl2 = bl = interpreter.unreifiedCallDepth() == 0;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        A_Fiber fiber2 = interpreter.fiber();
        AvailObject availObject = interpreter.getReifiedContinuation();
        Intrinsics.checkNotNull((Object)availObject);
        AvailObject continuation = availObject;
        A_Function a_Function = interpreter.function;
        Intrinsics.checkNotNull((Object)a_Function);
        interpreter.primitiveSuspend(a_Function);
        ContinuationDescriptor.Companion.dumpStackThen(interpreter.runtime, A_Fiber.Companion.getTextInterface(fiber2), continuation, (Function1<? super List<String>, Unit>)((Function1)new Function1<List<? extends String>, Unit>(fiber2, errorMessageProducer){
            final /* synthetic */ A_Fiber $fiber;
            final /* synthetic */ AvailObject $errorMessageProducer;
            {
                this.$fiber = $fiber;
                this.$errorMessageProducer = $errorMessageProducer;
                super(1);
            }

            public final void invoke(@NotNull List<String> stack) {
                Intrinsics.checkNotNullParameter(stack, (String)"stack");
                StringBuilder builder = new StringBuilder();
                Object[] objectArray = new Object[]{A_Fiber.Companion.getFiberName(this.$fiber), this.$errorMessageProducer};
                builder.append(String.format("A fiber (%s) has exited: %s", objectArray));
                if (A_Number.Companion.isInt(this.$errorMessageProducer)) {
                    AvailObject $this$cast$iv = this.$errorMessageProducer;
                    boolean $i$f$cast = false;
                    A_Number errorNumber = (A_Number)((Object)$this$cast$iv);
                    int intValue = A_Number.Companion.getExtractInt(errorNumber);
                    AvailErrorCode code = AvailErrorCode.Companion.byNumericCode(intValue);
                    if (code != null) {
                        Object[] objectArray2 = new Object[]{code.name()};
                        builder.append(String.format(" (= %s)", objectArray2));
                    }
                }
                for (String frame : stack) {
                    Object[] objectArray3 = new Object[]{frame};
                    builder.append(String.format("%n\t-- %s", objectArray3));
                }
                builder.append("\n\n");
                String string2 = builder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                AvailEmergencyExitException killer = new AvailEmergencyExitException(string2);
                killer.fillInStackTrace();
                A_Fiber.Companion.setExecutionState(this.$fiber, FiberDescriptor.ExecutionState.ABORTED);
                A_Fiber.Companion.getFailureContinuation(this.$fiber).invoke((Object)killer);
                System.err.print(builder);
                throw new RuntimeException(killer);
            }
        }));
        return Primitive.Result.FIBER_SUSPENDED;
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(PrimitiveTypeDescriptor.Types.ANY.getO()), BottomTypeDescriptor.Companion.getBottom(), null, 4, null);
    }

    @Override
    public boolean tryToGenerateSpecialPrimitiveInvocation(@NotNull L2ReadBoxedOperand functionToCallReg, @NotNull A_RawFunction rawFunction2, @NotNull List<L2ReadBoxedOperand> arguments, @NotNull List<? extends A_Type> argumentTypes, @NotNull L1Translator translator, @NotNull L1Translator.CallSiteHelper callSiteHelper) {
        Intrinsics.checkNotNullParameter((Object)functionToCallReg, (String)"functionToCallReg");
        Intrinsics.checkNotNullParameter((Object)rawFunction2, (String)"rawFunction");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter(argumentTypes, (String)"argumentTypes");
        Intrinsics.checkNotNullParameter((Object)translator, (String)"translator");
        Intrinsics.checkNotNullParameter((Object)callSiteHelper, (String)"callSiteHelper");
        return false;
    }
}

