/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.numbers;

import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.numbers.AbstractNumberDescriptor;
import avail.descriptor.numbers.InfinityDescriptor;
import avail.descriptor.numbers.IntegerDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.A_Set;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.BottomTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.exceptions.ArithmeticException;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.levelTwo.operand.L2Operand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedOperand;
import avail.interpreter.levelTwo.operand.L2ReadIntOperand;
import avail.interpreter.levelTwo.operand.L2WriteIntOperand;
import avail.interpreter.levelTwo.operand.TypeRestriction;
import avail.interpreter.levelTwo.operation.L2_BIT_LOGIC_OP;
import avail.interpreter.levelTwo.operation.L2_MULTIPLY_INT_BY_INT;
import avail.optimizer.L1Translator;
import avail.optimizer.L2BasicBlock;
import avail.optimizer.L2Generator;
import avail.optimizer.values.L2SemanticPrimitiveInvocation;
import avail.optimizer.values.L2SemanticUnboxedInt;
import avail.optimizer.values.L2SemanticValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0014J\b\u0010\r\u001a\u00020\u000bH\u0014J\u001e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016JH\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\n2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u00060\u0019R\u00020\u0017H\u0016\u00a8\u0006\u001b"}, d2={"Lavail/interpreter/primitive/numbers/P_Multiplication;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "fallibilityForArgumentTypes", "Lavail/interpreter/Primitive$Fallibility;", "argumentTypes", "", "Lavail/descriptor/types/A_Type;", "privateBlockTypeRestriction", "privateFailureVariableType", "returnTypeGuaranteedByVM", "rawFunction", "Lavail/descriptor/functions/A_RawFunction;", "tryToGenerateSpecialPrimitiveInvocation", "", "functionToCallReg", "Lavail/interpreter/levelTwo/operand/L2ReadBoxedOperand;", "arguments", "translator", "Lavail/optimizer/L1Translator;", "callSiteHelper", "Lavail/optimizer/L1Translator$CallSiteHelper;", "BoundCalculator", "avail"})
@SourceDebugExtension(value={"SMAP\nP_Multiplication.kt\nKotlin\n*S Kotlin\n*F\n+ 1 P_Multiplication.kt\navail/interpreter/primitive/numbers/P_Multiplication\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,367:1\n1855#2:368\n1855#2,2:369\n1856#2:371\n1549#2:372\n1620#2,3:373\n*S KotlinDebug\n*F\n+ 1 P_Multiplication.kt\navail/interpreter/primitive/numbers/P_Multiplication\n*L\n126#1:368\n127#1:369,2\n126#1:371\n320#1:372\n320#1:373,3\n*E\n"})
public final class P_Multiplication
extends Primitive {
    @NotNull
    public static final P_Multiplication INSTANCE = new P_Multiplication();

    private P_Multiplication() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanFold, Primitive.Flag.CanInline};
        super(2, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Primitive.Result result2;
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(2);
        AvailObject a = interpreter.argument(0);
        AvailObject b = interpreter.argument(1);
        try {
            result2 = interpreter.primitiveSuccess(A_Number.Companion.timesCanDestroy(a, b, true));
        }
        catch (ArithmeticException e) {
            result2 = interpreter.primitiveFailure(e);
        }
        return result2;
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(PrimitiveTypeDescriptor.Types.NUMBER.getO(), PrimitiveTypeDescriptor.Types.NUMBER.getO()), PrimitiveTypeDescriptor.Types.NUMBER.getO(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_CANNOT_MULTIPLY_ZERO_AND_INFINITY};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }

    @Override
    @NotNull
    public A_Type returnTypeGuaranteedByVM(@NotNull A_RawFunction rawFunction2, @NotNull List<? extends A_Type> argumentTypes) {
        Intrinsics.checkNotNullParameter((Object)rawFunction2, (String)"rawFunction");
        Intrinsics.checkNotNullParameter(argumentTypes, (String)"argumentTypes");
        A_Type aType = argumentTypes.get(0);
        A_Type bType = argumentTypes.get(1);
        aType.makeImmutable();
        bType.makeImmutable();
        if (aType.isEnumeration() && bType.isEnumeration()) {
            A_Set aValues = A_Type.Companion.getInstances(aType);
            A_Set bValues = A_Type.Companion.getInstances(bType);
            if ((long)A_Set.Companion.getSetSize(aValues) * (long)A_Set.Companion.getSetSize(bValues) < 100L) {
                A_Set answers = null;
                answers = SetDescriptor.Companion.getEmptySet();
                Iterable $this$forEach$iv = aValues;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    AvailObject aValue = (AvailObject)element$iv;
                    boolean bl = false;
                    Iterable $this$forEach$iv2 = bValues;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        AvailObject bValue = (AvailObject)element$iv2;
                        boolean bl2 = false;
                        try {
                            answers = A_Set.Companion.setWithElementCanDestroy(answers, A_Number.Companion.timesCanDestroy(aValue, bValue, false), false);
                        }
                        catch (ArithmeticException arithmeticException) {
                        }
                    }
                }
                return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(answers);
            }
        }
        return aType.isIntegerRangeType() && bType.isIntegerRangeType() ? new BoundCalculator(aType, bType).process$avail() : AbstractNumberDescriptor.Companion.binaryNumericOperationTypeBound(aType, bType);
    }

    @Override
    @NotNull
    public Primitive.Fallibility fallibilityForArgumentTypes(@NotNull List<? extends A_Type> argumentTypes) {
        Intrinsics.checkNotNullParameter(argumentTypes, (String)"argumentTypes");
        A_Type aType = argumentTypes.get(0);
        A_Type bType = argumentTypes.get(1);
        boolean aTypeIncludesZero = IntegerDescriptor.Companion.getZero().isInstanceOf(aType);
        boolean aTypeIncludesInfinity = InfinityDescriptor.Companion.getNegativeInfinity().isInstanceOf(aType) || InfinityDescriptor.Companion.getPositiveInfinity().isInstanceOf(aType);
        boolean bTypeIncludesZero = IntegerDescriptor.Companion.getZero().isInstanceOf(bType);
        boolean bTypeIncludesInfinity = InfinityDescriptor.Companion.getNegativeInfinity().isInstanceOf(bType) || InfinityDescriptor.Companion.getPositiveInfinity().isInstanceOf(bType);
        return aTypeIncludesZero && bTypeIncludesInfinity || aTypeIncludesInfinity && bTypeIncludesZero ? Primitive.Fallibility.CallSiteCanFail : Primitive.Fallibility.CallSiteCannotFail;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean tryToGenerateSpecialPrimitiveInvocation(@NotNull L2ReadBoxedOperand functionToCallReg, @NotNull A_RawFunction rawFunction2, @NotNull List<L2ReadBoxedOperand> arguments, @NotNull List<? extends A_Type> argumentTypes, @NotNull L1Translator translator, @NotNull L1Translator.CallSiteHelper callSiteHelper) {
        Intrinsics.checkNotNullParameter((Object)functionToCallReg, (String)"functionToCallReg");
        Intrinsics.checkNotNullParameter((Object)rawFunction2, (String)"rawFunction");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter(argumentTypes, (String)"argumentTypes");
        Intrinsics.checkNotNullParameter((Object)translator, (String)"translator");
        Intrinsics.checkNotNullParameter((Object)callSiteHelper, (String)"callSiteHelper");
        L2ReadBoxedOperand a = arguments.get(0);
        L2ReadBoxedOperand b = arguments.get(1);
        A_Type aType = argumentTypes.get(0);
        A_Type bType = argumentTypes.get(1);
        if (A_Type.Companion.typeIntersection(aType, IntegerRangeTypeDescriptor.Companion.getI32()).isBottom() || A_Type.Companion.typeIntersection(bType, IntegerRangeTypeDescriptor.Companion.getI32()).isBottom()) {
            return false;
        }
        L2Generator generator = translator.getGenerator();
        L2BasicBlock fallback = generator.createBasicBlock("fall back to boxed multiplication");
        L2ReadIntOperand intA = generator.readInt(new L2SemanticUnboxedInt(a.semanticValue()), fallback);
        L2ReadIntOperand intB = generator.readInt(new L2SemanticUnboxedInt(b.semanticValue()), fallback);
        if (generator.currentlyReachable()) {
            Collection<A_Type> collection2;
            L2Operand[] $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = argumentTypes;
            A_RawFunction a_RawFunction = rawFunction2;
            P_Multiplication p_Multiplication = this;
            boolean $i$f$map232 = false;
            void var18_20 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object t : $this$mapTo$iv$iv) {
                void it;
                A_Type a_Type = (A_Type)t;
                collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(A_Type.Companion.typeIntersection((A_Type)it, IntegerRangeTypeDescriptor.Companion.getI32()));
            }
            collection2 = (List)destination$iv$iv;
            A_Type returnTypeIfInts = p_Multiplication.returnTypeGuaranteedByVM(a_RawFunction, (List<? extends A_Type>)collection2);
            Object[] $i$f$map232 = new L2SemanticValue[]{a.semanticValue(), b.semanticValue()};
            L2SemanticPrimitiveInvocation semanticTemp = L2SemanticValue.Companion.primitiveInvocation(this, CollectionsKt.listOf((Object[])$i$f$map232));
            L2WriteIntOperand tempWriter = generator.intWrite(SetsKt.setOf((Object)new L2SemanticUnboxedInt(semanticTemp)), TypeRestriction.Companion.restrictionForType(returnTypeIfInts, TypeRestriction.RestrictionFlagEncoding.UNBOXED_INT_FLAG));
            if (A_Type.Companion.isSubtypeOf(returnTypeIfInts, IntegerRangeTypeDescriptor.Companion.getI32())) {
                $this$mapTo$iv$iv = new L2Operand[]{intA, intB, tempWriter};
                translator.addInstruction(L2_BIT_LOGIC_OP.Companion.getWrappedMultiply(), $this$mapTo$iv$iv);
            } else {
                L2BasicBlock success2 = generator.createBasicBlock("product is in range");
                L2Operand[] l2OperandArray = new L2Operand[]{intA, intB, tempWriter, L2Generator.Companion.edgeTo(fallback), L2Generator.Companion.edgeTo(success2)};
                translator.addInstruction(L2_MULTIPLY_INT_BY_INT.INSTANCE, l2OperandArray);
                L2Generator.startBlock$default(generator, success2, false, null, 6, null);
            }
            callSiteHelper.useAnswer(generator.readBoxed(semanticTemp));
        }
        if (!((Collection)fallback.predecessorEdges()).isEmpty()) {
            L2Generator.startBlock$default(generator, fallback, false, null, 6, null);
            translator.generateGeneralFunctionInvocation(functionToCallReg, arguments, false, callSiteHelper);
        }
        return true;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\r\u0010\n\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lavail/interpreter/primitive/numbers/P_Multiplication$BoundCalculator;", "", "aType", "Lavail/descriptor/types/A_Type;", "bType", "(Lavail/descriptor/types/A_Type;Lavail/descriptor/types/A_Type;)V", "includedInfinities", "", "Lavail/descriptor/numbers/A_Number;", "union", "process", "process$avail", "processPair", "", "a", "b", "Companion", "avail"})
    public static final class BoundCalculator {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final A_Type aType;
        @NotNull
        private final A_Type bType;
        @NotNull
        private A_Type union;
        @NotNull
        private final Set<A_Number> includedInfinities;
        @NotNull
        private static final List<A_Type> interestingRanges;

        public BoundCalculator(@NotNull A_Type aType, @NotNull A_Type bType) {
            Intrinsics.checkNotNullParameter((Object)aType, (String)"aType");
            Intrinsics.checkNotNullParameter((Object)bType, (String)"bType");
            this.aType = aType;
            this.bType = bType;
            this.union = BottomTypeDescriptor.Companion.getBottom();
            this.includedInfinities = new LinkedHashSet();
        }

        private final void processPair(A_Number a, A_Number b) {
            if (!(A_Number.Companion.equalsInt(a, 0) && !b.isFinite() || A_Number.Companion.equalsInt(b, 0) && !a.isFinite())) {
                A_Number product = A_Number.Companion.timesCanDestroy(a, b, false);
                product.makeImmutable();
                this.union = A_Type.Companion.typeUnion(this.union, IntegerRangeTypeDescriptor.Companion.inclusive(product, product));
                if (!product.isFinite() && a.isInstanceOf(this.aType) && b.isInstanceOf(this.bType)) {
                    this.includedInfinities.add(product);
                }
            }
        }

        @NotNull
        public final A_Type process$avail() {
            List aRanges = BoundCalculator.Companion.split(this.aType);
            List bRanges = BoundCalculator.Companion.split(this.bType);
            for (A_Type aRange : aRanges) {
                A_Number aMin = A_Type.Companion.getLowerBound(aRange);
                A_Number aMax = A_Type.Companion.getUpperBound(aRange);
                for (A_Type bRange : bRanges) {
                    A_Number bMin = A_Type.Companion.getLowerBound(bRange);
                    A_Number bMax = A_Type.Companion.getUpperBound(bRange);
                    this.processPair(aMin, bMin);
                    this.processPair(aMin, bMax);
                    this.processPair(aMax, bMin);
                    this.processPair(aMax, bMax);
                }
            }
            this.union = A_Type.Companion.typeIntersection(this.union, IntegerRangeTypeDescriptor.Companion.getIntegers());
            for (A_Number infinity : this.includedInfinities) {
                this.union = A_Type.Companion.typeUnion(this.union, IntegerRangeTypeDescriptor.Companion.inclusive(infinity, infinity));
            }
            return this.union;
        }

        static {
            Object[] objectArray = new A_Type[]{IntegerRangeTypeDescriptor.Companion.inclusive(InfinityDescriptor.Companion.getNegativeInfinity(), IntegerDescriptor.Companion.negativeOne()), IntegerRangeTypeDescriptor.Companion.inclusive(IntegerDescriptor.Companion.getZero(), IntegerDescriptor.Companion.getZero()), IntegerRangeTypeDescriptor.Companion.inclusive(IntegerDescriptor.Companion.getOne(), InfinityDescriptor.Companion.getPositiveInfinity())};
            interestingRanges = CollectionsKt.listOf((Object[])objectArray);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0007\u001a\u00020\u0005H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lavail/interpreter/primitive/numbers/P_Multiplication$BoundCalculator$Companion;", "", "()V", "interestingRanges", "", "Lavail/descriptor/types/A_Type;", "split", "type", "avail"})
        @SourceDebugExtension(value={"SMAP\nP_Multiplication.kt\nKotlin\n*S Kotlin\n*F\n+ 1 P_Multiplication.kt\navail/interpreter/primitive/numbers/P_Multiplication$BoundCalculator$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,367:1\n1549#2:368\n1620#2,3:369\n766#2:372\n857#2,2:373\n*S KotlinDebug\n*F\n+ 1 P_Multiplication.kt\navail/interpreter/primitive/numbers/P_Multiplication$BoundCalculator$Companion\n*L\n258#1:368\n258#1:369,3\n259#1:372\n259#1:373,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * WARNING - void declaration
             */
            private final List<A_Type> split(A_Type type) {
                void $this$filterTo$iv$iv;
                Iterable $this$mapTo$iv$iv;
                Iterable $this$map$iv = interestingRanges;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    A_Type a_Type = (A_Type)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    collection2.add(A_Type.Companion.typeIntersection(type, (A_Type)it));
                }
                Iterable $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    A_Type subrange = (A_Type)element$iv$iv;
                    boolean bl = false;
                    if (!(!subrange.isBottom())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

