/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.phrases;

import avail.descriptor.phrases.A_Phrase;
import avail.descriptor.phrases.FirstOfSequencePhraseDescriptor;
import avail.descriptor.phrases.PhraseDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.PhraseTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014\u00a8\u0006\n"}, d2={"Lavail/interpreter/primitive/phrases/P_CreateFirstOfSequenceOfStatements;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
public final class P_CreateFirstOfSequenceOfStatements
extends Primitive {
    @NotNull
    public static final P_CreateFirstOfSequenceOfStatements INSTANCE = new P_CreateFirstOfSequenceOfStatements();

    private P_CreateFirstOfSequenceOfStatements() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline};
        super(1, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(1);
        AvailObject statements = interpreter.argument(0);
        int statementsSize = A_Tuple.Companion.getTupleSize(statements);
        List flat = new ArrayList();
        int i2 = 2;
        if (i2 <= statementsSize) {
            while (true) {
                A_Phrase.Companion.flattenStatementsInto(A_Tuple.Companion.tupleAt(statements, i2), flat);
                if (i2 == statementsSize) break;
                ++i2;
            }
        }
        if (!PhraseDescriptor.Companion.containsOnlyStatements(flat, PrimitiveTypeDescriptor.Types.TOP.getO())) {
            return interpreter.primitiveFailure(AvailErrorCode.E_SEQUENCE_CONTAINS_INVALID_STATEMENTS);
        }
        flat.add(0, A_Tuple.Companion.tupleAt(statements, 1));
        return interpreter.primitiveSuccess(FirstOfSequencePhraseDescriptor.Companion.newFirstOfSequenceNode(statements));
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(TupleTypeDescriptor.Companion.zeroOrMoreOf(PhraseTypeDescriptor.PhraseKind.PARSE_PHRASE.getMostGeneralType())), PhraseTypeDescriptor.PhraseKind.FIRST_OF_SEQUENCE_PHRASE.getMostGeneralType(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_SEQUENCE_CONTAINS_INVALID_STATEMENTS};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }
}

