/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.style;

import avail.descriptor.atoms.A_Atom;
import avail.descriptor.character.CharacterDescriptor;
import avail.descriptor.fiber.A_Fiber;
import avail.descriptor.module.A_Module;
import avail.descriptor.phrases.A_Phrase;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tokens.A_Token;
import avail.descriptor.tokens.LiteralTokenDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.RepeatedElementTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.EnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.PhraseTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.AvailLoader;
import avail.interpreter.execution.Interpreter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014\u00a8\u0006\n"}, d2={"Lavail/interpreter/primitive/style/P_StyleSpanOfPhrase;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
@SourceDebugExtension(value={"SMAP\nP_StyleSpanOfPhrase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 P_StyleSpanOfPhrase.kt\navail/interpreter/primitive/style/P_StyleSpanOfPhrase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,139:1\n766#2:140\n857#2,2:141\n2333#2,14:143\n1963#2,14:157\n*S KotlinDebug\n*F\n+ 1 P_StyleSpanOfPhrase.kt\navail/interpreter/primitive/style/P_StyleSpanOfPhrase\n*L\n89#1:140\n89#1:141,2\n97#1:143,14\n99#1:157,14\n*E\n"})
public final class P_StyleSpanOfPhrase
extends Primitive {
    @NotNull
    public static final P_StyleSpanOfPhrase INSTANCE = new P_StyleSpanOfPhrase();

    private P_StyleSpanOfPhrase() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline, Primitive.Flag.WritesToHiddenGlobalState};
        super(3, flagArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        String styleOrNull;
        Object v2;
        void $this$maxByOrNull$iv;
        Object v1;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(3);
        A_Phrase phrase = interpreter.argument(0);
        A_String styleName = interpreter.argument(1);
        boolean overwrite = A_Atom.Companion.getExtractBoolean(interpreter.argument(2));
        A_Fiber fiber2 = interpreter.fiber();
        if (!A_Fiber.Companion.getCanStyle(fiber2)) {
            return interpreter.primitiveFailure(AvailErrorCode.E_CANNOT_STYLE);
        }
        AvailLoader availLoader = A_Fiber.Companion.getAvailLoader(fiber2);
        Intrinsics.checkNotNull((Object)availLoader);
        AvailLoader loader = availLoader;
        A_Module module = loader.getModule();
        Iterable $this$filter$iv = A_Phrase.Companion.getAllTokens(phrase);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AvailObject it = (AvailObject)element$iv$iv;
            boolean bl = false;
            if (!it.isInCurrentModule(module)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List allTokens2 = (List)destination$iv$iv;
        if (allTokens2.isEmpty()) {
            return interpreter.primitiveSuccess(NilDescriptor.Companion.getNil());
        }
        Iterable $this$minByOrNull$iv = allTokens2;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v1 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v1 = minElem$iv;
            } else {
                AvailObject it = (AvailObject)minElem$iv;
                boolean bl = false;
                int minValue$iv = it.start();
                do {
                    Object e$iv = iterator$iv.next();
                    AvailObject it2 = (AvailObject)e$iv;
                    $i$a$-minByOrNull-P_StyleSpanOfPhrase$attempt$firstToken$1 = false;
                    int v$iv = it2.start();
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v1 = minElem$iv;
            }
        }
        Intrinsics.checkNotNull(v1);
        AvailObject firstToken = v1;
        int start = firstToken.start();
        iterator$iv = allTokens2;
        A_Token.Companion companion = A_Token.Companion;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv2 = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv2.hasNext()) {
            v2 = null;
        } else {
            Object maxElem$iv = iterator$iv2.next();
            if (!iterator$iv2.hasNext()) {
                v2 = maxElem$iv;
            } else {
                AvailObject it = (AvailObject)maxElem$iv;
                boolean bl = false;
                int maxValue$iv = A_Token.Companion.pastEnd(it);
                do {
                    Object e$iv = iterator$iv2.next();
                    AvailObject it3 = (AvailObject)e$iv;
                    $i$a$-maxByOrNull-P_StyleSpanOfPhrase$attempt$pastEnd$1 = false;
                    int v$iv = A_Token.Companion.pastEnd(it3);
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv2.hasNext());
                v2 = maxElem$iv;
            }
        }
        Intrinsics.checkNotNull(v2);
        int pastEnd = companion.pastEnd(v2);
        if (start == pastEnd) {
            return interpreter.primitiveSuccess(NilDescriptor.Companion.getNil());
        }
        String string2 = styleOrNull = A_Tuple.Companion.getTupleSize(styleName) == 0 ? null : A_String.Companion.asNativeString(styleName);
        if (styleOrNull == null && !overwrite) {
            return interpreter.primitiveSuccess(NilDescriptor.Companion.getNil());
        }
        A_Tuple a_Tuple = RepeatedElementTupleDescriptor.Companion.createRepeatedElementTuple(pastEnd - start, CharacterDescriptor.Companion.fromCodePoint(63));
        Intrinsics.checkNotNull((Object)a_Tuple, (String)"null cannot be cast to non-null type avail.descriptor.tuples.A_String");
        AvailObject fakeToken = LiteralTokenDescriptor.Companion.literalToken$default(LiteralTokenDescriptor.Companion, (A_String)a_Tuple, start, firstToken.lineNumber(), NilDescriptor.Companion.getNil(), NilDescriptor.Companion.getNil(), null, 32, null);
        fakeToken.setCurrentModule(loader.getModule());
        AvailLoader.styleToken$default(loader, (A_Token)fakeToken, styleOrNull, overwrite, null, 8, null);
        return interpreter.primitiveSuccess(NilDescriptor.Companion.getNil());
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_CANNOT_STYLE};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(PhraseTypeDescriptor.PhraseKind.PARSE_PHRASE.getMostGeneralType(), TupleTypeDescriptor.Companion.getStringType(), EnumerationTypeDescriptor.Companion.getBooleanType()), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null);
    }
}

