/*
 * Decompiled with CFR 0.152.
 */
package avail.persistence.cache.record;

import avail.persistence.cache.record.NameInModule;
import avail.persistence.cache.record.NamesIndex;
import avail.utility.CodingKt;
import avail.utility.structures.BloomFilter;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0006%&'()*B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B+\b\u0016\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0012\u001a\u00020\u0013J\u001e\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0013J\u0014\u0010\u0018\u001a\u00020\u000f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\nJ\u001e\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001e\u001a\u00020\u0007J\u0010\u0010\u0005\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\b\u0010\u001f\u001a\u00020 H\u0016J\u0015\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020#H\u0000\u00a2\u0006\u0002\b$R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006+"}, d2={"Lavail/persistence/cache/record/NamesIndex;", "", "bytes", "", "([B)V", "occurrences", "", "Lavail/persistence/cache/record/NameInModule;", "Lavail/persistence/cache/record/NamesIndex$NameOccurrences;", "bloomFilterIfPackage", "Lavail/utility/structures/BloomFilter;", "(Ljava/util/Map;Lavail/utility/structures/BloomFilter;)V", "getOccurrences", "()Ljava/util/Map;", "addDeclaration", "", "nameInModule", "alias", "phraseIndex", "", "addDefinition", "definitionType", "Lavail/persistence/cache/record/NamesIndex$DefinitionType;", "manifestIndex", "addToFilter", "filter", "addUsage", "usageType", "Lavail/persistence/cache/record/NamesIndex$UsageType;", "findMentions", "nameToFind", "toString", "", "write", "binaryStream", "Ljava/io/DataOutputStream;", "write$avail", "Declaration", "Definition", "DefinitionType", "NameOccurrences", "Usage", "UsageType", "avail"})
@SourceDebugExtension(value={"SMAP\nNamesIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NamesIndex.kt\navail/persistence/cache/record/NamesIndex\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,626:1\n1855#2,2:627\n1360#2:629\n1446#2,5:630\n1603#2,9:635\n1855#2:644\n1856#2:646\n1612#2:647\n1549#2:648\n1620#2,3:649\n1855#2,2:652\n1179#2,2:654\n1253#2,4:656\n1549#2:660\n1620#2,3:661\n1855#2,2:664\n1179#2,2:666\n1253#2,4:668\n1045#2:672\n1855#2,2:673\n1#3:645\n1#3:675\n*S KotlinDebug\n*F\n+ 1 NamesIndex.kt\navail/persistence/cache/record/NamesIndex\n*L\n488#1:627,2\n524#1:629\n524#1:630,5\n525#1:635,9\n525#1:644\n525#1:646\n525#1:647\n528#1:648\n528#1:649,3\n531#1:652,2\n533#1:654,2\n533#1:656,4\n536#1:660\n536#1:661,3\n539#1:664,2\n541#1:666,2\n541#1:668,4\n545#1:672\n545#1:673,2\n525#1:645\n*E\n"})
public final class NamesIndex {
    @NotNull
    private final Map<NameInModule, NameOccurrences> occurrences;
    @Nullable
    private BloomFilter<NameInModule> bloomFilterIfPackage;

    @NotNull
    public final Map<NameInModule, NameOccurrences> getOccurrences() {
        return this.occurrences;
    }

    private final NameOccurrences occurrences(NameInModule nameInModule) {
        NameOccurrences nameOccurrences = this.occurrences.computeIfAbsent(nameInModule, arg_0 -> NamesIndex.occurrences$lambda$0(occurrences.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)nameOccurrences, (String)"computeIfAbsent(...)");
        return nameOccurrences;
    }

    public final void addDeclaration(@NotNull NameInModule nameInModule, @Nullable NameInModule alias, int phraseIndex) {
        Intrinsics.checkNotNullParameter((Object)nameInModule, (String)"nameInModule");
        this.occurrences(nameInModule).getDeclarations().add(new Declaration(alias, phraseIndex));
    }

    public final void addDefinition(@NotNull NameInModule nameInModule, @NotNull DefinitionType definitionType, int manifestIndex) {
        Intrinsics.checkNotNullParameter((Object)nameInModule, (String)"nameInModule");
        Intrinsics.checkNotNullParameter((Object)((Object)definitionType), (String)"definitionType");
        this.occurrences(nameInModule).getDefinitions().add(new Definition(definitionType, manifestIndex));
    }

    public final void addUsage(@NotNull NameInModule nameInModule, @NotNull UsageType usageType, int phraseIndex) {
        Intrinsics.checkNotNullParameter((Object)nameInModule, (String)"nameInModule");
        Intrinsics.checkNotNullParameter((Object)((Object)usageType), (String)"usageType");
        this.occurrences(nameInModule).getUsages().add(new Usage(usageType, phraseIndex));
    }

    public final void addToFilter(@NotNull BloomFilter<NameInModule> filter2) {
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        BloomFilter<NameInModule> bloomFilter = this.bloomFilterIfPackage;
        if (bloomFilter != null) {
            BloomFilter<NameInModule> thisFilter = bloomFilter;
            boolean bl = false;
            filter2.addAll(thisFilter);
            return;
        }
        Iterable $this$forEach$iv = this.occurrences.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NameInModule p0 = (NameInModule)element$iv;
            boolean bl = false;
            filter2.add(p0);
        }
    }

    @Nullable
    public final NameOccurrences findMentions(@NotNull NameInModule nameToFind) {
        Intrinsics.checkNotNullParameter((Object)nameToFind, (String)"nameToFind");
        return this.occurrences.get(nameToFind);
    }

    /*
     * WARNING - void declaration
     */
    public final void write$avail(@NotNull DataOutputStream binaryStream) throws IOException {
        block9: {
            void $this$forEach$iv;
            void $this$associateTo$iv$iv;
            void $this$associate$iv;
            Iterator $this$mapTo$iv$iv;
            Iterable $this$associateTo$iv$iv2;
            void $this$associate$iv2;
            Iterator $this$mapTo$iv$iv2;
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Object list$iv$iv;
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv;
            Intrinsics.checkNotNullParameter((Object)binaryStream, (String)"binaryStream");
            Set fullNames = new LinkedHashSet();
            fullNames.addAll((Collection)this.occurrences.keySet());
            Iterable iterable = this.occurrences.values();
            Object object = fullNames;
            boolean $i$f$flatMap = false;
            void var5_7 = $this$flatMap$iv;
            Iterable<NameInModule> destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                NameOccurrences p0 = (NameOccurrences)element$iv$iv;
                boolean bl = false;
                list$iv$iv = p0.getDeclarations();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$flatMapTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach22 = false;
            list$iv$iv = $this$forEach$iv$iv$iv.iterator();
            while (list$iv$iv.hasNext()) {
                NameInModule it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = list$iv$iv.next();
                boolean bl = false;
                Declaration p0 = (Declaration)element$iv$iv;
                boolean bl2 = false;
                if (p0.getAlias() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            object.addAll((List)destination$iv$iv);
            Iterable $this$map$iv = fullNames;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator $i$f$forEach22 = $this$mapTo$iv$iv2.iterator();
            while ($i$f$forEach22.hasNext()) {
                void p02;
                Object item$iv$iv = $i$f$forEach22.next();
                NameInModule element$iv$iv$iv = (NameInModule)item$iv$iv;
                object = destination$iv$iv2;
                boolean bl = false;
                object.add(p02.getModuleName());
            }
            SortedSet moduleNames = CollectionsKt.toSortedSet((Iterable)((List)destination$iv$iv2));
            CodingKt.vlq(binaryStream, moduleNames.size());
            Iterable $this$forEach$iv2 = moduleNames;
            boolean $i$f$forEach32 = false;
            for (Object element$iv : $this$forEach$iv2) {
                String p0 = (String)element$iv;
                boolean bl = false;
                CodingKt.sizedString(binaryStream, p0);
            }
            Iterable $i$f$forEach32 = CollectionsKt.withIndex((Iterable)moduleNames);
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv2, (int)10)), (int)16);
            void p0 = $this$associate$iv2;
            Object destination$iv$iv3 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv2) {
                Map bl = destination$iv$iv3;
                IndexedValue it = (IndexedValue)element$iv$iv;
                boolean bl4 = false;
                it = TuplesKt.to((Object)it.getValue(), (Object)it.getIndex());
                bl.put(it.getFirst(), it.getSecond());
            }
            Map moduleNumbering = destination$iv$iv3;
            Iterable $this$map$iv2 = fullNames;
            boolean $i$f$map2 = false;
            $this$associateTo$iv$iv2 = $this$map$iv2;
            destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            Iterator p02 = $this$mapTo$iv$iv.iterator();
            while (p02.hasNext()) {
                void p03;
                Object item$iv$iv = p02.next();
                NameInModule bl = (NameInModule)item$iv$iv;
                object = destination$iv$iv3;
                boolean bl5 = false;
                object.add(p03.getAtomName());
            }
            SortedSet sortedNames = CollectionsKt.toSortedSet((Iterable)((List)destination$iv$iv3));
            CodingKt.vlq(binaryStream, sortedNames.size());
            Iterable $this$forEach$iv3 = sortedNames;
            boolean $i$f$forEach42 = false;
            for (Object element$iv : $this$forEach$iv3) {
                String p04 = (String)element$iv;
                boolean bl = false;
                CodingKt.sizedString(binaryStream, p04);
            }
            Iterable $i$f$forEach42 = CollectionsKt.withIndex((Iterable)sortedNames);
            boolean $i$f$associate2 = false;
            int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            void p04 = $this$associate$iv;
            Map destination$iv$iv4 = new LinkedHashMap(capacity$iv2);
            boolean $i$f$associateTo2 = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv4;
                IndexedValue it = (IndexedValue)element$iv$iv;
                boolean bl = false;
                Pair pair = TuplesKt.to((Object)it.getValue(), (Object)it.getIndex());
                map.put(pair.getFirst(), pair.getSecond());
            }
            Map nameNumbering = destination$iv$iv4;
            CodingKt.vlq(binaryStream, this.occurrences.size());
            Iterable $this$sortedBy$iv = this.occurrences.entrySet();
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Map.Entry it = (Map.Entry)a;
                    boolean bl = false;
                    Comparable comparable = (NameInModule)it.getKey();
                    it = (Map.Entry)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((NameInModule)it.getKey()));
                }
            });
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry entry = (Map.Entry)element$iv;
                boolean bl = false;
                NameInModule key = (NameInModule)entry.getKey();
                NameOccurrences occurrences2 = (NameOccurrences)entry.getValue();
                key.write(binaryStream, moduleNumbering, nameNumbering);
                occurrences2.write(binaryStream, moduleNumbering, nameNumbering);
            }
            binaryStream.writeBoolean(this.bloomFilterIfPackage != null);
            BloomFilter<NameInModule> bloomFilter = this.bloomFilterIfPackage;
            if (bloomFilter == null) break block9;
            BloomFilter<NameInModule> $this$write_u24lambda_u2412 = bloomFilter;
            boolean bl = false;
            $this$write_u24lambda_u2412.write(binaryStream);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        int n;
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u2415 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u2415.append("NamesIndex (");
        Iterable iterable = this.occurrences.values();
        StringBuilder stringBuilder2 = $this$toString_u24lambda_u2415;
        int n2 = 0;
        for (Object t : iterable) {
            void it;
            NameOccurrences nameOccurrences = (NameOccurrences)t;
            n = n2;
            boolean bl2 = false;
            int n3 = it.getDefinitions().size();
            n2 = n + n3;
        }
        n = n2;
        stringBuilder2.append(n);
        $this$toString_u24lambda_u2415.append(" defs");
        BloomFilter<NameInModule> bloomFilter = this.bloomFilterIfPackage;
        if (bloomFilter != null) {
            BloomFilter<NameInModule> $this$toString_u24lambda_u2415_u24lambda_u2414 = bloomFilter;
            boolean bl3 = false;
            $this$toString_u24lambda_u2415.append(", Bloom=");
            $this$toString_u24lambda_u2415.append($this$toString_u24lambda_u2415_u24lambda_u2414.getBitCount());
        }
        $this$toString_u24lambda_u2415.append(")");
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    public NamesIndex(@NotNull byte[] bytes2) throws IOException {
        BloomFilter bloomFilter;
        int n;
        ArrayList<String> arrayList;
        int n2;
        Intrinsics.checkNotNullParameter((Object)bytes2, (String)"bytes");
        DataInputStream binaryStream = new DataInputStream(new ByteArrayInputStream(bytes2));
        int n3 = CodingKt.unvlqInt(binaryStream);
        ArrayList<String> arrayList2 = new ArrayList<String>(n3);
        int n4 = 0;
        while (n4 < n3) {
            int n5 = n2 = n4++;
            arrayList = arrayList2;
            n = 0;
            arrayList.add(CodingKt.decodeString(binaryStream));
        }
        List moduleNames = arrayList2;
        int n6 = CodingKt.unvlqInt(binaryStream);
        ArrayList arrayList3 = new ArrayList(n6);
        n2 = 0;
        while (n2 < n6) {
            int it;
            n = it = n2++;
            arrayList = arrayList3;
            boolean bl = false;
            arrayList.add(CodingKt.decodeString(binaryStream));
        }
        List atomNames = arrayList3;
        this.occurrences = new LinkedHashMap();
        n6 = CodingKt.unvlqInt(binaryStream);
        int n7 = 0;
        while (n7 < n6) {
            int it = n7++;
            boolean bl = false;
            this.occurrences.put(new NameInModule(binaryStream, moduleNames, atomNames), new NameOccurrences(binaryStream, moduleNames, atomNames));
        }
        n6 = binaryStream.readBoolean() ? 1 : 0;
        if (n6 == 1) {
            bloomFilter = new BloomFilter(binaryStream);
        } else if (n6 == 0) {
            bloomFilter = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.bloomFilterIfPackage = bloomFilter;
    }

    public NamesIndex(@NotNull Map<NameInModule, NameOccurrences> occurrences2, @Nullable BloomFilter<NameInModule> bloomFilterIfPackage) {
        Intrinsics.checkNotNullParameter(occurrences2, (String)"occurrences");
        this.occurrences = occurrences2;
        this.bloomFilterIfPackage = bloomFilterIfPackage;
    }

    private static final NameOccurrences occurrences$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (NameOccurrences)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\bB\u0017\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u000b\u0010\u0012\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\t\u0010\u0013\u001a\u00020\fH\u00c6\u0003J\u001f\u0010\u0014\u001a\u00020\u00002\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\fH\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0006H\u00d6\u0001J6\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0002\u001a\u00020\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u001e2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u001eR\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006 "}, d2={"Lavail/persistence/cache/record/NamesIndex$Declaration;", "", "binaryStream", "Ljava/io/DataInputStream;", "moduleNames", "", "", "atomNames", "(Ljava/io/DataInputStream;Ljava/util/List;Ljava/util/List;)V", "alias", "Lavail/persistence/cache/record/NameInModule;", "phraseIndex", "", "(Lavail/persistence/cache/record/NameInModule;I)V", "getAlias", "()Lavail/persistence/cache/record/NameInModule;", "getPhraseIndex", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "write", "", "Ljava/io/DataOutputStream;", "moduleNumbering", "", "nameNumbering", "avail"})
    @SourceDebugExtension(value={"SMAP\nNamesIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NamesIndex.kt\navail/persistence/cache/record/NamesIndex$Declaration\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,626:1\n1#2:627\n*E\n"})
    public static final class Declaration {
        @Nullable
        private final NameInModule alias;
        private final int phraseIndex;

        public Declaration(@Nullable NameInModule alias, int phraseIndex) {
            this.alias = alias;
            this.phraseIndex = phraseIndex;
        }

        @Nullable
        public final NameInModule getAlias() {
            return this.alias;
        }

        public final int getPhraseIndex() {
            return this.phraseIndex;
        }

        public final void write(@NotNull DataOutputStream binaryStream, @NotNull Map<String, Integer> moduleNumbering, @NotNull Map<String, Integer> nameNumbering) {
            Intrinsics.checkNotNullParameter((Object)binaryStream, (String)"binaryStream");
            Intrinsics.checkNotNullParameter(moduleNumbering, (String)"moduleNumbering");
            Intrinsics.checkNotNullParameter(nameNumbering, (String)"nameNumbering");
            binaryStream.writeBoolean(this.alias != null);
            NameInModule nameInModule = this.alias;
            if (nameInModule != null) {
                NameInModule $this$write_u24lambda_u240 = nameInModule;
                boolean bl = false;
                $this$write_u24lambda_u240.write(binaryStream, moduleNumbering, nameNumbering);
            }
            CodingKt.vlq(binaryStream, this.phraseIndex);
        }

        public Declaration(@NotNull DataInputStream binaryStream, @NotNull List<String> moduleNames, @NotNull List<String> atomNames) {
            NameInModule nameInModule;
            Intrinsics.checkNotNullParameter((Object)binaryStream, (String)"binaryStream");
            Intrinsics.checkNotNullParameter(moduleNames, (String)"moduleNames");
            Intrinsics.checkNotNullParameter(atomNames, (String)"atomNames");
            boolean bl = binaryStream.readBoolean();
            if (bl) {
                nameInModule = new NameInModule(binaryStream, moduleNames, atomNames);
            } else if (!bl) {
                nameInModule = null;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            this(nameInModule, CodingKt.unvlqInt(binaryStream));
        }

        @Nullable
        public final NameInModule component1() {
            return this.alias;
        }

        public final int component2() {
            return this.phraseIndex;
        }

        @NotNull
        public final Declaration copy(@Nullable NameInModule alias, int phraseIndex) {
            return new Declaration(alias, phraseIndex);
        }

        public static /* synthetic */ Declaration copy$default(Declaration declaration2, NameInModule nameInModule, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                nameInModule = declaration2.alias;
            }
            if ((n2 & 2) != 0) {
                n = declaration2.phraseIndex;
            }
            return declaration2.copy(nameInModule, n);
        }

        @NotNull
        public String toString() {
            return "Declaration(alias=" + this.alias + ", phraseIndex=" + this.phraseIndex + ")";
        }

        public int hashCode() {
            int result2 = this.alias == null ? 0 : this.alias.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.phraseIndex);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Declaration)) {
                return false;
            }
            Declaration declaration2 = (Declaration)other;
            if (!Intrinsics.areEqual((Object)this.alias, (Object)declaration2.alias)) {
                return false;
            }
            return this.phraseIndex == declaration2.phraseIndex;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\bH\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\bH\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u0019R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Lavail/persistence/cache/record/NamesIndex$Definition;", "", "binaryStream", "Ljava/io/DataInputStream;", "(Ljava/io/DataInputStream;)V", "definitionType", "Lavail/persistence/cache/record/NamesIndex$DefinitionType;", "manifestIndex", "", "(Lavail/persistence/cache/record/NamesIndex$DefinitionType;I)V", "getDefinitionType", "()Lavail/persistence/cache/record/NamesIndex$DefinitionType;", "getManifestIndex", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "write", "", "Ljava/io/DataOutputStream;", "avail"})
    public static final class Definition {
        @NotNull
        private final DefinitionType definitionType;
        private final int manifestIndex;

        public Definition(@NotNull DefinitionType definitionType, int manifestIndex) {
            Intrinsics.checkNotNullParameter((Object)((Object)definitionType), (String)"definitionType");
            this.definitionType = definitionType;
            this.manifestIndex = manifestIndex;
        }

        @NotNull
        public final DefinitionType getDefinitionType() {
            return this.definitionType;
        }

        public final int getManifestIndex() {
            return this.manifestIndex;
        }

        public final void write(@NotNull DataOutputStream binaryStream) {
            Intrinsics.checkNotNullParameter((Object)binaryStream, (String)"binaryStream");
            CodingKt.vlq(binaryStream, this.definitionType.ordinal());
            CodingKt.vlq(binaryStream, this.manifestIndex);
        }

        public Definition(@NotNull DataInputStream binaryStream) {
            Intrinsics.checkNotNullParameter((Object)binaryStream, (String)"binaryStream");
            this(DefinitionType.Companion.getAll()[CodingKt.unvlqInt(binaryStream)], CodingKt.unvlqInt(binaryStream));
        }

        @NotNull
        public final DefinitionType component1() {
            return this.definitionType;
        }

        public final int component2() {
            return this.manifestIndex;
        }

        @NotNull
        public final Definition copy(@NotNull DefinitionType definitionType, int manifestIndex) {
            Intrinsics.checkNotNullParameter((Object)((Object)definitionType), (String)"definitionType");
            return new Definition(definitionType, manifestIndex);
        }

        public static /* synthetic */ Definition copy$default(Definition definition, DefinitionType definitionType, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                definitionType = definition.definitionType;
            }
            if ((n2 & 2) != 0) {
                n = definition.manifestIndex;
            }
            return definition.copy(definitionType, n);
        }

        @NotNull
        public String toString() {
            return "Definition(definitionType=" + this.definitionType + ", manifestIndex=" + this.manifestIndex + ")";
        }

        public int hashCode() {
            int result2 = this.definitionType.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.manifestIndex);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Definition)) {
                return false;
            }
            Definition definition = (Definition)other;
            if (this.definitionType != definition.definitionType) {
                return false;
            }
            return this.manifestIndex == definition.manifestIndex;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u0000 \t2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\n"}, d2={"Lavail/persistence/cache/record/NamesIndex$DefinitionType;", "", "(Ljava/lang/String;I)V", "Method", "Macro", "SemanticRestriction", "GrammaticalRestriction", "Lexer", "Seal", "Companion", "avail"})
    @SourceDebugExtension(value={"SMAP\nNamesIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NamesIndex.kt\navail/persistence/cache/record/NamesIndex$DefinitionType\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,626:1\n37#2,2:627\n*S KotlinDebug\n*F\n+ 1 NamesIndex.kt\navail/persistence/cache/record/NamesIndex$DefinitionType\n*L\n295#1:627,2\n*E\n"})
    public static final class DefinitionType
    extends Enum<DefinitionType> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private static final DefinitionType[] all;
        public static final /* enum */ DefinitionType Method;
        public static final /* enum */ DefinitionType Macro;
        public static final /* enum */ DefinitionType SemanticRestriction;
        public static final /* enum */ DefinitionType GrammaticalRestriction;
        public static final /* enum */ DefinitionType Lexer;
        public static final /* enum */ DefinitionType Seal;
        private static final /* synthetic */ DefinitionType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static DefinitionType[] values() {
            return (DefinitionType[])$VALUES.clone();
        }

        public static DefinitionType valueOf(String value) {
            return Enum.valueOf(DefinitionType.class, value);
        }

        @NotNull
        public static EnumEntries<DefinitionType> getEntries() {
            return $ENTRIES;
        }

        static {
            Method = new DefinitionType();
            Macro = new DefinitionType();
            SemanticRestriction = new DefinitionType();
            GrammaticalRestriction = new DefinitionType();
            Lexer = new DefinitionType();
            Seal = new DefinitionType();
            $VALUES = definitionTypeArray = new DefinitionType[]{DefinitionType.Method, DefinitionType.Macro, DefinitionType.SemanticRestriction, DefinitionType.GrammaticalRestriction, DefinitionType.Lexer, DefinitionType.Seal};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            Collection $this$toTypedArray$iv = (Collection)DefinitionType.getEntries();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            all = thisCollection$iv.toArray(new DefinitionType[0]);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lavail/persistence/cache/record/NamesIndex$DefinitionType$Companion;", "", "()V", "all", "", "Lavail/persistence/cache/record/NamesIndex$DefinitionType;", "getAll", "()[Lavail/persistence/cache/record/NamesIndex$DefinitionType;", "[Lavail/persistence/cache/record/NamesIndex$DefinitionType;", "avail"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final DefinitionType[] getAll() {
                return all;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\bB/\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\n\u00a2\u0006\u0002\u0010\u0010J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\nH\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\nH\u00c6\u0003J9\u0010\u0018\u001a\u00020\u00002\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n2\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\nH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0006H\u00d6\u0001J6\u0010\u001f\u001a\u00020 2\u0006\u0010\u0002\u001a\u00020!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001d0#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001d0#R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006%"}, d2={"Lavail/persistence/cache/record/NamesIndex$NameOccurrences;", "", "binaryStream", "Ljava/io/DataInputStream;", "moduleNames", "", "", "atomNames", "(Ljava/io/DataInputStream;Ljava/util/List;Ljava/util/List;)V", "declarations", "", "Lavail/persistence/cache/record/NamesIndex$Declaration;", "definitions", "Lavail/persistence/cache/record/NamesIndex$Definition;", "usages", "Lavail/persistence/cache/record/NamesIndex$Usage;", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getDeclarations", "()Ljava/util/List;", "getDefinitions", "getUsages", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "write", "", "Ljava/io/DataOutputStream;", "moduleNumbering", "", "nameNumbering", "avail"})
    @SourceDebugExtension(value={"SMAP\nNamesIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NamesIndex.kt\navail/persistence/cache/record/NamesIndex$NameOccurrences\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,626:1\n1855#2,2:627\n1855#2,2:629\n1855#2,2:631\n*S KotlinDebug\n*F\n+ 1 NamesIndex.kt\navail/persistence/cache/record/NamesIndex$NameOccurrences\n*L\n114#1:627,2\n118#1:629,2\n122#1:631,2\n*E\n"})
    public static final class NameOccurrences {
        @NotNull
        private final List<Declaration> declarations;
        @NotNull
        private final List<Definition> definitions;
        @NotNull
        private final List<Usage> usages;

        public NameOccurrences(@NotNull List<Declaration> declarations, @NotNull List<Definition> definitions, @NotNull List<Usage> usages) {
            Intrinsics.checkNotNullParameter(declarations, (String)"declarations");
            Intrinsics.checkNotNullParameter(definitions, (String)"definitions");
            Intrinsics.checkNotNullParameter(usages, (String)"usages");
            this.declarations = declarations;
            this.definitions = definitions;
            this.usages = usages;
        }

        @NotNull
        public final List<Declaration> getDeclarations() {
            return this.declarations;
        }

        @NotNull
        public final List<Definition> getDefinitions() {
            return this.definitions;
        }

        @NotNull
        public final List<Usage> getUsages() {
            return this.usages;
        }

        public final void write(@NotNull DataOutputStream binaryStream, @NotNull Map<String, Integer> moduleNumbering, @NotNull Map<String, Integer> nameNumbering) {
            Intrinsics.checkNotNullParameter((Object)binaryStream, (String)"binaryStream");
            Intrinsics.checkNotNullParameter(moduleNumbering, (String)"moduleNumbering");
            Intrinsics.checkNotNullParameter(nameNumbering, (String)"nameNumbering");
            CodingKt.vlq(binaryStream, this.declarations.size());
            Iterable $this$forEach$iv = this.declarations;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Declaration decl = (Declaration)element$iv;
                boolean bl = false;
                decl.write(binaryStream, moduleNumbering, nameNumbering);
            }
            CodingKt.vlq(binaryStream, this.definitions.size());
            $this$forEach$iv = this.definitions;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Definition def = (Definition)element$iv;
                boolean bl = false;
                def.write(binaryStream);
            }
            CodingKt.vlq(binaryStream, this.usages.size());
            $this$forEach$iv = this.usages;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Usage usage = (Usage)element$iv;
                boolean bl = false;
                usage.write(binaryStream);
            }
        }

        public NameOccurrences(@NotNull DataInputStream binaryStream, @NotNull List<String> moduleNames, @NotNull List<String> atomNames) {
            ArrayList<Definition> arrayList;
            ArrayList<Definition> arrayList2;
            int it;
            List<Declaration> list2;
            int n;
            Intrinsics.checkNotNullParameter((Object)binaryStream, (String)"binaryStream");
            Intrinsics.checkNotNullParameter(moduleNames, (String)"moduleNames");
            Intrinsics.checkNotNullParameter(atomNames, (String)"atomNames");
            int n2 = CodingKt.unvlqInt(binaryStream);
            NameOccurrences nameOccurrences = this;
            ArrayList<Definition> arrayList3 = new ArrayList<Definition>(n2);
            int n3 = 0;
            while (n3 < n2) {
                int n4 = n = n3++;
                list2 = arrayList3;
                boolean bl = false;
                ((ArrayList)list2).add(new Declaration(binaryStream, moduleNames, atomNames));
            }
            n2 = CodingKt.unvlqInt(binaryStream);
            list2 = arrayList3;
            arrayList3 = new ArrayList(n2);
            n3 = 0;
            while (n3 < n2) {
                it = n = n3++;
                arrayList2 = arrayList3;
                boolean bl = false;
                arrayList2.add(new Definition(binaryStream));
            }
            arrayList2 = arrayList3;
            n2 = CodingKt.unvlqInt(binaryStream);
            arrayList3 = new ArrayList(n2);
            n3 = 0;
            while (n3 < n2) {
                it = n = n3++;
                arrayList = arrayList3;
                boolean bl = false;
                arrayList.add((Definition)((Object)new Usage(binaryStream)));
            }
            arrayList = arrayList3;
            nameOccurrences(list2, arrayList2, arrayList);
        }

        @NotNull
        public final List<Declaration> component1() {
            return this.declarations;
        }

        @NotNull
        public final List<Definition> component2() {
            return this.definitions;
        }

        @NotNull
        public final List<Usage> component3() {
            return this.usages;
        }

        @NotNull
        public final NameOccurrences copy(@NotNull List<Declaration> declarations, @NotNull List<Definition> definitions, @NotNull List<Usage> usages) {
            Intrinsics.checkNotNullParameter(declarations, (String)"declarations");
            Intrinsics.checkNotNullParameter(definitions, (String)"definitions");
            Intrinsics.checkNotNullParameter(usages, (String)"usages");
            return new NameOccurrences(declarations, definitions, usages);
        }

        public static /* synthetic */ NameOccurrences copy$default(NameOccurrences nameOccurrences, List list2, List list3, List list4, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = nameOccurrences.declarations;
            }
            if ((n & 2) != 0) {
                list3 = nameOccurrences.definitions;
            }
            if ((n & 4) != 0) {
                list4 = nameOccurrences.usages;
            }
            return nameOccurrences.copy(list2, list3, list4);
        }

        @NotNull
        public String toString() {
            return "NameOccurrences(declarations=" + this.declarations + ", definitions=" + this.definitions + ", usages=" + this.usages + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.declarations).hashCode();
            result2 = result2 * 31 + ((Object)this.definitions).hashCode();
            result2 = result2 * 31 + ((Object)this.usages).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NameOccurrences)) {
                return false;
            }
            NameOccurrences nameOccurrences = (NameOccurrences)other;
            if (!Intrinsics.areEqual(this.declarations, nameOccurrences.declarations)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.definitions, nameOccurrences.definitions)) {
                return false;
            }
            return Intrinsics.areEqual(this.usages, nameOccurrences.usages);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\bH\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\bH\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u0019R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Lavail/persistence/cache/record/NamesIndex$Usage;", "", "binaryStream", "Ljava/io/DataInputStream;", "(Ljava/io/DataInputStream;)V", "usageType", "Lavail/persistence/cache/record/NamesIndex$UsageType;", "phraseIndex", "", "(Lavail/persistence/cache/record/NamesIndex$UsageType;I)V", "getPhraseIndex", "()I", "getUsageType", "()Lavail/persistence/cache/record/NamesIndex$UsageType;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "write", "", "Ljava/io/DataOutputStream;", "avail"})
    public static final class Usage {
        @NotNull
        private final UsageType usageType;
        private final int phraseIndex;

        public Usage(@NotNull UsageType usageType, int phraseIndex) {
            Intrinsics.checkNotNullParameter((Object)((Object)usageType), (String)"usageType");
            this.usageType = usageType;
            this.phraseIndex = phraseIndex;
        }

        @NotNull
        public final UsageType getUsageType() {
            return this.usageType;
        }

        public final int getPhraseIndex() {
            return this.phraseIndex;
        }

        public final void write(@NotNull DataOutputStream binaryStream) {
            Intrinsics.checkNotNullParameter((Object)binaryStream, (String)"binaryStream");
            CodingKt.vlq(binaryStream, this.usageType.ordinal());
            CodingKt.vlq(binaryStream, this.phraseIndex);
        }

        public Usage(@NotNull DataInputStream binaryStream) {
            Intrinsics.checkNotNullParameter((Object)binaryStream, (String)"binaryStream");
            this(UsageType.Companion.getAll()[CodingKt.unvlqInt(binaryStream)], CodingKt.unvlqInt(binaryStream));
        }

        @NotNull
        public final UsageType component1() {
            return this.usageType;
        }

        public final int component2() {
            return this.phraseIndex;
        }

        @NotNull
        public final Usage copy(@NotNull UsageType usageType, int phraseIndex) {
            Intrinsics.checkNotNullParameter((Object)((Object)usageType), (String)"usageType");
            return new Usage(usageType, phraseIndex);
        }

        public static /* synthetic */ Usage copy$default(Usage usage, UsageType usageType, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                usageType = usage.usageType;
            }
            if ((n2 & 2) != 0) {
                n = usage.phraseIndex;
            }
            return usage.copy(usageType, n);
        }

        @NotNull
        public String toString() {
            return "Usage(usageType=" + this.usageType + ", phraseIndex=" + this.phraseIndex + ")";
        }

        public int hashCode() {
            int result2 = this.usageType.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.phraseIndex);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Usage)) {
                return false;
            }
            Usage usage = (Usage)other;
            if (this.usageType != usage.usageType) {
                return false;
            }
            return this.phraseIndex == usage.phraseIndex;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\b\u0086\u0081\u0002\u0018\u0000 \u000f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000fB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007j\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u0010"}, d2={"Lavail/persistence/cache/record/NamesIndex$UsageType;", "", "toolTipText", "", "iconFileName", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "getIconFileName", "()Ljava/lang/String;", "getToolTipText", "MethodSend", "MacroSend", "DefinedInHeader", "ImportedInHeader", "CreationInBody", "ReferenceInBody", "Companion", "avail"})
    @SourceDebugExtension(value={"SMAP\nNamesIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NamesIndex.kt\navail/persistence/cache/record/NamesIndex$UsageType\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,626:1\n37#2,2:627\n*S KotlinDebug\n*F\n+ 1 NamesIndex.kt\navail/persistence/cache/record/NamesIndex$UsageType\n*L\n394#1:627,2\n*E\n"})
    public static final class UsageType
    extends Enum<UsageType> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String toolTipText;
        @NotNull
        private final String iconFileName;
        @NotNull
        private static final UsageType[] all;
        public static final /* enum */ UsageType MethodSend;
        public static final /* enum */ UsageType MacroSend;
        public static final /* enum */ UsageType DefinedInHeader;
        public static final /* enum */ UsageType ImportedInHeader;
        public static final /* enum */ UsageType CreationInBody;
        public static final /* enum */ UsageType ReferenceInBody;
        private static final /* synthetic */ UsageType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private UsageType(String toolTipText, String iconFileName) {
            this.toolTipText = toolTipText;
            this.iconFileName = iconFileName;
        }

        @NotNull
        public final String getToolTipText() {
            return this.toolTipText;
        }

        @NotNull
        public final String getIconFileName() {
            return this.iconFileName;
        }

        public static UsageType[] values() {
            return (UsageType[])$VALUES.clone();
        }

        public static UsageType valueOf(String value) {
            return Enum.valueOf(UsageType.class, value);
        }

        @NotNull
        public static EnumEntries<UsageType> getEntries() {
            return $ENTRIES;
        }

        static {
            MethodSend = new UsageType("Method Send", "Name-Send-Method-Dark.png");
            MacroSend = new UsageType("Macro Send", "Name-Send-Macro-Dark.png");
            DefinedInHeader = new UsageType("Defined in Header", "Name-Creation-Header-Both.png");
            ImportedInHeader = new UsageType("Imported in Header", "Name-Mention-Header-Both.png");
            CreationInBody = new UsageType("Creation in Body", "Name-Creation-Body-Dark.png");
            ReferenceInBody = new UsageType("Reference in Body", "Name-Mention-Body-Dark.png");
            $VALUES = usageTypeArray = new UsageType[]{UsageType.MethodSend, UsageType.MacroSend, UsageType.DefinedInHeader, UsageType.ImportedInHeader, UsageType.CreationInBody, UsageType.ReferenceInBody};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            Collection $this$toTypedArray$iv = (Collection)UsageType.getEntries();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            all = thisCollection$iv.toArray(new UsageType[0]);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lavail/persistence/cache/record/NamesIndex$UsageType$Companion;", "", "()V", "all", "", "Lavail/persistence/cache/record/NamesIndex$UsageType;", "getAll", "()[Lavail/persistence/cache/record/NamesIndex$UsageType;", "[Lavail/persistence/cache/record/NamesIndex$UsageType;", "avail"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final UsageType[] getAll() {
                return all;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

