/*
 * Decompiled with CFR 0.152.
 */
package avail.persistence.cache.record;

import avail.compiler.splitter.MessageSplitter;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.StringDescriptor;
import avail.persistence.cache.record.NameInModule;
import avail.persistence.cache.record.NamesIndex;
import avail.persistence.cache.record.PhrasePathRecord;
import avail.utility.CodingKt;
import avail.utility.CollectionExtensionsKt;
import avail.utility.Mutable;
import avail.utility.evaluation.Combinator;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0017B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u001d\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lavail/persistence/cache/record/PhrasePathRecord;", "", "bytes", "", "([B)V", "rootTrees", "", "Lavail/persistence/cache/record/PhrasePathRecord$PhraseNode;", "(Ljava/util/List;)V", "getRootTrees", "()Ljava/util/List;", "phraseNodesDo", "", "action", "Lkotlin/Function1;", "toString", "", "write", "binaryStream", "Ljava/io/DataOutputStream;", "namesIndex", "Lavail/persistence/cache/record/NamesIndex;", "write$avail", "PhraseNode", "avail"})
@SourceDebugExtension(value={"SMAP\nPhrasePathRecord.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhrasePathRecord.kt\navail/persistence/cache/record/PhrasePathRecord\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,565:1\n1045#2:566\n1855#2,2:567\n1045#2:569\n1855#2,2:570\n1855#2,2:572\n*S KotlinDebug\n*F\n+ 1 PhrasePathRecord.kt\navail/persistence/cache/record/PhrasePathRecord\n*L\n135#1:566\n135#1:567,2\n140#1:569\n140#1:570,2\n216#1:572,2\n*E\n"})
public final class PhrasePathRecord {
    @NotNull
    private final List<PhraseNode> rootTrees;

    public PhrasePathRecord(@NotNull List<PhraseNode> rootTrees) {
        Intrinsics.checkNotNullParameter(rootTrees, (String)"rootTrees");
        this.rootTrees = rootTrees;
    }

    public /* synthetic */ PhrasePathRecord(List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list2 = new ArrayList();
        }
        this(list2);
    }

    @NotNull
    public final List<PhraseNode> getRootTrees() {
        return this.rootTrees;
    }

    public final void phraseNodesDo(@NotNull Function1<? super PhraseNode, Unit> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        List workStack = new ArrayList();
        workStack.addAll(CollectionsKt.reversed((Iterable)this.rootTrees));
        while (!((Collection)workStack).isEmpty()) {
            PhraseNode node = (PhraseNode)CollectionExtensionsKt.removeLast(workStack);
            action2.invoke((Object)node);
            workStack.addAll(CollectionsKt.reversed((Iterable)node.getChildren()));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void write$avail(@NotNull DataOutputStream binaryStream, @NotNull NamesIndex namesIndex) throws IOException {
        A_String string2;
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)binaryStream, (String)"binaryStream");
        Intrinsics.checkNotNullParameter((Object)namesIndex, (String)"namesIndex");
        Map moduleNameMap = new LinkedHashMap();
        Map atomNameMap = new LinkedHashMap();
        List workStack = CollectionsKt.toMutableList((Collection)CollectionsKt.reversed((Iterable)this.rootTrees));
        while (!((Collection)workStack).isEmpty()) {
            A_String it;
            PhraseNode node = (PhraseNode)CollectionExtensionsKt.removeLast(workStack);
            if (node.getAtomModuleName() != null) {
                boolean bl = false;
                moduleNameMap.computeIfAbsent(it, arg_0 -> PhrasePathRecord.write$lambda$1$lambda$0((Function1)new Function1<A_String, Integer>((Map<A_String, Integer>)moduleNameMap){
                    final /* synthetic */ Map<A_String, Integer> $moduleNameMap;
                    {
                        this.$moduleNameMap = $moduleNameMap;
                        super(1);
                    }

                    @NotNull
                    public final Integer invoke(@NotNull A_String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return this.$moduleNameMap.size() + 1;
                    }
                }, arg_0));
            }
            if (node.getAtomName() != null) {
                boolean bl = false;
                atomNameMap.computeIfAbsent(it, arg_0 -> PhrasePathRecord.write$lambda$3$lambda$2((Function1)new Function1<A_String, Integer>((Map<A_String, Integer>)atomNameMap){
                    final /* synthetic */ Map<A_String, Integer> $atomNameMap;
                    {
                        this.$atomNameMap = $atomNameMap;
                        super(1);
                    }

                    @NotNull
                    public final Integer invoke(@NotNull A_String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return this.$atomNameMap.size() + 1;
                    }
                }, arg_0));
            }
            workStack.addAll(CollectionsKt.reversed((Iterable)node.getChildren()));
        }
        CodingKt.vlq(binaryStream, moduleNameMap.size());
        Iterable $this$sortedBy$iv = moduleNameMap.entrySet();
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Integer)it.getValue();
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)it.getValue()));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            string2 = (A_String)entry.getKey();
            CodingKt.sizedString(binaryStream, A_String.Companion.asNativeString(string2));
        }
        CodingKt.vlq(binaryStream, atomNameMap.size());
        $this$sortedBy$iv = atomNameMap.entrySet();
        $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Integer)it.getValue();
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)it.getValue()));
            }
        });
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            string2 = (A_String)entry.getKey();
            CodingKt.sizedString(binaryStream, A_String.Companion.asNativeString(string2));
        }
        CodingKt.vlq(binaryStream, this.rootTrees.size());
        workStack.addAll(CollectionsKt.reversed((Iterable)this.rootTrees));
        Mutable<Integer> tokenCursor = new Mutable<Integer>(0);
        int phraseNumber = 0;
        while (!((Collection)workStack).isEmpty()) {
            PhraseNode node = (PhraseNode)CollectionExtensionsKt.removeLast(workStack);
            if (node.getNameInModule() != null) {
                NameInModule nodeNameInModule;
                boolean bl = false;
                namesIndex.addUsage(nodeNameInModule, node.getUsageType(), phraseNumber);
            }
            int n = phraseNumber;
            phraseNumber = n + 1;
            node.write$avail(binaryStream, moduleNameMap, atomNameMap, tokenCursor);
            CodingKt.vlq(binaryStream, node.getChildren().size());
            workStack.addAll(CollectionsKt.reversed((Iterable)node.getChildren()));
        }
    }

    @NotNull
    public String toString() {
        return "PhrasePathRecord (" + this.rootTrees.size() + " top-level phrases)";
    }

    public PhrasePathRecord(@NotNull byte[] bytes2) throws IOException {
        boolean bl;
        int n;
        ArrayList<A_String> arrayList;
        int n2;
        Intrinsics.checkNotNullParameter((Object)bytes2, (String)"bytes");
        this(null, 1, null);
        DataInputStream binaryStream = new DataInputStream(new ByteArrayInputStream(bytes2));
        int n3 = CodingKt.unvlqInt(binaryStream);
        ArrayList<A_String> arrayList2 = new ArrayList<A_String>(n3);
        int n4 = 0;
        while (n4 < n3) {
            int n5 = n2 = n4++;
            arrayList = arrayList2;
            n = 0;
            arrayList.add(StringDescriptor.Companion.stringFrom(CodingKt.decodeString(binaryStream)));
        }
        List moduleNames = arrayList2;
        int n6 = CodingKt.unvlqInt(binaryStream);
        ArrayList arrayList3 = new ArrayList(n6);
        n2 = 0;
        while (n2 < n6) {
            int it;
            n = it = n2++;
            arrayList = arrayList3;
            boolean bl2 = false;
            arrayList.add(StringDescriptor.Companion.stringFrom(CodingKt.decodeString(binaryStream)));
        }
        List atomNames = arrayList3;
        PhraseNode fakeRoot = new PhraseNode(null, null, NamesIndex.UsageType.MethodSend, CollectionsKt.emptyList(), null, null, 32, null);
        Object[] objectArray = new PhraseNode[]{fakeRoot};
        List phraseStack = CollectionsKt.mutableListOf((Object[])objectArray);
        Object[] it = new Mutable[]{new Mutable<Integer>(CodingKt.unvlqInt(binaryStream))};
        List countdownStack = CollectionsKt.mutableListOf((Object[])it);
        Mutable<Integer> tokenCursor = new Mutable<Integer>(0);
        while (!((Collection)countdownStack).isEmpty()) {
            Mutable countdown = (Mutable)CollectionsKt.last((List)countdownStack);
            if (((Number)countdown.getValue()).intValue() == 0) {
                CollectionExtensionsKt.removeLast(countdownStack);
                CollectionExtensionsKt.removeLast(phraseStack);
                continue;
            }
            int bl2 = ((Number)countdown.getValue()).intValue();
            countdown.setValue(bl2 + -1);
            PhraseNode child = PhraseNode.Companion.read(binaryStream, moduleNames, atomNames, tokenCursor, (PhraseNode)CollectionsKt.last((List)phraseStack));
            phraseStack.add(child);
            countdownStack.add(new Mutable<Integer>(CodingKt.unvlqInt(binaryStream)));
        }
        this.rootTrees.addAll((Collection<PhraseNode>)fakeRoot.getChildren());
        Iterable $this$forEach$iv = this.rootTrees;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PhraseNode it2 = (PhraseNode)element$iv;
            boolean bl3 = false;
            it2.setParent(null);
        }
        boolean bl4 = bl = binaryStream.available() == 0;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
    }

    private static final Integer write$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Integer)$tmp0.invoke(p0);
    }

    private static final Integer write$lambda$3$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Integer)$tmp0.invoke(p0);
    }

    public PhrasePathRecord() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 ;2\u00020\u0001:\u0002;<BI\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0000\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00000\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0000H\u0002J\u0006\u0010*\u001a\u00020\u0014J\u001a\u0010+\u001a\u00020(2\n\u0010,\u001a\u00060-j\u0002`.2\u0006\u0010/\u001a\u00020\u0014J\b\u00100\u001a\u000201H\u0016JK\u00102\u001a\u00020(2\u0006\u00103\u001a\u0002042\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0014062\u0012\u00107\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0014062\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u001409H\u0000\u00a2\u0006\u0002\b:R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00000\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R \u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00148F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001c\u0010\n\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR$\u0010!\u001a\u0004\u0018\u00010 2\b\u0010\u0013\u001a\u0004\u0018\u00010 8F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u0006="}, d2={"Lavail/persistence/cache/record/PhrasePathRecord$PhraseNode;", "", "atomModuleName", "Lavail/descriptor/tuples/A_String;", "atomName", "usageType", "Lavail/persistence/cache/record/NamesIndex$UsageType;", "tokenSpans", "", "Lavail/persistence/cache/record/PhrasePathRecord$PhraseNode$PhraseNodeToken;", "parent", "children", "", "(Lavail/descriptor/tuples/A_String;Lavail/descriptor/tuples/A_String;Lavail/persistence/cache/record/NamesIndex$UsageType;Ljava/util/List;Lavail/persistence/cache/record/PhrasePathRecord$PhraseNode;Ljava/util/List;)V", "getAtomModuleName", "()Lavail/descriptor/tuples/A_String;", "getAtomName", "getChildren", "()Ljava/util/List;", "<set-?>", "", "indexInParent", "getIndexInParent", "()I", "nameInModule", "Lavail/persistence/cache/record/NameInModule;", "getNameInModule", "()Lavail/persistence/cache/record/NameInModule;", "getParent", "()Lavail/persistence/cache/record/PhrasePathRecord$PhraseNode;", "setParent", "(Lavail/persistence/cache/record/PhrasePathRecord$PhraseNode;)V", "Lavail/compiler/splitter/MessageSplitter;", "splitter", "getSplitter", "()Lavail/compiler/splitter/MessageSplitter;", "getTokenSpans", "getUsageType", "()Lavail/persistence/cache/record/NamesIndex$UsageType;", "addChild", "", "child", "depth", "describeOn", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "characterBudget", "toString", "", "write", "binaryStream", "Ljava/io/DataOutputStream;", "moduleNameMap", "", "atomNameMap", "tokenCursor", "Lavail/utility/Mutable;", "write$avail", "Companion", "PhraseNodeToken", "avail"})
    @SourceDebugExtension(value={"SMAP\nPhrasePathRecord.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhrasePathRecord.kt\navail/persistence/cache/record/PhrasePathRecord$PhraseNode\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,565:1\n1864#2,3:566\n1855#2,2:570\n1620#2,3:572\n1655#2,8:575\n1002#2,2:583\n1855#2,2:585\n1855#2,2:587\n1#3:569\n*S KotlinDebug\n*F\n+ 1 PhrasePathRecord.kt\navail/persistence/cache/record/PhrasePathRecord$PhraseNode\n*L\n351#1:566,3\n376#1:570,2\n402#1:572,3\n420#1:575,8\n422#1:583,2\n431#1:585,2\n484#1:587,2\n*E\n"})
    public static final class PhraseNode {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final A_String atomModuleName;
        @Nullable
        private final A_String atomName;
        @NotNull
        private final NamesIndex.UsageType usageType;
        @NotNull
        private final List<PhraseNodeToken> tokenSpans;
        @Nullable
        private PhraseNode parent;
        @NotNull
        private final List<PhraseNode> children;
        @Nullable
        private MessageSplitter splitter;
        private volatile int indexInParent;

        public PhraseNode(@Nullable A_String atomModuleName, @Nullable A_String atomName, @NotNull NamesIndex.UsageType usageType, @NotNull List<PhraseNodeToken> tokenSpans, @Nullable PhraseNode parent, @NotNull List<PhraseNode> children2) {
            Intrinsics.checkNotNullParameter((Object)((Object)usageType), (String)"usageType");
            Intrinsics.checkNotNullParameter(tokenSpans, (String)"tokenSpans");
            Intrinsics.checkNotNullParameter(children2, (String)"children");
            this.atomModuleName = atomModuleName;
            this.atomName = atomName;
            this.usageType = usageType;
            this.tokenSpans = tokenSpans;
            this.parent = parent;
            this.children = children2;
            Object object = this.parent;
            if (object != null && (object = ((PhraseNode)object).children) != null) {
                object.add(this);
            }
            this.indexInParent = -1;
        }

        public /* synthetic */ PhraseNode(A_String a_String, A_String a_String2, NamesIndex.UsageType usageType, List list2, PhraseNode phraseNode, List list3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x20) != 0) {
                list3 = new ArrayList();
            }
            this(a_String, a_String2, usageType, list2, phraseNode, list3);
        }

        @Nullable
        public final A_String getAtomModuleName() {
            return this.atomModuleName;
        }

        @Nullable
        public final A_String getAtomName() {
            return this.atomName;
        }

        @NotNull
        public final NamesIndex.UsageType getUsageType() {
            return this.usageType;
        }

        @NotNull
        public final List<PhraseNodeToken> getTokenSpans() {
            return this.tokenSpans;
        }

        @Nullable
        public final PhraseNode getParent() {
            return this.parent;
        }

        public final void setParent(@Nullable PhraseNode phraseNode) {
            this.parent = phraseNode;
        }

        @NotNull
        public final List<PhraseNode> getChildren() {
            return this.children;
        }

        private final void addChild(PhraseNode child) {
            this.children.add(child);
        }

        @Nullable
        public final NameInModule getNameInModule() {
            NameInModule nameInModule;
            A_String a_String = this.atomModuleName;
            if (a_String != null) {
                A_String mod = a_String;
                boolean bl = false;
                A_String a_String2 = this.atomName;
                if (a_String2 != null) {
                    A_String name = a_String2;
                    boolean bl2 = false;
                    nameInModule = new NameInModule(A_String.Companion.asNativeString(mod), A_String.Companion.asNativeString(name));
                } else {
                    nameInModule = null;
                }
            } else {
                nameInModule = null;
            }
            return nameInModule;
        }

        @Nullable
        public final MessageSplitter getSplitter() {
            MessageSplitter messageSplitter = this.splitter;
            if (messageSplitter == null) {
                A_String a_String = this.atomName;
                if (a_String != null) {
                    A_String it = a_String;
                    boolean bl = false;
                    messageSplitter = this.splitter = MessageSplitter.Companion.split(it);
                } else {
                    messageSplitter = null;
                }
            }
            return messageSplitter;
        }

        public final int getIndexInParent() {
            block3: {
                if (this.indexInParent != -1) break block3;
                Object object = this.parent;
                if (object != null && (object = ((PhraseNode)object).children) != null) {
                    Iterable $this$forEachIndexed$iv = (Iterable)object;
                    boolean $i$f$forEachIndexed = false;
                    int index$iv = 0;
                    for (Object item$iv : $this$forEachIndexed$iv) {
                        int n;
                        if ((n = index$iv++) < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        PhraseNode phraseNode = (PhraseNode)item$iv;
                        int i2 = n;
                        boolean bl = false;
                        child.indexInParent = i2 + 1;
                    }
                }
            }
            return this.indexInParent;
        }

        /*
         * Unable to fully structure code
         */
        public final void write$avail(@NotNull DataOutputStream binaryStream, @NotNull Map<A_String, Integer> moduleNameMap, @NotNull Map<A_String, Integer> atomNameMap, @NotNull Mutable<Integer> tokenCursor) throws IOException {
            Intrinsics.checkNotNullParameter((Object)binaryStream, (String)"binaryStream");
            Intrinsics.checkNotNullParameter(moduleNameMap, (String)"moduleNameMap");
            Intrinsics.checkNotNullParameter(atomNameMap, (String)"atomNameMap");
            Intrinsics.checkNotNullParameter(tokenCursor, (String)"tokenCursor");
            v0 = binaryStream;
            v1 = this.atomModuleName;
            if (v1 == null) ** GOTO lbl-1000
            var8_5 = v1;
            var16_6 = v0;
            $i$a$-let-PhrasePathRecord$PhraseNode$write$1 = false;
            v2 = moduleNameMap.get(p0);
            v0 = var16_6;
            v1 = v2;
            if (v2 != null) {
                v3 = v1.intValue();
            } else lbl-1000:
            // 2 sources

            {
                v3 = 0;
            }
            CodingKt.vlq(v0, v3);
            v4 = binaryStream;
            v5 = this.atomName;
            if (v5 == null) ** GOTO lbl-1000
            p0 = v5;
            var16_6 = v4;
            $i$a$-let-PhrasePathRecord$PhraseNode$write$2 = false;
            v6 = atomNameMap.get(p0);
            v4 = var16_6;
            v5 = v6;
            if (v6 != null) {
                v7 = v5.intValue();
            } else lbl-1000:
            // 2 sources

            {
                v7 = 0;
            }
            CodingKt.vlq(v4, v7);
            CodingKt.vlq(binaryStream, this.usageType.ordinal());
            CodingKt.vlq(binaryStream, this.tokenSpans.size());
            $this$forEach$iv = this.tokenSpans;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                var9_8 = (PhraseNodeToken)element$iv;
                $i$a$-forEach-PhrasePathRecord$PhraseNode$write$3 = false;
                start = var9_8.component1();
                pastEnd = var9_8.component2();
                line = var9_8.component3();
                tokenIndexInName = var9_8.component4();
                tokenContent = var9_8.component5();
                CodingKt.zigzag(binaryStream, start - ((Number)tokenCursor.getValue()).intValue());
                tokenCursor.setValue(start);
                CodingKt.zigzag(binaryStream, pastEnd - ((Number)tokenCursor.getValue()).intValue());
                tokenCursor.setValue(pastEnd);
                CodingKt.vlq(binaryStream, line);
                CodingKt.vlq(binaryStream, tokenIndexInName);
                if (tokenIndexInName != 0) continue;
                v8 = tokenContent;
                Intrinsics.checkNotNull((Object)v8);
                binaryStream.writeUTF(v8);
            }
        }

        public final int depth() {
            return CollectionsKt.count(CollectionExtensionsKt.iterableWith(this, (Function1)depth.1.INSTANCE));
        }

        /*
         * WARNING - void declaration
         */
        public final void describeOn(@NotNull StringBuilder builder, int characterBudget) {
            void $this$distinctBy$iv;
            void destination$iv;
            Iterable $this$mapTo$iv;
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            MessageSplitter messageSplitter = this.getSplitter();
            if (messageSplitter == null) {
                return;
            }
            MessageSplitter splitter = messageSplitter;
            Ref.ObjectRef triples = new Ref.ObjectRef();
            Iterable iterable = this.tokenSpans;
            Collection collection2 = new ArrayList();
            Ref.ObjectRef objectRef = triples;
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void span;
                PhraseNodeToken phraseNodeToken = (PhraseNodeToken)item$iv;
                void var20_23 = destination$iv;
                boolean bl = false;
                A_String lexeme = splitter.getMessageParts()[span.getTokenIndexInName() - 1];
                var20_23.add(new Triple((Object)1, (Object)span, (Object)A_String.Companion.asNativeString(lexeme)));
            }
            objectRef.element = destination$iv;
            Combinator.INSTANCE.recurse(TuplesKt.to((Object)1, (Object)this), (Function2)new Function2<Pair<? extends Integer, ? extends PhraseNode>, Function1<? super Pair<? extends Integer, ? extends PhraseNode>, ? extends Unit>, Unit>((Ref.ObjectRef<List<Triple<Integer, PhraseNodeToken, String>>>)triples){
                final /* synthetic */ Ref.ObjectRef<List<Triple<Integer, PhraseNodeToken, String>>> $triples;
                {
                    this.$triples = $triples;
                    super(2);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull Pair<Integer, PhraseNode> pair, @NotNull Function1<? super Pair<Integer, PhraseNode>, Unit> again) {
                    void $this$mapTo$iv;
                    Intrinsics.checkNotNullParameter(pair, (String)"<name for destructuring parameter 0>");
                    Intrinsics.checkNotNullParameter(again, (String)"again");
                    int depth2 = ((Number)pair.component1()).intValue();
                    PhraseNode node = (PhraseNode)pair.component2();
                    MessageSplitter nodeSplitter = node.getSplitter();
                    Iterable iterable = node.getTokenSpans();
                    Collection destination$iv = (Collection)this.$triples.element;
                    boolean $i$f$mapTo = false;
                    for (T item$iv : $this$mapTo$iv) {
                        String string2;
                        void span;
                        PhraseNodeToken phraseNodeToken = (PhraseNodeToken)item$iv;
                        Collection collection2 = destination$iv;
                        boolean bl = false;
                        int inName = span.getTokenIndexInName();
                        if (inName == 0) {
                            String string3 = span.getTokenContent();
                            string2 = string3;
                            Intrinsics.checkNotNull((Object)string3);
                        } else {
                            MessageSplitter messageSplitter = nodeSplitter;
                            Intrinsics.checkNotNull((Object)messageSplitter);
                            string2 = A_String.Companion.asNativeString(messageSplitter.getMessageParts()[inName - 1]);
                        }
                        String lexeme = string2;
                        collection2.add(new Triple((Object)depth2, (Object)span, (Object)lexeme));
                    }
                    Iterable $this$forEach$iv = node.getChildren();
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        PhraseNode child = (PhraseNode)element$iv;
                        boolean bl = false;
                        again.invoke((Object)TuplesKt.to((Object)(depth2 + 1), (Object)child));
                    }
                }
            });
            $this$mapTo$iv = (Iterable)triples.element;
            objectRef = triples;
            boolean $i$f$distinctBy = false;
            HashSet<Integer> set$iv = new HashSet<Integer>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                Triple bl = (Triple)e$iv;
                boolean bl2 = false;
                PhraseNodeToken span = (PhraseNodeToken)bl.component2();
                Integer key$iv = span.getStart();
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            objectRef.element = CollectionsKt.toMutableList((Collection)list$iv);
            List $this$sortBy$iv = (List)triples.element;
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() > 1) {
                CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Triple triple = (Triple)a;
                        boolean bl = false;
                        PhraseNodeToken span = (PhraseNodeToken)triple.component2();
                        triple = (Triple)b;
                        Comparable comparable = Integer.valueOf(span.getStart());
                        bl = false;
                        span = (PhraseNodeToken)triple.component2();
                        return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(span.getStart()));
                    }
                });
            }
            int previousPastEnd = 0;
            boolean wasTooDeep = false;
            int startOfTooDeep = 0;
            startOfTooDeep = -1;
            int pastEndOfTooDeep = 0;
            pastEndOfTooDeep = -1;
            List oldTriples = (List)triples.element;
            triples.element = new ArrayList();
            Iterable $this$forEach$iv = oldTriples;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Triple triple = (Triple)element$iv;
                boolean bl = false;
                int depth2 = ((Number)triple.component1()).intValue();
                PhraseNodeToken span = (PhraseNodeToken)triple.component2();
                boolean tooDeep = depth2 > 8;
                if (!wasTooDeep && !tooDeep) {
                    ((List)triples.element).add(triple);
                } else if (!wasTooDeep && tooDeep) {
                    startOfTooDeep = span.getStart();
                    pastEndOfTooDeep = span.getPastEnd();
                } else if (wasTooDeep && tooDeep) {
                    pastEndOfTooDeep = span.getPastEnd();
                } else {
                    ((List)triples.element).add(new Triple((Object)-999, (Object)new PhraseNodeToken(startOfTooDeep, pastEndOfTooDeep, -999, 0, "..."), (Object)"..."));
                    ((List)triples.element).add(triple);
                }
                wasTooDeep = tooDeep;
            }
            if (wasTooDeep) {
                ((List)triples.element).add(new Triple((Object)-999, (Object)new PhraseNodeToken(startOfTooDeep, pastEndOfTooDeep, -999, 0, "..."), (Object)"..."));
            }
            $this$forEach$iv = (Iterable)triples.element;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Triple triple = (Triple)element$iv;
                boolean bl = false;
                PhraseNodeToken span = (PhraseNodeToken)triple.component2();
                String lexeme = (String)triple.component3();
                if (span.getStart() != previousPastEnd) {
                    builder.append(" ");
                }
                builder.append(lexeme);
                previousPastEnd = span.getPastEnd();
            }
        }

        @NotNull
        public String toString() {
            StringBuilder stringBuilder;
            StringBuilder $this$toString_u24lambda_u2412 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$toString_u24lambda_u2412.append("PhraseNode ");
            PhraseNode phraseNode = this.parent;
            if (phraseNode != null) {
                PhraseNode p = phraseNode;
                boolean bl2 = false;
                $this$toString_u24lambda_u2412.append("(");
                $this$toString_u24lambda_u2412.append(this.getIndexInParent());
                $this$toString_u24lambda_u2412.append("/");
                $this$toString_u24lambda_u2412.append(p.children.size());
                $this$toString_u24lambda_u2412.append(") ");
            }
            $this$toString_u24lambda_u2412.append(this.atomName);
            $this$toString_u24lambda_u2412.append(": ");
            CollectionsKt.joinTo$default((Iterable)this.tokenSpans, (Appendable)$this$toString_u24lambda_u2412, (CharSequence)", ", null, null, (int)0, null, (Function1)toString.1.2.INSTANCE, (int)60, null);
            String string2 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
            return string2;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JB\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0004\u00a8\u0006\u000f"}, d2={"Lavail/persistence/cache/record/PhrasePathRecord$PhraseNode$Companion;", "", "()V", "read", "Lavail/persistence/cache/record/PhrasePathRecord$PhraseNode;", "binaryStream", "Ljava/io/DataInputStream;", "moduleNameList", "", "Lavail/descriptor/tuples/A_String;", "atomNameList", "tokenCursor", "Lavail/utility/Mutable;", "", "parent", "avail"})
        @SourceDebugExtension(value={"SMAP\nPhrasePathRecord.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhrasePathRecord.kt\navail/persistence/cache/record/PhrasePathRecord$PhraseNode$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,565:1\n1549#2:566\n1620#2,3:567\n*S KotlinDebug\n*F\n+ 1 PhrasePathRecord.kt\navail/persistence/cache/record/PhrasePathRecord$PhraseNode$Companion\n*L\n544#1:566\n544#1:567,3\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final PhraseNode read(@NotNull DataInputStream binaryStream, @NotNull List<? extends A_String> moduleNameList, @NotNull List<? extends A_String> atomNameList, @NotNull Mutable<Integer> tokenCursor, @Nullable PhraseNode parent) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)binaryStream, (String)"binaryStream");
                Intrinsics.checkNotNullParameter(moduleNameList, (String)"moduleNameList");
                Intrinsics.checkNotNullParameter(atomNameList, (String)"atomNameList");
                Intrinsics.checkNotNullParameter(tokenCursor, (String)"tokenCursor");
                int index2 = CodingKt.unvlqInt(binaryStream);
                A_String atomModuleName = index2 == 0 ? null : moduleNameList.get(index2 - 1);
                int index3 = CodingKt.unvlqInt(binaryStream);
                A_String atomName = index3 == 0 ? null : atomNameList.get(index3 - 1);
                NamesIndex.UsageType usageType = NamesIndex.UsageType.Companion.getAll()[CodingKt.unvlqInt(binaryStream)];
                Iterable $this$map$iv = (Iterable)new IntRange(1, CodingKt.unvlqInt(binaryStream));
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    int item$iv$iv;
                    int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    int start = ((Number)tokenCursor.getValue()).intValue() + CodingKt.unzigzagInt(binaryStream);
                    tokenCursor.setValue(start);
                    int pastEnd = ((Number)tokenCursor.getValue()).intValue() + CodingKt.unzigzagInt(binaryStream);
                    tokenCursor.setValue(pastEnd);
                    int line = CodingKt.unvlqInt(binaryStream);
                    int tokenIndexInName = CodingKt.unvlqInt(binaryStream);
                    String tokenContent = tokenIndexInName == 0 ? binaryStream.readUTF() : null;
                    collection2.add(new PhraseNodeToken(start, pastEnd, line, tokenIndexInName, tokenContent));
                }
                List tokenSpans = (List)destination$iv$iv;
                return new PhraseNode(atomModuleName, atomName, usageType, tokenSpans, parent, null, 32, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\bH\u00c6\u0003J=\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001b\u001a\u00020\bH\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lavail/persistence/cache/record/PhrasePathRecord$PhraseNode$PhraseNodeToken;", "", "start", "", "pastEnd", "line", "tokenIndexInName", "tokenContent", "", "(IIIILjava/lang/String;)V", "getLine", "()I", "getPastEnd", "getStart", "getTokenContent", "()Ljava/lang/String;", "getTokenIndexInName", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "avail"})
        public static final class PhraseNodeToken {
            private final int start;
            private final int pastEnd;
            private final int line;
            private final int tokenIndexInName;
            @Nullable
            private final String tokenContent;

            public PhraseNodeToken(int start, int pastEnd, int line, int tokenIndexInName, @Nullable String tokenContent) {
                this.start = start;
                this.pastEnd = pastEnd;
                this.line = line;
                this.tokenIndexInName = tokenIndexInName;
                this.tokenContent = tokenContent;
            }

            public final int getStart() {
                return this.start;
            }

            public final int getPastEnd() {
                return this.pastEnd;
            }

            public final int getLine() {
                return this.line;
            }

            public final int getTokenIndexInName() {
                return this.tokenIndexInName;
            }

            @Nullable
            public final String getTokenContent() {
                return this.tokenContent;
            }

            public final int component1() {
                return this.start;
            }

            public final int component2() {
                return this.pastEnd;
            }

            public final int component3() {
                return this.line;
            }

            public final int component4() {
                return this.tokenIndexInName;
            }

            @Nullable
            public final String component5() {
                return this.tokenContent;
            }

            @NotNull
            public final PhraseNodeToken copy(int start, int pastEnd, int line, int tokenIndexInName, @Nullable String tokenContent) {
                return new PhraseNodeToken(start, pastEnd, line, tokenIndexInName, tokenContent);
            }

            public static /* synthetic */ PhraseNodeToken copy$default(PhraseNodeToken phraseNodeToken, int n, int n2, int n3, int n4, String string2, int n5, Object object) {
                if ((n5 & 1) != 0) {
                    n = phraseNodeToken.start;
                }
                if ((n5 & 2) != 0) {
                    n2 = phraseNodeToken.pastEnd;
                }
                if ((n5 & 4) != 0) {
                    n3 = phraseNodeToken.line;
                }
                if ((n5 & 8) != 0) {
                    n4 = phraseNodeToken.tokenIndexInName;
                }
                if ((n5 & 0x10) != 0) {
                    string2 = phraseNodeToken.tokenContent;
                }
                return phraseNodeToken.copy(n, n2, n3, n4, string2);
            }

            @NotNull
            public String toString() {
                return "PhraseNodeToken(start=" + this.start + ", pastEnd=" + this.pastEnd + ", line=" + this.line + ", tokenIndexInName=" + this.tokenIndexInName + ", tokenContent=" + this.tokenContent + ")";
            }

            public int hashCode() {
                int result2 = Integer.hashCode(this.start);
                result2 = result2 * 31 + Integer.hashCode(this.pastEnd);
                result2 = result2 * 31 + Integer.hashCode(this.line);
                result2 = result2 * 31 + Integer.hashCode(this.tokenIndexInName);
                result2 = result2 * 31 + (this.tokenContent == null ? 0 : this.tokenContent.hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof PhraseNodeToken)) {
                    return false;
                }
                PhraseNodeToken phraseNodeToken = (PhraseNodeToken)other;
                if (this.start != phraseNodeToken.start) {
                    return false;
                }
                if (this.pastEnd != phraseNodeToken.pastEnd) {
                    return false;
                }
                if (this.line != phraseNodeToken.line) {
                    return false;
                }
                if (this.tokenIndexInName != phraseNodeToken.tokenIndexInName) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.tokenContent, (Object)phraseNodeToken.tokenContent);
            }
        }
    }
}

