/*
 * Decompiled with CFR 0.152.
 */
package avail.utility;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lavail/utility/UTF8ResourceBundleControl;", "Ljava/util/ResourceBundle$Control;", "()V", "newBundle", "Ljava/util/ResourceBundle;", "baseName", "", "locale", "Ljava/util/Locale;", "format", "loader", "Ljava/lang/ClassLoader;", "reload", "", "avail"})
@SourceDebugExtension(value={"SMAP\nUTF8ResourceBundleControl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UTF8ResourceBundleControl.kt\navail/utility/UTF8ResourceBundleControl\n+ 2 Casts.kt\navail/utility/CastsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,126:1\n46#2:127\n1#3:128\n*S KotlinDebug\n*F\n+ 1 UTF8ResourceBundleControl.kt\navail/utility/UTF8ResourceBundleControl\n*L\n66#1:127\n*E\n"})
public final class UTF8ResourceBundleControl
extends ResourceBundle.Control {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ResourceBundle newBundle(@NotNull String baseName, @NotNull Locale locale, @NotNull String format, @NotNull ClassLoader loader, boolean reload) throws IOException {
        Intrinsics.checkNotNullParameter((Object)baseName, (String)"baseName");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
        String bundleName = this.toBundleName(baseName, locale);
        ResourceBundle bundle = null;
        if (Intrinsics.areEqual((Object)format, (Object)"java.class")) {
            try {
                Class<?> $this$cast$iv = loader.loadClass(bundleName);
                boolean $i$f$cast = false;
                Class bundleClass = (Class)((Object)$this$cast$iv);
                if (!ResourceBundle.class.isAssignableFrom(bundleClass)) {
                    throw new ClassCastException(bundleClass.getName() + " cannot be cast to ResourceBundle");
                }
                bundle = (ResourceBundle)bundleClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException bundleClass) {
            }
            catch (InstantiationException bundleClass) {
            }
            catch (IllegalAccessException bundleClass) {}
        } else if (Intrinsics.areEqual((Object)format, (Object)"java.properties")) {
            Object object;
            Serializable serializable;
            Reader stream = null;
            String resourceName = this.toResourceName(bundleName, "properties");
            InputStream inputStream = null;
            if (reload) {
                serializable = loader.getResource(resourceName);
                if (serializable == null) {
                    throw new IOException("Invalid URL for resource");
                }
                URL url = serializable;
                object = url.openConnection();
                if (object == null) {
                    throw new IOException("Invalid URL for resource");
                }
                URLConnection connection = object;
                connection.setUseCaches(false);
                InputStream inputStream2 = connection.getInputStream();
                Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"getInputStream(...)");
                inputStream = inputStream2;
            } else {
                InputStream inputStream3 = loader.getResourceAsStream(resourceName);
                Intrinsics.checkNotNull((Object)inputStream3);
                inputStream = inputStream3;
            }
            stream = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
            Closeable closeable = stream;
            serializable = null;
            try {
                Reader p0 = (Reader)closeable;
                boolean bl = false;
                object = new PropertyResourceBundle(p0);
            }
            catch (Throwable throwable) {
                serializable = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)serializable);
            }
            bundle = (ResourceBundle)object;
        } else {
            throw new IllegalArgumentException("unknown format: " + format);
        }
        return bundle;
    }
}

