/*
 * Decompiled with CFR 0.152.
 */
package avail.descriptor.sets;

import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AbstractDescriptor;
import avail.descriptor.representation.AbstractSlotsEnum;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.AvailObjectRepresentation;
import avail.descriptor.representation.BitField;
import avail.descriptor.representation.IntegerSlotsEnum;
import avail.descriptor.representation.Mutability;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.representation.ObjectSlotsEnum;
import avail.descriptor.sets.A_Set;
import avail.descriptor.sets.A_SetBin;
import avail.descriptor.sets.HashedSetBinDescriptor;
import avail.descriptor.sets.LinearSetBinDescriptor;
import avail.descriptor.sets.SetBinDescriptor;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.TypeTag;
import avail.utility.structures.EnumMap;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 02\u00020\u0001:\u00040123B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0000H\u0016J\b\u0010\u0013\u001a\u00020\u0000H\u0016J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0005H\u0016J\u0018\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u000fH\u0016J \u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0005H\u0016J5\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u000bH\u0010\u00a2\u0006\u0002\b J\u0010\u0010!\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\"\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010#\u001a\u00020$H\u0016J0\u0010%\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u000bH\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010(\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010)\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010*\u001a\u00020\u001d2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J \u0010+\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010,\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J \u0010-\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010.\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010/\u001a\u00020\u0000H\u0016R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u00064"}, d2={"Lavail/descriptor/sets/HashedSetBinDescriptor;", "Lavail/descriptor/sets/SetBinDescriptor;", "mutability", "Lavail/descriptor/representation/Mutability;", "level", "", "(Lavail/descriptor/representation/Mutability;I)V", "shift", "getShift", "()I", "allowsImmutableToMutableReferenceInField", "", "e", "Lavail/descriptor/representation/AbstractSlotsEnum;", "binUnionKind", "Lavail/descriptor/types/A_Type;", "self", "Lavail/descriptor/representation/AvailObject;", "immutable", "mutable", "o_BinElementAt", "index", "o_BinElementsAreAllInstancesOfKind", "kind", "o_BinHasElementWithHash", "elementObject", "Lavail/descriptor/representation/A_BasicObject;", "elementObjectHash", "o_BinRemoveElementHashLevelCanDestroy", "Lavail/descriptor/sets/A_SetBin;", "myLevel", "canDestroy", "o_BinRemoveElementHashLevelCanDestroy$avail", "o_BinUnionKind", "o_IsBinSubsetOf", "potentialSuperset", "Lavail/descriptor/sets/A_Set;", "o_SetBinAddingElementHashLevelCanDestroy", "o_SetBinIterator", "Lavail/descriptor/sets/SetDescriptor$SetIterator;", "o_SetBinSize", "o_SetBinUnion", "otherBin", "o_SetBinUnionWithHashedBin", "hashedBin", "o_SetBinUnionWithLinearBin", "linearBin", "shared", "Companion", "HashedSetBinIterator", "IntegerSlots", "ObjectSlots", "avail"})
@SourceDebugExtension(value={"SMAP\nHashedSetBinDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HashedSetBinDescriptor.kt\navail/descriptor/sets/HashedSetBinDescriptor\n+ 2 A_BasicObject.kt\navail/descriptor/representation/A_BasicObject$Companion\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 EnumMap.kt\navail/utility/structures/EnumMap$Companion\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,835:1\n1188#2,2:836\n1190#2,2:839\n1#3:838\n1#3:849\n1726#4,3:841\n234#5,3:844\n237#5:848\n238#5:850\n239#5:852\n13309#6:847\n13310#6:851\n*S KotlinDebug\n*F\n+ 1 HashedSetBinDescriptor.kt\navail/descriptor/sets/HashedSetBinDescriptor\n*L\n216#1:836,2\n216#1:839,2\n216#1:838\n788#1:849\n502#1:841,3\n788#1:844,3\n788#1:848\n788#1:850\n788#1:852\n788#1:847\n788#1:851\n*E\n"})
public final class HashedSetBinDescriptor
extends SetBinDescriptor {
    @NotNull
    public static final Companion Companion;
    private final int shift;
    private static final boolean checkBinHashes = false;
    public static final int numberOfLevels = 6;
    @NotNull
    private static final EnumMap<Mutability, HashedSetBinDescriptor[]> descriptors;

    /*
     * WARNING - void declaration
     */
    private HashedSetBinDescriptor(Mutability mutability, int level) {
        super(mutability, TypeTag.UNKNOWN_TAG, ObjectSlots.class, IntegerSlots.class, level);
        void it;
        boolean bl;
        int n;
        int n2 = n = level * 6;
        HashedSetBinDescriptor hashedSetBinDescriptor = this;
        boolean bl2 = false;
        boolean bl3 = bl = it < 32;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        hashedSetBinDescriptor.shift = n;
    }

    public final int getShift() {
        return this.shift;
    }

    @Override
    protected boolean allowsImmutableToMutableReferenceInField(@NotNull AbstractSlotsEnum e) {
        Intrinsics.checkNotNullParameter(e, "e");
        return e == ObjectSlots.BIN_UNION_KIND_OR_NIL;
    }

    @Override
    public int o_SetBinSize(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return self.get(IntegerSlots.Companion.getBIN_SIZE());
    }

    @Override
    @NotNull
    public AvailObject o_BinElementAt(@NotNull AvailObject self, int index2) {
        Intrinsics.checkNotNullParameter(self, "self");
        return self.get(ObjectSlots.BIN_ELEMENT_AT_, index2);
    }

    private final A_Type binUnionKind(AvailObject self) {
        A_Type union = self.get(ObjectSlots.BIN_UNION_KIND_OR_NIL);
        if (union.isNil()) {
            union = A_SetBin.Companion.getBinUnionKind(self.get(ObjectSlots.BIN_ELEMENT_AT_, 1));
            int i2 = 2;
            int n = self.variableObjectSlotsCount();
            if (i2 <= n) {
                while (true) {
                    union = A_Type.Companion.typeUnion(union, A_SetBin.Companion.getBinUnionKind(self.get(ObjectSlots.BIN_ELEMENT_AT_, i2)));
                    if (i2 == n) break;
                    ++i2;
                }
            }
            if (this.isShared()) {
                union = union.makeShared();
            }
            self.set(ObjectSlots.BIN_UNION_KIND_OR_NIL, union);
        }
        return union;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public A_Type o_BinUnionKind(@NotNull AvailObject self) {
        A_Type a_Type;
        Intrinsics.checkNotNullParameter(self, "self");
        A_BasicObject.Companion companion = A_BasicObject.Companion;
        A_BasicObject a_BasicObject = self;
        boolean syncCondition$iv = this.isShared();
        boolean $i$f$synchronizeIf = false;
        if (syncCondition$iv) {
            void var6_6 = $this$synchronizeIf$iv;
            synchronized (var6_6) {
                boolean bl = false;
                void $this$o_BinUnionKind_u24lambda_u241 = $this$synchronizeIf$iv;
                boolean bl2 = false;
                A_Type a_Type2 = this.binUnionKind(self);
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl16 : MonitorExitStatement: MONITOREXIT : var6_6
                a_Type = a_Type2;
            }
        } else {
            void $this$o_BinUnionKind_u24lambda_u241 = $this$synchronizeIf$iv;
            boolean bl = false;
            a_Type = this.binUnionKind(self);
        }
        return a_Type;
    }

    @Override
    public boolean o_BinElementsAreAllInstancesOfKind(@NotNull AvailObject self, @NotNull A_Type kind2) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(kind2, "kind");
        return A_Type.Companion.isSubtypeOf(A_SetBin.Companion.getBinUnionKind(self), kind2);
    }

    @Override
    @NotNull
    public A_SetBin o_SetBinAddingElementHashLevelCanDestroy(@NotNull AvailObject self, @NotNull A_BasicObject elementObject, int elementObjectHash, int myLevel, boolean canDestroy) {
        boolean bl;
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(elementObject, "elementObject");
        boolean bl2 = bl = myLevel == this.getLevel$avail();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        int objectEntryCount = self.variableObjectSlotsCount();
        int logicalIndex = elementObjectHash >>> this.shift & 0x3F;
        long logicalBitValue = 1L << logicalIndex;
        long vector = self.get(IntegerSlots.BIT_VECTOR);
        long masked = vector & logicalBitValue - 1L;
        int physicalIndex = Long.bitCount(masked) + 1;
        AvailObject objectToModify = null;
        A_Type typeUnion = null;
        if ((vector & logicalBitValue) != 0L) {
            AvailObject availObject;
            AvailObject availObject2;
            A_SetBin entry = null;
            entry = self.get(ObjectSlots.BIN_ELEMENT_AT_, physicalIndex);
            int previousBinSize = A_SetBin.Companion.getSetBinSize(entry);
            int previousEntryHash = A_SetBin.Companion.getSetBinHash(entry);
            int previousTotalHash = A_SetBin.Companion.getSetBinHash(self);
            int delta = A_SetBin.Companion.getSetBinSize(entry = A_SetBin.Companion.setBinAddingElementHashLevelCanDestroy(entry, elementObject, elementObjectHash, this.getLevel$avail() + 1, canDestroy)) - previousBinSize;
            if (delta == 0) {
                if (!canDestroy) {
                    self.makeImmutable();
                }
                return self;
            }
            int hashDelta = A_SetBin.Companion.getSetBinHash(entry) - previousEntryHash;
            int newSize = self.get(IntegerSlots.Companion.getBIN_SIZE()) + delta;
            typeUnion = self.get(ObjectSlots.BIN_UNION_KIND_OR_NIL);
            if (((A_Type)typeUnion).getNotNil()) {
                typeUnion = A_Type.Companion.typeUnion(typeUnion, A_SetBin.Companion.getBinUnionKind(entry));
            }
            if (canDestroy && this.isMutable()) {
                availObject2 = self;
            } else {
                if (!canDestroy && this.isMutable()) {
                    self.makeSubobjectsImmutable();
                }
                availObject2 = AvailObjectRepresentation.Companion.newLike(Companion.descriptorFor(Mutability.MUTABLE, this.getLevel$avail()), self, 0, 0);
            }
            AvailObject $this$o_SetBinAddingElementHashLevelCanDestroy_u24lambda_u242 = availObject = (objectToModify = availObject2);
            boolean bl3 = false;
            $this$o_SetBinAddingElementHashLevelCanDestroy_u24lambda_u242.setSlot(IntegerSlots.Companion.getBIN_HASH(), previousTotalHash + hashDelta);
            $this$o_SetBinAddingElementHashLevelCanDestroy_u24lambda_u242.setSlot(IntegerSlots.Companion.getBIN_SIZE(), newSize);
            $this$o_SetBinAddingElementHashLevelCanDestroy_u24lambda_u242.setSlot(ObjectSlots.BIN_UNION_KIND_OR_NIL, typeUnion);
            $this$o_SetBinAddingElementHashLevelCanDestroy_u24lambda_u242.setSlot(ObjectSlots.BIN_ELEMENT_AT_, physicalIndex, entry);
            return availObject;
        }
        if (!canDestroy && this.isMutable()) {
            self.makeSubobjectsImmutable();
        }
        if (((A_Type)(typeUnion = self.mutableSlot(ObjectSlots.BIN_UNION_KIND_OR_NIL))).getNotNil()) {
            typeUnion = A_Type.Companion.typeUnion(typeUnion, elementObject.kind());
        }
        objectToModify = HashedSetBinDescriptor.Companion.createUninitializedHashedSetBin(this.getLevel$avail(), objectEntryCount + 1, A_SetBin.Companion.getSetBinSize(self) + 1, A_SetBin.Companion.getSetBinHash(self) + elementObjectHash, vector | logicalBitValue, typeUnion);
        objectToModify.setSlotsFromObjectSlots(ObjectSlots.BIN_ELEMENT_AT_, 1, self, ObjectSlots.BIN_ELEMENT_AT_, 1, physicalIndex - 1);
        objectToModify.set(ObjectSlots.BIN_ELEMENT_AT_, physicalIndex, elementObject);
        objectToModify.setSlotsFromObjectSlots(ObjectSlots.BIN_ELEMENT_AT_, physicalIndex + 1, self, ObjectSlots.BIN_ELEMENT_AT_, physicalIndex, objectEntryCount - physicalIndex + 1);
        return objectToModify;
    }

    @Override
    @NotNull
    public A_SetBin o_SetBinUnion(@NotNull AvailObject self, @NotNull A_SetBin otherBin, int level) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(otherBin, "otherBin");
        return A_SetBin.Companion.setBinUnionWithHashedBin(otherBin, self, level);
    }

    @Override
    @NotNull
    public A_SetBin o_SetBinUnionWithLinearBin(@NotNull AvailObject self, @NotNull AvailObject linearBin, int level) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(linearBin, "linearBin");
        return Companion.combineHashedAndLinear(self, linearBin, level);
    }

    @Override
    @NotNull
    public A_SetBin o_SetBinUnionWithHashedBin(@NotNull AvailObject self, @NotNull AvailObject hashedBin, int level) {
        boolean bl;
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(hashedBin, "hashedBin");
        if (self.sameAddressAs(hashedBin)) {
            return self;
        }
        long mask1 = self.get(IntegerSlots.BIT_VECTOR);
        long mask2 = hashedBin.get(IntegerSlots.BIT_VECTOR);
        long mergedMask = mask1 | mask2;
        int newSize = Long.bitCount(mergedMask);
        AvailObject out2 = mask1 == mergedMask && this.isMutable() ? self : (mask2 == mergedMask && hashedBin.descriptor().isMutable() ? hashedBin : (mask1 == mask2 ? AvailObjectRepresentation.Companion.newLike(this.mutable(), self, 0, 0) : HashedSetBinDescriptor.Companion.createUninitializedHashedSetBin(level, newSize, 0, 0, mergedMask, NilDescriptor.Companion.getNil())));
        int source1 = 1;
        int source2 = 1;
        int elementCount = 0;
        int hash = 0;
        int dest = 1;
        if (dest <= newSize) {
            while (true) {
                long bit = Long.lowestOneBit(mergedMask);
                A_SetBin child = (mask2 & bit) == 0L ? (A_SetBin)self.get(ObjectSlots.BIN_ELEMENT_AT_, source1++) : ((mask1 & bit) == 0L ? (A_SetBin)hashedBin.get(ObjectSlots.BIN_ELEMENT_AT_, source2++) : A_SetBin.Companion.setBinUnion(self.get(ObjectSlots.BIN_ELEMENT_AT_, source1++), hashedBin.get(ObjectSlots.BIN_ELEMENT_AT_, source2++), level + 1));
                elementCount += A_SetBin.Companion.getSetBinSize(child);
                hash += A_SetBin.Companion.getSetBinHash(child);
                out2.set(ObjectSlots.BIN_ELEMENT_AT_, dest, child);
                mergedMask ^= bit;
                if (dest == newSize) break;
                ++dest;
            }
        }
        boolean bl2 = bl = mergedMask == 0L;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        boolean bl3 = bl = source1 == self.variableObjectSlotsCount() + 1;
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        boolean bl4 = bl = source2 == hashedBin.variableObjectSlotsCount() + 1;
        if (_Assertions.ENABLED && !bl) {
            String string4 = "Assertion failed";
            throw new AssertionError((Object)string4);
        }
        out2.set(IntegerSlots.Companion.getBIN_HASH(), hash);
        out2.set(IntegerSlots.Companion.getBIN_SIZE(), elementCount);
        out2.set(ObjectSlots.BIN_UNION_KIND_OR_NIL, NilDescriptor.Companion.getNil());
        return out2;
    }

    @Override
    public boolean o_BinHasElementWithHash(@NotNull AvailObject self, @NotNull A_BasicObject elementObject, int elementObjectHash) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(elementObject, "elementObject");
        int logicalIndex = elementObjectHash >>> this.shift & 0x3F;
        long logicalBitValue = 1L << logicalIndex;
        long vector = self.get(IntegerSlots.BIT_VECTOR);
        if ((vector & logicalBitValue) == 0L) {
            return false;
        }
        long masked = vector & logicalBitValue - 1L;
        int physicalIndex = Long.bitCount(masked) + 1;
        A_SetBin subBin = self.get(ObjectSlots.BIN_ELEMENT_AT_, physicalIndex);
        return A_SetBin.Companion.binHasElementWithHash(subBin, elementObject, elementObjectHash);
    }

    @Override
    @NotNull
    public A_SetBin o_BinRemoveElementHashLevelCanDestroy$avail(@NotNull AvailObject self, @NotNull A_BasicObject elementObject, int elementObjectHash, int myLevel, boolean canDestroy) {
        boolean bl;
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(elementObject, "elementObject");
        boolean bl2 = bl = this.getLevel$avail() == myLevel;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        int objectEntryCount = self.variableObjectSlotsCount();
        int logicalIndex = elementObjectHash >>> this.shift & 0x3F;
        long logicalBitValue = 1L << logicalIndex;
        long vector = self.get(IntegerSlots.BIT_VECTOR);
        if ((vector & logicalBitValue) == 0L) {
            if (!canDestroy) {
                self.makeImmutable();
            }
            return self;
        }
        long masked = vector & logicalBitValue - 1L;
        int physicalIndex = Long.bitCount(masked) + 1;
        A_SetBin oldEntry = self.get(ObjectSlots.BIN_ELEMENT_AT_, physicalIndex);
        int oldEntryHash = A_SetBin.Companion.getSetBinHash(oldEntry);
        int oldEntrySize = A_SetBin.Companion.getSetBinSize(oldEntry);
        int oldTotalHash = A_SetBin.Companion.getSetBinHash(self);
        int oldTotalSize = A_SetBin.Companion.getSetBinSize(self);
        A_SetBin replacementEntry = A_SetBin.Companion.binRemoveElementHashLevelCanDestroy(oldEntry, elementObject, elementObjectHash, this.getLevel$avail() + 1, canDestroy);
        int deltaHash = A_SetBin.Companion.getSetBinHash(replacementEntry) - oldEntryHash;
        int deltaSize = A_SetBin.Companion.getSetBinSize(replacementEntry) - oldEntrySize;
        AvailObject result2 = null;
        if (A_SetBin.Companion.getSetBinSize(replacementEntry) == 0) {
            if (objectEntryCount == 1) {
                return LinearSetBinDescriptor.Companion.emptyLinearSetBin(this.getLevel$avail());
            }
            result2 = HashedSetBinDescriptor.Companion.createUninitializedHashedSetBin(this.getLevel$avail(), objectEntryCount - 1, oldTotalSize + deltaSize, oldTotalHash + deltaHash, vector ^ logicalBitValue, NilDescriptor.Companion.getNil());
            result2.setSlotsFromObjectSlots(ObjectSlots.BIN_ELEMENT_AT_, 1, self, ObjectSlots.BIN_ELEMENT_AT_, 1, physicalIndex - 1);
            result2.setSlotsFromObjectSlots(ObjectSlots.BIN_ELEMENT_AT_, physicalIndex, self, ObjectSlots.BIN_ELEMENT_AT_, physicalIndex + 1, objectEntryCount - physicalIndex);
            if (!canDestroy) {
                result2.makeSubobjectsImmutable();
            }
        } else {
            AvailObject availObject;
            if (canDestroy && this.isMutable()) {
                availObject = self;
            } else {
                if (!canDestroy) {
                    self.makeSubobjectsImmutable();
                }
                availObject = AvailObjectRepresentation.Companion.newLike(Companion.descriptorFor(Mutability.MUTABLE, this.getLevel$avail()), self, 0, 0);
            }
            AvailObject $this$o_BinRemoveElementHashLevelCanDestroy_u24lambda_u243 = result2 = availObject;
            boolean bl3 = false;
            $this$o_BinRemoveElementHashLevelCanDestroy_u24lambda_u243.setSlot(ObjectSlots.BIN_ELEMENT_AT_, physicalIndex, replacementEntry);
            $this$o_BinRemoveElementHashLevelCanDestroy_u24lambda_u243.setSlot(IntegerSlots.Companion.getBIN_HASH(), oldTotalHash + deltaHash);
            $this$o_BinRemoveElementHashLevelCanDestroy_u24lambda_u243.setSlot(IntegerSlots.Companion.getBIN_SIZE(), oldTotalSize + deltaSize);
            $this$o_BinRemoveElementHashLevelCanDestroy_u24lambda_u243.setSlot(ObjectSlots.BIN_UNION_KIND_OR_NIL, NilDescriptor.Companion.getNil());
        }
        return result2;
    }

    @Override
    public boolean o_IsBinSubsetOf(@NotNull AvailObject self, @NotNull A_Set potentialSuperset) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(self, "self");
            Intrinsics.checkNotNullParameter(potentialSuperset, "potentialSuperset");
            Iterable $this$all$iv = new IntRange(1, self.variableObjectSlotsCount());
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator2 = $this$all$iv.iterator();
                while (iterator2.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator2).nextInt();
                    boolean bl2 = false;
                    if (A_SetBin.Companion.isBinSubsetOf(self.get(ObjectSlots.BIN_ELEMENT_AT_, it), potentialSuperset)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public SetDescriptor.SetIterator o_SetBinIterator(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return new HashedSetBinIterator(self);
    }

    @Override
    @NotNull
    public HashedSetBinDescriptor mutable() {
        return Companion.descriptorFor(Mutability.MUTABLE, this.getLevel$avail());
    }

    @Override
    @NotNull
    public HashedSetBinDescriptor immutable() {
        return Companion.descriptorFor(Mutability.IMMUTABLE, this.getLevel$avail());
    }

    @Override
    @NotNull
    public HashedSetBinDescriptor shared() {
        return Companion.descriptorFor(Mutability.SHARED, this.getLevel$avail());
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        Companion = new Companion(null);
        EnumMap.Companion this_$iv = EnumMap.Companion;
        boolean $i$f$enumMap = false;
        Enum[] keys$iv = (Enum[])Mutability.class.getEnumConstants();
        Intrinsics.checkNotNull(keys$iv);
        EnumMap map$iv = new EnumMap(keys$iv);
        Enum[] $this$forEach$iv$iv = keys$iv;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv$iv.length;
        for (int j = 0; j < n; ++j) {
            Enum element$iv$iv;
            Enum key$iv = element$iv$iv = $this$forEach$iv$iv[j];
            boolean bl = false;
            Intrinsics.checkNotNull(key$iv);
            Mutability mut = (Mutability)key$iv;
            boolean bl2 = false;
            int n2 = 0;
            HashedSetBinDescriptor[] hashedSetBinDescriptorArray = new HashedSetBinDescriptor[6];
            while (n2 < 6) {
                int n3 = n2++;
                hashedSetBinDescriptorArray[n3] = new HashedSetBinDescriptor(mut, n3);
            }
            HashedSetBinDescriptor[] value$iv = hashedSetBinDescriptorArray;
            boolean bl3 = false;
            map$iv.set(key$iv, value$iv);
        }
        descriptors = var3_3;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000bJ\u001e\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018J8\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0016\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u000bJ*\u0010 \u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u000b2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020$0#R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lavail/descriptor/sets/HashedSetBinDescriptor$Companion;", "", "()V", "checkBinHashes", "", "descriptors", "Lavail/utility/structures/EnumMap;", "Lavail/descriptor/representation/Mutability;", "", "Lavail/descriptor/sets/HashedSetBinDescriptor;", "numberOfLevels", "", "checkHashedSetBin", "", "self", "Lavail/descriptor/representation/AvailObject;", "combineHashedAndLinear", "Lavail/descriptor/sets/A_SetBin;", "hashedBin", "linearBin", "level", "createInitializedHashSetBin", "localSize", "bitVector", "", "createUninitializedHashedSetBin", "totalSize", "hash", "unionKindOrNil", "Lavail/descriptor/types/A_Type;", "descriptorFor", "flag", "generateHashedSetBinFrom", "size", "generator", "Lkotlin/Function1;", "Lavail/descriptor/representation/A_BasicObject;", "avail"})
    @SourceDebugExtension(value={"SMAP\nHashedSetBinDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HashedSetBinDescriptor.kt\navail/descriptor/sets/HashedSetBinDescriptor$Companion\n+ 2 AbstractDescriptor.kt\navail/descriptor/representation/AbstractDescriptor\n*L\n1#1,835:1\n574#2:836\n*S KotlinDebug\n*F\n+ 1 HashedSetBinDescriptor.kt\navail/descriptor/sets/HashedSetBinDescriptor$Companion\n*L\n656#1:836\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void checkHashedSetBin(@NotNull AvailObject self) {
            Intrinsics.checkNotNullParameter(self, "self");
        }

        private final AvailObject createUninitializedHashedSetBin(int level, int localSize, int totalSize, int hash, long bitVector, A_Type unionKindOrNil) {
            AvailObject availObject;
            boolean bl;
            boolean bl2 = bl = Long.bitCount(bitVector) == localSize;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            HashedSetBinDescriptor descriptor2 = this.descriptorFor(Mutability.MUTABLE, level);
            AbstractDescriptor this_$iv = descriptor2;
            boolean $i$f$create = false;
            AvailObject $this$createUninitializedHashedSetBin_u24lambda_u241 = availObject = AvailObject.Companion.newIndexedDescriptor(localSize, this_$iv);
            boolean bl3 = false;
            $this$createUninitializedHashedSetBin_u24lambda_u241.setSlot(IntegerSlots.Companion.getBIN_HASH(), hash);
            $this$createUninitializedHashedSetBin_u24lambda_u241.setSlot(IntegerSlots.Companion.getBIN_SIZE(), totalSize);
            $this$createUninitializedHashedSetBin_u24lambda_u241.setSlot(IntegerSlots.BIT_VECTOR, bitVector);
            $this$createUninitializedHashedSetBin_u24lambda_u241.setSlot(ObjectSlots.BIN_UNION_KIND_OR_NIL, unionKindOrNil);
            return availObject;
        }

        @NotNull
        public final AvailObject createInitializedHashSetBin(int level, int localSize, long bitVector) {
            AvailObject instance = this.createUninitializedHashedSetBin(level, localSize, 0, 0, bitVector, NilDescriptor.Companion.getNil());
            AvailObject emptySubbin = LinearSetBinDescriptor.Companion.emptyLinearSetBin(level + 1);
            instance.fillSlots(ObjectSlots.BIN_ELEMENT_AT_, 1, localSize, emptySubbin);
            return instance;
        }

        @NotNull
        public final AvailObject generateHashedSetBinFrom(int level, int size, @NotNull Function1<? super Integer, ? extends A_BasicObject> generator) {
            boolean bl;
            int binIndex;
            Object object;
            Intrinsics.checkNotNullParameter(generator, "generator");
            List[] groups2 = new List[64];
            int shift = 6 * level;
            int i2 = 1;
            if (i2 <= size) {
                while (true) {
                    A_BasicObject element;
                    int groupIndex;
                    List<A_BasicObject> group;
                    if ((group = groups2[groupIndex = (element = generator.invoke((Integer)i2)).hash() >>> shift & 0x3F]) == null) {
                        object = new A_BasicObject[]{element};
                        groups2[groupIndex] = group = CollectionsKt.mutableListOf(object);
                    } else if (!element.equals((A_BasicObject)group.get(0))) {
                        group.add(element);
                    }
                    if (i2 == size) break;
                    ++i2;
                }
            }
            long bitVector = 0L;
            int occupiedBinCount = 0;
            for (binIndex = 0; binIndex < 64; ++binIndex) {
                if (groups2[binIndex] == null) continue;
                bitVector |= 1L << binIndex;
                ++occupiedBinCount;
            }
            int n = binIndex = bitVector != 0L ? 1 : 0;
            if (_Assertions.ENABLED && binIndex == 0) {
                object = "Assertion failed";
                throw new AssertionError(object);
            }
            int n2 = binIndex = occupiedBinCount != 0 ? 1 : 0;
            if (_Assertions.ENABLED && binIndex == 0) {
                object = "Assertion failed";
                throw new AssertionError(object);
            }
            AvailObject hashedBin = this.createUninitializedHashedSetBin(level, occupiedBinCount, 0, 0, bitVector, NilDescriptor.Companion.getNil());
            int written = 0;
            int hash = 0;
            int totalCount = 0;
            for (int binIndex2 = 0; binIndex2 < 64; ++binIndex2) {
                List group = groups2[binIndex2];
                if (group == null) continue;
                A_SetBin childBin2 = SetBinDescriptor.Companion.generateSetBinFrom(level + 1, group.size(), (Function1<? super Integer, ? extends A_BasicObject>)new Function1<Integer, A_BasicObject>((List<? extends A_BasicObject>)group){
                    final /* synthetic */ List<A_BasicObject> $group;
                    {
                        this.$group = $group;
                        super(1);
                    }

                    @NotNull
                    public final A_BasicObject invoke(int it) {
                        return this.$group.get(it - 1);
                    }
                });
                totalCount += A_SetBin.Companion.getSetBinSize(childBin2);
                hash += A_SetBin.Companion.getSetBinHash(childBin2);
                hashedBin.set(ObjectSlots.BIN_ELEMENT_AT_, ++written, childBin2);
                groups2[binIndex2] = null;
            }
            if (A_SetBin.Companion.getSetBinSize(hashedBin) == 1) {
                return hashedBin.get(ObjectSlots.BIN_ELEMENT_AT_, 1);
            }
            boolean bl2 = bl = written == occupiedBinCount;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            hashedBin.set(IntegerSlots.Companion.getBIN_SIZE(), totalCount);
            hashedBin.set(IntegerSlots.Companion.getBIN_HASH(), hash);
            return hashedBin;
        }

        @NotNull
        public final HashedSetBinDescriptor descriptorFor(@NotNull Mutability flag, int level) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)flag, "flag");
            boolean bl2 = 0 <= level ? level < 6 : (bl = false);
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            Object v = descriptors.get((Object)flag);
            Intrinsics.checkNotNull(v);
            return ((HashedSetBinDescriptor[])v)[level];
        }

        @NotNull
        public final A_SetBin combineHashedAndLinear(@NotNull AvailObject hashedBin, @NotNull AvailObject linearBin, int level) {
            Intrinsics.checkNotNullParameter(hashedBin, "hashedBin");
            Intrinsics.checkNotNullParameter(linearBin, "linearBin");
            Ref.ObjectRef<A_SetBin> out2 = new Ref.ObjectRef<A_SetBin>();
            out2.element = hashedBin;
            A_SetBin.Companion.getSetBinIterator(linearBin).forEachRemaining(arg_0 -> Companion.combineHashedAndLinear$lambda$2(new Function1<AvailObject, Unit>(out2, level){
                final /* synthetic */ Ref.ObjectRef<A_SetBin> $out;
                final /* synthetic */ int $level;
                {
                    this.$out = $out;
                    this.$level = $level;
                    super(1);
                }

                public final void invoke(@NotNull AvailObject element) {
                    Intrinsics.checkNotNullParameter(element, "element");
                    this.$out.element = A_SetBin.Companion.setBinAddingElementHashLevelCanDestroy((A_SetBin)this.$out.element, element, element.hash(), this.$level, true);
                }
            }, arg_0));
            return (A_SetBin)out2.element;
        }

        private static final void combineHashedAndLinear$lambda$2(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
            $tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\n\u001a\u00020\u000bH\u0096\u0002J\t\u0010\f\u001a\u00020\rH\u0096\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lavail/descriptor/sets/HashedSetBinDescriptor$HashedSetBinIterator;", "Lavail/descriptor/sets/SetDescriptor$SetIterator;", "root", "Lavail/descriptor/sets/A_SetBin;", "(Lavail/descriptor/sets/A_SetBin;)V", "binStack", "Ljava/util/ArrayDeque;", "currentElement", "subscriptStack", "", "hasNext", "", "next", "Lavail/descriptor/representation/AvailObject;", "traceDownward", "", "binOrElement", "avail"})
    public static final class HashedSetBinIterator
    extends SetDescriptor.SetIterator {
        @NotNull
        private final ArrayDeque<A_SetBin> binStack;
        @NotNull
        private final ArrayDeque<Integer> subscriptStack;
        @Nullable
        private A_SetBin currentElement;

        public HashedSetBinIterator(@NotNull A_SetBin root) {
            Intrinsics.checkNotNullParameter(root, "root");
            this.binStack = new ArrayDeque();
            this.subscriptStack = new ArrayDeque();
            this.traceDownward(root);
        }

        private final void traceDownward(A_SetBin binOrElement) {
            boolean bl;
            A_SetBin current = binOrElement;
            while (A_SetBin.Companion.isSetBin(current)) {
                this.binStack.add(current);
                int size = current.variableObjectSlotsCount();
                this.subscriptStack.add(size);
                current = A_SetBin.Companion.binElementAt(current, size);
            }
            boolean bl2 = bl = this.binStack.size() == this.subscriptStack.size();
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            this.currentElement = current;
        }

        @Override
        @NotNull
        public AvailObject next() {
            boolean bl;
            if (this.currentElement == null) {
                throw new NoSuchElementException();
            }
            A_SetBin a_SetBin = this.currentElement;
            Intrinsics.checkNotNull(a_SetBin);
            A_SetBin result2 = a_SetBin;
            boolean bl2 = bl = !((Collection)this.binStack).isEmpty();
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            boolean bl3 = bl = this.binStack.size() == this.subscriptStack.size();
            if (_Assertions.ENABLED && !bl) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
            do {
                boolean bl4;
                A_SetBin leafBin = (A_SetBin)CollectionsKt.last((Iterable)this.binStack);
                int nextIndex = ((Number)this.subscriptStack.removeLast()).intValue() - 1;
                if (nextIndex >= 1) {
                    this.subscriptStack.add(nextIndex);
                    boolean bl5 = bl4 = this.binStack.size() == this.subscriptStack.size();
                    if (_Assertions.ENABLED && !bl4) {
                        String string4 = "Assertion failed";
                        throw new AssertionError((Object)string4);
                    }
                    Intrinsics.checkNotNull(leafBin);
                    this.traceDownward(A_SetBin.Companion.binElementAt(leafBin, nextIndex));
                    return (AvailObject)result2;
                }
                this.binStack.removeLast();
                boolean bl6 = bl4 = this.binStack.size() == this.subscriptStack.size();
                if (!_Assertions.ENABLED || bl4) continue;
                String string5 = "Assertion failed";
                throw new AssertionError((Object)string5);
            } while (!this.binStack.isEmpty());
            this.currentElement = null;
            return (AvailObject)result2;
        }

        @Override
        public boolean hasNext() {
            return this.currentElement != null;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u0000 \u00062\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0001\u0006B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0007"}, d2={"Lavail/descriptor/sets/HashedSetBinDescriptor$IntegerSlots;", "", "Lavail/descriptor/representation/IntegerSlotsEnum;", "(Ljava/lang/String;I)V", "BIN_HASH_AND_MORE", "BIT_VECTOR", "Companion", "avail"})
    public static final class IntegerSlots
    extends Enum<IntegerSlots>
    implements IntegerSlotsEnum {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private static final BitField BIN_HASH;
        @NotNull
        private static final BitField BIN_SIZE;
        public static final /* enum */ IntegerSlots BIN_HASH_AND_MORE;
        public static final /* enum */ IntegerSlots BIT_VECTOR;
        private static final /* synthetic */ IntegerSlots[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static IntegerSlots[] values() {
            return (IntegerSlots[])$VALUES.clone();
        }

        public static IntegerSlots valueOf(String value) {
            return Enum.valueOf(IntegerSlots.class, value);
        }

        @NotNull
        public static EnumEntries<IntegerSlots> getEntries() {
            return $ENTRIES;
        }

        static {
            boolean bl;
            BIN_HASH_AND_MORE = new IntegerSlots();
            BIT_VECTOR = new IntegerSlots();
            $VALUES = integerSlotsArray = new IntegerSlots[]{IntegerSlots.BIN_HASH_AND_MORE, IntegerSlots.BIT_VECTOR};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            BIN_HASH = new BitField(BIN_HASH_AND_MORE, 0, 32, Companion.BIN_HASH.1.INSTANCE);
            BIN_SIZE = new BitField(BIN_HASH_AND_MORE, 32, 32, Companion.BIN_SIZE.1.INSTANCE);
            boolean bl2 = bl = SetBinDescriptor.IntegerSlots.BIN_HASH_AND_MORE.ordinal() == BIN_HASH_AND_MORE.ordinal();
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            bl = SetBinDescriptor.IntegerSlots.Companion.getBIN_HASH().isSamePlaceAs(BIN_HASH);
            if (_Assertions.ENABLED && !bl) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lavail/descriptor/sets/HashedSetBinDescriptor$IntegerSlots$Companion;", "", "()V", "BIN_HASH", "Lavail/descriptor/representation/BitField;", "getBIN_HASH", "()Lavail/descriptor/representation/BitField;", "BIN_SIZE", "getBIN_SIZE", "avail"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final BitField getBIN_HASH() {
                return BIN_HASH;
            }

            @NotNull
            public final BitField getBIN_SIZE() {
                return BIN_SIZE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lavail/descriptor/sets/HashedSetBinDescriptor$ObjectSlots;", "", "Lavail/descriptor/representation/ObjectSlotsEnum;", "(Ljava/lang/String;I)V", "BIN_UNION_KIND_OR_NIL", "BIN_ELEMENT_AT_", "avail"})
    public static final class ObjectSlots
    extends Enum<ObjectSlots>
    implements ObjectSlotsEnum {
        public static final /* enum */ ObjectSlots BIN_UNION_KIND_OR_NIL = new ObjectSlots();
        public static final /* enum */ ObjectSlots BIN_ELEMENT_AT_ = new ObjectSlots();
        private static final /* synthetic */ ObjectSlots[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ObjectSlots[] values() {
            return (ObjectSlots[])$VALUES.clone();
        }

        public static ObjectSlots valueOf(String value) {
            return Enum.valueOf(ObjectSlots.class, value);
        }

        @NotNull
        public static EnumEntries<ObjectSlots> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = objectSlotsArray = new ObjectSlots[]{ObjectSlots.BIN_UNION_KIND_OR_NIL, ObjectSlots.BIN_ELEMENT_AT_};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

