/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.fibers;

import avail.AvailRuntime;
import avail.descriptor.fiber.A_Fiber;
import avail.descriptor.fiber.FiberDescriptor;
import avail.descriptor.functions.A_Function;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.numbers.InfinityDescriptor;
import avail.descriptor.numbers.IntegerDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.primitive.fibers.P_Sleep;
import java.util.TimerTask;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\t"}, d2={"Lavail/interpreter/primitive/fibers/P_Sleep;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "avail"})
public final class P_Sleep
extends Primitive {
    @NotNull
    public static final P_Sleep INSTANCE = new P_Sleep();

    private P_Sleep() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CannotFail, Primitive.Flag.CanSuspend, Primitive.Flag.Unknown};
        super(1, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(1);
        AvailObject sleepMillis = interpreter.argument(0);
        if (A_Number.Companion.equalsInt(sleepMillis, 0)) {
            return interpreter.primitiveSuccess(NilDescriptor.Companion.getNil());
        }
        A_Fiber fiber2 = interpreter.fiber();
        AvailRuntime runtime = interpreter.runtime;
        A_Function a_Function = interpreter.function;
        Intrinsics.checkNotNull(a_Function);
        A_Function primitiveFunction = a_Function;
        if (A_Number.Companion.isLong(sleepMillis)) {
            TimerTask task2 = new TimerTask(fiber2, runtime){
                final /* synthetic */ A_Fiber $fiber;
                final /* synthetic */ AvailRuntime $runtime;
                {
                    this.$fiber = $fiber;
                    this.$runtime = $runtime;
                }

                public void run() {
                    this.$fiber.lock((Function0)new Function0<Unit>(this.$fiber, this.$runtime){
                        final /* synthetic */ A_Fiber $fiber;
                        final /* synthetic */ AvailRuntime $runtime;
                        {
                            this.$fiber = $fiber;
                            this.$runtime = $runtime;
                            super(0);
                        }

                        public final void invoke() {
                            if (A_Fiber.Companion.getExecutionState(this.$fiber) == FiberDescriptor.ExecutionState.ASLEEP) {
                                A_Fiber.Companion.setWakeupTask(this.$fiber, null);
                                A_Fiber.Companion.setExecutionState(this.$fiber, FiberDescriptor.ExecutionState.SUSPENDED);
                                this.$runtime.resumeFromSuccessfulPrimitive(this.$fiber, P_Sleep.INSTANCE, NilDescriptor.Companion.getNil());
                            }
                        }
                    });
                }
            };
            interpreter.postExitContinuation(new Function0<Unit>(fiber2, runtime, this, task2, sleepMillis){
                final /* synthetic */ A_Fiber $fiber;
                final /* synthetic */ AvailRuntime $runtime;
                final /* synthetic */ P_Sleep this$0;
                final /* synthetic */ attempt.task.1 $task;
                final /* synthetic */ AvailObject $sleepMillis;
                {
                    this.$fiber = $fiber;
                    this.$runtime = $runtime;
                    this.this$0 = $receiver;
                    this.$task = $task;
                    this.$sleepMillis = $sleepMillis;
                    super(0);
                }

                public final void invoke() {
                    this.$fiber.lock((Function0)new Function0<Unit>(this.$fiber, this.$runtime, this.this$0, this.$task, this.$sleepMillis){
                        final /* synthetic */ A_Fiber $fiber;
                        final /* synthetic */ AvailRuntime $runtime;
                        final /* synthetic */ P_Sleep this$0;
                        final /* synthetic */ attempt.task.1 $task;
                        final /* synthetic */ AvailObject $sleepMillis;
                        {
                            this.$fiber = $fiber;
                            this.$runtime = $runtime;
                            this.this$0 = $receiver;
                            this.$task = $task;
                            this.$sleepMillis = $sleepMillis;
                            super(0);
                        }

                        public final void invoke() {
                            if (A_Fiber.Companion.interruptRequestFlag(this.$fiber, FiberDescriptor.InterruptRequestFlag.TERMINATION_REQUESTED)) {
                                boolean bl;
                                boolean bl2 = bl = A_Fiber.Companion.getExecutionState(this.$fiber) == FiberDescriptor.ExecutionState.SUSPENDED;
                                if (_Assertions.ENABLED && !bl) {
                                    String string2 = "Assertion failed";
                                    throw new AssertionError((Object)string2);
                                }
                                this.$runtime.resumeFromSuccessfulPrimitive(this.$fiber, this.this$0, NilDescriptor.Companion.getNil());
                            } else {
                                A_Fiber.Companion.setWakeupTask(this.$fiber, this.$task);
                                A_Fiber.Companion.setExecutionState(this.$fiber, FiberDescriptor.ExecutionState.ASLEEP);
                                this.$runtime.getTimer().schedule((TimerTask)this.$task, A_Number.Companion.getExtractLong(this.$sleepMillis));
                            }
                        }
                    });
                }
            });
        } else {
            interpreter.postExitContinuation(new Function0<Unit>(fiber2, runtime, this){
                final /* synthetic */ A_Fiber $fiber;
                final /* synthetic */ AvailRuntime $runtime;
                final /* synthetic */ P_Sleep this$0;
                {
                    this.$fiber = $fiber;
                    this.$runtime = $runtime;
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    this.$fiber.lock((Function0)new Function0<Unit>(this.$fiber, this.$runtime, this.this$0){
                        final /* synthetic */ A_Fiber $fiber;
                        final /* synthetic */ AvailRuntime $runtime;
                        final /* synthetic */ P_Sleep this$0;
                        {
                            this.$fiber = $fiber;
                            this.$runtime = $runtime;
                            this.this$0 = $receiver;
                            super(0);
                        }

                        public final void invoke() {
                            if (A_Fiber.Companion.interruptRequestFlag(this.$fiber, FiberDescriptor.InterruptRequestFlag.TERMINATION_REQUESTED)) {
                                boolean bl;
                                boolean bl2 = bl = A_Fiber.Companion.getExecutionState(this.$fiber) == FiberDescriptor.ExecutionState.SUSPENDED;
                                if (_Assertions.ENABLED && !bl) {
                                    String string2 = "Assertion failed";
                                    throw new AssertionError((Object)string2);
                                }
                                this.$runtime.resumeFromSuccessfulPrimitive(this.$fiber, this.this$0, NilDescriptor.Companion.getNil());
                            } else {
                                A_Fiber.Companion.setExecutionState(this.$fiber, FiberDescriptor.ExecutionState.ASLEEP);
                            }
                        }
                    });
                }
            });
        }
        return interpreter.primitiveSuspend(primitiveFunction);
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(IntegerRangeTypeDescriptor.Companion.inclusive(IntegerDescriptor.Companion.getZero(), InfinityDescriptor.Companion.getPositiveInfinity())), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null);
    }
}

