/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.general;

import avail.descriptor.numbers.A_Number;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\t"}, d2={"Lavail/interpreter/primitive/general/P_AdjustDebugSetting;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "avail"})
public final class P_AdjustDebugSetting
extends Primitive {
    @NotNull
    public static final P_AdjustDebugSetting INSTANCE = new P_AdjustDebugSetting();

    private P_AdjustDebugSetting() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.Unknown, Primitive.Flag.CannotFail};
        super(1, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(1);
        AvailObject levelObject = interpreter.argument(0);
        int level = A_Number.Companion.getExtractInt(levelObject);
        Interpreter.Companion.setDebugL1((level & 1) != 0);
        Interpreter.Companion.setDebugL2((level & 2) != 0);
        Interpreter.Companion.setDebugPrimitives((level & 4) != 0);
        Interpreter.Companion.setDebugCustom((level & 0x80) != 0);
        Level level2 = level != 0 ? Level.ALL : Level.OFF;
        Intrinsics.checkNotNull(level2);
        Interpreter.Companion.setLoggerLevel(level2);
        return interpreter.primitiveSuccess(NilDescriptor.Companion.getNil());
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(IntegerRangeTypeDescriptor.Companion.getU8()), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null);
    }
}

