/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.pojos;

import avail.descriptor.pojos.PojoFieldDescriptor;
import avail.descriptor.pojos.RawPojoDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.PojoTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.descriptor.types.VariableTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.AvailLoader;
import avail.interpreter.execution.Interpreter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014\u00a8\u0006\n"}, d2={"Lavail/interpreter/primitive/pojos/P_BindPojoInstanceField;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
public final class P_BindPojoInstanceField
extends Primitive {
    @NotNull
    public static final P_BindPojoInstanceField INSTANCE = new P_BindPojoInstanceField();

    private P_BindPojoInstanceField() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanFold, Primitive.Flag.CanInline};
        super(2, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(2);
        AvailObject pojo2 = interpreter.argument(0);
        AvailObject fieldName = interpreter.argument(1);
        AvailLoader availLoader = interpreter.availLoaderOrNull();
        if (availLoader != null) {
            availLoader.statementCanBeSummarized(false);
        }
        Object obj = pojo2.rawPojo().javaObjectNotNull();
        Class<?> javaClass = obj.getClass();
        Field field = null;
        try {
            Field field2 = javaClass.getField(A_String.Companion.asNativeString(fieldName));
            Intrinsics.checkNotNullExpressionValue(field2, "getField(...)");
            field = field2;
        }
        catch (NoSuchFieldException e) {
            return interpreter.primitiveFailure(AvailErrorCode.E_JAVA_FIELD_NOT_AVAILABLE);
        }
        if (Modifier.isStatic(field.getModifiers())) {
            return interpreter.primitiveFailure(AvailErrorCode.E_JAVA_FIELD_NOT_AVAILABLE);
        }
        Type type2 = field.getGenericType();
        Intrinsics.checkNotNullExpressionValue(type2, "getGenericType(...)");
        A_Type fieldType = PojoTypeDescriptor.Companion.resolvePojoType(type2, A_Type.Companion.getTypeVariables(pojo2.kind()));
        AvailObject variable = PojoFieldDescriptor.Companion.pojoFieldVariableForInnerType(RawPojoDescriptor.Companion.equalityPojo(field), pojo2.rawPojo(), fieldType);
        return interpreter.primitiveSuccess(variable);
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(PojoTypeDescriptor.Companion.mostGeneralPojoType(), TupleTypeDescriptor.Companion.getStringType()), VariableTypeDescriptor.Companion.getMostGeneralVariableType(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_JAVA_FIELD_NOT_AVAILABLE};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }
}

