/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.types;

import avail.descriptor.atoms.AtomDescriptor;
import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.EnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.InstanceMetaDescriptor;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.levelTwo.L2Instruction;
import avail.interpreter.levelTwo.operand.L2ConstantOperand;
import avail.interpreter.levelTwo.operand.L2Operand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedOperand;
import avail.interpreter.levelTwo.operation.L2_GET_TYPE;
import avail.interpreter.levelTwo.operation.L2_JUMP_IF_KIND_OF_OBJECT;
import avail.interpreter.levelTwo.operation.L2_JUMP_IF_SUBTYPE_OF_CONSTANT;
import avail.interpreter.levelTwo.operation.L2_JUMP_IF_SUBTYPE_OF_OBJECT;
import avail.optimizer.L1Translator;
import avail.optimizer.L2BasicBlock;
import avail.optimizer.L2Generator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014JH\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\u0006\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u00060\u0015R\u00020\u0013H\u0016\u00a8\u0006\u0016"}, d2={"Lavail/interpreter/primitive/types/P_IsSubtypeOf;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "tryToGenerateSpecialPrimitiveInvocation", "", "functionToCallReg", "Lavail/interpreter/levelTwo/operand/L2ReadBoxedOperand;", "rawFunction", "Lavail/descriptor/functions/A_RawFunction;", "arguments", "", "argumentTypes", "translator", "Lavail/optimizer/L1Translator;", "callSiteHelper", "Lavail/optimizer/L1Translator$CallSiteHelper;", "avail"})
public final class P_IsSubtypeOf
extends Primitive {
    @NotNull
    public static final P_IsSubtypeOf INSTANCE = new P_IsSubtypeOf();

    private P_IsSubtypeOf() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CannotFail, Primitive.Flag.CanFold, Primitive.Flag.CanInline};
        super(2, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(2);
        AvailObject type1 = interpreter.argument(0);
        AvailObject type2 = interpreter.argument(1);
        return interpreter.primitiveSuccess(AtomDescriptor.Companion.objectFromBoolean(A_Type.Companion.isSubtypeOf(type1, type2)));
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(InstanceMetaDescriptor.Companion.topMeta(), InstanceMetaDescriptor.Companion.topMeta()), EnumerationTypeDescriptor.Companion.getBooleanType(), null, 4, null);
    }

    @Override
    public boolean tryToGenerateSpecialPrimitiveInvocation(@NotNull L2ReadBoxedOperand functionToCallReg, @NotNull A_RawFunction rawFunction2, @NotNull List<L2ReadBoxedOperand> arguments2, @NotNull List<? extends A_Type> argumentTypes, @NotNull L1Translator translator, @NotNull L1Translator.CallSiteHelper callSiteHelper) {
        AvailObject constantXType;
        Intrinsics.checkNotNullParameter(functionToCallReg, "functionToCallReg");
        Intrinsics.checkNotNullParameter(rawFunction2, "rawFunction");
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        Intrinsics.checkNotNullParameter(argumentTypes, "argumentTypes");
        Intrinsics.checkNotNullParameter(translator, "translator");
        Intrinsics.checkNotNullParameter(callSiteHelper, "callSiteHelper");
        L2ReadBoxedOperand xTypeReg = arguments2.get(0);
        L2ReadBoxedOperand yTypeReg = arguments2.get(1);
        AvailObject xType = A_Type.Companion.getInstance(xTypeReg.type());
        AvailObject yType = A_Type.Companion.getInstance(yTypeReg.type());
        AvailObject constantYType = yTypeReg.constantOrNull();
        if (constantYType != null) {
            boolean bl = A_Type.Companion.isSubtypeOf(constantYType, yType);
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            if (A_Type.Companion.isSubtypeOf(xType, constantYType)) {
                callSiteHelper.useAnswer(translator.getGenerator().boxedConstant(AtomDescriptor.Companion.getTrueObject()));
                return true;
            }
        }
        if ((constantXType = xTypeReg.constantOrNull()) != null) {
            boolean bl = A_Type.Companion.isSubtypeOf(constantXType, xType);
            if (_Assertions.ENABLED && !bl) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
            if (!A_Type.Companion.isSubtypeOf(constantXType, yType)) {
                callSiteHelper.useAnswer(translator.getGenerator().boxedConstant(AtomDescriptor.Companion.getFalseObject()));
                return true;
            }
        }
        if (xType.isBottom()) {
            callSiteHelper.useAnswer(translator.getGenerator().boxedConstant(AtomDescriptor.Companion.getTrueObject()));
            return true;
        }
        L2BasicBlock ifSubtype = translator.getGenerator().createBasicBlock("if subtype");
        L2BasicBlock ifNotSubtype = translator.getGenerator().createBasicBlock("not subtype");
        L2Instruction xDef = xTypeReg.definitionSkippingMoves(true);
        if (Intrinsics.areEqual(xDef.getOperation(), L2_GET_TYPE.INSTANCE)) {
            L2ReadBoxedOperand xInstanceRead = L2_GET_TYPE.sourceValueOf(xDef);
            if (constantYType != null) {
                translator.getGenerator().jumpIfKindOfConstant(xInstanceRead, constantYType, ifSubtype, ifNotSubtype);
            } else {
                L2Operand[] l2OperandArray = new L2Operand[]{xInstanceRead, yTypeReg, L2Generator.Companion.edgeTo(ifSubtype), L2Generator.Companion.edgeTo(ifNotSubtype)};
                translator.addInstruction(L2_JUMP_IF_KIND_OF_OBJECT.INSTANCE, l2OperandArray);
            }
        } else if (constantYType != null) {
            L2Operand[] l2OperandArray = new L2Operand[]{xTypeReg, new L2ConstantOperand(constantYType), L2Generator.Companion.edgeTo(ifSubtype), L2Generator.Companion.edgeTo(ifNotSubtype)};
            translator.addInstruction(L2_JUMP_IF_SUBTYPE_OF_CONSTANT.INSTANCE, l2OperandArray);
        } else {
            L2Operand[] l2OperandArray = new L2Operand[]{xTypeReg, yTypeReg, L2Generator.Companion.edgeTo(ifSubtype), L2Generator.Companion.edgeTo(ifNotSubtype)};
            translator.addInstruction(L2_JUMP_IF_SUBTYPE_OF_OBJECT.INSTANCE, l2OperandArray);
        }
        L2Generator.startBlock$default(translator.getGenerator(), ifSubtype, false, null, 6, null);
        callSiteHelper.useAnswer(translator.getGenerator().boxedConstant(AtomDescriptor.Companion.getTrueObject()));
        L2Generator.startBlock$default(translator.getGenerator(), ifNotSubtype, false, null, 6, null);
        callSiteHelper.useAnswer(translator.getGenerator().boxedConstant(AtomDescriptor.Companion.getFalseObject()));
        return true;
    }
}

